/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: surface.h,v 1.1.1.1.42.1 2004/07/09 01:58:56 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _SURFACE_H_
#define _SURFACE_H_

#ifndef WIDTHBYTES
#define WIDTHBYTES(i)	((unsigned long)((i+31)&(~31))/8)  /* ULONG aligned ! */
#endif

// Forward declarations
class ColorFuncAccess;
class CHXSiteWindowed;

class CHXSurface : public IHXVideoSurface,
		    public IHXVideoControl
{
protected:

    virtual ~CHXSurface();

    PRIVATE_DESTRUCTORS_ARE_NOT_A_CRIME

    LONG32		    m_lRefCount;
    IUnknown*		    m_pContext;
    ColorFuncAccess*	    m_pConverter;

    float		    m_Brightness;
    float		    m_Contrast;
    float		    m_Saturation;
    float		    m_Hue;
    float		    m_Sharpness;

    float		    m_PrevBrightness;
    float		    m_PrevContrast;
    float		    m_PrevSaturation;
    float		    m_PrevHue;
    float		    m_PrevSharpness;

    INT16		    m_ModeSharpness;
    INT16		    m_nBitDepth;

    CHXSiteWindowed*	    m_pSite;
    HX_MOFTAG		    m_PreferredFormat;

    STDMETHOD(BltImage)		(UCHAR* pImageData,
				HXBitmapInfoHeader* pBitmapInfo,
				REF(CHXxRect) rDestRect,
				REF(CHXxRect) rSrcRect) PURE;

    void PerformYUVConversion	(UCHAR* ySrc, UCHAR* uSrc, UCHAR* vSrc, 
				INT32 nPitchSrc, UCHAR* Dst, INT32 nWidth, 
				INT32 nHeight, INT32 nPitchDst, 
				HX_MOFTAG Format, INT16 nExpand);
    UINT16 CalculateNewBitDepth	(HX_COMPRESSION_TYPE nNewFormat);
    void AdjustBitmapHeader	(HXBitmapInfoHeader* pBitmapInfo, 
				HX_MOFTAG NewFormat);
    UINT16 CheckColorSettings	();
    UINT16 CheckSharpness	();

public:

    CHXSurface(IUnknown* pContext, CHXSiteWindowed* pSite);

    /*
     *	IUnknown methods
     */
    STDMETHOD(QueryInterface)	(THIS_
				REFIID riid,
				void** ppvObj);

    STDMETHOD_(ULONG32,AddRef)	(THIS);

    STDMETHOD_(ULONG32,Release)	(THIS);

    /*
     * IHXVideoSurface methods usually called by renderers to
     * Draw on the surface
     */
    STDMETHOD(Blt)		(THIS_
				UCHAR*			/*IN*/	pImageData,
				HXBitmapInfoHeader*    /*IN*/	pBitmapInfo,
				REF(HXxRect)		/*IN*/	rDestRect,
				REF(HXxRect)		/*IN*/	rSrcRect);

    STDMETHOD(BeginOptimizedBlt)(THIS_ 
				HXBitmapInfoHeader*    /*IN*/	pBitmapInfo);
    
    STDMETHOD(OptimizedBlt)	(THIS_
				UCHAR*			/*IN*/	pImageBits,
				REF(HXxRect)		/*IN*/	rDestRect,
				REF(HXxRect)		/*IN*/	rSrcRect);
    
    STDMETHOD(EndOptimizedBlt)	(THIS);

    STDMETHOD(GetOptimizedFormat)(THIS_
				REF(HX_COMPRESSION_TYPE) /*OUT*/ ulType);

    STDMETHOD(GetPreferredFormat)(THIS_
				REF(HX_COMPRESSION_TYPE) /*OUT*/ ulType);


    /*
     * IHXVideoControls methods
     */
    STDMETHOD_(float, GetBrightness)	(THIS);
    STDMETHOD(SetBrightness)		(THIS_ float Brightness);

    STDMETHOD_(float, GetContrast)	(THIS);
    STDMETHOD(SetContrast)		(THIS_ float Contrast);

    STDMETHOD_(float, GetSaturation)	(THIS);
    STDMETHOD(SetSaturation)		(THIS_ float Saturation);

    STDMETHOD_(float, GetHue)		(THIS);
    STDMETHOD(SetHue)			(THIS_ float Hue);

    STDMETHOD_(float, GetSharpness)	(THIS);
    STDMETHOD(SetSharpness)		(THIS_ float Sharpness);

    STDMETHOD(SetModeSharpness)		(THIS_ UINT16 dFlag);


};

#endif	// _SURFACE_H_
