/* 
   khotswap - KDE frontend for the hotswap program.

   Copyright (C) 2003 Tim Stadelmann

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
*/


/** HEADERS **/

/* KDE headers */
#include <kaboutdata.h>
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <klocale.h>

/* Program headers */
#include "hotswapform.h"



/** MACROS **/

#ifndef IDE_CONTROLLER
#  define IDE_CONTROLLER "1"
#endif /* IDE_CONTROLLER */

#ifndef HOTSWAP_PATH
#  define HOTSWAP_PATH "hotswap"
#endif /* HOTSWAP_PATH */



/** MAIN **/

int main (int argc, char* argv[])
{
  /* Data describing the application.  This is used in the About
     dialog and on the command line.  */

  KAboutData *about
    = new KAboutData ("khotswap",
		      I18N_NOOP ("Hotswap"),
		      "0.3.3",
		      I18N_NOOP ("Supports hotswapping IDE peripherals."),
		      KAboutData::License_GPL,
		      "© 2003 Tim Stadelmann",
		      0,
		      "http://users.ox.ac.uk/~univ1377",
		      "stadelmann@physics.ox.ac.uk");

  /* Initialize the command line arguments.  */
  KCmdLineArgs::init (argc, argv, about);

  /* Define application specific command line options and add them.  */
  static KCmdLineOptions options[] =
    {
      {"ide-controller N",
       I18N_NOOP ("Use IDE controller N"),
       IDE_CONTROLLER},
      {"hotswap-path PATH",
       I18N_NOOP ("Look for the hotswap backend at the\n"
		  "location given by PATH"),
       HOTSWAP_PATH},
      {"systray",
       I18N_NOOP ("Only show system tray icon at startup"),
       0}
    };

  KCmdLineArgs::addCmdLineOptions (options);

  /* Create the application object.  */
  KApplication application (argc, argv);

  /* Make the parsed command line arguments available.  */
  KCmdLineArgs *args = KCmdLineArgs::parsedArgs ();

  /* Create a HotswapForm widget as the main widget.  */

  QString hotswap_path = args->getOption ("hotswap-path");
  unsigned int ide_controller
    = args->getOption ("ide-controller").toUInt ();
  
  HotswapForm*  main_form;
  
  /* There can only be  one instance.  */
  const int instance = 1;

  if (kapp->isRestored () && KMainWindow::canBeRestored (instance))
    {
      main_form = new HotswapForm (0, ide_controller, hotswap_path);
      main_form->restore (instance, false);
      if (!main_form->systray)
	main_form->show ();
    }
  else
    {
      main_form = new HotswapForm (0, ide_controller, hotswap_path);
      if (!args->isSet ("systray"))
	main_form->show ();
    }
  
  /* Enter the event loop and pass on the return value.  */
  return application.exec ();
}
