///////
   //    HtmlStatement.h
   //    HtmlStatement Class declaration
   //
   //    Class for HtmlStatement storage
   //
   //    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
   //    Some Portions Copyright (c) 1995-2000 The ht://Dig Group <www.htdig.org>
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: HtmlStatement.h,v 1.11 2003/12/30 09:38:47 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 05.10.1999
///////

#ifndef _HTMLSTATEMENT_H
#define _HTMLSTATEMENT_H

#include <Object.h>
#include <htString.h>


class HtmlStatement : public Object
{

   // Write the object to the output
   friend ostream& operator<<(ostream&, const HtmlStatement& );
   
   public:
   
      // Construction / Destruction
      HtmlStatement();
      virtual ~HtmlStatement();

///////
   //    Public Interface
///////

      void Reset();

      void SetIDUrl        (unsigned int id) { IDUrl = id; }
      void SetTagPosition  (unsigned int tp) { TagPosition = tp; }
      void SetTag          (const String &t) { Tag = t; }
      void SetStatement    (const String &s) { Statement = s; }
      void SetRow          (unsigned int r) { Row = r; }
      void SetLinkTagPosition  (unsigned int ltp) { LinkTagPosition = ltp; }

      unsigned int GetIDUrl() const          { return IDUrl; }
      unsigned int GetTagPosition() const    { return TagPosition; }
      const String &GetTag() const           { return Tag; }
      const String &GetStatement() const     { return Statement; }
      unsigned int GetRow() const    { return Row; }
      unsigned int GetLinkTagPosition() const    { return LinkTagPosition; }

      // Static methods for managing debug level
      static void SetDebugLevel (int d) { debug=d;}

///////
   //    Protected attributes
///////

   protected:

      unsigned int   IDUrl;
      unsigned int   TagPosition;
      String         Tag;
      String         Statement;
      unsigned int   Row;
      unsigned int   LinkTagPosition;
      
///////
   //    Static attributes
///////

      static int debug;    // Run-time debugging level

};

#endif
