--------------------------------------------------------------------------------
-- |
-- Module      :  Sound.OpenAL.AL.Source
-- Copyright   :  (c) Sven Panne 2003-2004
-- License     :  BSD-style (see the file libraries/OpenAL/LICENSE)
-- 
-- Maintainer  :  sven.panne@aedion.de
-- Stability   :  provisional
-- Portability :  portable
--
--------------------------------------------------------------------------------

module Sound.OpenAL.AL.Source (
   Source
) where

import Control.Monad ( liftM )
import Foreign.Marshal.Array ( withArrayLen, peekArray, allocaArray )
import Foreign.Ptr ( Ptr )
import Graphics.Rendering.OpenGL.GL.BufferObjects ( ObjectName(..) )
import Sound.OpenAL.AL.BasicTypes
import Sound.OpenAL.AL.ALboolean ( unmarshalALboolean )

--------------------------------------------------------------------------------

newtype Source = Source { sourceID :: ALuint }
   deriving ( Eq, Ord, Show )

instance ObjectName Source where
   genObjectNames n =
      allocaArray n $ \buf -> do
         alGenSources (fromIntegral n) buf
         liftM (map Source) $ peekArray n buf

   deleteObjectNames sources =
      withArrayLen (map sourceID sources) $
         alDeleteSources . fromIntegral

   isObjectName = liftM unmarshalALboolean . alIsSource . sourceID

foreign import CALLCONV unsafe "alGenSources"
   alGenSources :: ALsizei -> Ptr ALuint -> IO ()

foreign import CALLCONV unsafe "alDeleteSources"
   alDeleteSources :: ALsizei -> Ptr ALuint -> IO ()

foreign import CALLCONV unsafe "alIsSource"
   alIsSource :: ALuint -> IO ALboolean



{-
sourcei/sourcef/sourcefv:
AL_BUFFER
AL_CONE_INNER_ANGLE
AL_CONE_OUTER_ANGLE
AL_CONE_OUTER_GAIN
AL_DIRECTION
AL_GAIN
AL_GAIN_LINEAR_LOKI
AL_LOOPING
AL_MAX_DISTANCE
AL_MAX_GAIN
AL_MIN_GAIN
AL_PITCH
AL_POSITION
AL_REFERENCE_DISTANCE
AL_ROLLOFF_FACTOR
AL_SOURCE_RELATIVE
AL_STREAMING
AL_VELOCITY

getsourceiv
AL_BUFFERS_PROCESSED
AL_BUFFERS_QUEUED
AL_BYTE_LOKI
AL_CONE_INNER_ANGLE
AL_CONE_OUTER_ANGLE
AL_CONE_OUTER_GAIN
AL_DIRECTION
AL_GAIN
AL_GAIN_LINEAR_LOKI
AL_LOOPING
AL_MAX_DISTANCE
AL_PITCH
AL_POSITION
AL_REFERENCE_DISTANCE
AL_ROLLOFF_FACTOR
AL_SOURCE_RELATIVE
AL_SOURCE_STATE
AL_STREAMING
AL_VELOCITY

getsourcefv
*AL_BUFFER
AL_BUFFERS_PROCESSED
AL_BUFFERS_QUEUED
AL_BYTE_LOKI
AL_CONE_INNER_ANGLE
AL_CONE_OUTER_ANGLE
AL_CONE_OUTER_GAIN
AL_DIRECTION
AL_GAIN
AL_GAIN_LINEAR_LOKI
AL_LOOPING
AL_MAX_DISTANCE
*AL_MAX_GAIN
*AL_MIN_GAIN
AL_PITCH
AL_POSITION
AL_REFERENCE_DISTANCE
AL_ROLLOFF_FACTOR
AL_SOURCE_RELATIVE
AL_SOURCE_STATE
AL_STREAMING
AL_VELOCITY


-}
