/****************************************************************************
 *
 * Copyright (c) 1999-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#ifndef _HULAUTIL_H
#define _HULAUTIL_H

#include <stddef.h>

#define	NMAP_HASH_SIZE 128
#define NMAP_CRED_STORE_SIZE 4096
#define NMAP_CRED_DIGEST_SIZE 16
#define NMAP_CRED_CHUNK_SIZE ((NMAP_CRED_STORE_SIZE * NMAP_CRED_DIGEST_SIZE) / NMAP_HASH_SIZE)

#ifndef offsetof
#define offsetof(s, m) ((size_t) &((s *)0)->m)
#endif
                                                                                                                                                                            
enum CommandColors {
    RedCommand = 0,
    BlackCommand,
                                                                                                                                                                            
    MaxCommandColors
};
                                                                                                                                                                            
typedef int (* CommandHandler)(void *param);

typedef struct _ProtocolCommand {
    unsigned char *name;
    unsigned char *help;
                                                                                                                                                                            
    int length;
                                                                                                                                                                            
    CommandHandler handler;
                                                                                                                                                                            
    struct _ProtocolCommand *parent;
    struct _ProtocolCommand *left;
    struct _ProtocolCommand *right;
                                                                                                                                                                            
    enum CommandColors color;
} ProtocolCommand;
                                                                                                                                                                            
typedef struct _ProtocolCommandTree {
    ProtocolCommand *sentinel;
    ProtocolCommand *root;
                                                                                                                                                                            
    XplAtomic nodes;
                                                                                                                                                                            
    ProtocolCommand proxy;
} ProtocolCommandTree;

extern const unsigned char *Base64Chars;

/***** Begin HulaKeyword *****/
#define HULA_KEYWORD_VALUES_PER_BYTE 256
#define HULA_KEYWORD_BITS_PER_BYTE 8
#define HULA_KEYWORD_BITS_PER_WORD (sizeof(unsigned long) * HULA_KEYWORD_BITS_PER_BYTE)
#define HULA_KEYWORD_FULL_MASK (unsigned long)(-1)
#define HULA_KEYWORD_HIGH_BIT_MASK (1 << (HULA_KEYWORD_BITS_PER_WORD - 1))
/* HULA_KEYWORD_BBPW (bits required to store the number of bits in a word) */
/* could be calculated as */
/* (int BBPW) */
/* after calling frexp(BITS_PER_WORD, &BBPW) */
/* but it would end up getting calculated at run time */
#define HULA_KEYWORD_BBPW ((HULA_KEYWORD_BITS_PER_WORD < 33) ? 5 : (HULA_KEYWORD_BITS_PER_WORD < 65) ? 6 : (HULA_KEYWORD_BITS_PER_WORD < 129) ? 7 : (HULA_KEYWORD_BITS_PER_WORD < 257) ? 8 : 9)
/* HULA_KEYWORD_BTIM is the number of bits in the HULA_KEYWORD_TABLE_INDEX_MASK */
#define HULA_KEYWORD_BTIM ((HULA_KEYWORD_BITS_PER_WORD - 1 - HULA_KEYWORD_BBPW) >> 1)
#define HULA_KEYWORD_TABLE_INDEX_MASK (HULA_KEYWORD_FULL_MASK >> (HULA_KEYWORD_BITS_PER_WORD - HULA_KEYWORD_BTIM))
#define HULA_KEYWORD_STRING_INDEX_MASK  (~(HULA_KEYWORD_HIGH_BIT_MASK | HULA_KEYWORD_TABLE_INDEX_MASK))

typedef unsigned long HulaKeywordTable[HULA_KEYWORD_VALUES_PER_BYTE];

typedef struct {
    HulaKeywordTable *table;
    unsigned long *sortedList;
} HulaKeywordIndex;

HulaKeywordIndex *HulaKeywordIndexCreate(unsigned char **stringList, BOOL makeCaseInsensitive);
void HulaKeywordIndexFree(HulaKeywordIndex *Index);
long HulaKeywordFind(HulaKeywordIndex *keywordTable, unsigned char *searchString);
/***** End HulaKeyword *****/

void LoadProtocolCommandTree(ProtocolCommandTree *tree, ProtocolCommand *commands);
ProtocolCommand *ProtocolCommandTreeSearch(ProtocolCommandTree *tree, const unsigned char *command);

BOOL QuickNCmp(unsigned char *str1, unsigned char *str2, int len);
BOOL QuickCmp(unsigned char *str1, unsigned char *str2);

#define HulaStrNCpy(dest, src, len) {strncpy((dest), (src), (len)); (dest)[(len) - 1] = '\0';}

unsigned char *DecodeBase64(unsigned char *EncodedString);
unsigned char *EncodeBase64(const unsigned char *UnencodedString);

BOOL HashCredential(const unsigned char *DN, unsigned char *Credential, unsigned char *Hash);

#endif /* _HULAUTIL_H */
