/*
 *  2001-2002 (C) Unpublished Copyright Novell, Inc. 
 */

#ifndef WEBADMIN_H
#define WEBADMIN_H

#include <mdb.h>

/** Request definitions (submitted via URL) **/
/* Basic request types, handled by the engine */
#define	DISPLAY_TEMPLATE		1
#define	REDIRECT_CLIENT		2
#define	REQUEST_LOGOUT			3
#define	DISPLAY_IMAGE			4
#define	REQUEST_LOGOUT_REDIR	5
#define	REQUEST_LOGIN			7
#define	REQUEST_OBJECT			8

/* Semi-internal - index for colors kept in session structure */
#define	COLOR_PAGE_FG			0
#define	COLOR_PAGE_BG			1
#define	COLOR_BORDER_FG		2
#define	COLOR_BORDER_BG		3
#define	COLOR_SECTION_FG		4
#define	COLOR_SECTION_BG		5
#define	COLOR_FIELDNAME_FG	6
#define	COLOR_FIELDNAME_BG	7
#define	COLOR_FIELDBODY_FG	8
#define	COLOR_FIELDBODY_BG	9

#define	MODULE_TEMPLATE		1
#define	MODULE_MIME				2
#define	MODULE_SEND				3
#define	MODULE_OBJECT			4
#define	MODULE_SAVE				5
#define	MODULE_DELETE			6
#define	MODULE_RENAME			7

#define	URL_TYPE_LINK			'w'
#define	URL_TYPE_IMAGE			'p'
#define	URL_TYPE_REDIRECT		'r'
#define	URL_TYPE_PUBLIC		'a'

#define	TOKEN_UNKNOWN			0
#define	TOKEN_DONE				1
#define	TOKEN_MOVE_FORWARD	2
#define	TOKEN_MOVE_BACKWARD	3

/* Returned by WAGetFormValue */
#define	FORMFIELD_NEXT			0
#define	FORMFIELD_DONE			1
#define	FORMFIELD_PARTIAL		2


/* Error codes */
#define	WAERR_SUCCESS					0
#define	WAERR_UNKNOWN					1
#define	WAERR_SHOW_SUCCESS			2				/* Action completed succesfully.  Show it */
#define	WAERR_MISSING_NAME			3				/* Missing the object name for creating an object */
#define	WAERR_MISSING_CLASS			4				/* Missing the class name for creating an object (form tampered with?) */
#define	WAERR_MISSING_MANDATORY		5				/* Missing a mandatory field for the attribute */
#define	WAERR_OBJECT_EXISTS			6				/* An object by the name already exists */
#define	WAERR_OBJECT_CREATED			7				/* Object successfully created */
#define	WAERR_OBJECT_NOT_CREATED	8				/* Generic error */
#define	WAERR_CONTAINER_NOT_EMPTY	9				/* Still has subordinate objects */
#define	WAERR_OBJECT_NOT_DELETED	10				/* Hm, what happened? */
#define	WAERR_OBJECT_DELETED			11
#define	WAERR_NOT_ENOUGH_RIGHTS		12				/* Not enough rights to perform action */
#define	WAERR_OBJECT_NOT_RENAMED	13				/* Bummer, isn't it? */
#define	WAERR_VALUE_NOT_WRITTEN		14				/* MDBWrite failed */
#define	WAERR_PASSWORDS_DONT_MATCH	15
#define	WAERR_ILLEGAL_NAME			16
#define	WAERR_FULLNAME_REQUIRED		17
#define	WAERR_COULD_NOT_SELECT		18
#define	WAERR_COULD_NOT_FIND			19
#define	WAERR_NOT_ALLOWED				20

/* Schema */
#define	WA_C_SERVER_OBJECT							"WebAdminServer"
#define	WA_C_ROLE										"WebAdminRole"
#define	WA_A_ROLE_NAME									"WebAdminName"
#define	WA_A_CONFIG										"WebAdminConfig"
#define	WA_A_CONFIG_DN									"WebAdminConfigDN"
#define	WA_SERVER_OBJECT								"Web Administration"

#define	WA_A_PORT										"WebAdminPort"
#define	WA_A_SSLPORT									"WebAdminSSLPort"
#define	WA_A_PATH										"WebAdminPath"
#define	WA_A_CERT_PATH									"WebAdminCertPath"
#define	WA_A_KEY_PATH									"WebAdminKeyPath"
#define	WA_A_ADDRESS									"WebAdminAddress"
#define	MSGSRV_A_CONFIGURATION						"Novonyx:Configuration"

#ifndef WEBADMIN_BUILD_INTERNAL

#define  BUFSIZE						1023
#define  MTU							(1480*3)

#define	AddError(Name, Error)									\
			{																\
				MDBAddValue(Name, Session->ErrorNames);		\
				MDBAddValue(Error, Session->ErrorStrings);	\
			}

/*
	This structure contains all information relevant to a session
	including user preferences, the template to use and mailbox state.
	This structure may seem "biased" towards email; but the module
	design actually allows any kind of data stored in the session
	structure, should there be a need to use the framework for other
	purposes.

	The published structures do not contain all information that is 
	available internally; for data integrity purposes webadmin uses
	a slighly larger structure internally.
*/

typedef struct _SessionStruct {
	/* MDB Rights */
	MDBHandle			AuthHandle;

	/* User data, public */
	unsigned char		*User;
	unsigned char		*UserDN;
	unsigned long		Language;
	unsigned char		Colors[10][7];
	unsigned char		*Charset;
	unsigned char		*EMailAddress;
	unsigned char		*OfficialDomain;

	/* User preferences */
	unsigned long		ItemsPerPage;

	/* Mailstore address */
	struct in_addr		NMAPAddress;

	/* Template data */
	long					TemplateID;
	unsigned char		**Strings;
	unsigned char		**Images;
	TemplateObjectOverlay	**Pages;
	TemplateObjectOverlay	**StaticPages;
	MDBValueStruct		*AllowedTemplates;

	/* Direct NMAP access */
	int					NMAPs;					/* NMAP Socket					*/
	int					NBufferPtr;				/* Current NMAP pointer		*/
	unsigned char		NBuffer[BUFSIZE+1];	/* NMAP Input buffer			*/

	MDBValueStruct		*V;

	/* Error Handling */
	unsigned long		LastError;
	MDBValueStruct		*ErrorNames;
	MDBValueStruct		*ErrorStrings;

	/* Form Handling */
	MDBValueStruct		*LastFormNames;
	MDBValueStruct		*LastFormValues;

	/* The current object */
	unsigned char		CurrentObject[MDB_MAX_OBJECT_CHARS+1];
	unsigned char		CurrentTree[MDB_MAX_OBJECT_CHARS+1];
	unsigned char		CurrentClass[MDB_MAX_OBJECT_CHARS+1];

	/* A unique session identifier */
	unsigned long		SessionID;
} SessionStruct;


typedef struct _ConnectionStruct {
	int						s;							/* Socket						*/
	SessionStruct			*Session;				/* Current session			*/
	unsigned char			Temp[BUFSIZE+1];		/* Temp work buffer			*/
	struct sockaddr_in	cs;						/* Client info					*/
	BOOL						KeepAlive;				/* Keep connection?			*/
	unsigned char			Command[BUFSIZE+1];	/* Current command			*/
	unsigned char			*URLExtra;				/* Addtl. URL info			*/
	BOOL						NMAPProtected;			/* NMAP Transaction active	*/
	unsigned char			ClientSSL;				/* Doing SSL?					*/
	unsigned long			DeviceType;				/* Current Device Type		*/
} ConnectionStruct;

typedef struct _URLStruct {
	unsigned long	Request;
	unsigned long	Argument[6];
} URLStruct;

#endif /* !WEBADMIN_BUILD_INTERNAL */

#ifdef __cplusplus
extern "C" {
#endif

/** Little helpers **/
extern BOOL					*WAExiting;

#if defined(DEBUG)
extern int					WAModuleScreen;
#define	ModDebug			SetCurrentScreen(WAModuleScreen); printf("[%d] ", __LINE__); printf
#else																																																   
#define	ModDebug			if (0) printf
#endif


/*** Module function descriptions ***/

/** All modules **/
/* Module initialization */
typedef	void	(*WAModuleShutdownFunc)(void);
typedef	BOOL	(*WAModuleInitFunc)(void *WAAPIIn);

/** Template modules **/
/* These functions are called everytime a new session is created and destroyed */
typedef	BOOL	(*WASessionInitFunc)(struct _SessionStruct *Session, void **ModuleData);
typedef	BOOL	(*WASessionDestroyFunc)(struct _SessionStruct *Session, void *ModuleData);

/** Object modules **/
/* Flags */
#define	WAOBJ_PRIMARY_HANDLER	(1<<0)
#define	WAOBJ_NOTIFY_WRITE		(1<<1)

/* CreateFunc is only called for the primary handler */
typedef	unsigned long	(*WAObjCreateFunc)(struct _SessionStruct *Session, const unsigned char *ObjectClass, const unsigned char *ObjectName, const unsigned char *ParentDN, MDBValueStruct *Name, MDBValueStruct *Value, void *ModuleData);
typedef	BOOL				(*WAObjDeleteFunc)(struct _SessionStruct *Session, const unsigned char *ObjectClass, const unsigned char *DN, void *ModuleData);
typedef	BOOL				(*WAObjRenameFunc)(struct _SessionStruct *Session, const unsigned char *ObjectClass, const unsigned char *OldDN, const unsigned char *NewDN, void *ModuleData);
typedef	BOOL				(*WAObjUpdateFunc)(struct _SessionStruct *Session, const unsigned char *ObjectClass, const unsigned char *DN, MDBValueStruct *Name, MDBValueStruct *Value, MDBValueStruct *Type, void *ModuleData);

/* Template processing; here's where it's happening */
typedef	BOOL				(*WAHandleURLFunc)(struct _ConnectionStruct *Client, struct _SessionStruct *Session, struct _URLStruct *URL, void *ModuleData);
typedef	BOOL				(*WAHandleTemplateFunc)(struct _ConnectionStruct *Client, struct _SessionStruct *Session, unsigned long Page, struct _TokenOverlayStruct *Token, unsigned long *GotoToken, void *ModuleData);

/* Save form processing */
typedef	unsigned long	(*WASaveFunc)(struct _SessionStruct *Session, const unsigned char *ObjectClass, const unsigned char *DN, unsigned char *Name, unsigned char *Value, void *ModuleData);

/* Delete object processing */
typedef	unsigned long	(*WADeleteFunc)(struct _SessionStruct *Session, const unsigned char *ObjectClass, const unsigned char *DN, void *ModuleData);

/* Rename Object processing */
typedef	unsigned long	(*WARenameFunc)(struct _SessionStruct *Session, const unsigned char *ObjectClass, const unsigned char *DN, unsigned char *NewName, void *ModuleData);

/** MIME modules **/
typedef	int	(*WAHandleStreamFunc)(struct _ConnectionStruct *Client, struct _SessionStruct *Session);

/** Send modules **/
//typedef int		(*WAHandleStreamFunc)(struct _ConnectionStruct *Client, struct _SessionStruct *Session);


/** Here's the fun part: The structure that a module must fill out when registering with WA during init */
typedef struct {
	WASessionInitFunc			InitSession;
	WASessionDestroyFunc		DestroySession;
	WAHandleURLFunc			HandleURL;
	WAHandleTemplateFunc		HandleTemplate;
	unsigned long				TokenRangeStart;
	unsigned long				TokenRangeEnd;
} TemplateModuleStruct;

typedef struct {
	unsigned char				*ObjectClass;
	unsigned long				Flags;
	WASessionInitFunc			InitSession;
	WASessionDestroyFunc		DestroySession;
	WAObjCreateFunc			CreateFunction;
	WAObjDeleteFunc			DeleteFunction;
	WAObjRenameFunc			RenameFunction;
	WAObjUpdateFunc			UpdateFunction;
} ObjectModuleStruct;

typedef struct {
	unsigned char				*ObjectClass;
	unsigned long				Flags;
	WASessionInitFunc			InitSession;
	WASessionDestroyFunc		DestroySession;
	WASaveFunc					SaveFunction;
} SaveModuleStruct;

typedef struct {
	unsigned char				*ObjectClass;
	unsigned long				Flags;
	WASessionInitFunc			InitSession;
	WASessionDestroyFunc		DestroySession;
	WADeleteFunc				DeleteFunction;
} DeleteModuleStruct;

typedef struct {
	unsigned char				*ObjectClass;
	unsigned long				Flags;
	WASessionInitFunc			InitSession;
	WASessionDestroyFunc		DestroySession;
	WARenameFunc				RenameFunction;
} RenameModuleStruct;

typedef struct {
	unsigned char				*Name;
	WAHandleStreamFunc		Decoder;
	WAHandleStreamFunc		Encoder;
	BOOL							IsCharset;
} StreamModuleStruct;


typedef struct {
	unsigned long				ModuleType;
	union {
		TemplateModuleStruct	Template;
		ObjectModuleStruct	Object;
		SaveModuleStruct		Save;
		DeleteModuleStruct	Delete;
		RenameModuleStruct	Rename;
	} Module;
} ModuleRegisterStruct;


/* 
	The exported functions; of general interest 

	This is split into two sections; on NetWare, we can just define the prototypes, on Windows,
	Solaris, Linux (and probably the other Unix platforms with shared libraries we actually
	need to export the pointers to the parents functions...
*/


/* webadmin.c - main & basic functions; public */

#if defined(NETWARE) || defined(LIBC)
#define	APIFUNC(Command)		Command
#define	WAAPISetup
#define	WAAPIDefine				void *Ignored
#define	WAAPISet
#define	WAAPIArg					void *Ignored

#endif /* NETWARE || LIBC	*/

#if defined(LINUX) || defined(SOLARIS) || defined(WIN32) || defined(S390RH) || defined(REDHAT)
#define	APIFUNC(Command)	(* Command)
typedef struct _WAAPIStruct {
#endif /* LINUX || SOLARIS || WIN32 || S390RH || REDHAT */

int					APIFUNC(WADirectClientRead)(struct _ConnectionStruct *Client, const unsigned char *Buf, int Len);
int					APIFUNC(WADirectClientWrite)(struct _ConnectionStruct *Client, const unsigned char *Buf, int Len);
int					APIFUNC(WADirectNMAPRead)(struct _SessionStruct *Session, const unsigned char *Buf, int Len);
int					APIFUNC(WADirectNMAPWrite)(struct _SessionStruct *Session, const unsigned char *Buf, int Len);
BOOL					APIFUNC(WAFlushClient)(struct _ConnectionStruct *Client);
BOOL					APIFUNC(WASendClient)(struct _ConnectionStruct *Client, const unsigned char *Data, int Len);
BOOL					APIFUNC(WASendClientEscaped)(struct _ConnectionStruct *Client, const unsigned char *Data, int Len);
BOOL					APIFUNC(WASendNMAPServer)(struct _SessionStruct *Session, const unsigned char *Data, int Len);
int					APIFUNC(WAGetNMAPAnswer)(struct _SessionStruct *Session, unsigned char *Reply, int ReplyLen, BOOL CheckForResult);
BOOL					APIFUNC(WAReadClientLine)(struct _ConnectionStruct *Client);
BOOL					APIFUNC(WAProtectNMAP)(struct _ConnectionStruct *Client, BOOL Protect);

/* webadmins.c - session management; public */
BOOL					APIFUNC(WAConnectUserToNMAPServer)(SessionStruct *Session);
BOOL					APIFUNC(WADestroySession)(struct _SessionStruct *Session);

/* webadminu.c - utilities; public */
BOOL					APIFUNC(WAQuickCmp)(unsigned char *str1, unsigned char *str2);
BOOL					APIFUNC(WAQuickNCmp)(unsigned char *str1, unsigned char *str2, int len);
#define				WAGetFormName(Client, Name, NameSize)		WAGetFormNameEx((Client), (Name), NULL, NULL, (NameSize))
BOOL					APIFUNC(WAGetFormNameEx)(struct _ConnectionStruct *Client, unsigned char *Name, unsigned char *Type, unsigned char *Filename, unsigned long NameSize);
unsigned long		APIFUNC(WAGetFormValue)(struct _ConnectionStruct *Client, unsigned char *Value, unsigned long *ValueSize);
BOOL					APIFUNC(WAEncodeURL)(struct _SessionStruct *Session, unsigned char *URL, unsigned char Type, unsigned long Request, unsigned long Arg1, unsigned long Arg2, unsigned long Arg3, unsigned long Arg4);
BOOL					APIFUNC(WAEncodeURLEx)(struct _SessionStruct *Session, unsigned char *URL, unsigned char Type, unsigned long Request, unsigned long Arg1, unsigned long Arg2, unsigned long Arg3, unsigned long Arg4, BOOL ResumeOK);
BOOL					APIFUNC(WARedirectClient)(struct _ConnectionStruct *Client, unsigned char *URL);
int					APIFUNC(WAMDBtoX500)(const unsigned char *MDB, unsigned char *X500, MDBValueStruct *V);
int					APIFUNC(WAX500toMDB)(const unsigned char *X500, unsigned char *MDB, MDBValueStruct *V);
BOOL					APIFUNC(WASendURLExtra)(ConnectionStruct *Client, const unsigned char *Extra);
unsigned long		APIFUNC(WAURLExtraDecode)(ConnectionStruct *Client, unsigned char *Target, unsigned long TargetSize);


/* webadmint.c - template & preference management */
long					APIFUNC(WAFindTemplate)(unsigned char *TemplateName);
long					APIFUNC(WAFindTemplatePage)(unsigned char *Name, unsigned long Template);
BOOL					APIFUNC(WASetSessionTemplate)(unsigned long Template, unsigned long Language, struct _SessionStruct *Session);

/* webadmind.c - page display and processing; public */
BOOL					APIFUNC(WASendHTTPHeader)(struct _ConnectionStruct *Client, unsigned char *Type, unsigned long Size, unsigned char *Filename, BOOL Cache);
BOOL					APIFUNC(WAHandleTemplate)(struct _ConnectionStruct *Client, struct _SessionStruct *Session, unsigned long TemplateID, BOOL SendHeader);
BOOL					APIFUNC(WAHandlePublicTemplate)(struct _ConnectionStruct *Client, struct _SessionStruct *Session, unsigned long TemplateID);

/* webadminm.c - module management; public */
BOOL					APIFUNC(WARegisterModule)(ModuleRegisterStruct *Register);

#if defined(LINUX) || defined(SOLARIS) || defined(WIN32) || defined(S390RH) || defined(REDHAT)
} WAAPIStruct;

#ifdef __cplusplus
}
#endif

#ifndef WEBADMIN_BUILD_INTERNAL

extern	WAAPIStruct				*WAAPI;
#define	WAAPIDefine				WAAPIStruct *WAAPI = NULL
#define	WAAPISet					WAAPI=(WAAPIStruct *)WAAPIIn
#define	WAAPIArg					void *WAAPIIn

#define	WADirectClientRead	WAAPI->WADirectClientRead
#define	WADirectClientWrite	WAAPI->WADirectClientWrite
#define	WADirectNMAPRead		WAAPI->WADirectNMAPRead
#define	WADirectNMAPWrite		WAAPI->WADirectNMAPWrite
#define	WAFlushClient			WAAPI->WAFlushClient
#define	WASendClient			WAAPI->WASendClient
#define	WASendClientEscaped	WAAPI->WASendClientEscaped
#define	WASendNMAPServer		WAAPI->WASendNMAPServer
#define	WAGetNMAPAnswer		WAAPI->WAGetNMAPAnswer
#define	WAReadClientLine		WAAPI->WAReadClientLine
#define	WAProtectNMAP			WAAPI->WAProtectNMAP

#define	WAConnectUserToNMAPServer	WAAPI->WAConnectUserToNMAPServer
#define	WADestroySession		WAAPI->WADestroySession

#define	WAQuickCmp				WAAPI->WAQuickCmp
#define	WAQuickNCmp				WAAPI->WAQuickNCmp
#define	WAGetFormNameEx		WAAPI->WAGetFormNameEx
#define	WAGetFormValue			WAAPI->WAGetFormValue
#define	WAEncodeURL				WAAPI->WAEncodeURL
#define	WAEncodeURLEx			WAAPI->WAEncodeURLEx
#define	WARedirectClient		WAAPI->WARedirectClient
#define	WAMDBtoX500				WAAPI->WAMDBtoX500
#define	WAX500toMDB				WAAPI->WAX500toMDB
#define	WASendURLExtra			WAAPI->WASendURLExtra
#define	WAURLExtraDecode		WAAPI->WAURLExtraDecode

#define	WAFindTemplate			WAAPI->WAFindTemplate
#define	WAFindTemplatePage	WAAPI->WAFindTemplatePage
#define	WASetSessionTemplate	WAAPI->WASetSessionTemplate

#define	WASendHTTPHeader		WAAPI->WASendHTTPHeader
#define	WAHandleTemplate		WAAPI->WAHandleTemplate
#define	WAHandlePublicTemplate			WAAPI->WAHandlePublicTemplate
#define	WARegisterModule		WAAPI->WARegisterModule


#else

int					WADirectClientRead(struct _ConnectionStruct *Client, const unsigned char *Buf, int Len);
int					WADirectClientWrite(struct _ConnectionStruct *Client, const unsigned char *Buf, int Len);
int					WADirectNMAPRead(struct _SessionStruct *Session, const unsigned char *Buf, int Len);
int					WADirectNMAPWrite(struct _SessionStruct *Session, const unsigned char *Buf, int Len);
BOOL					WAFlushClient(struct _ConnectionStruct *Client);
BOOL					WASendClient(struct _ConnectionStruct *Client, const unsigned char *Data, int Len);
BOOL					WASendClientEscaped(struct _ConnectionStruct *Client, const unsigned char *Data, int Len);
BOOL					WASendNMAPServer(struct _SessionStruct *Session, const unsigned char *Data, int Len);
int					WAGetNMAPAnswer(struct _SessionStruct *Session, unsigned char *Reply, int ReplyLen, BOOL CheckForResult);
BOOL					WAReadClientLine(struct _ConnectionStruct *Client);
BOOL					WAProtectNMAP(struct _ConnectionStruct *Client, BOOL Protect);

/* webadmins.c - session management; public */
BOOL					WAConnectUserToNMAPServer(SessionStruct *Session);
BOOL					WADestroySession(struct _SessionStruct *Session);

/* webadminu.c - utilities; public */
BOOL					WAQuickCmp(unsigned char *str1, unsigned char *str2);
BOOL					WAQuickNCmp(unsigned char *str1, unsigned char *str2, int len);
#define				WAGetFormName(Client, Name, NameSize)		WAGetFormNameEx((Client), (Name), NULL, NULL, (NameSize))
BOOL					WAGetFormNameEx(struct _ConnectionStruct *Client, unsigned char *Name, unsigned char *Type, unsigned char *Filename, unsigned long NameSize);
unsigned long		WAGetFormValue(struct _ConnectionStruct *Client, unsigned char *Value, unsigned long *ValueSize);
BOOL					WAEncodeURL(struct _SessionStruct *Session, unsigned char *URL, unsigned char Type, unsigned long Request, unsigned long Arg1, unsigned long Arg2, unsigned long Arg3, unsigned long Arg4);
BOOL					WAEncodeURLEx(struct _SessionStruct *Session, unsigned char *URL, unsigned char Type, unsigned long Request, unsigned long Arg1, unsigned long Arg2, unsigned long Arg3, unsigned long Arg4, BOOL ResumeOK);
BOOL					WARedirectClient(struct _ConnectionStruct *Client, unsigned char *URL);
int					WAMDBtoX500(const unsigned char *MDB, unsigned char *X500, MDBValueStruct *V);
int					WAX500toMDB(const unsigned char *X500, unsigned char *MDB, MDBValueStruct *V);
BOOL					WASendURLExtra(ConnectionStruct *Client, const unsigned char *Extra);
unsigned long		WAURLExtraDecode(ConnectionStruct *Client, unsigned char *Target, unsigned long TargetSize);

/* webadmint.c - template & preference management */
long					WAFindTemplate(unsigned char *TemplateName);
long					WAFindTemplatePage(unsigned char *Name, unsigned long Template);
BOOL					WASetSessionTemplate(unsigned long Template, unsigned long Language, struct _SessionStruct *Session);

/* webadmind.c - page display and processing; public */
BOOL					WASendHTTPHeader(struct _ConnectionStruct *Client, unsigned char *Type, unsigned long Size, unsigned char *Filename, BOOL Cache);
BOOL					WAHandleTemplate(struct _ConnectionStruct *Client, struct _SessionStruct *Session, unsigned long TemplateID, BOOL SendHeader);
BOOL					WAHandlePublicTemplate(struct _ConnectionStruct *Client, struct _SessionStruct *Session, unsigned long TemplateID);

/* webadminm.c - module management; public */
BOOL					WARegisterModule(ModuleRegisterStruct *Register);

#define	WAAPISetup																\
	WAAPI.WADirectClientRead=WADirectClientRead;							\
	WAAPI.WADirectClientWrite=WADirectClientWrite;						\
	WAAPI.WADirectNMAPRead=WADirectNMAPRead;								\
	WAAPI.WADirectNMAPWrite=WADirectNMAPWrite;							\
	WAAPI.WAFlushClient=WAFlushClient;										\
	WAAPI.WASendClient=WASendClient;											\
	WAAPI.WASendClientEscaped=WASendClientEscaped;						\
	WAAPI.WASendNMAPServer=WASendNMAPServer;								\
	WAAPI.WAGetNMAPAnswer=WAGetNMAPAnswer;									\
	WAAPI.WAReadClientLine=WAReadClientLine;								\
	WAAPI.WAProtectNMAP=WAProtectNMAP;										\
																						\
	WAAPI.WAConnectUserToNMAPServer=WAConnectUserToNMAPServer;		\
	WAAPI.WADestroySession=WADestroySession;								\
																						\
	WAAPI.WAQuickCmp=WAQuickCmp;												\
	WAAPI.WAQuickNCmp=WAQuickNCmp;											\
	WAAPI.WAGetFormNameEx=WAGetFormNameEx;									\
	WAAPI.WAGetFormValue=WAGetFormValue;									\
	WAAPI.WAEncodeURL=WAEncodeURL;											\
	WAAPI.WAEncodeURLEx=WAEncodeURLEx;										\
	WAAPI.WARedirectClient=WARedirectClient;								\
	WAAPI.WAMDBtoX500=WAMDBtoX500;											\
	WAAPI.WAX500toMDB=WAX500toMDB;											\
	WAAPI.WASendURLExtra=WASendURLExtra;									\
	WAAPI.WAURLExtraDecode=WAURLExtraDecode;								\
																						\
	WAAPI.WAFindTemplate=WAFindTemplate;									\
	WAAPI.WAFindTemplatePage=WAFindTemplatePage;							\
	WAAPI.WASetSessionTemplate=WASetSessionTemplate;					\
																						\
	WAAPI.WASendHTTPHeader=WASendHTTPHeader;								\
	WAAPI.WAHandleTemplate=WAHandleTemplate;								\
	WAAPI.WAHandlePublicTemplate=WAHandlePublicTemplate;				\
																						\
	WAAPI.WARegisterModule=WARegisterModule;

#endif /* WEBADMIN_BUILD_INTERNAL */

#if !defined(_UNICODE_TYPE_DEFINED)
#define _UNICODE_TYPE_DEFINED
typedef unsigned short	unicode;
#endif

#endif /* LINUX || SOLARIS || WIN32 || S390RH || REDHAT */

#endif
