/****************************************************************************
 *
 * Copyright (c) 2001-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#ifndef _CALENDAR_H
#define _CALENDAR_H

#include <connio.h>
#include <mdb.h>
#include <management.h>
#include <msgapi.h>
#include <nmap.h>
#include <nmlib.h>
#include <streamio.h>
#include <libical.h>

#define PRODUCT_SHORT_NAME "hulacalendar.nlm"

#define CONNECTION_TIMEOUT (15 * 60)

typedef enum _CalStates {
    CAL_STATE_STARTING = 0, 
    CAL_STATE_INITIALIZING, 
    CAL_STATE_LOADING, 
    CAL_STATE_RUNNING, 
    CAL_STATE_RELOADING, 
    CAL_STATE_UNLOADING, 
    CAL_STATE_STOPPING, 
    CAL_STATE_DONE, 

    CAL_STATE_MAX_STATES
} CalStates;

typedef enum _CalFlags {
    CAL_FLAG_UNUSED = (1 << 0), 
} CalFlags;

typedef enum _CalClientFlags {
    CAL_CLIENT_FLAG_NEW = (1 << 0), 
    CAL_CLIENT_FLAG_WAITING = (1 << 1), 
    CAL_CLIENT_FLAG_EXITING = (1 << 2)
} CalClientFlags;

typedef enum _CalBounce {
    CAL_BOUNCE_NONE = 0, 
    CAL_BOUNCE_NO_ATTENDEE, 
    CAL_BOUNCE_INVALID_OBJECT
} CalBounce;

typedef struct {
	CalClientFlags flags;

    Connection *conn;

    unsigned char *envelope;
    unsigned char *from;

    unsigned char line[CONN_BUFSIZE + 1];
    unsigned char command[CONN_BUFSIZE + 1];
    unsigned char dn[MDB_MAX_OBJECT_CHARS + 1];

    ICalObject *iCal;
    MDBValueStruct *vs;
} CalClient;

typedef struct _CalGlobals {
	CalStates state;
	CalFlags flags;

    unsigned char officialName[MAXEMAILNAMESIZE + 1];

    struct {
        XplSemaphore semaphore;

        struct {
            XplSemaphore todo;

            XplAtomic maximum;
            XplAtomic active;
            XplAtomic idle;

            Connection *head;
            Connection *tail;
        } worker;

        struct {
            BOOL enable;

            ConnSSLConfiguration config;

            SSL_CTX *context;

            Connection *conn;
        } ssl;

        Connection *conn;

        void *pool;

        time_t sleepTime;

        unsigned long queue;

        unsigned char address[80];
        unsigned char hash[NMAP_HASH_SIZE];
    } nmap;

    struct {
        MDBHandle directory;

        void *logging;
    } handle;

    struct {
        XplThreadID main;
        XplThreadID group;
    } id;

    struct {
        XplSemaphore main;
        XplSemaphore shutdown;
    } sem;

    struct {
        XplAtomic active;
    } server;

    struct {
        XplAtomic called;
    } stats;
} CalGlobals;

extern CalGlobals Cal;

/* management.c */
ManagementVariables *GetCalManagementVariables(void);
int GetCalManagementVariablesCount(void);
ManagementCommands *GetCalManagementCommands(void);
int GetCalManagementCommandsCount(void);

/* stream.c */
BOOL MWHandleNamedTemplate(void *ignored1, unsigned char *ignored2, void *ignored3);
int CalStreamToMemory(StreamStruct *codec, StreamStruct *next);
int CalStreamToFile(StreamStruct *codec, StreamStruct *next);
int CalStreamFromNMAP(StreamStruct *codec, StreamStruct *next);

#endif /* _CALENDAR_H */
