/****************************************************************************
 *
 * Copyright (c) 2001-2005 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#ifndef _HULAFORWARD_H
#define _HULAFORWARD_H

#include <connio.h>
#include <mdb.h>
#include <management.h>
#include <msgapi.h>
#include <libical.h>
#include <streamio.h>
#include <nmap.h>
#include <nmlib.h>

#define PRODUCT_SHORT_NAME "hulaforward.nlm"

#define CONNECTION_TIMEOUT (15 * 60)

typedef enum _ForwardStates {
    FORWARD_STATE_STARTING = 0, 
    FORWARD_STATE_INITIALIZING, 
    FORWARD_STATE_LOADING, 
    FORWARD_STATE_RUNNING, 
    FORWARD_STATE_RELOADING, 
    FORWARD_STATE_UNLOADING, 
    FORWARD_STATE_STOPPING, 
    FORWARD_STATE_DONE, 

    FORWARD_STATE_MAX_STATES
} ForwardStates;

typedef enum _ForwardClientFlags {
    FORWARD_CLIENT_FLAG_NEW = (1 << 0), 
    FORWARD_CLIENT_FLAG_WAITING = (1 << 1), 
    FORWARD_CLIENT_FLAG_EXITING = (1 << 2)
} ForwardClientFlags;

typedef struct {
    ForwardClientFlags flags;

    Connection *conn;
    Connection *store;

    unsigned char *envelope;
    unsigned char line[CONN_BUFSIZE + 1];
    unsigned char queueID[16];
    unsigned char dn[MDB_MAX_OBJECT_CHARS + 1];
    unsigned char user[MDB_MAX_OBJECT_CHARS + 1];
    unsigned char recipient[MDB_MAX_OBJECT_CHARS + 1];
} ForwardClient;

typedef struct _ForwardGlobals {
    ForwardStates state;

    unsigned char *replyMessage;
    unsigned char officialName[MAXEMAILNAMESIZE + 1];
    unsigned char postmaster[MDB_MAX_OBJECT_CHARS + 1];

    MDBValueStruct *vs;
    MDBValueStruct *forward;

    struct {
        MDBHandle directory;

        void *logging;
    } handle;

    struct {
        XplThreadID main;
        XplThreadID group;
    } id;

    struct {
        XplSemaphore semaphore;

        struct {
            XplSemaphore todo;

            XplAtomic maximum;
            XplAtomic active;
            XplAtomic idle;

            Connection *head;
            Connection *tail;
        } worker;

        struct {
            BOOL enable;

            ConnSSLConfiguration config;

            SSL_CTX *context;

            Connection *conn;
        } ssl;

        Connection *conn;

        void *pool;

        time_t sleepTime;

        unsigned long queue;

        unsigned char address[80];
        unsigned char hash[NMAP_HASH_SIZE];
    } nmap;

    struct {
        XplSemaphore main;
        XplSemaphore shutdown;
    } sem;

    struct {
        XplAtomic active;
    } server;

    struct {
        XplAtomic called;
    } stats;
} ForwardGlobals;

extern ForwardGlobals Forward;

/* management.c */
ManagementVariables *GetForwardManagementVariables(void);
int GetForwardManagementVariablesCount(void);
ManagementCommands *GetForwardManagementCommands(void);
int GetForwardManagementCommandsCount(void);

#endif /* _HULAFORWARD_H */
