/****************************************************************************
 *
 * Copyright (c) 1997-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#include <config.h>
#include <xpl.h>
#include <mdb.h>

#include "nmapdp.h"

int 
NmapCommandShareAdbk(void *param)
{
    int count;
    int ccode;
    unsigned long used;
    unsigned int len;
    unsigned char *ptr;
    unsigned char buffer[CONN_BUFSIZE + 1];
    unsigned char resource[XPL_MAX_PATH + 1];
    BOOL result;
    NMAPClient *client = (NMAPClient *)param;
    MDBValueStruct *vs = NULL;

    if (client->states & NMAP_CLIENT_USER) {
        ptr = client->buffer + 10;
    } else {
        return(ConnWrite(client->conn, MSG3241NOUSER, sizeof(MSG3241NOUSER) - 1));
    }

    /* SHARE ADBK[ <resource name>[ <grantee> <permissions>]] */
    if (*ptr == '\0') {
        result = MsgFindObject(client->user, client->dn, NULL, NULL, NULL);
    } else if ((*ptr++ == ' ') && (*ptr) && (!isspace(*ptr))) {
        return(HandleShareCreate(client, NMAP_SHARE_ADDRESS_BOOK, resource, ptr));
    } else {
        return(ConnWrite(client->conn, MSG3010BADARGC, sizeof(MSG3010BADARGC) - 1));
    }

    if (result) {
        vs = MDBCreateValueStruct(NMAP.handle.directory, NULL);
    } else {
        return(ConnWrite(client->conn, MSG4224NOUSER, sizeof(MSG4224NOUSER) - 1));
    }

    if (vs) {
        strcpy(buffer, "ABAddressBook\r");
        count = 14;

        ccode = ConnWrite(client->conn, "2002-Coming up\r\n", 16);

        MDBRead(client->dn, MSGSRV_A_OWNED_SHARES, vs);
        for (used = 0; (ccode != -1) && (used < vs->Used); used++) {
            if (XplStrNCaseCmp(buffer, vs->Value[used], count) != 0) {
                continue;
            }

            len = strlen(vs->Value[used]);
            vs->Value[used][len - 11] = '\0';

            ptr = strchr(vs->Value[used], '\r');
            if (ptr != NULL) {
                *ptr++ = '\0';

                ccode = ConnWriteF(client->conn, "2002-%s %s %lu\r\n", vs->Value[used] + 2, ptr, atol(&(vs->Value[used][len - 10])));
            }
        }

        if (ccode != -1) {
            ccode = ConnWrite(client->conn, MSG1000OK, sizeof(MSG1000OK) - 1);
        }

        MDBDestroyValueStruct(vs);
    } else {
        ccode = ConnWrite(client->conn, MSG5001NOMEMORY, sizeof(MSG5001NOMEMORY) - 1);
    }

    return(ccode);
}

int 
NmapCommandAdbk(void *param)
{
    int ccode;
    unsigned long count;
    unsigned char *ptr;
    unsigned char *data;
    unsigned char ident[9];
    BOOL result;
    NMAPClient *client = (NMAPClient *)param;
    MDBValueStruct *vs;

    if (client->states & NMAP_CLIENT_USER) {
        ptr = client->buffer + 4;
        if (*ptr == ' ') {
            ptr++;
        } else {
            return(ConnWrite(client->conn, MSG3010BADARGC, sizeof(MSG3010BADARGC) - 1));
        }
    } else {
        return(ConnWrite(client->conn, MSG3241NOUSER, sizeof(MSG3241NOUSER) - 1));
    }

    result = MsgFindObject(client->user, client->dn, NULL, NULL, NULL);
    if (result) {
        vs = MDBCreateValueStruct(NMAP.handle.directory, NULL);
    } else {
        return(ConnWrite(client->conn, MSG4224NOUSER, sizeof(MSG4224NOUSER) - 1));
    }

    MDBRead(client->dn, MSGSRV_A_ADDRESSBOOK, vs);

    switch(toupper(*ptr)) {
        case 'A': {
            /* ADD <count> */
            /* ID is 8, all fields have a \n, so total count is at least 19 */
            if ((toupper(ptr[1]) == 'D') 
                    && (toupper(ptr[2]) == 'D') 
                    && (ptr[3] == ' ') 
                    && (isdigit(ptr[4])) 
                    && ((count = atol(ptr + 4)) >= 19)) {
                data = MemMalloc(sizeof(unsigned char)*(count + 1));
            } else {
                ccode = ConnWrite(client->conn, MSG3010BADARGC, sizeof(MSG3010BADARGC) - 1);
                break;
            }

            if (data) {
                ccode = ConnReadCount(client->conn, data, count);
                if (ccode != -1) {
                    data[count] = '\0';
                } else {
                    break;
                }
            } else {
                ccode = ConnWrite(client->conn, MSG5001NOMEMORY, sizeof(MSG5001NOMEMORY) - 1);
                break;
            }

            /* Check if there's an existing entry by the same ID and delete it if found */
            memcpy(ident, data, 8);
            ident[8] = '\0';

            result = FALSE;
            for (count = 0; count < vs->Used; count++) {
                if (QuickNCmp(ident, vs->Value[count], 8)) {
                    MDBFreeValue(count, vs);

                    result = TRUE;
                }
            }

            if ((MDBAddValue(data, vs)) 
                    && (MDBWrite(client->dn, MSGSRV_A_ADDRESSBOOK, vs))) {
                if (!result) {
                    ccode = ConnWriteF(client->conn, "1000 %s Addressbook entry created\r\n", ident);
                } else {
                    ccode = ConnWriteF(client->conn, "1000 %s Addressbook entry replaced\r\n", ident);
                }
            } else {
                ccode = ConnWrite(client->conn, "5005 Could not update user database\r\n", 37);
            }

            MemFree(data);
            break;
        }

        case 'D': {
            /* Delete ID */
            if ((toupper(ptr[1]) == 'E') 
                    && (toupper(ptr[2]) == 'L') 
                    && (toupper(ptr[3]) == 'E') 
                    && (toupper(ptr[4]) == 'T') 
                    && (toupper(ptr[5]) == 'E') 
                    && (ptr[6] == ' ')) {
                ptr += 7;
            } else {
                ccode = ConnWrite(client->conn, MSG3010BADARGC, sizeof(MSG3010BADARGC) - 1);
                break;
            }

            result = FALSE;
            for (count = 0; count < vs->Used; count++) {
                if (QuickNCmp(ptr, vs->Value[count], 8)) {
                    MDBFreeValue(count, vs);
                    result = TRUE;
                }
            }

            if (result && MDBWrite(client->dn, MSGSRV_A_ADDRESSBOOK, vs)) {
                ccode = ConnWrite(client->conn, "1000 Addressbook entry deleted\r\n", 32);
            } else {
                ccode = ConnWrite(client->conn, MSG4220NOENTRY, sizeof(MSG4220NOENTRY) - 1);
            }

            break;
        }

        case 'L': {
            /* List [ID]*/
            if ((toupper(ptr[1]) == 'I') 
                    && (toupper(ptr[2]) == 'S') 
                    && (toupper(ptr[3]) == 'T') 
                    && ((ptr[4] == '\0') || (ptr[4] == ' '))) {
                ptr += 4;
            } else {
                ccode = ConnWrite(client->conn, MSG3010BADARGC, sizeof(MSG3010BADARGC) - 1);
                break;
            }

            if (*ptr == '\0') {
                ccode = ConnWriteF(client->conn, "2002 %lu entries follow\r\n", vs->Used);
                for (count = 0; (ccode != -1) && (count < vs->Used); count++) {
                    memcpy(ident, vs->Value[count], 8);
                    ident[8] = '\0';

                    ccode = ConnWriteF(client->conn, "2001 %d %s entry follows\r\n", strlen(vs->Value[count]), ident);
                    if (ccode != -1) {
                        ccode = ConnWrite(client->conn, vs->Value[count], strlen(vs->Value[count]));
                    }
                }

            } else {
                ccode = 0;
                ptr++;
                for (count = 0; count < vs->Used; count++) {
                    if (QuickNCmp(ptr, vs->Value[count], 8)) {
                        ccode = ConnWriteF(client->conn, "2001 %d %s entry follows\r\n", strlen(vs->Value[count]), ptr);
                        break;
                    }
                }
            }

            if (ccode != -1) {
                ccode = ConnWrite(client->conn, MSG1000OK, sizeof(MSG1000OK) - 1);
            }

            break;
        }
    }

    MDBDestroyValueStruct(vs);

    return(ccode);
}
