/****************************************************************************
 *
 * Copyright (c) 1998-2004 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#include <msgapi.h>

#define DEFAULT_QUOTA_MESSAGE             "The user to whom this message was addressed has exceeded the allowed mailbox\nquota. Please resend the message at a later time."
#define NMAP_CREDENTIAL_SIZE              4096

#define HULA_SETUP_SCHEMA                 (1 << 0)
#define HULA_SETUP_CREATE                 (1 << 1)
#define HULA_SETUP_VERBOSE                (1 << 2)
#define HULA_SETUP_CERTIFICATE            (1 << 3)
#define HULA_SETUP_DIRECTORY_CREDENTIAL   (1 << 4)
#define HULA_SETUP_SERVER_CREDENTIAL      (1 << 5)
#define HULA_SETUP_HOST_ASSOCIATION       (1 << 6)
#define HULA_SETUP_ALL                    (HULA_SETUP_SCHEMA | HULA_SETUP_CREATE | HULA_SETUP_CERTIFICATE | HULA_SETUP_DIRECTORY_CREDENTIAL | HULA_SETUP_SERVER_CREDENTIAL)

#define HULA_AGENT_ADDRESS_BOOK            (1 << 1)
#define HULA_AGENT_ALIAS                   (1 << 2)
#define HULA_AGENT_ANTISPAM                (1 << 3)
#define HULA_AGENT_ANTIVIRUS               (1 << 4)
#define HULA_AGENT_CALENDAR                (1 << 5)
#define HULA_AGENT_FINGER                  (1 << 6)
#define HULA_AGENT_FORWARD                 (1 << 7)
#define HULA_AGENT_CONNMGR                 (1 << 8)
#define HULA_AGENT_IMAP                    (1 << 9)
#define HULA_AGENT_LISTSRV                 (1 << 10)
#define HULA_AGENT_MODWEB                  (1 << 11)
#define HULA_AGENT_NMAP                    (1 << 12)
#define HULA_AGENT_PLUSPACK                (1 << 13)
#define HULA_AGENT_POP                     (1 << 14)
#define HULA_AGENT_PROXY                   (1 << 15)
#define HULA_AGENT_RULESRV                 (1 << 16)
#define HULA_AGENT_SMTP                    (1 << 17)
#define HULA_AGENT_WEBADMIN                (1 << 18)
#define HULA_AGENT_ALL                     (HULA_AGENT_ALIAS | HULA_AGENT_ADDRESS_BOOK | HULA_AGENT_ANTISPAM | HULA_AGENT_ANTIVIRUS | HULA_AGENT_CALENDAR | HULA_AGENT_FINGER | HULA_AGENT_FORWARD | HULA_AGENT_CONNMGR | HULA_AGENT_IMAP | HULA_AGENT_LISTSRV | HULA_AGENT_MODWEB | HULA_AGENT_NMAP | HULA_AGENT_PLUSPACK | HULA_AGENT_POP | HULA_AGENT_PROXY | HULA_AGENT_RULESRV | HULA_AGENT_SMTP | HULA_AGENT_WEBADMIN)

#define HULA_CLASS_INTERNET_SERVICES       (1 << 0)
#define HULA_CLASS_MESSAGING_SERVER        (1 << 1)
#define HULA_CLASS_MAIL_AGENT              (1 << 2)
#define HULA_CLASS_PROXY_AGENT             (1 << 3)
#define HULA_CLASS_ADDRESSBOOK_AGENT       (1 << 4)
#define HULA_CLASS_NMAP_AGENT              (1 << 5)
#define HULA_CLASS_POP_AGENT               (1 << 6)
#define HULA_CLASS_IMAP_AGENT              (1 << 7)
#define HULA_CLASS_WEBMAIL_AGENT           (1 << 8)
#define HULA_CLASS_SMTP_AGENT              (1 << 9)
#define HULA_CLASS_ANTISPAM_AGENT          (1 << 10)
#define HULA_CLASS_AUTOREPLY_AGENT         (1 << 11)
#define HULA_CLASS_FINGER_AGENT            (1 << 12)
#define HULA_CLASS_USER                    (1 << 13)
#define HULA_CLASS_GROUP                   (1 << 14)
#define HULA_CLASS_CONTEXT                 (1 << 15)
#define HULA_CLASS_NCP_SERVER              (1 << 16)
#define HULA_CLASS_ALIAS_AGENT             (1 << 17)
#define HULA_CLASS_SIGNUP_AGENT            (1 << 18)
#define HULA_CLASS_CONNMGR_AGENT           (1 << 19)
#define HULA_CLASS_RULESRV_AGENT           (1 << 20)
#define HULA_CLASS_ORGANIZATIONAL_ROLE     (1 << 21)
#define HULA_CLASS_LIST_AGENT              (1 << 22)
#define HULA_CLASS_LIST_CONTAINER          (1 << 23)
#define HULA_CLASS_LIST                    (1 << 24)
#define HULA_CLASS_LIST_USER               (1 << 25)
#define HULA_CLASS_NDSLIST                 (1 << 26)
#define HULA_CLASS_PARENT_CONTAINER        (1 << 27)
#define HULA_CLASS_PARENT_OBJECT           (1 << 28)
#define HULA_CLASS_TEMPLATE_CONTAINER      (1 << 29)
#define HULA_CLASS_MODWEB_TEMPLATE         (1 << 30)
#define HULA_CLASS_UNUSED                  (1 << 31)
#define HULA_CLASS2_MODWEB_AGENT           (1 << 0)
#define HULA_CLASS2_MWMAIL_MODULE          (1 << 1)
#define HULA_CLASS2_MWCAL_MODULE           (1 << 2)
#define HULA_CLASS2_MWPREF_MODULE          (1 << 3)
#define HULA_CLASS2_MWTOM_MODULE           (1 << 4)
#define HULA_CLASS2_CALENDAR_AGENT         (1 << 5)
#define HULA_CLASS2_ANTIVIRUS_AGENT        (1 << 6)
#define HULA_CLASS2_MWSIGNUP_MODULE        (1 << 7)
#define HULA_CLASS2_PLUSPACK_AGENT         (1 << 8)
#define HULA_CLASS2_HULA_RESOURCE          (1 << 9)
#define HULA_CLASS2_CAP_AGENT              (1 << 10)
#define HULA_CLASS2_WEBADMIN_AGENT         (1 << 11)
#define HULA_CLASS2_WEBADMIN_ROLE          (1 << 12)
#define HULA_CLASS2_MODWEB_MODULE          (1 << 13)
#define HULA_CLASS2_GATEKEEPER_MODULE      (1 << 14)
#define HULA_CLASS2_USER_MODULE            (1 << 15)
#define HULA_CLASS2_LISTS_MODULE           (1 << 16)
#define HULA_CLASS2_RBL_MODULE             (1 << 17)
#define HULA_CLASS2_RDNS_MODULE            (1 << 18)

#define HULA_ATTRIBUTE_FLAG_DN             (1 << 0)
#define HULA_ATTRIBUTE_FLAG_SINGLE_VALUE   (1 << 1)
#define HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC (1 << 2)
#define HULA_ATTRIBUTE_FLAG_PUBLIC         (1 << 3)

#define HULA_CLASS_FLAG_CONTAINER          (1 << 0)

#define Advance(p, b)                     { (p)=((b)); while (*(p) && isspace(*(p))) (p)++; }
#define ChopNL(s)                         { unsigned char *p = strchr((s), 0x0A); if (p) { *p = '\0'; p = strrchr((s), 0x0D); if (p) { *p = '\0'; } } }

typedef struct _DirectoryAttributeStruct {
    unsigned char *name;
    unsigned char *asn1;

    unsigned long flags;

    int minimum;
    int maximum;

    struct {
        unsigned long mandatory;
        unsigned long optional[2];
    } attributes;
} DirectoryAttributeStruct;

typedef struct _DirectoryObjectClassStruct {
	unsigned char *name;
    unsigned char *asn1;

    unsigned long flags;
	unsigned long classes[2];

	unsigned char *superClass;
	unsigned char *naming;
	unsigned char *containment[4];
	unsigned char *mandatory[8];
} DirectoryObjectClassStruct;
