/****************************************************************************
 *
 * Copyright (c) 1997-2004 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#ifndef LOGGERP_H
#define LOGGERP_H

#include <config.h>
#include <xpl.h>
#include <logger.h>

/*
  Novell NSure Audit Support

  AppID Prefix is 0x0002
*/
#define	HULA_NSURE_LOG_NAME "Hula"
#define	HULA_NSURE_DEFAULT_FLAG 0

/* Definitions */
enum LoggerStates {
    LOGGER_STATE_LOADING = 0, 
    LOGGER_STATE_INITIALIZING, 
    LOGGER_STATE_RUNNING, 
    LOGGER_STATE_ABORTING, 
    LOGGER_STATE_CLOSING, 

    LOGGER_STATE_MAX
};

typedef void *(*LoggerOpenFunc) (const char *name);
typedef void (*LoggerCloseFunc) (void *handle);
typedef void (*LoggerEventFunc) (void *LoggingHandle, const char *subsystem, unsigned long eventId, int level, int unknown /*fixme*/, const char *str1, const char *str2, int i1, int i2, void *p, int size);

/* Structures */

typedef struct _Logger {
    LoggerOpenFunc open;
    LoggerCloseFunc close;
    LoggerEventFunc event;
} Log;

typedef struct _LoggerConfiguration {
    enum LoggerStates State;
    XplSemaphore Shutdown;
    const Log *log;
} LoggerConfiguration;

/* Variables */

#if 0
static unsigned char	*DefaultNSurePrivateKey= {	
    "-----BEGIN RSA PRIVATE KEY-----\r\n"
    "MIIBOwIBAAJBAMrZU2cp4CtQVHWQ003RI5M6L8INWFIwzRUb0rOdeOhnTwUxoWpl\r\n"
    "T0KFiR0t/8EExDXRLwOLVuo48FCHZDZir2UCAwEAAQJAbe2woSu0bESwQLYnjPhV\r\n"
    "yyexUfxhbMk9mr7lRKmGKIs7i/LHwWLIMaSSLNrJ/S4iEiibMc9n6J89qV1FBwO8\r\n"
    "gQIhAP1OIcBGbMPUgvbB4n/JNDZjdvEK8J215lCYFCCl/qjJAiEAzQHHKsbEbwbu\r\n"
    "C2mH8LOgPKDi3hZIXd06KGi1W89L+70CIQCIi5WmEFCRP/1ZBysRt2Rt7TAwv7T1\r\n"
    "TxjYWSKAdvrQAQIgDPjm1HMdbPUgTQKRgo6rPgrkMC9yxtW/31y41SVp5nUCIQCP\r\n"
    "qU2dwoyCh1CLBwB+1ShM7Yqn6pxW+QXN5e53uCdFmA==\r\n"
    "-----END RSA PRIVATE KEY-----\r\n"
};

static unsigned char	*DefaultNSureCertificate = {	
    "-----BEGIN CERTIFICATE-----\r\n"
    "MIIBlDCCAT6gAwIBAgIBAjANBgkqhkiG9w0BAQQFADAqMQswCQYDVQQGEwJVUzEb\r\n"
    "MBkGA1UEAxMSTm92ZWxsIE5TdXJlIEF1ZGl0MB4XDTAzMDMzMDAzNTQxM1oXDTEz\r\n"
    "MDMyNzAzNTQxM1owHzELMAkGA1UEBhMCVVMxEDAOBgNVBAMTB05ldE1haWwwXDAN\r\n"
    "BgkqhkiG9w0BAQEFAANLADBIAkEAytlTZyngK1BUdZDTTdEjkzovwg1YUjDNFRvS\r\n"
    "s5146GdPBTGhamVPQoWJHS3/wQTENdEvA4tW6jjwUIdkNmKvZQIDAQABo1owWDAO\r\n"
    "BgNVHQ8BAf8EBAMCBaAwGAYDVR0RBBEwD4ENYXJnbEBibGFoLmNvbTARBglghkgB\r\n"
    "hvhCAQEEBAMCBaAwGQYMYIZIAYb4NwGCWwoBBAkWB05ldE1haWwwDQYJKoZIhvcN\r\n"
    "AQEEBQADQQBatYuQTb3DMMjOYSOD+1B3pLta7xUhph1pzjpRSSFzlYq6Y19q9sKF\r\n"
    "Kee/2eLDUlMeiCIEzJnCaeDUGP7/ZPH7\r\n"
    "-----END CERTIFICATE-----\r\n"
};
#endif

/* Prototypes */

int LoggerFormatMessage (int eventId, char *buf, unsigned int len, const char *var_S, const char *var_T, unsigned int var_1, unsigned int var_2,  void *var_D, int var_X);

const Log *LoggerGetSyslog (void);

#endif /* LOGGERP_H */
