/****************************************************************************
 *
 * Copyright (c) 2001-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#include <config.h>
#define NMLOGID_H_NEED_LOGGING_KEY
#define NMLOGID_H_NEED_LOGGING_CERT
#include <xpl.h>

#include <mdb.h>
#include <msgapi.h>
#include <msgaddr.h>
#include <nmap.h>
#include	<rulesrv.h>
#include <hulautil.h>

#include <modweb.h>
#include <mwtempl.h>
#include <ctype.h>

MWAPIDefine;

#define	PRODUCT_SHORT_NAME		"mwpref.nlm"

#include "mwpref.h"

static BOOL				UnloadOK						= TRUE;
XplAtomic		MWPREFLibraryUserCount;

unsigned long	PasswordConfig				= 2;		/* First bit is allow password.  Second bit is require SSL */
unsigned long	GeneralConfig				= 0;		/* First bit is colours.  Second bit is general config */
void				*LogHandle					= NULL;
MDBHandle		ModuleDirectoryHandle	= NULL;

static int				TGid;
XplSemaphore	MWPrefShutdownSemaphore;
#if defined(MODWEB_DEBUG_BUILD)
int				ModScreen;
#endif

static BOOL 
ProcessRuleCreateForm(ConnectionStruct *Client, SessionStruct *Session, PrefSessionStruct *PrefSession)
{
	unsigned long	ValueSize;
	unsigned char	FieldName[128];
	unsigned char	ConditionData[BUFSIZE];
	unsigned char	ActionDataBuf[BUFSIZE];
	unsigned char	*ActionData = ActionDataBuf;
	unsigned char	Buff[BUFSIZE];
	unsigned char	*ptr;
	unsigned char	*EndPtr;
	unsigned long	c;
	unsigned	char	Condition = '\0';
	unsigned	char	Action = '\0';
	BOOL				Stop = FALSE;

	while (MWGetFormName(Client, FieldName, 128)) {
		ValueSize=BUFSIZE;
		while(MWGetFormValue(Client, Client->Temp, &ValueSize) != FORMFIELD_NEXT) {

			/* Check for garbage data */
			ptr=Client->Temp;
			EndPtr=Client->Temp+ValueSize;
			while (ptr < EndPtr) {
				if ((*ptr < 20) && (!isspace(*ptr))) {
					goto NextFormName;
				}
				ptr++;
			}

			switch (tolower(FieldName[2])) {
				case 'n' : {
					if (FieldName[3] == 'd') { /* Condition */
						switch (tolower(Client->Temp[0])) {
							case 'f' : { /* From */
								Condition = RULE_COND_FROM;
								break;
							}

							case 't' : { /* To */
								Condition = RULE_COND_TO;
								break;
							}

							case 'c' : { /* CC */
								Condition = RULE_COND_HEADER;
								break;
							}

							case 's' : { /* Subject */
								Condition = RULE_COND_SUBJECT;
								break;
							}

							case 'b' : { /* Body */
								Condition = RULE_COND_BODY;
								break;
							}

							case 'a' : { /* All */
								Condition = RULE_COND_ANY;
								break;
							}
						}
					} else { /* contains */
					    HulaStrNCpy(ConditionData, Client->Temp, sizeof(ConditionData));
					}
					break;
				}

				case 'v' : { /* moveto */
					Action = RULE_ACT_MOVE;
					for (c = 0; c < Session->FolderList->Used; c++) {
						unsigned char		*Folder = Session->FolderList->Value[c];

						if (*Folder == 'M' && MWQuickCmp(Client->Temp, Folder + 3)) {
							ActionData = Folder + 3;
							break;
						}
					}
					break;
				}

				case 't' : { /* ccto */
					Action = RULE_ACT_COPY;
					if (MsgIsAddress(Client->Temp, strlen(Client->Temp), "", NULL)) {
						HulaStrNCpy(ActionData, Client->Temp, sizeof(ActionDataBuf) - (ActionData - ActionDataBuf));
					} else {
						PrefSession->Error = ILLEGAL_USER_NAME;				/* (Bug Alert - This needs a better error) */
					}
					break;
				}

				case 'l' : { /* delete */
					Action = RULE_ACT_DELETE;
					break;
				}

				case 'r' : { /* forward to */
					Action = RULE_ACT_FORWARD;
					if (MsgIsAddress(Client->Temp, strlen(Client->Temp), "", NULL)) {
						HulaStrNCpy(ActionData, Client->Temp, sizeof(ActionDataBuf) - (ActionData - ActionDataBuf));
					} else {
						PrefSession->Error = ILLEGAL_USER_NAME;				/* (Bug Alert - This needs a better error) */
					}
					break;
				}

				case 'o' : { /* Stop */
					Stop = TRUE;
					break;
				}
			}
			ValueSize=BUFSIZE;
		}
NextFormName:
		;
	}

	/* Create rule string */

	ptr = Buff;
	if (Condition != '\0' && Action != '\0' && (PrefSession->Error == 0)) {
	    int bufLen = sizeof(Buff);
	    int count;

	    count = snprintf(ptr, bufLen, "%08XA%c", (unsigned int)time(NULL), Condition);												/* Send Identifier and Condition */
	    ptr += count;
	    bufLen -= count;
		if (Condition == RULE_COND_ANY) {																			/* Send appropriate arguments */
		    count = snprintf(ptr, bufLen, "000Z000Z");
		    ptr += count;
		    bufLen -= count;
		} else if (Condition == RULE_COND_HEADER) {
			count = snprintf(ptr, bufLen, "002CCZ%03d%sZ", strlen(ConditionData), ConditionData);
			ptr += count;
			bufLen -= count;
		} else {
		    count = snprintf(ptr, bufLen, "%03d%sZ000Z", strlen(ConditionData), ConditionData);
		    ptr += count;
		    bufLen -= count;
		}

		if (Action == RULE_ACT_DELETE) {																				/* Send action and appropriate arguments */
		    count - snprintf(ptr, bufLen, "%c000Z000Z", Action);
		    ptr += count;
		    bufLen -= count;
		} else {
			count - snprintf(ptr, bufLen, "%c%03d%sZ000Z", Action, strlen(ActionData), ActionData);
			ptr += count;
			bufLen -= count;
		}
		if (Stop) {
			ptr += snprintf(ptr, bufLen, "%c000Z000Z", RULE_ACT_STOP);
			ptr += count;
			bufLen -= count;
		}
		MDBFreeValues(PrefSession->V);
		
		MsgGetUserFeature(Session->UserDN, FEATURE_RULES, MSGSRV_A_RULE, PrefSession->V);
		MDBAddValue(Buff, PrefSession->V);
		MDBWrite(Session->UserDN, MSGSRV_A_RULE, PrefSession->V);
		MDBFreeValues(PrefSession->V);
	}
	return(TRUE);
}

static BOOL 
ProcessComplexRule(ConnectionStruct *Client, SessionStruct *Session, PrefSessionStruct *PrefSession)
{
	unsigned long		ValueSize;
	unsigned char		FieldName[128];
	MDBValueStruct		*Names;
	MDBValueStruct		*Values;
	unsigned long		i;

	Names = MDBShareContext(PrefSession->V);
	Values = MDBShareContext(PrefSession->V);

	while (MWGetFormName(Client, FieldName, 128)) {
		unsigned long		Order = atol(FieldName);
		BOOL					Added = FALSE;

		ValueSize = BUFSIZE;
		while (MWGetFormValue(Client, Client->Temp, &ValueSize) != FORMFIELD_NEXT) {
			
			ValueSize=BUFSIZE;
		}


		for (i = 0; i < Names->Used && !Added; i++) {
			if (atol(Names->Value[i]) > Order) {
				unsigned char		*TempName;
				unsigned char		*TempValue;
				unsigned long		c;

				/*
					It goes here.
					We now know where to put it, so we need to add it, to increase the size
					of the value struct, then copy the pointers into our temp vars and then
					move each of the values after this back one, and put our new one in.

					Sounds simple huh?
				*/
				MDBAddValue(FieldName, Names);
				MDBAddValue(Client->Temp, Values);

				TempName = Names->Value[Names->Used - 1];
				TempValue = Values->Value[Values->Used - 1];
				Added = TRUE;

				c = Names->Used - 1;
				while (c > i) {
					Names->Value[c] = Names->Value[c - 1];
					Values->Value[c] = Values->Value[c - 1];
					c--;
				}
				Names->Value[i] = TempName;
				Values->Value[i] = TempValue;
			}
		}
		if (!Added) {
			MDBAddValue(FieldName, Names);
			MDBAddValue(Client->Temp, Values);
		}
	}

	if (Names->Used == Values->Used) {
		unsigned long		i;
		unsigned long		Len = 10;		/* 8 digit ID, active flag, terminator */
		unsigned long		Id;
		unsigned char		*Buffer;
		unsigned char		*ptr;
		int count;
		int bufLen;

		/* All the elements needed to build a single condition */
		unsigned char		Condition = '\0';
		unsigned char		Action = '\0';
		unsigned char		Bool = '\0';
		unsigned char		*Arg1 = NULL;
		unsigned char		*Arg2 = NULL;
		BOOL					FirstCondition = TRUE;

		/*
			Ok, now we have all the data in RuleNames, and RuleValues.  We should have
			them sorted it by the ID number.  Each value in RuleNames should start
			with a number followed by a '-' which specifies the order.  We have no
			idea what order the browser sent them in, so we need to sort them.

			Next we need to piece together each portion (all parts of a portion
			begin with the same id) and then putting the rule together should be easy.

			Before doing any of that though we need a buffer to store our new rule in.
			Since the length is 3 digits the max length is 1000 chars.  Since there are
			two args per portion that can get REALLY big, so lets figure out just how
			big first
		*/

		if (Names->Used == 0) {
			return(FALSE);
		}

		for (i = 0; i < Names->Used; i++) {
			unsigned char		*ptr;

			/* Figure out what part it is and add the proper length */
			ptr = strchr(Names->Value[i], '-');
			if (ptr) {
				ptr++;

				if (MWQuickCmp(ptr, "FirstArgument") || MWQuickCmp(ptr, "SecondArgument")) {
					Len += strlen(Values->Value[i]);
				} else if (MWQuickCmp(ptr, "Condition") || MWQuickCmp(ptr, "Action")) {
					Len += 10;	/* 1 for the condition or action, 1 for a possible bool, and 8 for the arg lenghts and terminators */
				} else {
					/* Anything else will add a max of two chars, and its faster not to check */
					Len += 2;
				}
			}
		}

		Buffer = MemMalloc(Len);
		ptr = Buffer;
		bufLen = Len;
		

		if (!Buffer) {
			XplConsolePrintf("MWPref Module out of memory!  Failed to allocate %lu bytes\n", Len);
			return(FALSE);
		}

		if (PrefSession->RuleID == 0) {
			PrefSession->RuleID = time(NULL);
		}
		count = snprintf(ptr, bufLen, "%08XA", (unsigned int)PrefSession->RuleID);
		ptr += count;
		bufLen -= count;

		/* Alright, lets make a rule */
		Id = atol(Names->Value[0]);
		for (i = 0; i < Names->Used; i++) {
			unsigned long		NextId;
			unsigned char		*Name = strchr(Names->Value[i], '-');
			unsigned char		*Value = Values->Value[i];

			if (!Name) {
				return(FALSE);
			}
			Name++;	/* Find the start of the actual name */

			if (i + 1 < Names->Used) {
				NextId = atol(Names->Value[i + 1]);
			} else {
				/* Just make sure they aren't the same */
				NextId = Id + 1;
			}

			/* What are we looking at? */

			if (MWQuickCmp(Name, "Condition")) {

				if ((*Value >= 'A' && *Value <= 'Z') || (*Value >= 'a' && *Value <= 'z')) {
					Condition = Value[0];
				}
			} else if (MWQuickCmp(Name, "Action")) {

				if ((*Value >= 'A' && *Value <= 'Z') || (*Value >= 'a' && *Value <= 'z')) {
					Action = Value[0];
				}
			} else if (MWQuickCmp(Name, "Bool")) {
				if (*Value == RULE_ACT_BOOL_AND || *Value == RULE_ACT_BOOL_OR || *Value == RULE_ACT_BOOL_NOT) {
					Bool = *Value;
				}
			} else if (MWQuickCmp(Name, "FirstArgument")) {

				Arg1 = Value;
			} else if (MWQuickCmp(Name, "SecondArgument")) {

				Arg2 = Value;
			}

			if (Id != NextId) {
				/* We are done with this condition, make sure its ok and print it */
				Id = NextId;

				if (Condition || Action) {
					unsigned long		ArgNumber;

					if (Condition) {
						if (FirstCondition) {
							FirstCondition = FALSE;
						} else if (Bool) {
							*ptr = Bool;
							ptr++;
						}

						*ptr = Condition;
						ptr++;
					} else if (Action) {
						*ptr = Action;
						ptr++;

						if (((Action != RULE_ACT_COPY) && (Action != RULE_ACT_FORWARD)) || MsgIsAddress(Arg1, strlen(Arg1), "", NULL)) {
							;
						} else {
							/* Somebody entered an illegal email address */
							PrefSession->Error = ILLEGAL_USER_NAME;			/* (Bug Alert - This needs a better error) */
						}
					}

					for (ArgNumber = 1; ArgNumber <=2; ArgNumber++) {
						unsigned char		*Arg = (ArgNumber == 1) ? Arg1 : Arg2;
						unsigned long		Length = 0;

						/*
							Text:

							The string must be proceeded with a 3 digit length, and no more
							than 255 chars may be stored.  Termination is not required.
						*/
						if (Arg && *Arg != '\001') {
							Length = strlen(Arg);
							if (Length > 999) {
								Length = 999;
								Arg[999] = '\0';
							}
							count = snprintf(ptr, bufLen, "%03lu%sZ", Length, Arg);
							ptr += count;
							bufLen -= count;
						} else {
						    count = snprintf(ptr, bufLen, "000Z");
						    ptr += count;
						    bufLen -= count;
						}
					}
				}

				/* Clean up for the next time through */
				Condition = '\0';
				Action = '\0';
				Bool = '\0';
				Arg1 = NULL;
				Arg2 = NULL;
			}
		}

		/* Clean up and write */

		MDBFreeValues(Names);
		MDBFreeValues(Values);
		MDBFreeValues(PrefSession->V);

		if (PrefSession->Error == 0) {
			MDBRead(Session->UserDN, MSGSRV_A_RULE, PrefSession->V);
			/*
				If there is already a rule with that ID we need to remove it.
			*/
			for (i = 0; i < PrefSession->V->Used; i++) {
				unsigned long		ID;
				unsigned char		Temp = PrefSession->V->Value[i][8];

				PrefSession->V->Value[i][8] = '\0';
				ID = strtol(PrefSession->V->Value[i], NULL, 16);
				PrefSession->V->Value[i][8] = Temp;

				if (ID == PrefSession->RuleID) {
					MDBFreeValue(i, PrefSession->V);
					i = PrefSession->V->Used;
				}
			}

			MDBAddValue(Buffer, PrefSession->V);
			MDBWrite(Session->UserDN, MSGSRV_A_RULE, PrefSession->V);
			MDBFreeValues(PrefSession->V);
		}

		PrefSession->RuleID = 0;

		MemFree(Buffer);
		return(TRUE);
	
	}

	return(FALSE);
}

static int CompareRuleID(const void *First, const void *Second)
{
	const unsigned char	*One	= *(unsigned char**)First;
	const unsigned char	*Two	= *(unsigned char**)Second;
	unsigned long			IDOne;
	unsigned long			IDTwo;
	unsigned char			Temp;

	if (!One || !Two || strlen((unsigned char *)One) < 9 || strlen((unsigned char *)Two) < 9) {
		return(0);
	}

	Temp = ((unsigned char *)One)[8];
	((unsigned char *)One)[8] = '\0';
	IDOne = strtol((unsigned char *)One, NULL, 16);
	((unsigned char *)One)[8] = Temp;

	Temp = ((unsigned char *)Two)[8];
	((unsigned char *)Two)[8] = '\0';
	IDTwo = strtol((unsigned char *)Two, NULL, 16);
	((unsigned char *)Two)[8] = Temp;

	if (IDOne < IDTwo) {
		return(-1);
	} else if (IDOne > IDTwo) {
		return(1);
	} else {
		return(0);
	}
}

static int
SortFolder(const void *Folder1, const void *Folder2)
{
	BOOL			Folder1Inbox = FALSE;
	BOOL			Folder2Inbox = FALSE;

	/* Ignore the first character.  It is being used to specify the type */

	/* Special case INBOX -- it always goes first */
	if (MWQuickNCmp(*(unsigned char **)Folder1 + 1, "INBOX", 5)) {
		Folder1Inbox = TRUE;
	}

	if (MWQuickNCmp(*(unsigned char **)Folder2 + 1, "INBOX", 5)) {
		Folder2Inbox = TRUE;
	}

	if (Folder1Inbox) {
		if (Folder2Inbox) {
			/* Both folders are INBOX* */

			return(XplStrCaseCmp(*(unsigned char **)Folder1 + 1, *(unsigned char **)Folder2 + 1));
		} else {
			return(-1);
		}
	} else if (Folder2Inbox) {
		/* Folder 2 is INBOX* and folder 1 isn't */

		return(1);
	}
		
	/* Neither are in the INBOX hierarchy, just compare them normally */
	return(XplStrCaseCmp(*(unsigned char **)Folder1 + 1, *(unsigned char **)Folder2 + 1));
}

/* Modified Base64 encoding/decoding tables; used in mUTF-7  */
#if 0
static unsigned char MBASE64[] = {"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+,"};
#endif
static unsigned char MBASE64_R[256] = {
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3E, 0x3F, 0xFF, 0xFF, 0xFF,
	0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E,
	0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,
	0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x30, 0x31, 0x32, 0x33, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
};

static int
UTF8EncodeChar(unicode unichar, unsigned char *dest)
{
	if (unichar < 0x0080) {					/* 0000-007F */
		dest[0] = (char)(unichar);
		return(1);
	}
	if (unichar < 0x0800) {					/* 0080-07FF */
		dest[0] = (char)(0xC0 | ((unichar & 0x07C0) >> 6));
		dest[1] = (char)(0x80 | (unichar & 0x003F));
		return(2);
	}
														/* 0800-FFFF */
	dest[0] = (char)(0xE0 | ((unichar & 0xF000) >> 12));
	dest[1] = (char)(0x80 | ((unichar & 0x0FC0) >> 6));
	dest[2] = (char)(0x80 | (unichar & 0x003F));
	return(3);	
}

/*
	This function will translate an NMAP folder name into UTF8;
	it will return the length of the translated string and it
	will NULL-terminate the UTF8 string
*/

static int
FolderUTF7toUTF8(const unsigned char *UTF7, unsigned char *UTF8)
{
	unsigned long	Src;
	unsigned long	Dst;
	BOOL				Done=FALSE;
	unsigned long	i;
	unsigned long	UDst;
	unsigned char	Unicode[6];
	unsigned char	Base64[4];

	Src=0;
	Dst=0;

	ModDebug("FolderUTF7toUTF8(): Decoding %s\n", UTF7);

	while (!Done) {
		switch(UTF7[Src]) {
			case 0x7f: {
				UTF8[Dst]=' ';
				Dst++;
				Src++;
				break;
			}

			case '&': {
				Src++;
				if (UTF7[Src]!='-') {

					UDst=0;

					do {
						/* We get four encoded chars, translate them */
						for (i=0; i<4; i++) {
							if ((UTF7[Src]!='\0') && (UTF7[Src]!='-')) {
								Base64[i]=UTF7[Src++];
							} else {
								Base64[i]='A';
							}
						}

						/* We've got the encoded char in Base64, padded if neccessary, now translate to unicode */
						i=0;
						Unicode[UDst++] = ((MBASE64_R[Base64[0]] << 2) & 0xFC) | ((MBASE64_R[Base64[1]] >> 4) & 0x03);
						Unicode[UDst++] = ((MBASE64_R[Base64[1]] << 4) & 0xF0) | ((MBASE64_R[Base64[2]] >> 2) & 0x0F);
						Unicode[UDst++] = ((MBASE64_R[Base64[2]] << 6) & 0xC0) | ((MBASE64_R[Base64[3]] >> 0) & 0x3F);

						/* Convert to UTF-8 every 6 bytes (= 3 Unicode characters, = 2 loop iterations) */
						if (UDst==6) {
							for (i = 0; i < 6; i += 2) {
								if (((Unicode[i] << 8) | Unicode[i + 1]) != 0) {	/* May have padding */
									Dst += UTF8EncodeChar((unicode )(Unicode[i] << 8) | Unicode[i + 1], UTF8 + Dst);
								}
							}
							UDst=0;
						}						
					} while (UTF7[Src]!='\0' && UTF7[Src]!='-');

					if (UTF7[Src]=='-') {
						/* Whack the terminator */
						Src++;
					}

					if (UDst==3) {
						Dst += UTF8EncodeChar((unicode )(Unicode[0] << 8) | Unicode[1], UTF8 + Dst);
					}

				} else {
					UTF8[Dst]='&';
					Dst++;
					Src++;
				}

				break;
			}

			case '\0': {
				UTF8[Dst]='\0';
				Done=TRUE;
				break;
			}

			default: {
				UTF8[Dst++]=UTF7[Src++];
				break;
			}
		}
	}

	return(Dst);
}

/*
	These are the functions this module implements
*/
static BOOL
MWPrefInitSession(SessionStruct *Session, void **ModuleData)
{
	PrefSessionStruct	*PrefSession;

	ModDebug("MWPrefInitSession() called\n");

	PrefSession=MemMalloc(sizeof(PrefSessionStruct));
	if (!PrefSession) {
		return(FALSE);
	}

	memset(PrefSession, 0, sizeof(PrefSessionStruct));


	PrefSession->V = MDBCreateValueStruct(ModuleDirectoryHandle, NULL);

	/* Password config */
	if (MsgGetUserFeature(Session->UserDN, FEATURE_MODWEB, MSGSRV_A_PASSWORD_CONFIGURATION, PrefSession->V)) {
		PrefSession->PasswordConfig = atol(PrefSession->V->Value[0]);
	} else {
		PrefSession->PasswordConfig = PasswordConfig;
	}
	MDBFreeValues(PrefSession->V);

	/* Colours and general config */
	if (MsgGetUserFeature(Session->UserDN, FEATURE_MODWEB, MSGSRV_A_CONFIGURATION, PrefSession->V)) {
		PrefSession->GeneralConfig = atol(PrefSession->V->Value[0] + 9);
	} else {
		PrefSession->GeneralConfig = GeneralConfig;
	}
	MDBFreeValues(PrefSession->V);



	*ModuleData=(void *)PrefSession;
	return(TRUE);
}

static BOOL
MWPrefDestroySession(SessionStruct *Session, void *ModuleData)
{
	PrefSessionStruct	*PrefSession=(PrefSessionStruct *)ModuleData;

	ModDebug("MWPrefDestroySession() called\n");
	if (PrefSession) {
		MDBDestroyValueStruct(PrefSession->V);
		MemFree(PrefSession);
	}

	return(TRUE);
}

static BOOL
MWPrefHandleURL(ConnectionStruct *Client, SessionStruct *Session, URLStruct *URL, void *ModuleData)
{
	PrefSessionStruct		*PrefSession=(PrefSessionStruct *)ModuleData;

	ModDebug("MWPrefHandleURL called\n");
//XplConsolePrintf("MWPrefHandleURL called %d\n", URL->Request);
	switch(URL->Request) {
		case SAVE_FORM: {

			MDBAddValue(Session->UserDN, PrefSession->V);
			PrefSession->Error = ProcessSaveForm(Client, Session, PrefSession->V, TRUE);
			MDBFreeValues(PrefSession->V);

			Client->KeepAlive=FALSE;
			MWHandleTemplate(Client, Session, URL->Argument[0]);
			return(TRUE);
		}

		case RULE_LIST_FORM: {
			if (MsgGetUserFeature(Session->UserDN, FEATURE_RULES, NULL, NULL)) {
				ProcessRuleListForm(Client, Session->UserDN);
				Client->KeepAlive=FALSE;
				MWHandleTemplate(Client, Session, URL->Argument[0]);
			}
			return(TRUE);
		}

		case RULE_CREATE_FORM: {
			if (MsgGetUserFeature(Session->UserDN, FEATURE_RULES, NULL, NULL)) {
				ProcessRuleCreateForm(Client, Session, PrefSession);
				Client->KeepAlive=FALSE;
				MWHandleTemplate(Client, Session, URL->Argument[0]);
			}
			return(TRUE);
		}

		case RULE_DELETE: {
			MDBFreeValues(PrefSession->V);
			if (MsgGetUserFeature(Session->UserDN, FEATURE_RULES, MSGSRV_A_RULE, PrefSession->V)) {
				MDBFreeValue(URL->Argument[1], PrefSession->V);
				MDBWrite(Session->UserDN, MSGSRV_A_RULE, PrefSession->V);
			}

			MDBFreeValues(PrefSession->V);
			Client->KeepAlive=FALSE;
			MWHandleTemplate(Client, Session, URL->Argument[0]);
			return(TRUE);
		}

		case REQUEST_RULE_EDIT: {
			unsigned long		ID;
			unsigned long		i;

			//Session->LastError = WAERR_UNKNOWN;

			MDBRead(Session->UserDN, MSGSRV_A_RULE, PrefSession->V);
			for (i = 0; i < PrefSession->V->Used; i++) {
				if (strlen(PrefSession->V->Value[i]) > 8) {
					unsigned char		Temp = PrefSession->V->Value[i][8];

					PrefSession->V->Value[i][8] = '\0';
					ID = strtol(PrefSession->V->Value[i], NULL, 16);
					PrefSession->V->Value[i][8] = Temp;

					if (ID == URL->Argument[1]) {
						/*
							We found the matching ID, so lets store
							it so when the next page comes up we can
							find it again.
						*/
						PrefSession->RuleID = ID;
						MDBFreeValues(PrefSession->V);
						//Session->LastError = WAERR_SUCCESS;
					}
				}
			}
			MDBFreeValues(PrefSession->V);

			MWHandleTemplate(Client, Session, URL->Argument[0]);

			return(TRUE);
		}

		case REQUEST_RULE_DELETE: {
			unsigned long		ID;
			unsigned long		i;

			//Session->LastError = WAERR_OBJECT_NOT_DELETED;

			MDBRead(Session->UserDN, MSGSRV_A_RULE, PrefSession->V);
			for (i = 0; i < PrefSession->V->Used; i++) {
				if (strlen(PrefSession->V->Value[i]) > 8) {
					unsigned char		Temp = PrefSession->V->Value[i][8];

					PrefSession->V->Value[i][8] = '\0';
					ID = strtol(PrefSession->V->Value[i], NULL, 16);
					PrefSession->V->Value[i][8] = Temp;

					if (ID == URL->Argument[1]) {
						/*
							We found the matching ID, so lets pull it
							out of the value struct and write it back.
						*/
						MDBFreeValue(i, PrefSession->V);
						MDBWrite(Session->UserDN, MSGSRV_A_RULE, PrefSession->V);
						MDBFreeValues(PrefSession->V);
						//Session->LastError = WAERR_SUCCESS;
					}
				}
			}
			MDBFreeValues(PrefSession->V);

			MWHandleTemplate(Client, Session, URL->Argument[0]);

			return(TRUE);
		}

		case REQUEST_RULE_TOGGLE_STATE: {
			unsigned long		ID;
			unsigned long		i;

			//Session->LastError = WAERR_OBJECT_NOT_DELETED;

			MDBRead(Session->UserDN, MSGSRV_A_RULE, PrefSession->V);
			for (i = 0; i < PrefSession->V->Used; i++) {
				if (strlen(PrefSession->V->Value[i]) > 8) {
					unsigned char		Temp = PrefSession->V->Value[i][8];

					PrefSession->V->Value[i][8] = '\0';
					ID = strtol(PrefSession->V->Value[i], NULL, 16);
					PrefSession->V->Value[i][8] = Temp;

					if (ID == URL->Argument[1]) {
						/*
							We found the matching ID, so lets toggle
							the active/non active state and write it
							back.
						*/
						if (PrefSession->V->Value[i][8] == RULE_ACTIVE) {
							PrefSession->V->Value[i][8] = RULE_INACTIVE;
						} else {
							PrefSession->V->Value[i][8] = RULE_ACTIVE;
						}

						MDBWrite(Session->UserDN, MSGSRV_A_RULE, PrefSession->V);
						MDBFreeValues(PrefSession->V);
						//Session->LastError = WAERR_SUCCESS;
					}
				}
			}
			MDBFreeValues(PrefSession->V);

			MWHandleTemplate(Client, Session, URL->Argument[0]);

			return(TRUE);
		}

		case REQUEST_RULE_UP: {
			unsigned long		ID;
			unsigned long		i;
			unsigned char		TempID[8];

			/* Swap with the rule above it, if there is one */

			MDBRead(Session->UserDN, MSGSRV_A_RULE, PrefSession->V);
			qsort(PrefSession->V->Value, PrefSession->V->Used, sizeof(unsigned char*), CompareRuleID);

			/* Start at 1 because the first can't be moved up */
			for (i = 1; i < PrefSession->V->Used; i++) {
				if (strlen(PrefSession->V->Value[i]) > 8) {
					unsigned char		Temp = PrefSession->V->Value[i][8];

					PrefSession->V->Value[i][8] = '\0';
					ID = strtol(PrefSession->V->Value[i], NULL, 16);
					PrefSession->V->Value[i][8] = Temp;

					if (ID == URL->Argument[1]) {
						/*
							We found the matching ID
						*/
						if (i >= 1) {
							/* Get the ID of the rule before it, then swap them */
							memcpy(TempID, PrefSession->V->Value[i - 1], 8);
							memcpy(PrefSession->V->Value[i - 1], PrefSession->V->Value[i], 8);
							memcpy(PrefSession->V->Value[i], TempID, 8);
						}

						MDBWrite(Session->UserDN, MSGSRV_A_RULE, PrefSession->V);
						MDBFreeValues(PrefSession->V);
						//Session->LastError = WAERR_SUCCESS;
					}
				}
			}
			MDBFreeValues(PrefSession->V);

			MWHandleTemplate(Client, Session, URL->Argument[0]);

			return(TRUE);
		}

		case REQUEST_RULE_DOWN: {
			unsigned long		ID;
			unsigned long		i;
			unsigned char		TempID[8];

			/* Swap with the rule above it, if there is one */

			if (MDBRead(Session->UserDN, MSGSRV_A_RULE, PrefSession->V)) {
				qsort(PrefSession->V->Value, PrefSession->V->Used, sizeof(unsigned char*), CompareRuleID);

				for (i = 0; i < PrefSession->V->Used; i++) {
					if (strlen(PrefSession->V->Value[i]) > 8) {
						unsigned char		Temp = PrefSession->V->Value[i][8];

						PrefSession->V->Value[i][8] = '\0';
						ID = strtol(PrefSession->V->Value[i], NULL, 16);
						PrefSession->V->Value[i][8] = Temp;

						if (ID == URL->Argument[1]) {
							/*
								We found the matching ID
							*/
							if (i < PrefSession->V->Used - 1) {
								/* Get the ID of the rule before it, then swap them */
								memcpy(TempID, PrefSession->V->Value[i + 1], 8);
								memcpy(PrefSession->V->Value[i + 1], PrefSession->V->Value[i], 8);
								memcpy(PrefSession->V->Value[i], TempID, 8);
							}

							MDBWrite(Session->UserDN, MSGSRV_A_RULE, PrefSession->V);
							MDBFreeValues(PrefSession->V);
							//Session->LastError = WAERR_SUCCESS;
						}
					}
				}
				MDBFreeValues(PrefSession->V);
			}

			MWHandleTemplate(Client, Session, URL->Argument[0]);

			return(TRUE);
		}

		case REQUEST_RULE_SAVE: {
			ProcessComplexRule(Client, Session, PrefSession);
			Client->KeepAlive = FALSE;
			MWHandleTemplate(Client, Session, URL->Argument[0]);

			return(TRUE);
		}

		case REQUEST_DELETE_SHARE: {
			unsigned char			Buffer[BUFSIZE+1];

			/*
				The data in URLExtra should look like "FolderName UserName"
				We need to delete this share, so we want to send the following
				to NMAP:

				SHARE MBOX FolderName UserName 0\r\n
			*/

			if (!Session->ReadOnly) {
				if (URL->Argument[1]) {
					MWSendNMAPServer(Session, "SHARE MBOX ", 11);	/* Notice the space and NO \r\n */
				} else {
					MWSendNMAPServer(Session, "SHARE CAL ", 10);		/* Notice the space and NO \r\n */
				}
				MWURLExtraDecode(Client, Buffer, sizeof(Buffer));
				MWSendNMAPServer(Session, Buffer, strlen(Buffer));
				MWSendNMAPServer(Session, " 0\r\n", 4);			/* Notice the space and now we send the \r\n */

				/* Should be a 1000 OK, but we aren't going to do anything based on the responce */
				MWGetNMAPAnswer(Session, Buffer, sizeof(Buffer), TRUE);
			}

			MWHandleTemplate(Client, Session, URL->Argument[0]);
			return(TRUE);
		}

		case REQUEST_PROXY_DELETE: {
			unsigned char			buffer[BUFSIZE+1];
			unsigned long			len;

			if (!Session->ReadOnly) {
				MWURLExtraDecode(Client, Client->Temp, sizeof(Client->Temp));
				
				len = snprintf(buffer, sizeof(buffer), "PROXY %s 0\r\n", Client->Temp);
				MWSendNMAPServer(Session, buffer, len);
				MWGetNMAPAnswer(Session, buffer, sizeof(buffer), TRUE);
			}

			MWHandleTemplate(Client, Session, URL->Argument[0]);
			return(TRUE);
		}

		case REQUEST_PROXY_RO: {
			unsigned char			buffer[BUFSIZE+1];
			unsigned long			len;

			if (!Session->ReadOnly) {
				MWURLExtraDecode(Client, Client->Temp, sizeof(Client->Temp));
				
				len = snprintf(buffer, sizeof(buffer), "PROXY %s 1\r\n", Client->Temp);
				MWSendNMAPServer(Session, buffer, len);
				MWGetNMAPAnswer(Session, buffer, sizeof(buffer), TRUE);
			}

			MWHandleTemplate(Client, Session, URL->Argument[0]);
			return(TRUE);
		}

		case REQUEST_PROXY_RW: {
			unsigned char			buffer[BUFSIZE+1];
			unsigned long			len;

			if (!Session->ReadOnly) {
				MWURLExtraDecode(Client, Client->Temp, sizeof(Client->Temp));
				
				len = snprintf(buffer, sizeof(buffer), "PROXY %s 2\r\n", Client->Temp);
				MWSendNMAPServer(Session, buffer, len);
				MWGetNMAPAnswer(Session, buffer, sizeof(buffer), TRUE);
			}

			MWHandleTemplate(Client, Session, URL->Argument[0]);
			return(TRUE);
		}
	}

	return(FALSE);
}

static BOOL
MWPrefHandleTemplate(ConnectionStruct *Client, SessionStruct *Session, unsigned long Page, TokenOverlayStruct *Token, unsigned long *GotoToken, void *ModuleData)
{
	PrefSessionStruct		*PrefSession=(PrefSessionStruct *)ModuleData;
	unsigned char			URL[256];
	unsigned char			Buffer[BUFSIZE+1];
	int						Len;
	unsigned char			*ptr;
	unsigned long			c;

//XplConsolePrintf("MWPrefHandleTemplate called with %d\n", Token->TokenID);
	switch(Token->TokenID) {

		case T_PREF_VALUE: {
			switch (Token->ArgumentOffsetOrID[0]) {
				case AA_TIMEOUT: {
					MsgGetUserFeature(Session->UserDN, FEATURE_MODWEB, MSGSRV_A_TIMEOUT, PrefSession->V);
					if (PrefSession->V->Used >0) {
						MWSendClient(Client, PrefSession->V->Value[0], strlen(PrefSession->V->Value[0]));
					} else {
						MWSendClient(Client, "6", 1);
					}

					MDBFreeValues(PrefSession->V);
					return(TRUE);
				}

				case AA_REPLYTO: {
					MsgGetUserFeature(Session->UserDN, FEATURE_MODWEB, MSGSRV_A_EMAIL_ADDRESS, PrefSession->V);
					if (PrefSession->V->Used > 0) {
						MWSendClient(Client, PrefSession->V->Value[0], strlen(PrefSession->V->Value[0]));
					}
					MDBFreeValues(PrefSession->V);
					return(TRUE);
				}

				case AA_AUTOREPLYMESSAGE: {
					MsgGetUserFeature(Session->UserDN, FEATURE_AUTOREPLY, MSGSRV_A_AUTOREPLY_MESSAGE, PrefSession->V);
					if (PrefSession->V->Used >0) {
						MWSendClient(Client, PrefSession->V->Value[0], strlen(PrefSession->V->Value[0]));
					}
					MDBFreeValues(PrefSession->V);
					return(TRUE);
				}

				case AA_SIGNATUREMESSAGE	: {
					if (MsgGetUserFeature(Session->UserDN, FEATURE_MODWEB, MSGSRV_A_SIGNATURE, PrefSession->V)) {
						for (c = 0; c < PrefSession->V->Used; c++) {
							int len = strlen(PrefSession->V->Value[c]);

							if (len > 2) {
								if (PrefSession->V->Value[c][0] == 'S' && PrefSession->V->Value[c][1] == ':') {
									MWSendClient(Client, PrefSession->V->Value[c] + 2, len - c - 1);
								}
							}
						}
					}

					MDBFreeValues(PrefSession->V);
					return(TRUE);
				}

				case AA_SECRETQUESTION: {
					if (MDBRead(Session->UserDN, MSGSRV_A_PHRASE, PrefSession->V)) {
						for (c = 0; c < PrefSession->V->Used; c++) {
							if (PrefSession->V->Value[c][0] == 'Q' && PrefSession->V->Value[c][1] == ':') {
								MWSendClient(Client, PrefSession->V->Value[c] + 2, strlen(PrefSession->V->Value[c] + 2));
								break;
							}
						}
					}			
					MDBFreeValues(PrefSession->V);			
					return(TRUE);
				}

				case AA_LDAPSERVER: {
					if (MsgGetUserFeature(Session->UserDN, FEATURE_MWMAIL_ADDRBOOK_G, MSGSRV_A_ADDRESSBOOK_URL_PUBLIC, PrefSession->V)) {
						if (PrefSession->V->Used == 1) {
							MWSendClient(Client, PrefSession->V->Value[0], strlen(PrefSession->V->Value[0]));
						} else {
							unsigned char		*Server = NULL;
							unsigned char		*Context = NULL;

							for (c = 0; c < PrefSession->V->Used; c++) {	/* 2.6 compatibility */
								if (PrefSession->V->Value[c][0] == 'S' && PrefSession->V->Value[c][1] == ':') {
									Server = PrefSession->V->Value[c] + 2;
								}
								if (PrefSession->V->Value[c][0] == 'B' && PrefSession->V->Value[c][1] == ':') {
									Context = PrefSession->V->Value[c] + 2;
								}
							}
							if (Server) {
								if (Context) {
									snprintf(Client->Temp, sizeof(Client->Temp), "%s/%s", Server, Context);
									MWSendClient(Client, Client->Temp, strlen(Client->Temp));
								} else {
									MWSendClient(Client, Server, strlen(Server));
								}
							}
						}
					}
					MDBFreeValues(PrefSession->V);
					return(TRUE);
				}

				case AA_FORWARDADDRESS: {
					MsgGetUserFeature(Session->UserDN, FEATURE_FORWARD, MSGSRV_A_FORWARDING_ADDRESS, PrefSession->V);
					for (c = 0; c < PrefSession->V->Used; c++) {
						MWSendClient(Client, PrefSession->V->Value[c], strlen(PrefSession->V->Value[c]));
						MWSendClient(Client, "\r\n", 2);
					}
					MDBFreeValues(PrefSession->V);
					return(TRUE);
				}
			}
			return (FALSE);	
		}

		case T_PREF_OPTIONS: {
			switch (Token->ArgumentOffsetOrID[0]) {
				case AA_PRIVACY: {
					if (MsgGetUserFeature(Session->UserDN, FEATURE_MODWEB, MSGSRV_A_PRIVACY, PrefSession->V)) {
						c = atoi(PrefSession->V->Value[0]);
					} else {
						c = 0;
					}

					MWSendClient(Client, "<OPTION value=\"NONE\">", 21);
					ptr=Session->Strings[Token->ArgumentOffsetOrID[1]];
					MWSendClient(Client, ptr, strlen(ptr)); 

					if (c == PRIVACY_LIMITED) {
						MWSendClient(Client, "<OPTION SELECTED value=\"LIMITED\">", 33);
					} else {
						MWSendClient(Client, "<OPTION value=\"LIMITED\">", 24);
					}
					ptr = Session->Strings[Token->ArgumentOffsetOrID[1] + 1];
					MWSendClient(Client, ptr, strlen(ptr));

					if (c == PRIVACY_UNLISTED) {
						MWSendClient(Client, "<OPTION SELECTED value=\"UNLISTED\">", 34);
					} else { 
						MWSendClient(Client, "<OPTION value=\"UNLISTED\">", 25);
					}
					ptr = Session->Strings[Token->ArgumentOffsetOrID[1] + 2];
					MWSendClient(Client, ptr, strlen(ptr));

					MDBFreeValues(PrefSession->V);
					return(TRUE);
				}

				case AA_DRAFTSFOLDER:
				case AA_SENTFOLDER:
				case AA_DEFAULTFOLDER: {
					unsigned char	*ptr2;
					unsigned long	Len;
			
					MsgGetUserFeature(Session->UserDN, FEATURE_MODWEB, MSGSRV_A_PREFERENCES, PrefSession->V);

					MWSendClient(Client, OPTION, strlen(OPTION));
					MWSendClient(Client, " ", 1); /* Need to send this to be sure that no folder gets set */
					ptr=Session->Strings[Token->ArgumentOffsetOrID[1]];
					MWSendClient(Client, ptr, strlen(ptr));
					
					if (Token->ArgumentOffsetOrID[0] == AA_DEFAULTFOLDER) {
						ptr2 = "Webmail:AutoFolderName:";
						Len = 23;
					} else if (Token->ArgumentOffsetOrID[0] == AA_SENTFOLDER) {
						ptr2 = "Webmail:SentFolderName:";
						Len = 23;
					} else {
						ptr2 = "Webmail:DraftFolderName:";
						Len = 24;
					}

					ptr = "";
					for (c = 0; c < PrefSession->V->Used; c++) {
						if (MWQuickNCmp(PrefSession->V->Value[c], ptr2, Len)) {
							ptr = PrefSession->V->Value[c] + Len;
							break;
						}
					}

//XplConsolePrintf("NumOfFolders is %d\n", Session->NumOfFolders);
					for (c = 0; c < Session->FolderList->Used; c++) {
						unsigned char		*Folder = Session->FolderList->Value[c];

						if (Folder[0] == 'M' && Folder[2] == '1') {
							Len = snprintf(Client->Temp, sizeof(Client->Temp), "<OPTION VALUE=\"%s\"%s>%s</OPTION>\r\n", Folder + 3, MWQuickCmp(ptr, Folder + 3) ? " SELECTED" : "", Session->FolderDisplayNames->Value[c]);
							MWSendClient(Client, Client->Temp, Len);
						}
					}		

					MDBFreeValues(PrefSession->V);
					return(TRUE);
				}

				case AA_TIMEZONE	: {
					for (c = 0; c < NUM_OF_TIMEZONES; c++) {
						snprintf(Client->Temp, sizeof(Client->Temp), OPTION_FULL, (Session->TimezoneID == c) ? " SELECTED " : "", (int)c);
						MWSendClient(Client, Client->Temp, strlen(Client->Temp));
						MWSendClient(Client, Session->Strings[Token->ArgumentOffsetOrID[1] + c], strlen(Session->Strings[Token->ArgumentOffsetOrID[1] + c]));
					}
					return(TRUE);
				}

				case AA_WEEKDAY: {
					unsigned long		Len;
					unsigned long		WeekDay = 0;

					if (MsgGetUserFeature(Session->UserDN, FEATURE_MODWEB, MSGSRV_A_LOCALE, PrefSession->V)) {
						for (c = 0; c < PrefSession->V->Used; c++) {
							if (MWQuickNCmp(PrefSession->V->Value[c], "WDS:", 4)) {
								if (strlen(PrefSession->V->Value[c]) > 4) {
									WeekDay = atol(PrefSession->V->Value[c] + 4);
								}
							}
						}
					}
					MDBFreeValues(PrefSession->V);

					for (c = 0; c < 7; c++) {
						Len = snprintf(Client->Temp, sizeof(Client->Temp), "<OPTION %sVALUE=\"%d\">%s</OPTION>\r\n", 
							(WeekDay == c) ? "SELECTED " : "",
							(int)c, Session->Strings[Token->ArgumentOffsetOrID[1] + c]);
						MWSendClient(Client, Client->Temp, Len);
					}
					return(TRUE);
				}

				case AA_DEFAULTCHARSET: {
					unsigned long		CharsetOffset = 0;
					StreamDescStruct	*StreamListPtr=MWGetStreamTable();

					if (MsgGetUserFeature(Session->UserDN, FEATURE_MODWEB, MSGSRV_A_DEFAULT_CHARSET, PrefSession->V)) {
						ptr = PrefSession->V->Value[0];

						/* Look for old style.  Pre NIMS 3.0 the charset was stored as a number instead of a string */
						if ((strlen(PrefSession->V->Value[0]) == 2) && isdigit(PrefSession->V->Value[0][0]) && isdigit(PrefSession->V->Value[0][1])) {
							CharsetOffset = atol(PrefSession->V->Value[0]);
							if (CharsetOffset <= NUM_OF_OLD_CHARSETS) {
								ptr = OldCharsets[CharsetOffset];
							}
							CharsetOffset = 0; /* Stole it so I have to reset it */
						}

						c = 0;
						while (StreamListPtr[c].Charset != NULL) {
							if ((StreamListPtr[c].CharsetType != CHAR_SET_TYPE_NONE) && MWQuickCmp(StreamListPtr[c].Charset, ptr)) {
								CharsetOffset = c;
							}
							c++;
						}
					}

					/* Send charset List */
					c = 0;
					while (StreamListPtr[c].Charset != NULL) {
						if (StreamListPtr[c].CharsetType != CHAR_SET_TYPE_NONE) {
							if (CharsetOffset == c) {
								MWSendClient(Client, OPTION_SELECTED, strlen(OPTION_SELECTED));
							} else {
								MWSendClient(Client, OPTION, strlen(OPTION));
							}
							MWSendClient(Client, StreamListPtr[c].Charset, strlen(StreamListPtr[c].Charset));	
						}
						c++;
					}
					MDBFreeValues(PrefSession->V);
					return(TRUE);
				}

				case AA_TEMPLATE: {
					long					UserTemplate = -1;
					long					CurrentTemplate;
					unsigned long		Len;
					unsigned char		*ptr;
					MDBValueStruct		*Config;

					Config = MDBCreateValueStruct(ModuleDirectoryHandle, NULL);
					/* Figure out which templates to display */
					if (MDBReadDN(Session->UserDN, MSGSRV_A_PARENT_OBJECT, Config)) {
						MDBReadDN(Config->Value[0], MSGSRV_A_TEMPLATE, PrefSession->V);
					}

					if (PrefSession->V->Used == 0) {  /* We didn't get anything from the parent object so we show them all */
						MDBSetValueStructContext(MsgGetServerDN(NULL), PrefSession->V);
						Len = MDBReadDN(MSGSRV_AGENT_MODWEB, MSGSRV_A_TEMPLATE, PrefSession->V);
						MDBSetValueStructContext(NULL, PrefSession->V);
					}
					MDBFreeValues(Config);

					/* Read what the user had stored */
					if (MDBReadDN(Session->UserDN, MSGSRV_A_TEMPLATE, Config)) {
						ptr = strrchr(Config->Value[0], '\\');
						if (ptr) {
							ptr++;
						} else {
							ptr = Config->Value[0];
						}
						UserTemplate = MWFindTemplate(ptr);
					}

					/* Read the default template from the parent object */
					if (UserTemplate == -1) {
						if (MsgGetUserFeature(Session->UserDN, FEATURE_MODWEB, MSGSRV_A_DEFAULT_TEMPLATE, Config)) {
							ptr = strrchr(Config->Value[0], '\\');
							if (ptr) {
								ptr++;
							} else {
								ptr = Config->Value[0];
							}
							UserTemplate = MWFindTemplate(ptr);
						}
					}

					/* Read the default template from the modweb agent */
					if (UserTemplate == -1) {
						MDBFreeValues(Config);
						MDBSetValueStructContext(MsgGetServerDN(NULL), Config);
						if (MDBReadDN(MSGSRV_AGENT_MODWEB, MSGSRV_A_DEFAULT_TEMPLATE, Config)) {
							ptr = strrchr(Config->Value[0], '\\');
							if (ptr) {
								ptr++;
							} else {
								ptr = Config->Value[0];
							}
							UserTemplate = MWFindTemplate(ptr);
						}
						MDBSetValueStructContext(NULL, Config);
					}

					/* 
						Now PrefSession->V contains a list of objects we should be able to display
						Cross check them with MWFindTemplate before showing 
					*/
					for (c = 0; c < PrefSession->V->Used; c++) {
						ptr = strrchr(PrefSession->V->Value[c], '\\');
						if (ptr) {
							ptr++;
						} else {
							ptr = PrefSession->V->Value[c];
						}
						if ((CurrentTemplate = MWFindTemplate(ptr)) != -1) {
							/* We have a good one, send it */
							Len = snprintf(Client->Temp, sizeof(Client->Temp), "<OPTION%s>%s</OPTION>\r\n",
								(CurrentTemplate == UserTemplate) ? " SELECTED" : "", ptr);
							MWSendClient(Client, Client->Temp, Len);
						}
					}

					MDBFreeValues(PrefSession->V);
					MDBDestroyValueStruct(Config);			
					return(TRUE);
				}

				case AA_SHORTDATEFORMAT: {
					unsigned long		Len;
					unsigned long		ValueOffset = 0;

					if (MsgGetUserFeature(Session->UserDN, FEATURE_MODWEB, MSGSRV_A_LOCALE, PrefSession->V)) {
						for (c = 0; c < PrefSession->V->Used; c++) {
							if (MWQuickNCmp(PrefSession->V->Value[c], "DS:", 3)) {
								ValueOffset = c;
							}
						}
					}

					if (PrefSession->V->Used == 0) {
						/* put garbage in there just so we don't crash below */
						MDBAddValue("_DON'T_MATCH_", PrefSession->V);
					}

					for (c = 0; ShortDateFormats[c] != NULL; c++) {
						Len = snprintf(Client->Temp, sizeof(Client->Temp), "<OPTION %sVALUE=\"%s\">%s</OPTION>\r\n", 
							strcmp(ShortDateFormats[c], PrefSession->V->Value[ValueOffset] + 3) ? "" : "SELECTED ", /* Can't use MWQuickCmp because of case sensitivity */
							ShortDateFormats[c],
							ShortDateFormatNames[c]);
						MWSendClient(Client, Client->Temp, Len);
					}
					MDBFreeValues(PrefSession->V);
					return(TRUE);
				}

				case AA_LONGDATEFORMAT: {
					unsigned long		Len;
					unsigned long		ValueOffset = 0;

					if (MsgGetUserFeature(Session->UserDN, FEATURE_MODWEB, MSGSRV_A_LOCALE, PrefSession->V)) {
						for (c = 0; c < PrefSession->V->Used; c++) {
							if (MWQuickNCmp(PrefSession->V->Value[c], "DL:", 3)) {
								ValueOffset = c;
							}
						}
					}

					if (PrefSession->V->Used == 0) {
						/* put garbage in there just so we don't crash below */
						MDBAddValue("_DON'T_MATCH_", PrefSession->V);
					}

					for (c = 0; LongDateFormats[c] != NULL; c++) {
						Len = snprintf(Client->Temp, sizeof(Client->Temp), "<OPTION %sVALUE=\"%s\">%s</OPTION>\r\n", 
							strcmp(LongDateFormats[c], PrefSession->V->Value[ValueOffset] + 3) ? "" : "SELECTED ",
							LongDateFormats[c],
							LongDateNames[c]);
						MWSendClient(Client, Client->Temp, Len);
					}
					MDBFreeValues(PrefSession->V);
					return(TRUE);
				}

				case AA_TIMEFORMAT: {
					unsigned long		Len;
					unsigned long		ValueOffset = 0;

					if (MsgGetUserFeature(Session->UserDN, FEATURE_MODWEB, MSGSRV_A_LOCALE, PrefSession->V)) {
						for (c = 0; c < PrefSession->V->Used; c++) {
							if (MWQuickNCmp(PrefSession->V->Value[c], "T:", 2)) {
								ValueOffset = c;
							}
						}
					}

					if (PrefSession->V->Used == 0) {
						/* put garbage in there just so we don't crash below */
						MDBAddValue("_DON'T_MATCH_", PrefSession->V);
					}

					for (c = 0; TimeFormats[c] != NULL; c++) {
						Len = snprintf(Client->Temp, sizeof(Client->Temp), "<OPTION %sVALUE=\"%s\">%s</OPTION>\r\n", 
							MWQuickCmp(TimeFormats[c], PrefSession->V->Value[ValueOffset] + 2) ? "SELECTED " : "",
							TimeFormats[c],
							TimeNames[c]);
						MWSendClient(Client, Client->Temp, Len);
					}
					MDBFreeValues(PrefSession->V);
					return(TRUE);
				}
			}
			return (FALSE);	
		}

		case T_PREF_STATUS: {
			if (PrefSession->Error != 0) {
				MWSendClient(Client, Session->Strings[Token->ArgumentOffsetOrID[0] + PrefSession->Error - 1], strlen(Session->Strings[Token->ArgumentOffsetOrID[0] + PrefSession->Error - 1]));
			}
			PrefSession->Error = 0;
			return(TRUE);
		}

		case T_PREF_SHOW_PASS_BEGIN: {
			if (PrefSession->PasswordConfig & ALLOW_PASSWORD_CHANGE) {
				if (PrefSession->PasswordConfig & SSL_FOR_PASS_CHANGE) {
					if (Client->ClientSSL) {
						return(TRUE);
					}
				} else {
					return(TRUE);
				}
			}
			*GotoToken=T_PREF_SHOW_PASS_END;
			return(TOKEN_MOVE_FORWARD);
		}

		case T_PREF_SHOW_PASS_END: {
			return(TRUE);
		}

		case T_PREF_SHOW_TIMEOUT_BEGIN: {
			if (PrefSession->GeneralConfig & PREF_HIDE_TIMEOUT) {
				*GotoToken=T_PREF_SHOW_TIMEOUT_END;
				return(TOKEN_MOVE_FORWARD);
			} else {
				return(TRUE);
			}
		}

		case T_PREF_SHOW_TIMEOUT_END: {
			return(TRUE);
		}

		case T_PREF_SHOW_COLORS_BEGIN: {
			if (PrefSession->GeneralConfig & PREF_HIDE_COLORS) {
				*GotoToken=T_PREF_SHOW_COLORS_END;
				return(TOKEN_MOVE_FORWARD);
			} else {
				return(TRUE);
			}
		}

		case T_PREF_SHOW_COLORS_END: {
			return(TRUE);
		}

		case T_PREF_SHOW_PRIVACY_BEGIN: {
			if (PrefSession->GeneralConfig & PREF_HIDE_PRIVACY) {
				*GotoToken=T_PREF_SHOW_PRIVACY_END;
				return(TOKEN_MOVE_FORWARD);
			} else {
				return(TRUE);
			}
		}

		case T_PREF_SHOW_PRIVACY_END: {
			return(TRUE);
		}

		case T_PREF_SHOW_SIGNATURE_BEGIN: {
			if (PrefSession->GeneralConfig & PREF_HIDE_SIGNATURE) {
				*GotoToken=T_PREF_SHOW_SIGNATURE_END;
				return(TOKEN_MOVE_FORWARD);
			} else {
				return(TRUE);
			}
		}

		case T_PREF_SHOW_SIGNATURE_END: {
			return(TRUE);
		}

		case T_PREF_MSGPERPAGE : {
			unsigned long		Len;
			unsigned long		a = -1;
			
			if (MsgGetUserFeature(Session->UserDN, FEATURE_MODWEB, MSGSRV_A_PREFERENCES, PrefSession->V)) {
				for (c = 0; c < PrefSession->V->Used; c++) {
					if (MWQuickNCmp(PrefSession->V->Value[c], "ModWeb:MsgPerPage=", 18)) {
						a = atol(PrefSession->V->Value[c] + 18);
					}
				}
			} else {
				a = 0;
			}
			
			for (c = Token->ArgumentOffsetOrID[0]; c <= Token->ArgumentOffsetOrID[1]; c+=Token->ArgumentOffsetOrID[2]) {
				Len = snprintf(Client->Temp, sizeof(Client->Temp), "<OPTION%s>%d</OPTION>\r\n", (c >= a && a != 0) ? " SELECTED" : "", (int)c); 
				if (c >= a) {
					a = 0;
				}
				MWSendClient(Client, Client->Temp, Len);
			}

			MDBFreeValues(PrefSession->V);
			return(TRUE);
		}

		/* Begin proxy section */

		/* Stored as: Title Host User Password UID IMAP KeepMail */
		case T_PREF_PROXY_BEGIN: {
			if (PrefSession->Count == 0) {
				MsgGetUserFeature(Session->UserDN, FEATURE_PROXY, MSGSRV_A_PROXY_LIST, PrefSession->V);
				if (PrefSession->V->Used > 0) {
					memset(&PrefSession->Proxy, 0, sizeof(PrefSession->Proxy));
					ParseProxyList(PrefSession->V, (ProxyListStruct *)&PrefSession->Proxy);
				}				
			}
			return(TRUE);
		}

		case T_PREF_PROXY_END: {
			PrefSession->Count++;
			
			if (PrefSession->Count >= 3) {
				MDBFreeValues(PrefSession->V);
				PrefSession->Count = 0;
				return(TRUE);
			} else {
				*GotoToken=T_PREF_PROXY_BEGIN;
				return(TOKEN_MOVE_BACKWARD);
			}
			break;
		}

		case T_PREF_PROXY_VALUE: {
			switch (Token->ArgumentOffsetOrID[0]) {

				case AA_CURRENT: {
					c = snprintf(Client->Temp, sizeof(Client->Temp), "%lu", PrefSession->Count);
					MWSendClient(Client, Client->Temp, c);
					return(TRUE);
				}

				case AA_HOSTNAME: {
					if (PrefSession->Count < PrefSession->V->Used) {
						if (PrefSession->Proxy[PrefSession->Count].Host) {
							MWSendClient(Client, PrefSession->Proxy[PrefSession->Count].Host, strlen(PrefSession->Proxy[PrefSession->Count].Host));
						}
					}
					return(TRUE);
				}

				case AA_USERNAME: {
					if (PrefSession->Count < PrefSession->V->Used) {
						if (PrefSession->Proxy[PrefSession->Count].User) {
							MWSendClient(Client, PrefSession->Proxy[PrefSession->Count].User, strlen(PrefSession->Proxy[PrefSession->Count].User));
						}
					}
					return(TRUE);
				}

				case AA_PASSWORD: {
					if (PrefSession->Count < PrefSession->V->Used) {
						if (PrefSession->Proxy[PrefSession->Count].Password) {
							MWSendClient(Client, PrefSession->Proxy[PrefSession->Count].Password, strlen(PrefSession->Proxy[PrefSession->Count].Password));
						}
					}
					return(TRUE);
				}

				case AA_UID: {
					if (PrefSession->Count < PrefSession->V->Used) {
						if (PrefSession->Proxy[PrefSession->Count].UID) {
							MWSendClient(Client, PrefSession->Proxy[PrefSession->Count].UID, strlen(PrefSession->Proxy[PrefSession->Count].UID));
						} else {
							MWSendClient(Client, "0", 1);
						}
					}
					return(TRUE);
				}

				case AA_PROTOCOL: {
					if (PrefSession->Count < PrefSession->V->Used) {
						c = snprintf(Client->Temp, sizeof(Client->Temp), "<OPTION%s>IMAP<OPTION%s>POP3", PrefSession->Proxy[PrefSession->Count].IMAP ? " SELECTED" : "", PrefSession->Proxy[PrefSession->Count].IMAP ? "" : " SELECTED");
						MWSendClient(Client, Client->Temp, c);
					} else {
						MWSendClient(Client, "<OPTION>IMAP<OPTION>POP3", 24);
					} 
					return(TRUE);
				}

				case AA_LEAVE: {
					if (PrefSession->Count < PrefSession->V->Used) {
						if (PrefSession->Proxy[PrefSession->Count].KeepMail) {
							MWSendClient(Client, CHECKED, strlen(CHECKED) - 1);
						}
					}
					return(TRUE);
				}

				case AA_SSL: {
					if (PrefSession->Count < PrefSession->V->Used) {
						if (PrefSession->Proxy[PrefSession->Count].SSL) {
							MWSendClient(Client, CHECKED, strlen(CHECKED) - 1);
						}
					}
					return(TRUE);
				}
			}
			return(FALSE);
		}
		/* End of proxy section */

		case T_PREF_ENABLED : {
			BOOL	Enabled = FALSE;
				
			switch (Token->ArgumentOffsetOrID[0]) {

				case AA_IMPLICITPURGE: {
					MsgGetUserFeature(Session->UserDN, FEATURE_MODWEB, MSGSRV_A_PREFERENCES, PrefSession->V);
					for (c = 0; c < PrefSession->V->Used; c++) {
						if (MWQuickNCmp(PrefSession->V->Value[c], "Webmail:Options:", 16)) {
							if ((atoi(PrefSession->V->Value[c] + 16) & PREFS_PURGE_MASK) >> PREFS_PURGE_SHIFT) {
								Enabled = TRUE;
							} 
							break;
						}
					}
					break;
				}

				case AA_FORWARDING: {
					MsgGetUserFeature(Session->UserDN, FEATURE_FORWARD, MSGSRV_A_FORWARDING_ENABLED, PrefSession->V);
					if (PrefSession->V->Used > 0) {
						if (PrefSession->V->Value[0][0]!='0') {
							Enabled = TRUE;
						}
					}
					break;
				}

				case AA_FORWARDANDKEEPCOPY: {
					MsgGetUserFeature(Session->UserDN, FEATURE_FORWARD, MSGSRV_A_FORWARDING_ENABLED, PrefSession->V);
					if (PrefSession->V->Used >0) {
						if (PrefSession->V->Value[0][0] == '2') {
							Enabled = TRUE;
						}
					}
					break;
				}

				case AA_AUTOREPLY: {
					MsgGetUserFeature(Session->UserDN, FEATURE_AUTOREPLY, MSGSRV_A_AUTOREPLY_ENABLED, PrefSession->V);
					if (PrefSession->V->Used >0) {
						if (PrefSession->V->Value[0][0]!='0') {
							Enabled = TRUE;
						}
					}
					break;
				}

				case AA_SIGNATURE: {
					if (MsgGetUserFeature(Session->UserDN, FEATURE_MODWEB, MSGSRV_A_SIGNATURE, PrefSession->V)) {
						for (c = 0; c < PrefSession->V->Used; c++) {
							if (strlen(PrefSession->V->Value[c]) > 2) {
								if (PrefSession->V->Value[c][0] == 'E' && PrefSession->V->Value[c][1] == ':' && PrefSession->V->Value[c][2] == 'T') {
										Enabled = TRUE;
										break;
								}
							}
						}
					}
					break;
				}
			}

			MDBFreeValues(PrefSession->V);

			if (Enabled) {
				MWSendClient(Client, Token->Data+Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
			} else {
				MWSendClient(Client, Token->Data+Token->ArgumentOffsetOrID[2], Token->ArgumentSize[2]);
			}
			
			return(TRUE);
		}

#if 0
		case T_PREF_LDAP_CONTEXT : {
			if (MsgGetUserFeature(Session->UserDN, FEATURE_MWMAIL_ADDRBOOK_G, MSGSRV_A_ADDRESSBOOK_URL_PUBLIC, PrefSession->V)) {
				for (c = 0; c < PrefSession->V->Used; c++) {
					if (PrefSession->V->Value[c][0] == 'B' && PrefSession->V->Value[c][1] == ':') {
						MWSendClient(Client, PrefSession->V->Value[c] + 2, strlen(PrefSession->V->Value[c] + 2));
						break;
					}
				}
			}			
			MDBFreeValues(PrefSession->V);			
			return(TRUE);
		}
#endif

		case T_PREF_SECRET_BEGIN:	{
			if (MDBRead(Session->UserDN, MSGSRV_A_PHRASE, PrefSession->V)) {
				MDBFreeValues(PrefSession->V);			
				return(TRUE);
			}
			MDBFreeValues(PrefSession->V);			

			*GotoToken=T_PREF_SECRET_END;
			return(TOKEN_MOVE_FORWARD);
		}

		case T_PREF_SECRET_END: {
			return(TRUE);
		}

		case T_SAVE_FORM: {
			MWEncodeURL(Session, URL, URL_TYPE_LINK, SAVE_FORM, Token->ArgumentOffsetOrID[0], 0, 0, 0);
			MWSendClient(Client, URL, strlen(URL));
			return(TRUE);
		}

		case T_RULE_LIST_FORM : {
			MWEncodeURL(Session, URL, URL_TYPE_LINK, RULE_LIST_FORM, Token->ArgumentOffsetOrID[0], 0, 0, 0);
			MWSendClient(Client, URL, strlen(URL));
			return(TRUE);
		}

		case T_RULE_CREATE_FORM : {
			MWEncodeURL(Session, URL, URL_TYPE_LINK, RULE_CREATE_FORM, Token->ArgumentOffsetOrID[0], 0, 0, 0);
			MWSendClient(Client, URL, strlen(URL));
			return(TRUE);
		}

		case T_RULE_LIST_BEGIN : {
			if (PrefSession->Count == 0) {
				MsgGetUserFeature(Session->UserDN, FEATURE_RULES, MSGSRV_A_RULE, PrefSession->V);
				if (PrefSession->V->Used == 0) {
					*GotoToken=T_RULE_LIST_END;
					return(TOKEN_MOVE_FORWARD);
				}
			}
			if (PrefSession->Count < PrefSession->V->Used) {
				PrefSession->CurrentRule = PrefSession->V->Value[PrefSession->Count];

				if ((PrefSession->Count % 2)==0) {
					PrefSession->CurrentColor=Token->Data+Token->ArgumentOffsetOrID[0];
					PrefSession->CurrentColorLen=Token->ArgumentSize[0];
				} else {
					PrefSession->CurrentColor=Token->Data+Token->ArgumentOffsetOrID[1];
					PrefSession->CurrentColorLen=Token->ArgumentSize[1];
				}
			}
			return(TRUE);
		}

		case T_RULE_LIST_END : {
			if ((PrefSession->Count + 1) < PrefSession->V->Used) {
				PrefSession->Count++;
				*GotoToken = T_RULE_LIST_BEGIN;
				return(TOKEN_MOVE_BACKWARD);
			}
			PrefSession->Count = 0;

			MDBFreeValues(PrefSession->V);
			return(TRUE);
		}

		case T_RULE_LIST_NAME : {
			
			if (PrefSession->CurrentRule && CheckRuleString(Client, PrefSession->CurrentRule, Session)) {
				SendRuleString(Client, PrefSession->CurrentRule, Session);
			}
			return(TRUE);
		}

		case T_RULE_LIST_CURRENT_COLOR : {
			MWSendClient(Client, PrefSession->CurrentColor, PrefSession->CurrentColorLen);
			return(TRUE);
		}

		case T_RULE_ACTIVE : {
			MWSendClient(Client, "<INPUT TYPE=\"CHECKBOX\" ", 23);
			c = snprintf(Client->Temp, sizeof(Client->Temp), "NAME=\"%d\"%s>", (int)PrefSession->Count, (PrefSession->CurrentRule && (PrefSession->CurrentRule[8] == RULE_ACTIVE)) ? " CHECKED" : "");
			MWSendClient(Client, Client->Temp, c);
			return(TRUE);
		}

		case T_RULE_DELETE : {
			MWEncodeURL(Session, URL, URL_TYPE_LINK, RULE_DELETE, Token->ArgumentOffsetOrID[0], PrefSession->Count, 0, 0);
			MWSendClient(Client, URL, strlen(URL));
			return(TRUE);
		}

		case T_RULE_CREATE_CONDITION : {
			MWSendClient(Client, RULECREATE_FROM, strlen(RULECREATE_FROM));
			MWSendClient(Client, Session->Strings[Token->ArgumentOffsetOrID[0] + RULE_FROM], strlen(Session->Strings[Token->ArgumentOffsetOrID[0] + RULE_FROM]));

			MWSendClient(Client, RULECREATE_TO, strlen(RULECREATE_TO));
			MWSendClient(Client, Session->Strings[Token->ArgumentOffsetOrID[0] + RULE_TO], strlen(Session->Strings[Token->ArgumentOffsetOrID[0] + RULE_TO]));

			MWSendClient(Client, RULECREATE_CC, strlen(RULECREATE_CC));
			MWSendClient(Client, Session->Strings[Token->ArgumentOffsetOrID[0] + RULE_CC], strlen(Session->Strings[Token->ArgumentOffsetOrID[0] + RULE_CC]));

			MWSendClient(Client, RULECREATE_SUBJECT, strlen(RULECREATE_SUBJECT));
			MWSendClient(Client, Session->Strings[Token->ArgumentOffsetOrID[0] + RULE_SUBJECT], strlen(Session->Strings[Token->ArgumentOffsetOrID[0] + RULE_SUBJECT]));

			MWSendClient(Client, RULECREATE_BODY, strlen(RULECREATE_BODY));
			MWSendClient(Client, Session->Strings[Token->ArgumentOffsetOrID[0] + RULE_BODY], strlen(Session->Strings[Token->ArgumentOffsetOrID[0] + RULE_BODY]));

			MWSendClient(Client, RULECREATE_ALL, strlen(RULECREATE_ALL));
			MWSendClient(Client, Session->Strings[Token->ArgumentOffsetOrID[0] + RULE_ALL], strlen(Session->Strings[Token->ArgumentOffsetOrID[0] + RULE_ALL]));
			return(TRUE);
		}

		case T_RULE_CREATE_MOVE : {
			unsigned long		Len;

			for (c = 0; c < Session->FolderList->Used; c++) {
				unsigned char		*Folder = Session->FolderList->Value[c];

				if (*Folder == 'M') {
					Len = snprintf(Client->Temp, sizeof(Client->Temp), "<OPTION VALUE=\"%s\">", Folder + 3);
					MWSendClient(Client, Client->Temp, Len);
					ptr = Folder + 3;
					while (isspace(*ptr)) {
						MWSendClient(Client, "&nbsp;", 6);
						ptr++;
					}
					MWSendClient(Client, ptr, strlen(ptr));
					MWSendClient(Client, "</OPTION>\r\n", 11);
				}
			}		

			return(TRUE);
		}

		case T_FEATURE_PROXY_BEGIN : {
			if (MsgGetUserFeature(Session->UserDN, FEATURE_PROXY, NULL, NULL)) {
				return(TRUE);
			} else {
				*GotoToken=T_FEATURE_PROXY_END;
				return(TOKEN_MOVE_FORWARD);
			}
		}

		case T_FEATURE_PROXY_END : {
			return(TRUE);
		}

		case T_FEATURE_FORWARD_BEGIN : {
			if (MsgGetUserFeature(Session->UserDN, FEATURE_FORWARD, NULL, NULL)) {
				return(TRUE);
			} else {
				*GotoToken=T_FEATURE_FORWARD_END;
				return(TOKEN_MOVE_FORWARD);
			}
		}

		case T_FEATURE_FORWARD_END : {
			return(TRUE);
		}

		case T_FEATURE_AUTOREPLY_BEGIN : {
			if (MsgGetUserFeature(Session->UserDN, FEATURE_AUTOREPLY, NULL, NULL)) {
				return(TRUE);
			} else {
				*GotoToken=T_FEATURE_AUTOREPLY_END;
				return(TOKEN_MOVE_FORWARD);
			}
		}

		case T_FEATURE_AUTOREPLY_END : {
			return(TRUE);
		}

		case T_FEATURE_RULES_BEGIN : {
			if (MsgGetUserFeature(Session->UserDN, FEATURE_RULES, NULL, NULL)) {
				return(TRUE);
			} else {
				*GotoToken=T_FEATURE_RULES_END;
				return(TOKEN_MOVE_FORWARD);
			}
		}

		case T_FEATURE_RULES_END : {
			return(TRUE);
		}

		case T_FEATURE_ADDRBOOK_BEGIN : {
			if (MsgGetUserFeature(Session->UserDN, FEATURE_MWMAIL_ADDRBOOK_G, NULL, NULL)) {
				return(TRUE);
			} else {
				*GotoToken=T_FEATURE_ADDRBOOK_END;
				return(TOKEN_MOVE_FORWARD);
			}
		}

		case T_FEATURE_ADDRBOOK_END : {
			return(TRUE);
		}

		case T_USER_RULE_LIST_BEGIN : {
			if (PrefSession->V->Used == 0) {
				MDBRead(Session->UserDN, MSGSRV_A_RULE, PrefSession->V);

				if (PrefSession->V->Used == 0) {
					*GotoToken=T_USER_RULE_LIST_END;
					return(TOKEN_MOVE_FORWARD);
				}

				/*
					Sort by unique rule ID, because we are using the id to define order
				*/
				qsort(PrefSession->V->Value, PrefSession->V->Used, sizeof(unsigned char*), CompareRuleID);
			}
			return(TRUE);
		}

		case T_USER_RULE_LIST_END : {
			if (PrefSession->V->Used) {
				MDBFreeValue(0, PrefSession->V);
			}

			if (PrefSession->V->Used) {
				/* We have more to display */

				*GotoToken = T_USER_RULE_LIST_BEGIN;
				return(TOKEN_MOVE_BACKWARD);
			}
			PrefSession->CurrentRuleSegment = NULL;
			PrefSession->RuleID = 0;

			return(TRUE);
		}

		case T_USER_RULE_LIST_VALUE : {
			if (PrefSession->V->Used) {
				if (PrefSession->V->Used && strlen(PrefSession->V->Value[0]) > 8) {
					switch (Token->ArgumentOffsetOrID[0]) {
						case AA_RULESTRING: {
							if (CheckRuleString(Client, PrefSession->V->Value[0], Session)) {
								SendRuleString(Client, PrefSession->V->Value[0], Session);
							}
							break;
						}
						case AA_RULEACTIVE: {
							if (PrefSession->V->Value[0][8] == RULE_ACTIVE) {
								MWSendClient(Client, Token->Data+Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
							} else {
								MWSendClient(Client, Token->Data+Token->ArgumentOffsetOrID[2], Token->ArgumentSize[2]);
							}
							break;
						}
					}
				}
			}
			return(TRUE);
		}

		case T_USER_RULE_LIST_ACTION : {
			unsigned long		ID = 0;
			unsigned long		Action = DISPLAY_TEMPLATE;

			if (PrefSession->V->Used && strlen(PrefSession->V->Value[0]) > 8) {
				unsigned char		Temp = PrefSession->V->Value[0][8];

				PrefSession->V->Value[0][8] = '\0';
				ID = strtol(PrefSession->V->Value[0], NULL, 16);
				PrefSession->V->Value[0][8] = Temp;

				switch (Token->ArgumentOffsetOrID[0]) {
					case AA_RULEEDIT: {
						Action = REQUEST_RULE_EDIT;
						break;
					}

					case AA_RULEDELETE: {
						Action = REQUEST_RULE_DELETE;
						break;
					}

					case AA_RULETOGGLE: {
						Action = REQUEST_RULE_TOGGLE_STATE;
						break;
					}

					case AA_RULEUP: {
						Action = REQUEST_RULE_UP;
						break;
					}

					case AA_RULEDOWN: {
						Action = REQUEST_RULE_DOWN;
						break;
					}
				}
			}
			MWEncodeURL(Session, URL, URL_TYPE_LINK, Action, Token->ArgumentOffsetOrID[1], ID, TRUE, TRUE);
			MWSendClient(Client, URL, strlen(URL));

			return(TRUE);
		}

		case T_USER_RULE_ID: {
			Len = snprintf(Buffer, sizeof(Buffer), "%lu", PrefSession->RuleID);
			MWSendClient(Client, Buffer, Len);
			return(TRUE);
		}

		case T_USER_RULE_PART_BEGIN: {
			/*
				If the rule type (argument 0) is AA_RULECONDITION we just need to find the
				selected rule, and setup to display the first condition.  If the type
				is AA_RULEACTION then we need to make sure we skip past the conditions of
				the rule.  Since about 95% of the time the actions will directly follow
				the conditions in the template it seems like a waste to read and parse
				the rule twice, but we can't rely on that.  We have to make sure we
				clean up for each.
			*/

			if (!PrefSession->V->Used) {
				BOOL			Found = FALSE;

				/* We are comming in for the first time */

				if (MDBRead(Session->UserDN, MSGSRV_A_RULE, PrefSession->V)) {

					/*
						A single rule matching PrefSession->RuleID should
						be left after this for loop
					*/

					while (!Found && PrefSession->V->Used > 0) {
						unsigned long		ID;

						if (strlen(PrefSession->V->Value[0]) > 8) {
							unsigned char		Temp = PrefSession->V->Value[0][8];

							PrefSession->V->Value[0][8] = '\0';
							ID = strtol(PrefSession->V->Value[0], NULL, 16);
							PrefSession->V->Value[0][8] = Temp;

							if (ID != PrefSession->RuleID) {
								/*
									We found a non-matching ID, so lets rip it out
								*/
								MDBFreeValue(0, PrefSession->V);
							} else {
								/* Lets free all values except the first one */
								while (PrefSession->V->Used > 1) {
									MDBFreeValue(1, PrefSession->V);
								}
								Found = TRUE;
							}
						} else {
							MDBFreeValue(0, PrefSession->V);
						}
					}
				}

				if (!PrefSession->V->Used) {
					/*
						We didn't read a value, so there is no rule
						on this object.  We will continue as normal
						and RuleCondEnd will break the loop
					*/
					break;
				}
				if (Token->ArgumentOffsetOrID[0] == AA_RULECONDITION) {
					PrefSession->CurrentRuleSegment = PrefSession->V->Value[0] + 9;
				} else if (Token->ArgumentOffsetOrID[0] == AA_RULEACTION) {
					unsigned char		*ptr;

					/*
						We now need to get past all the conditions, so we know
						we are at the start of the actions.
					*/

					ptr = PrefSession->V->Value[0] + 8;		/* The ID, Active/Inactive flag, and the first condition type */
					do {
						unsigned long		Len;

						ptr += 2;	/* Condition and bool (active/inactive flag on the first instead of bool */

						/* We know this is a condition, so skip past its args */
						Len = ((ptr[0] - '0') * 100) + ((ptr[1] - '0') * 10) + (ptr[2] - '0');
						if ((Len + 3) < strlen(ptr)) {
							ptr += Len + 4;	/* The length plus the terminator character */
						} else {
							/* Incomplete rule.  Just bail */
							ptr = NULL;
						}

						if (ptr) {
							Len = ((ptr[0] - '0') * 100) + ((ptr[1] - '0') * 10) + (ptr[2] - '0');
							if ((Len + 3) < strlen(ptr)) {
								ptr += Len + 4;	/* The length plus the terminator character */
							} else {
								/* Incomplete rule.  Just bail */
								ptr = NULL;
							}
						}
					} while (ptr && *ptr >= RULE_ACT_BOOL_START);

					PrefSession->CurrentRuleSegment = ptr;
				}
			} else {
				if (Token->ArgumentOffsetOrID[0] == AA_RULECONDITION) {
					if (PrefSession->CurrentRuleSegment && (*PrefSession->CurrentRuleSegment >= RULE_ACT_BOOL_START && *PrefSession->CurrentRuleSegment <= RULE_ACT_BOOL_NOT)) {
						PrefSession->RuleSegmentBool = *PrefSession->CurrentRuleSegment;
						PrefSession->CurrentRuleSegment += 1;
					} else {
						/* We are done with conditions. */
						PrefSession->CurrentRuleSegment = NULL;

						*GotoToken = T_USER_RULE_PART_END;
						return(TOKEN_MOVE_FORWARD);
					}
				} else if (Token->ArgumentOffsetOrID[0] == AA_RULEACTION) {
					PrefSession->RuleSegmentBool = '\0';
				}
			}

			if (PrefSession->CurrentRuleSegment) {
				PrefSession->RuleSegmentType = PrefSession->CurrentRuleSegment[0];
				PrefSession->CurrentRuleSegment += 1;
			}

			/* Grab arg1 */
			if (PrefSession->CurrentRuleSegment && strlen(PrefSession->CurrentRuleSegment) > 3) {
				PrefSession->RuleSegmentArg1Len = ((PrefSession->CurrentRuleSegment[0] - '0') * 100) + ((PrefSession->CurrentRuleSegment[1] - '0') * 10) + (PrefSession->CurrentRuleSegment[2] - '0');
				if (PrefSession->RuleSegmentArg1Len + 3 <= strlen(PrefSession->CurrentRuleSegment)) {
					PrefSession->RuleSegmentArg1 = PrefSession->CurrentRuleSegment + 3;

					/* The three digit length, the string itself and the terminator */
					PrefSession->CurrentRuleSegment += (4 + PrefSession->RuleSegmentArg1Len);
				} else {
					PrefSession->CurrentRuleSegment = NULL;
				}
			}

			/* Grab arg2 */
			if (PrefSession->CurrentRuleSegment && strlen(PrefSession->CurrentRuleSegment) > 3) {
				PrefSession->RuleSegmentArg2Len = ((PrefSession->CurrentRuleSegment[0] - '0') * 100) + ((PrefSession->CurrentRuleSegment[1] - '0') * 10) + (PrefSession->CurrentRuleSegment[2] - '0');
				if (PrefSession->RuleSegmentArg2Len + 3 <= strlen(PrefSession->CurrentRuleSegment)) {
					PrefSession->RuleSegmentArg2 = PrefSession->CurrentRuleSegment + 3;

					/* The three digit length, the string itself and the terminator */
					PrefSession->CurrentRuleSegment += (4 + PrefSession->RuleSegmentArg2Len);
				} else {
					PrefSession->CurrentRuleSegment = NULL;
				}
			}

			return(TRUE);
		}

		case T_USER_RULE_PART_END: {
			if (PrefSession->CurrentRuleSegment && *(PrefSession->CurrentRuleSegment)) {
				/* We still have stuff to send, so lets jump back to RuleCondBegin */

				/* Clean up for the next time through */
				PrefSession->RuleSegmentType = '\0';
				PrefSession->RuleSegmentBool = '\0';

				PrefSession->RuleSegmentArg1Len = 0;
				PrefSession->RuleSegmentArg1 = NULL;

				PrefSession->RuleSegmentArg2Len = 0;
				PrefSession->RuleSegmentArg2 = NULL;

				*GotoToken = T_USER_RULE_PART_BEGIN;
				return(TOKEN_MOVE_BACKWARD);
			}
			PrefSession->CurrentRuleSegment = NULL;
			MDBFreeValues(PrefSession->V);

			return(TRUE);
		}

		case T_USER_RULE_COND_VALUE:
		case T_USER_RULE_ACTION_VALUE: {
			if (PrefSession->CurrentRuleSegment) {
				switch (Token->ArgumentOffsetOrID[0]) {
					case AA_RULEBOOL: {
						if (PrefSession->RuleSegmentBool) {
							MWSendClient(Client, &(PrefSession->RuleSegmentBool), 1);
						} else {
							MWSendClient(Client, "0", 1);
						}
						break;
					}

					case AA_RULECONDITION:
					case AA_RULEACTION: {
						if (PrefSession->RuleSegmentType) {
							MWSendClient(Client, &(PrefSession->RuleSegmentType), 1);
						} else {
							MWSendClient(Client, "0", 1);
						}
						break;
					}

					case AA_RULEARG1: {
						if (PrefSession->RuleSegmentArg1) {
							MWSendClient(Client, PrefSession->RuleSegmentArg1, PrefSession->RuleSegmentArg1Len);
						}
						break;
					}

					case AA_RULEARG2: {
						if (PrefSession->RuleSegmentArg2) {
							MWSendClient(Client, PrefSession->RuleSegmentArg2, PrefSession->RuleSegmentArg2Len);
						}
						break;
					}
				}
			}
			return(TRUE);
		}

		case T_USER_RULE_EDIT: {
			MWEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_RULE_SAVE, Token->ArgumentOffsetOrID[0], 0, 0, 0);
			MWSendClient(Client, URL, strlen(URL));
			return(TRUE);
		}

		case T_PREF_SHAREDFOLDERS_BEGIN: {
			if (PrefSession->V->Used == 0) {
				/*
					This is our first time through

					Send NMAP a "SHARE MBOX" command, and put each line into PrefSession->V,
					which we then sort.  We loop in the Share Folder User tokens while
					we are in the same folder.  As soon as we find a new folder we go on.
				*/

				MWSendNMAPServer(Session, "SHARE MBOX\r\n", 12);
				if (MWGetNMAPAnswer(Session, Buffer, sizeof(Buffer), TRUE) != 2002) {
					/* We got crap from NMAP.  Oops */
					return(TRUE);
				}

				*Buffer = 'M';
				while (MWGetNMAPAnswer(Session, Buffer + 1, BUFSIZE, TRUE) != 1000) {
					MDBAddValue(Buffer, PrefSession->V);
				}

				MWSendNMAPServer(Session, "SHARE CAL\r\n", 11);
				if (MWGetNMAPAnswer(Session, Buffer, sizeof(Buffer), TRUE) != 2002) {
					/* We got crap from NMAP.  Oops */
					return(TRUE);
				}

				*Buffer = 'C';
				while (MWGetNMAPAnswer(Session, Buffer + 1, BUFSIZE, TRUE) != 1000) {
					MDBAddValue(Buffer, PrefSession->V);
				}

				if (PrefSession->V->Used == 0) {
					/* We didn't get anything, so just skip out */
					*GotoToken = T_PREF_SHAREDFOLDERS_END;
					return(TOKEN_MOVE_FORWARD);
				}

				qsort(PrefSession->V->Value, PrefSession->V->Used, sizeof(unsigned char *), SortFolder);

				PrefSession->Count = 0;
			}
			return(TRUE);
		}

		case T_PREF_SHAREDFOLDERS_END: {
			if (PrefSession->V->Used > 0) {
				MDBFreeValue(0, PrefSession->V);
			}

			if (PrefSession->V->Used > 0) {
				/* We're not done, so loop back to T_PREF_SHAREDFOLDERS_BEGIN */

				*GotoToken = T_PREF_SHAREDFOLDERS_BEGIN;
				return(TOKEN_MOVE_BACKWARD);
			} else {
				PrefSession->Count = 0;
				return(TRUE);
			}
		}

		case T_PREF_SHAREDFOLDERS_VALUE: {
			switch (Token->ArgumentOffsetOrID[0]) {
				case AA_SHARENAME: {
					if (PrefSession->V->Used > 0) {
						unsigned char		*ptr = strchr(PrefSession->V->Value[0] + 1, ' ');

						if (ptr) {
							*ptr = '\0';
							FolderUTF7toUTF8(PrefSession->V->Value[0] + 1, Buffer);
							MWSendClient(Client, Buffer, strlen(Buffer));
							*ptr = ' ';
						}
					}
					break;
				}

				case AA_SHAREIMAGE: {
					if (PrefSession->V->Used > 0) {
						unsigned char		FolderType = PrefSession->V->Value[PrefSession->Count][0];

						switch (toupper(FolderType)) {
							case 'M': {	/* MailBox */
								MWEncodeURL(Session, URL, URL_TYPE_IMAGE, DISPLAY_IMAGE, Session->TemplateID, Session->Language, Token->ArgumentOffsetOrID[1], 0);
								break;
							}
							case 'C': {	/* Calendar */
								MWEncodeURL(Session, URL, URL_TYPE_IMAGE, DISPLAY_IMAGE, Session->TemplateID, Session->Language, Token->ArgumentOffsetOrID[2], 0);
								break;
							}
							case 'F': {	/* Folder */
								MWEncodeURL(Session, URL, URL_TYPE_IMAGE, DISPLAY_IMAGE, Session->TemplateID, Session->Language, Token->ArgumentOffsetOrID[3], 0);
								break;
							}
						}
						MWSendClient(Client, URL, strlen(URL));
					}

					break;
				}
			}
			return(TRUE);
		}


		case T_PREF_SHAREDFOLDERUSER_BEGIN: {
			if (PrefSession->V->Used > 0) {
				return(TRUE);
			} else {
				/* We don't actually have anything, so we just leave */

				*GotoToken = T_PREF_SHAREDFOLDERUSER_END;
				return(TOKEN_MOVE_FORWARD);
			}
		}

		case T_PREF_SHAREDFOLDERUSER_END: {
			BOOL			Rewind = FALSE;

			/*
				We need to figure out if the next line has the same folder
				as the current line.  If so we loop back to
				T_PREF_SHAREDFOLDERUSER_BEGIN and if not we go on.
			*/

			if (PrefSession->V->Used > 1) {
				unsigned char		*OldValue = strchr(PrefSession->V->Value[0], ' ');
				unsigned char		*NewValue = strchr(PrefSession->V->Value[1], ' ');

				if (OldValue && NewValue) {
					*OldValue = '\0';
					*NewValue = '\0';

					if (MWQuickCmp(PrefSession->V->Value[0], PrefSession->V->Value[1])) {
						Rewind = TRUE;
					}

					*OldValue = ' ';
					*NewValue = ' ';
				}
			}

			/* We abuse count, so lets reset it */
			PrefSession->Count = 0;

			if (Rewind) {
				/* We're not done, so loop back to T_PREF_SHAREDFOLDERUSER_BEGIN */

				if (PrefSession->V->Used > 0) {
					MDBFreeValue(0, PrefSession->V);
				}

				*GotoToken = T_PREF_SHAREDFOLDERUSER_BEGIN;
				return(TOKEN_MOVE_BACKWARD);
			} else {
				return(TRUE);
			}
		}

		case T_PREF_SHAREDFOLDERUSER_DEL: {
			/* Genereate a URL to delete the share */
			if (PrefSession->V->Used > 0) {
				unsigned char		*ptr;

				if (PrefSession->V->Value[0][0] == 'M') {
					MWEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_DELETE_SHARE, Token->ArgumentOffsetOrID[0], TRUE, 0, 0);
				} else {
					MWEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_DELETE_SHARE, Token->ArgumentOffsetOrID[0], FALSE, 0, 0);
				}
				MWSendClient(Client, URL, strlen(URL));

				/* Send "FolderName UserName" as URLExtra */
				ptr = strchr(PrefSession->V->Value[0] + 1, ' ');
				if (ptr) {
					ptr++;
					ptr = strchr(ptr, ' ');
				}

				if (ptr) {
					*ptr = '\0';
					MWSendURLExtra(Client, PrefSession->V->Value[0] + 1);
					*ptr = ' ';
				}
			}

			return(TRUE);
		}

		case T_PREF_SHAREDFOLDERUSER_VALUE: {
			if (PrefSession->V->Used > 0) {

				/* Abuse count to store the flags */
				if (PrefSession->Count == 0) {
					unsigned char		*ptr;

					ptr = strrchr(PrefSession->V->Value[0], ' ');
					if (ptr) {
						ptr++;

						PrefSession->Count = atol(ptr);
					}
				}

				switch (Token->ArgumentOffsetOrID[0]) {
					case AA_GRANTEE: {
						unsigned char		*Begin;
						unsigned char		*End;

						/* Display the grantee name */

						Begin = strchr(PrefSession->V->Value[0], ' ');
						if (Begin) {
							Begin++;
							End = strchr(Begin, ' ');

							if (End) {
								*End = '\0';
								MWSendClient(Client, Begin, strlen(Begin));
								*End = ' ';
							}
						}
						break;
					}

					case AA_SHARESEEN: {
						if (PrefSession->Count & NMAP_SHARE_SEEN) {
							MWSendClient(Client, Token->Data + Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
						} else {
							MWSendClient(Client, Token->Data + Token->ArgumentOffsetOrID[2], Token->ArgumentSize[2]);
						}

						break;
					}

					case AA_SHAREREAD: {
						if (PrefSession->Count & NMAP_SHARE_READ) {
							MWSendClient(Client, Token->Data + Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
						} else {
							MWSendClient(Client, Token->Data + Token->ArgumentOffsetOrID[2], Token->ArgumentSize[2]);
						}

						break;
					}

					case AA_SHAREWRITE: {
						if (PrefSession->Count & NMAP_SHARE_WRITE) {
							MWSendClient(Client, Token->Data + Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
						} else {
							MWSendClient(Client, Token->Data + Token->ArgumentOffsetOrID[2], Token->ArgumentSize[2]);
						}

						break;
					}

					case AA_SHAREINSERT: {
						if (PrefSession->Count & NMAP_SHARE_INSERT) {
							MWSendClient(Client, Token->Data + Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
						} else {
							MWSendClient(Client, Token->Data + Token->ArgumentOffsetOrID[2], Token->ArgumentSize[2]);
						}

						break;
					}

					case AA_SHARECREATE: {
						if (PrefSession->Count & NMAP_SHARE_CREATE) {
							MWSendClient(Client, Token->Data + Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
						} else {
							MWSendClient(Client, Token->Data + Token->ArgumentOffsetOrID[2], Token->ArgumentSize[2]);
						}

						break;
					}

					case AA_SHAREDELETE: {
						if (PrefSession->Count & NMAP_SHARE_DELETE) {
							MWSendClient(Client, Token->Data + Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
						} else {
							MWSendClient(Client, Token->Data + Token->ArgumentOffsetOrID[2], Token->ArgumentSize[2]);
						}

						break;
					}
				}
			}
			return(TRUE);
		}

		case T_PREF_SHAREDFOLDERUSER_NAME: {
			if (PrefSession->V->Used > 0) {
				unsigned char		*ptr;

				ptr = strrchr(PrefSession->V->Value[0], ' ');

				if (ptr) {
					*ptr = '\0';

					switch (Token->ArgumentOffsetOrID[0]) {
						case AA_SHARESEEN: {
							MWSendClient(Client, Buffer, snprintf(Buffer, sizeof(Buffer), "ShareRights:%s %lu", PrefSession->V->Value[0], (long unsigned int)NMAP_SHARE_SEEN));
							break;
						}

						case AA_SHAREREAD: {
							MWSendClient(Client, Buffer, snprintf(Buffer, sizeof(Buffer), "ShareRights:%s %lu", PrefSession->V->Value[0], (long unsigned int)NMAP_SHARE_READ));
							break;
						}

						case AA_SHAREWRITE: {
							MWSendClient(Client, Buffer, snprintf(Buffer, sizeof(Buffer), "ShareRights:%s %lu", PrefSession->V->Value[0], (long unsigned int)NMAP_SHARE_WRITE));
							break;
						}

						case AA_SHAREINSERT: {
							MWSendClient(Client, Buffer, snprintf(Buffer, sizeof(Buffer), "ShareRights:%s %lu", PrefSession->V->Value[0], (long unsigned int)NMAP_SHARE_INSERT));
							break;
						}

						case AA_SHARECREATE: {
							MWSendClient(Client, Buffer, snprintf(Buffer, sizeof(Buffer), "ShareRights:%s %lu", PrefSession->V->Value[0], (long unsigned int)NMAP_SHARE_CREATE));
							break;
						}

						case AA_SHAREDELETE: {
							MWSendClient(Client, Buffer, snprintf(Buffer, sizeof(Buffer), "ShareRights:%s %lu", PrefSession->V->Value[0], (long unsigned int)NMAP_SHARE_DELETE));
							break;
						}
					}

					*ptr = ' ';
				}
			}

			return(TRUE);
		}

		case T_PROXY_ALLOWED_BEGIN: {
			if (PrefSession->V->Used == 0) {
				unsigned long		i;

				/*
					First time through
				*/

				if (MDBReadDN(Session->UserDN, MSGSRV_A_MANAGED_RESOURCES, PrefSession->V) > 0) {
					unsigned char		*ptr;

					/* Just need the object names, strip off the path */

					do {
						ptr = strrchr(PrefSession->V->Value[0], '\\');
						if (ptr) {
							MDBAddValue(ptr + 1, PrefSession->V);
							MDBFreeValue(0, PrefSession->V);
						}
					} while (ptr);
				}

				MWSendNMAPServer(Session, "SHOWPROXY\r\n", 11);
				if (MWGetNMAPAnswer(Session, Buffer, BUFSIZE, TRUE) != 2002) {
					*GotoToken = T_PROXY_ALLOWED_END;
					return(TOKEN_MOVE_FORWARD);
				}

				while ((i = MWGetNMAPAnswer(Session, Buffer, BUFSIZE, TRUE)) != 1000) {
					unsigned char		*ptr;

					ptr = strrchr(Buffer, ' ');
					if (ptr) {
						*ptr = '\0';
					}
					MDBAddValue(Buffer, PrefSession->V);
				}

				if (PrefSession->V->Used == 0) {
					*GotoToken = T_PROXY_ALLOWED_END;
					return(TOKEN_MOVE_FORWARD);
				}
			}

			return(TRUE);
		}

		case T_PROXY_ALLOWED_END: {
			if (PrefSession->V->Used > 0) {
				MDBFreeValue(0, PrefSession->V);
			}

			if (PrefSession->V->Used > 0) {
				/* We aren't done. */
					*GotoToken = T_PROXY_ALLOWED_BEGIN;
					return(TOKEN_MOVE_BACKWARD);
			}

			/* We used this durning this loop, so make sure its reset afterwards */
			PrefSession->Count = 0;

			return(TRUE);
		}

		case T_PROXY_ALLOWED_VALUE: {
			if (PrefSession->V->Used > 0) {
				switch (Token->ArgumentOffsetOrID[0]) {
					case AA_PROXYSWITCH: {
						MWEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_PROXY_SWITCH, Token->ArgumentOffsetOrID[1], 0, 0, 0);
						MWSendClient(Client, URL, strlen(URL));

						MWSendURLExtra(Client, PrefSession->V->Value[0]);

						break;
					}
					case AA_PROXYNAME: {
						MWSendClient(Client, PrefSession->V->Value[0], strlen(PrefSession->V->Value[0]));
						break;
					}
				}
			}
			return(TRUE);
		}

		case T_PROXY_ALLOWING_BEGIN: {
			if (PrefSession->V->Used == 0) {
				unsigned long		i;

				/*
					First time through
				*/
				MWSendNMAPServer(Session, "PROXY\r\n", 7);
				if (MWGetNMAPAnswer(Session, Buffer, BUFSIZE, TRUE) != 2002) {
					*GotoToken = T_PROXY_ALLOWING_END;
					return(TOKEN_MOVE_FORWARD);
				}

				while ((i = MWGetNMAPAnswer(Session, Buffer, BUFSIZE, TRUE)) != 1000) {
					MDBAddValue(Buffer, PrefSession->V);
				}

				if (PrefSession->V->Used == 0) {
					*GotoToken = T_PROXY_ALLOWING_END;
					return(TOKEN_MOVE_FORWARD);
				}
			}
			return(TRUE);
		}

		case T_PROXY_ALLOWING_END: {
			if (PrefSession->V->Used > 0) {
				MDBFreeValue(0, PrefSession->V);
			}

			if (PrefSession->V->Used > 0) {
				/* We aren't done. */
					*GotoToken = T_PROXY_ALLOWING_BEGIN;
					return(TOKEN_MOVE_BACKWARD);
			}
			return(TRUE);
		}

		case T_PROXY_ALLOWING_VALUE: {
			if (PrefSession->V->Used > 0) {
				unsigned char		*ptr;

				switch (Token->ArgumentOffsetOrID[0]) {
					case AA_PROXYDELETE: {
						MWEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_PROXY_DELETE, Token->ArgumentOffsetOrID[1], 0, 0, 0);
						MWSendClient(Client, URL, strlen(URL));

						ptr = strrchr(PrefSession->V->Value[0], ' ');
						if (ptr) {
							*ptr = '\0';
						}

						MWSendURLExtra(Client, PrefSession->V->Value[0]);

						if (ptr) {
							*ptr = ' ';
						}
						break;
					}

					case AA_PROXYRO: {
						MWEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_PROXY_RO, Token->ArgumentOffsetOrID[1], 0, 0, 0);
						MWSendClient(Client, URL, strlen(URL));

						ptr = strrchr(PrefSession->V->Value[0], ' ');
						if (ptr) {
							*ptr = '\0';
						}

						MWSendURLExtra(Client, PrefSession->V->Value[0]);

						if (ptr) {
							*ptr = ' ';
						}
						break;
					}

					case AA_PROXYRW: {
						MWEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_PROXY_RW, Token->ArgumentOffsetOrID[1], 0, 0, 0);
						MWSendClient(Client, URL, strlen(URL));

						ptr = strrchr(PrefSession->V->Value[0], ' ');
						if (ptr) {
							*ptr = '\0';
						}

						MWSendURLExtra(Client, PrefSession->V->Value[0]);

						if (ptr) {
							*ptr = ' ';
						}
						break;
					}

					case AA_PROXYNAME: {
						ptr = strrchr(PrefSession->V->Value[0], ' ');
						if (ptr) {
							*ptr = '\0';
						}

						MWSendClient(Client, PrefSession->V->Value[0], strlen(PrefSession->V->Value[0]));

						if (ptr) {
							*ptr = ' ';
						}

						break;
					}

					case AA_PROXYRIGHTS: {
						ptr = strrchr(PrefSession->V->Value[0], ' ');
						if (ptr) {
							ptr++;

							if (*ptr == '2') {
								MWSendClient(Client, Token->Data+Token->ArgumentOffsetOrID[3], Token->ArgumentSize[3]);
							} else {
								MWSendClient(Client, Token->Data+Token->ArgumentOffsetOrID[2], Token->ArgumentSize[2]);
							}
						}
					}
				}
			}
			return(TRUE);
		}

		case T_READ_ONLY_BEGIN: {
			if (Session->ReadOnly) {
				*GotoToken = T_READ_ONLY_END;
				return(TOKEN_MOVE_FORWARD);
			}

			return(TRUE);
		}

		case T_READ_ONLY_END: {

			return(TRUE);
		}
	}

	return(FALSE);
}

/*
	This are the two required functions for a module. The naming
	must be the binary name plus "Init" / "Shutdown"
	Init is supposed to call ModWeb and register any modules that
	are contained within the binary.
	Shutdown must clear the module for unloading.
*/


static BOOL 
ReadPrefConfiguration(void)
{
	MDBValueStruct	*V;

	V = MDBCreateValueStruct(ModuleDirectoryHandle, MsgGetServerDN(NULL));

	if (MDBRead(MSGSRV_AGENT_MODWEB"\\"MSGSRV_AGENT_MWPREF, MSGSRV_A_PASSWORD_CONFIGURATION, V)) {
		PasswordConfig = atol(V->Value[0]);
	}
	MDBFreeValues(V);

	if (MDBRead(MSGSRV_AGENT_MODWEB"\\"MSGSRV_AGENT_MWPREF, MSGSRV_A_CONFIGURATION, V)) {
		GeneralConfig = atol(V->Value[0]);
	}

	MDBDestroyValueStruct(V);
	return(TRUE);
}


EXPORT BOOL MWPREFInit(MWAPIArg);

EXPORT BOOL MWPREFInit(MWAPIArg)
{
	ModuleRegisterStruct	Register;

	if (UnloadOK == TRUE) {

		XplSafeWrite(MWPREFLibraryUserCount, 0);
		ModuleDirectoryHandle = (MDBHandle)MsgInit();
		if (ModuleDirectoryHandle) {
			UnloadOK = FALSE;

			LogHandle = LoggerOpen("mwpref" /* DefaultNSureCertificate, DefaultNSurePrivateKey, 0, NULL */);
			if (LogHandle == NULL) {
				XplConsolePrintf("MWPref: Unable to initialize Nsure Audit.  Logging disabled.\r\n");
			}

			MWAPISet;

			ReadPrefConfiguration();

			Register.ModuleType = MODULE_TEMPLATE;
			Register.Module.Template.InitSession = MWPrefInitSession;
			Register.Module.Template.DestroySession = MWPrefDestroySession;
			Register.Module.Template.HandleURL = MWPrefHandleURL;
			Register.Module.Template.HandleTemplate = MWPrefHandleTemplate;
			Register.Module.Template.TokenRangeStart = MWPREF_TOKEN_START;
			Register.Module.Template.TokenRangeEnd = MWPREF_TOKEN_END;

			MWRegisterModule(&Register);

			XplSafeIncrement(MWPREFLibraryUserCount);

			return(TRUE);
		}
	}

	return(FALSE);
}

EXPORT BOOL MWPREFShutdown(void);

EXPORT BOOL MWPREFShutdown(void)
{
	XplSafeDecrement(MWPREFLibraryUserCount);

	if (UnloadOK == FALSE) {
		UnloadOK = TRUE;

		/*	Make sure the library users are gone before beginning to 
			shutdown.	*/
		while (XplSafeRead(MWPREFLibraryUserCount)) {
			XplDelay(33);
		}

		/* Do any required cleanup */
		LoggerClose(LogHandle);

#if defined(NETWARE) || defined(LIBC)
		XplSignalLocalSemaphore(MWPrefShutdownSemaphore);	/* The signal will release main() */
		XplWaitOnLocalSemaphore(MWPrefShutdownSemaphore);	/* The wait will wait until main() is gone */

		XplCloseLocalSemaphore(MWPrefShutdownSemaphore);
#endif
	}

	return(TRUE);
}

/*
	Below are "stock" functions that are basically infrastructure.
	However, one might want to add initialization code to main
	and takedown code to the signal handler
*/
static void
MWPrefShutdownSigHandler(int Signal)
{
	int	oldTGid;

	oldTGid = XplSetThreadGroupID(TGid);

	if (UnloadOK == FALSE) {
		UnloadOK	= TRUE;

		/*	Make sure the library users are gone before beginning to 
			shutdown.	*/
		while (XplSafeRead(MWPREFLibraryUserCount) > 0) {
			XplDelay(33);
		}

		/* Do any required cleanup */
		LoggerClose(LogHandle);

#if defined(NETWARE) || defined(LIBC)
		XplSignalLocalSemaphore(MWPrefShutdownSemaphore);	/* The signal will release main() */
		XplWaitOnLocalSemaphore(MWPrefShutdownSemaphore);	/* The wait will wait until main() is gone */

		XplCloseLocalSemaphore(MWPrefShutdownSemaphore);
#endif
	}

	XplSetThreadGroupID(oldTGid);

	return;
}
#if defined (NETWARE) || defined (LIBC) 
int _NonAppCheckUnload(void)
{
	if (UnloadOK == FALSE) {
		XplConsolePrintf("\rThis NLM will automatically be unloaded by the thread that loaded it.\n");
		XplConsolePrintf("\rIt does not allow manual unloading.\n");
#if !defined(LIBC)	/* fixme - NetWare requirement */
		XplSetCurrentScreen(XplCreateScreen("System Console", 0));
#endif

		return(1);
	}

	return(0);
}
#endif

int main(int argc, char *argv[])
{
	TGid = XplGetThreadGroupID();

	XplRenameThread(XplGetThreadID(), "ModWeb Preferences Module");

	XplOpenLocalSemaphore(MWPrefShutdownSemaphore, 0);

	XplSignalHandler(MWPrefShutdownSigHandler);

	/*
		This will "park" the module 'til we get unloaded; 
		it would not be neccessary to do this on NetWare, 
		but to prevent from automatically exiting on Unix
		we need to keep main around...
	*/
	XplWaitOnLocalSemaphore(MWPrefShutdownSemaphore);
	XplSignalLocalSemaphore(MWPrefShutdownSemaphore);

	return(0);
}
