/* irqhigh.h -- set high priority IRQ's */

/*
// Copyright 1996, 1997 by Craig Estey -- See the file COPYING for details
*/

#include <linux/types.h>

#ifndef i386
#error irqhigh: this only works/is needed for x86/PC architecture -- sorry
#endif

/* original PC issue configuration */
#define IRQHIGH_MST_BAD			0
#define IRQHIGH_SLV_BAD			8

/* defaults based on standard configuration */
#define IRQHIGH_MST_DFT			3
#define IRQHIGH_SLV_DFT			14

/* master and slave acceptable ranges */
#define IRQHIGH_MST_LO			0
#define IRQHIGH_MST_HI			7
#define IRQHIGH_SLV_LO			8
#define IRQHIGH_SLV_HI			15

/* maximum number of IRQ's */
#define IRQHIGH_MAX			16

#define RNGE(x,lo,hi) \
	(((x) >= (lo)) && ((x) <= (hi)))
