/* This file is part of MemMXtest
 * Copyright (C) 1999, 2000  J.A. Bezemer
 * This program is licensed under the GNU General Public License,
 * see the top-level README file for details.
 */

/* The PR-march element  Up(rp, wn)         (Down not implemented) */

#include "defines.h"

.text

.align 16

.globl prmarchel_rp_wn_ml
prmarchel_rp_wn_ml:


#define PseudoRDEl
#include "marchel_ml_template.S"


/* The real test routine ****************************************************/

.align 16

begintest:

/* Generate new PR tables */

fillprtable1:
	movl  pseudor_start1, %ecx	/* ecx = start of PR table */
	movl  pseudor_end1, %esi	/* esi = end of PR table */
fillprtable1_loop:			/* mm0 = last used PR value */

#ifdef PR_SHIFTMOREBITS64
	movl  $PR_SHIFTBITSNO64, %ebp	/* ebp counts (usu.) 64->1 */
fillprtable1_s64:
#endif

	movq  %mm0, %mm2		/* mm2 is working copy */
        psrlq $32, %mm2			/* shift 32 bits right */
	movd  %mm2, %edx		/* copy to 32-bits temp. reg */
	psllq $1, %mm0			/* shift 1 left, doesn't chg flags */
	test  $0x80000000, %edx		/* test MSB, sets Zflag if zero */
	jz    fillprtable1_0		/* if MSB was zero, don't xor */
	pxor  %mm5,%mm0			/* XOR if needed */
fillprtable1_0:	

#ifdef PR_SHIFTMOREBITS64
	subl  $1, %ebp			/* subtract 1 from ebp */
	jnz   fillprtable1_s64		/* and again if not done enough */
#endif

        movq  %mm0, (%ecx)		/* store new value in table */
	addl  $8, %ecx
	cmpl  %esi, %ecx
	jb    fillprtable1_loop
	
fillprtable2:
	movl  pseudor_start2, %ecx	/* ecx = start of PR table */
	movl  pseudor_end2, %esi	/* esi = end of PR table */
fillprtable2_loop:			/* mm1 = last used PR value */

#ifdef PR_SHIFTMOREBITS64
	movl  $PR_SHIFTBITSNO64, %ebp	/* ebp counts (usu.) 64->1 */
fillprtable2_s64:
#endif

	movq  %mm1, %mm2		/* mm2 is working copy */
        psrlq $32, %mm2			/* shift 32 bits right */
	movd  %mm2, %edx		/* copy to 32-bits temp. reg */
	psllq $1, %mm1			/* shift 1 left, doesn't chg flags */
	test  $0x80000000, %edx		/* test MSB, sets Zflag if zero */
	jz    fillprtable2_0		/* if MSB was zero, don't xor */
	pxor  %mm5,%mm1			/* XOR if needed */
fillprtable2_0:	

#ifdef PR_SHIFTMOREBITS64
	subl  $1, %ebp			/* subtract 1 from ebp */
	jnz   fillprtable2_s64		/* and again if not done enough */
#endif

        movq  %mm1, (%ecx)		/* store new value in table */
	addl  $8, %ecx
	cmpl  %esi, %ecx
	jb    fillprtable2_loop

/* End generate new PR tables */

	movd  %mm4, %ebp		/* ebp = `test' mask */
	movl  pseudor_start1, %ecx	/* ecx = pointer in PR table 1 */
	movl  pseudor_start2, %esi	/* esi = pointer in PR table 2 */

.align 16

loop:
	movq  (%esi), %mm7		/* get neg pattern from table in mm7 */

	movq  (%eax), %mm2		/* mm2 = data from memory */

	movq  %mm7, (%eax)		/* write neg pattern (in mm7) to mem */

	movq  %mm2, %mm7		/* save read pattern in mm7 for
					   error reporting */
	pcmpeqd (%ecx), %mm2		/* compare on 32-bit basis with table*/
	psrlq %mm3, %mm2		/* shift 16 places to right */
	movd  %mm2, %edx		/* copy to 32-bit register */
	notl  %edx			/* invert check: all 0's = ok */
	test  %edx, %ebp		/* test bits of edx */
	jnz   fault			/* in case of not all 0's: fault! */

nextadr:
	addl  %ebx, %eax		/* address++ for memory and tables */
	addl  $8, %ecx
	addl  $8, %esi

	cmpl  %edi, %eax		/* End of autonomous range? */
	ja    callupadr			/* yes: call update_adr */

chkendtab:
	cmpl  $0x10000000, %ecx		/* End of table reached? (Mutating) */
	jb    loop			/* no: continue */
	jmp   fillprtable1		/* yes: generate new tables */

callupadr:
	movd  %esi, %mm7		/* Real esi=memstartadr was in mm6, */
	movd  %mm6, %esi		/* backup local esi=tablepntr in mm7 */
	call  update_adr		/* Calculate new addresses */
	movd  %esi, %mm6
	movd  %mm7, %esi
	jnc   chkendtab			/* carry set = end of test */

	ret


/* Error reporting **********************************************************/

fault:
	/* Store error */
	movl  error_p, %edx		/* get pointer to store address */
	cmpl  lasterror_p, %edx		/* skip if all space used */
	jae   errorfull

	movl  $0, (%edx)		/* seq.num of `read' element */
	addl  $4, %edx			/* always 0 here */
	movl  %eax, (%edx)		/* error address */
	addl  $4, %edx
	movq  (%ecx), %mm2		/* expected pattern from table */
	movq  %mm2, (%edx)
	addl  $8, %edx
	movq  %mm7, (%edx)		/* read pattern */
	addl  $8, %edx
	movl  %edx, error_p		/* write back new error_p */

errorfull:
	movl  sub_errorno, %edx		/* increase error count */
	addl  $1, %edx
	movl  %edx, sub_errorno

	/* Continue test */
	jmp   nextadr


/* 
Some data might be needed for local reference. This should be right here
(not in the .data area) to have it cached like the program itself. 

test_data:
	.fill 12
*/

endtest:
	nop


