/* This file is part of MemMXtest
 * Copyright (C) 1999, 2000  J.A. Bezemer
 * This program is licensed under the GNU General Public License,
 * see the top-level README file for details.
 */

/* Test address updating

   This file is not compiled by default. Compile with

   make update_adr_test

   Writes to /tmp/update_adr_test.out. View that file with

   ndisasm -o 0x0 -u update_adr_test.out | less

 */

#include "defines.h"
#include "mtest.h"
#include "tests.h"
#include <stdio.h>
#include <string.h>

/* Prototypes */
unsigned long bitrange32 (int start, int end);

unsigned long proc2mem (unsigned long procadr, adrbitmap_t adrbitmap);

unsigned long mem2proc (unsigned long memadr, adrbitmap_t adrbitmap);

adrcode_t adrcode;

adrbitmap_t adrbitmap_fastx =
{
  5, 3, 4, 0, 1, 2, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

adrbitmap_t adrbitmap_fasty =
{
  0, 1, 5, 3, 4, 2, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

adrbitmap_t adrbitmap_fastxileave =
{
  3, 4, 5, 0, 1, 2, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

adrbitmap_t adrbitmap_skip3test =
{
#define ORIGINAL
#ifdef ORIGINAL
  3, 5, 6, 4, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
#else
  3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
  30, 31, 32, 33, 34
#endif
};


void
main (void)
{
  unsigned long l;
  FILE *outfile;

  l = 0x9;
  printf ("fast-x  proc-adr=0x%lx -> mem-adr=0x%lx (should be 0xa)\n",
	  l, proc2mem (l, adrbitmap_fastx));
  l = 0x32;
  printf ("fast-x  proc-adr=0x%lx -> mem-adr=0x%lx (should be 0x15)\n",
	  l, proc2mem (l, adrbitmap_fastx));
  l = 0x109;
  printf ("fast-x  proc-adr=0x%lx -> mem-adr=0x%lx (should be 0x10a)\n",
	  l, proc2mem (l, adrbitmap_fastx));
  l = 0x0d;
  printf ("fast-y  proc-adr=0x%lx -> mem-adr=0x%lx (should be 0x29)\n",
	  l, proc2mem (l, adrbitmap_fasty));
  l = 0x1234561e;
  printf ("fast-xileave  proc-adr=0x%lx -> mem-adr=0x%lx (should be 0x12345633)\n",
	  l, proc2mem (l, adrbitmap_fastxileave));
  l = 0x168;
  printf ("fast-skip3test  proc-adr=0x%lx -> mem-adr=0x%lx (should be 0x27)\n",
	  l, proc2mem (l, adrbitmap_skip3test));

  printf ("\n");

  l = 0x9;
  printf ("fast-x  mem-adr=0x%lx -> proc-adr=0x%lx (should be 0x21)\n",
	  l, mem2proc (l, adrbitmap_fastx));
  l = 0xabcdef15;
  printf ("fast-y  mem-adr=0x%lx -> proc-adr=0x%lx (should be 0xabcdef31)\n",
	  l, mem2proc (l, adrbitmap_fasty));
  l = 0x23;
  printf ("fast-xileave  mem-adr=0x%lx -> proc-adr=0x%lx (should be 0x1c)\n",
	  l, mem2proc (l, adrbitmap_fastxileave));
  l = 0x28;
  printf ("fast-skip3test  mem-adr=0x%lx -> proc-adr=0x%lx (should be 0x110)\n",
	  l, mem2proc (l, adrbitmap_skip3test));

  printf ("\n");
  printf ("Bitrange 0-31: 0x%lx\n", bitrange32 (0, 31));
  printf ("Bitrange 1-1: 0x%lx\n", bitrange32 (1, 1));
  printf ("Bitrange 10-0: 0x%lx\n", bitrange32 (10, 0));
  printf ("Bitrange 6-9: 0x%lx\n", bitrange32 (6, 9));

  printf ("\n");
  outfile = fopen ("/tmp/update_adr_test.out", "wb");

  printf ("Writing up-code for fast-x (with allowranges=0)\n");
  memset (adrcode, 0x90, sizeof (adrcode));
  prepare_update_adr_up (adrbitmap_fastx, 0x09, 0x32, 0, adrcode);
  fwrite (adrcode, sizeof (adrcode), 1, outfile);

  printf ("Writing up-code for fast-x (with allowranges=1)\n");
  memset (adrcode, 0x90, sizeof (adrcode));
  prepare_update_adr_up (adrbitmap_fastx, 0x09, 0x32, 1, adrcode);
  fwrite (adrcode, sizeof (adrcode), 1, outfile);

  printf ("Writing up-code for skip3test (with allowranges=0)\n");
  memset (adrcode, 0x90, sizeof (adrcode));
  prepare_update_adr_up (adrbitmap_skip3test, 0x168, 0x110, 0, adrcode);
  fwrite (adrcode, sizeof (adrcode), 1, outfile);

  printf ("Writing up-code for skip3test (with allowranges=1)\n");
  memset (adrcode, 0x90, sizeof (adrcode));
  prepare_update_adr_up (adrbitmap_skip3test, 0x168, 0x110, 1, adrcode);
  fwrite (adrcode, sizeof (adrcode), 1, outfile);

  printf ("Writing down-code for fast-x (with allowranges=0)\n");
  memset (adrcode, 0x90, sizeof (adrcode));
  prepare_update_adr_dn (adrbitmap_fastx, 0x32, 0x09, 0, adrcode);
  fwrite (adrcode, sizeof (adrcode), 1, outfile);

  printf ("Writing down-code for fast-x (with allowranges=1)\n");
  memset (adrcode, 0x90, sizeof (adrcode));
  prepare_update_adr_dn (adrbitmap_fastx, 0x32, 0x09, 1, adrcode);
  fwrite (adrcode, sizeof (adrcode), 1, outfile);

  printf ("\nmd5sum /tmp/update_adr_test.out should be\n"
	  "af5bd06280b853536e50b1fec7408eda\n");

  fclose (outfile);
}
