#include "hx_types.h"
#include "hxlib.h"
#include "screen.h"
#include "htlc.h"
#include <stdlib.h>
#include "hx.h"
#include "dhargs.h"
#include <netinet/in.h>

void rcv_kick_complete (void);
void rcv_user_info (void);
int cmd_kick (int argc, char *const *argv);
int cmd_info (int argc, char *const *argv);

void
rcv_kick_complete (void)
{
	curscr_printf("\n <\xa5> kick successful");
}

int
cmd_kick (int argc, char *const *argv)
{
	u_int32_t sock;
	register int i, ban = 0;

	if (argc < 2) {
		curscr_printf("\nusage: %s [-b] {sock|nick}", argv[0]);
		return 0;
	}
	for (i = 1; i < argc; i++)
		if (argv[i][0] == '-' && argv[i][1] == 'b')
			ban = i;
	for (i = 1; i < argc; i++) {
		if (i == ban)
			continue;
		if (!(sock = atou32(argv[i])) &&
			!(sock = sock_lookup_nick(argv[i], (u_int8_t)strlen(argv[i])))) {
				curscr_printf("\n%s: %s: no such nick", argv[0], argv[i]);
				continue;
		}
		task_new(hx_trans, (task_fn_t)rcv_kick_complete, 0, 0);
		if (!ban)
			htlc_snd_user_kick(sock);
		else
			htlc_snd_user_kickban(sock);
	}

	return 0;
}

void
rcv_user_info (void)
{
	u_int16_t ilen = 0;
	u_int8_t info[0xffff], nick[32], nlen = 0;

	nick[0] = 0;
	dh_start(&(hx_buf[SIZEOF_HX_HDR]), hx_pos - SIZEOF_HX_HDR)
		switch (ntohs(dh->type)) {
			case HTLS_DATA_USER_INFO:
				ilen = ntohs(dh->len);
				memcpy(info, dh->data, ilen);
				break;
			case HTLS_DATA_NICK:
				nlen = ntohs(dh->len) > 31 ? 31 : ntohs(dh->len);
				memcpy(nick, dh->data, nlen);
				break;
		}
	dh_end()
	if (ilen) {
		CR2LF(info, ilen)
		curscr_printf("\n[info: %.*s]\n%.*s", nlen, nick, ilen, info);
	}
}

int
cmd_info (int argc, char *const *argv)
{
	u_int32_t sock;

	if (argc < 2) {
		curscr_printf("\nusage: %s {sock|nick}", argv[0]);
		return 0;
	}
	if (!(sock = atou32(argv[1])) &&
		!(sock = sock_lookup_nick(argv[1], (u_int8_t)strlen(argv[1])))) {
			curscr_printf("\n%s: %s: no such nick", argv[0], argv[1]);
			return 0;
	}
	task_new(hx_trans, (task_fn_t)rcv_user_info, 0, 0);
	htlc_snd_user_getinfo(sock);

	return 0;
}
