#include "hx_types.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "hxlib.h"
#include "screen.h"
#include "htlc.h"
#include "xmalloc.h"

void rcv_msg_complete (void);
int cmd_msg (int argc, char *const *argv, char *str);
int cmd_me (int argc, char *const *argv, char *str);

void
rcv_msg_complete (void)
{
	curscr_printf("\n <\xa5> msg sent");
}

int
cmd_msg (int argc, char *const *argv, char *str)
{
	u_int32_t sock;
	u_int8_t nlen;
	char *p;

	if (argc < 3) {
		curscr_printf("\nusage: %s {sock|nick} <msg>", argv[0]);
		return 0;
	}
	nlen = strlen(argv[1]);
	if (!(sock = atou32(argv[1])) &&
		!(sock = sock_lookup_nick(argv[1], nlen))) {
			curscr_printf("\n%s: %s: no such nick", argv[0], argv[1]);
			return 0;
	}
	curscr->history.msg = xrealloc(curscr->history.msg, 9 + nlen);
	sprintf(curscr->history.msg, "/msg '%s' ", argv[1]);
	if (!(p = strstr(str, argv[2]))) {
		curscr_printf("\n%s: did not find '%s' in '%s'", argv[0], argv[1], str);
		return -1;
	}
	task_new(hx_trans, (task_fn_t)rcv_msg_complete, 0, 0);
	htlc_snd_msg(sock, p, (u_int16_t)strlen(p));

	return 0;
}

int
cmd_me (int argc, char *const *argv, char *str)
{
	char *p;

	if (argc < 2) {
		curscr_printf("\nusage: %s <chat>", argv[0]);
		return 0;
	}
	if (!(p = strstr(str, argv[1]))) {
		curscr_printf("\n%s: did not find '%s' in '%s'", argv[0], argv[1], str);
		return -1;
	}
	if (!curchat)
		htlc_snd_chat_action(p, (u_int16_t)strlen(p));
	else
		htlc_snd_chat_chat_action(curchat->ref, p, (u_int16_t)strlen(p));

	return 0;
}
