#include "hx_types.h"
#include "hxlib.h"
#include "htlc.h"
#include "dhargs.h"
#include "hx.h"
#include "term.h"
#include "screen.h"
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <netinet/in.h>
#include <errno.h>
#include "xmalloc.h"

#ifdef __BEOS__
#include <kernel/OS.h>
extern thread_id input_threadid;
#endif

static char *news_buf = 0;
static unsigned int news_len = 0, getting_news = 0;

int cmd_post (int argc, char *const *argv, const char *str);
int cmd_news (void);

int
cmd_post (int argc, char *const *argv, const char *str)
{
	register char *p;

	if (argc < 2) {
		curscr_printf("\nusage: %s <post>", argv[0]);
		return 0;
	}
	if (!(p = strstr(str, argv[1]))) {
		curscr_printf("\n%s: did not find '%s' in '%s'", argv[0], argv[1], str);
		return -1;
	}
	task_new(hx_trans, 0, 0, 0);
	htlc_snd_news_post(p, (u_int16_t)strlen(p));

	return 0;
}

int
cmd_news (void)
{
	char buf[0xff], prev[0xff] = "\0";
	register char *p, *p2;

	if (!news_len) {
		if (hx_sock >= 0 && !getting_news) {
			task_new(hx_trans, rcv_news_file, 0, (void *)1);
			htlc_snd_news_getfile();
			getting_news = 1;
		}
		return 1;
	}
#ifdef __BEOS__
	if (input_threadid != find_thread(0))
		suspend_thread(input_threadid);
#endif
	p = news_buf;
	term_goto_line(curscr->li);
	while ((p2 = strchr(p, '\n'))) {
		term_puts("\n", 1);
		term_puts(p, p2 - p);
		if (read(0, buf, 1) <= 0 || buf[0] == 'q')
			break;
		if (buf[0] == '/') {
			unsigned char i = 0;
			write(1, "/", 1);
			while (read(0, &(buf[i]), 1) > 0 && buf[i] != '\n') {
				if ((buf[i] == '\10' || buf[i] == '\177') && i) {
					buf[--i] = 0;
					write(1, "\b", 1);
				} else
					write(1, &(buf[i++]), 1);
			}
			buf[i] = 0;
			if (!i && *prev)
				strcpy(buf, prev);
			else
				strcpy(prev, buf);
			if ((p = strstr(p2, buf)))
				continue;
		}
		p = &(p2[1]);
	}
	term_goto_line(LI);
#ifdef __BEOS__
	if (input_threadid != find_thread(0))
		resume_thread(input_threadid);
#endif

	return 0;
}

void
rcv_news_file (void *do_cmd_news)
{
	getting_news = 0;
	dh_start(&(hx_buf[SIZEOF_HX_HDR]), hx_pos - SIZEOF_HX_HDR)
		if (ntohs(dh->type) == HTLS_DATA_NEWS) {
			news_len = (unsigned int)ntohs(dh->len);
			news_buf = xrealloc(news_buf, news_len + 1);
			memcpy(news_buf, dh->data, news_len);
			news_buf[news_len] = 0;
			CR2LF(news_buf, news_len);
		}
	dh_end()
	if (do_cmd_news)
		cmd_news();
}

void
rcv_news_post (void)
{
	dh_start(&(hx_buf[SIZEOF_HX_HDR]), hx_pos - SIZEOF_HX_HDR)
		if (ntohs(dh->type) == HTLS_DATA_NEWS) {
			news_len += (unsigned int)ntohs(dh->len);
			news_buf = xrealloc(news_buf, news_len + 1);
			memmove(&(news_buf[ntohs(dh->len)]), news_buf, news_len - ntohs(dh->len));
			memcpy(news_buf, dh->data, ntohs(dh->len));
			news_buf[news_len] = 0;
			CR2LF(news_buf, ntohs(dh->len));
			curscr_printf("\n[news posted]");
		}
	dh_end()
	hx_reset();
}

void
news_kill (void)
{
	xfree(news_buf);
	news_buf = 0;
	news_len = 0;
	getting_news = 0;
}
