#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>
#include <stdio.h>

#include "log.h"
#include "script.h"

extern iac_server_configuration_t iac_cfg;

#ifdef HAVE_SCRIPTS
int
iac_script_check_nick ( const char *nick )
{
    iac_script_t *s;

    for ( s = iac_cfg.scripts; s; s = s->next )
    {
        if ( !rl_stricmp ( s->nick, nick ) )
        {
            return 1;
        }
    }

    return 0;
}


void
iac_script_call ( iac_client_conn_t *c, iac_script_t *script, char *args )
{
    pid_t pid;
    char *parg[256], *s;
    int i;

    /*
     * XXX: check arguments with char_regex
     */

    memset ( parg, 0, sizeof(parg) );

    parg[0] = script->cmd;
    parg[1] = c->nick;
    parg[2] = args;

    for (s = args, i = 3; i < 255; i++)
    {
        s = strchr ( s, ' ' );

        if ( s )
        {
            *s = '\0';
            s++;
            parg[i] = s;
        }
        else
            break;
    }

    parg[i] = NULL;

    c->script = script;

    pipe ( c->pipe );


    pid = fork();

    if ( pid < 0 )
    {
        iac_log ( IAC_ERR, "[EEE] Unable to fork: %s\n", strerror(errno) );
    }

    if ( pid )
    {
        /*
         * parent, return
         */

        c->child_pid = pid;

        return;
    }

    /*
     * child
     */
    close ( 0 );
    dup2(c->pipe[1], 0 );

    close ( 1 );
    dup2(c->pipe[1], 1 );

    close ( 2 ) ;
    dup2(c->pipe[1], 2 );

    if ( execve ( script->cmd, parg, NULL  ) < 0 )
        iac_log ( IAC_WARN, "[WWW] execl failed: %s\n", strerror(errno));

    /*
     * this is only needed in case execve fails
     */
    _exit ( 0 );
}

#endif
