'\" t
.TH c3270 1 "09 April 2005"
.SH "NAME"
c3270 \-
curses-based 
\s-1IBM\s+1 host access tool
.SH "SYNOPSIS"
\fBc3270\fP
[\fIoptions\fP]
[\fIhost\fP]

.SH "DESCRIPTION"
\fBc3270\fP opens
a telnet connection to an \s-1IBM\s+1
host in a console window.
It implements RFCs 2355 (TN3270E), 1576 (TN3270) and 1646 (LU name selection),
and supports IND$FILE file transfer.
If the console is capable of displaying colors, then \fBc3270\fP emulates an
\s-1IBM\s+1 3279.  Otherwise, it emulates a 3278.
.LP
The full syntax for \fIhost\fP is:
.RS
[\fIprefix\fP:]...[\fILUname\fP@]\fIhostname\fP[:\fIport\fP]
.RE
.LP
Prepending a \fBP:\fP onto \fIhostname\fP causes the connection to go
through the \fItelnet-passthru\fP service rather than directly to the host.
See \s-1PASSTHRU\s+1 below.
.LP
Prepending an \fBS:\fP onto \fIhostname\fP removes the "extended data
stream" option reported to the host.
See \fB\-tn\fP below for further information.
.LP
Prepending an \fBN:\fP onto \fIhostname\fP
turns off TN3270E support for the session.
.LP
Prepending an \fBL:\fP onto \fIhostname\fP
causes \fBc3270\fP to first create an SSL tunnel to the host, and then
create a TN3270 session inside the tunnel.  (This function is supported only if
\fBc3270\fP was built with SSL/TLS support).
Note that TLS-encrypted sessions using the TELNET START-TLS option are
negotiated with the host automatically; for these sessions the \fBL:\fP prefix
should not be used.
.LP
A specific LU name to use may be specified by prepending it to the
\fIhostname\fP with an `\fB@\fP'.
Multiple LU names to try can be separated by commas.
An empty LU can be placed in the list with an extra comma.
.LP
The \fIhostname\fP may optionally be placed inside square-bracket
characters `\fB[\fP' and `\fB]\fP'.
This will prevent any colon `\fB:\fP' characters in the hostname
from being interpreted as indicating option prefixes or port numbers.
This allows numeric IPv6 addresses to be used as hostnames.
.LP
On systems that support the \fIforkpty\fP library call, the
\fIhostname\fP may be replaced with \fB\-e\fP and a command string.
This will cause \fBc3270\fP to connect to a local child process, such as
a shell.
.LP
The port to connect to defaults to
\fBtelnet\fP.
This can be overridden with the \fB\-port\fP option, or by appending
a \fIport\fP to the \fIhostname\fP with a colon
`\fB:\fP'.
(For compatability with previous versions of \fBc3270\fP
and with \fItn3270\fP(1), the \fIport\fP
may also be specified as a second, separate argument.)
.SH "OPTIONS"
 \fBc3270\fP understands
the following options:
.TP
\fB\-allbold\fP
Forces all characters to be displayed in bold.
This helps with PC consoles which display non-bold characters in unreadably
dim colors.
.TP
\fB\-altscreen \fIrows\fP\fBx\fP\fIcols\fP\fB=\fP\fIinit_string\fP\fP
Defines the dimensions and escape sequence for the alternate (132-column)
screen mode.
See \s-1SCREEN SIZE SWITCHING\s+1, below.
.TP
\fB\-cbreak\fP
Causes \fBc3270\fP to operate in \fIcbreak\fP mode, instead of \fIraw\fP
mode.
In \fIcbreak\fP mode, the TTY driver will properly process XOFF and XON
characters, which are required by some terminals for proper operation.
However, those characters (usually ^S and ^Q), as well as the characters for
\fBinterrupt\fP, \fBquit\fP, and \fBlnext\fP (usually ^C, ^\\
and ^V respectively) will be seen by \fBc3270\fP only if preceded by
the \fBlnext\fP character.
The \fBsusp\fP character (usually ^Z) cannot be seen by \fBc3270\fP at all.
.TP
\fB\-charset\fP \fIname\fP
Specifies an \s-1EBCDIC\s+1 host character set.
See \s-1CHARACTER SETS\s+1 below.
.TP
\fB\-clear\fP \fItoggle\fP
Sets the initial value of \fItoggle\fP to \fBfalse\fP.
The list of toggle names is under \s-1TOGGLES\s+1
below.
.TP
\fB\-defscreen \fIrows\fP\fBx\fP\fIcols\fP\fB=\fP\fIinit_string\fP\fP
Defines the dimensions and escape sequence for the default (80-column)
screen mode.
See \s-1SCREEN SIZE SWITCHING\s+1, below.
.TP
\fB\-hostsfile\fP \fIfile\fP
Uses \fIfile\fP as the hosts file, which allows aliases for host names and
scripts to be executed at login.
See \fIibm_hosts\fP(1) for details.
.TP
\fB\-im\fP \fImethod\fP
Specifies the name of the input method to use for multi-byte input.
(Supported only when c3270 is compiled with DBCS support.)
.TP
\fB\-keymap\fP \fIname\fP
Specifies a keyboard map to be found in the resource
\fBc3270.keymap.\fP\fIname\fP or the file \fIname\fP.
See \s-1KEYMAPS\s+1 below for details.
.TP
\fB\-km\fP \fIname\fP
Specifies the local encoding method for multi-byte text.
\fIname\fP is an encoding name recognized by the ICU library.
(Supported only when c3270 is compiled with DBCS support, and necessary
only when c3270 cannot figure it out from the locale.)
.TP
\fB\-model\fP \fIname\fP
The model of 3270 display to be emulated.
The model name is in two parts, either of which may be omitted:
.IP
The first part is the
\fBbase model\fP,
which is either \fB3278\fP or \fB3279\fP.
\fB3278\fP specifies a monochrome 3270 display;
\fB3279\fP specifies a color 3270 display.
.IP
The second part is the
\fBmodel number\fP,
which specifies the number of rows and columns.
Model 4 is the default.
.PP
.TS
center;
c c c .
T{
.na
.nh
Model Number
T}	T{
.na
.nh
Columns
T}	T{
.na
.nh
Rows
T}
_
T{
.na
.nh
2
T}	T{
.na
.nh
80
T}	T{
.na
.nh
24
T}
T{
.na
.nh
3
T}	T{
.na
.nh
80
T}	T{
.na
.nh
30
T}
T{
.na
.nh
4
T}	T{
.na
.nh
80
T}	T{
.na
.nh
43
T}
T{
.na
.nh
5
T}	T{
.na
.nh
132
T}	T{
.na
.nh
27
T}
.TE
.IP
Note: Technically, there is no such 3270 display as a 3279-4 or 3279-5, but
most hosts seem to work with them anyway.
.IP
The default model
for a color display is \fB3279\-4\fP.
For a monochrome display, it is \fB3278\-4\fP.
.TP
\fB\-mono\fP
Forces 3278 emulation.
.TP
\fB\-oversize\fP \fIcols\fP\fBx\fP\fIrows\fP
Makes the screen larger than the default for the chosen model number.
This option has effect only in combination with extended data stream support
(controlled by the "c3270.extended" resource), and only if the host
supports the Query Reply structured field.
The number of columns multiplied by the number of rows must not exceed
16383 (3fff hex), the limit of 14-bit 3270 buffer addressing.
.TP
\fB\-port\fP \fIn\fP
Specifies a different \s-1TCP\s+1 port to connect to.
\fIn\fP can be a name from \fB/etc/services\fP like \fBtelnet\fP, or a
number.
This option changes the default port number used for all connections.
(The positional parameter affects only the initial connection.)
.TP
\fB\-printerlu \fIluname\fP\fP
Causes \fBc3270\fP to automatically start a \fIpr3287\fP printer
session.
If \fIluname\fP is ".", then the printer session will be associated with the
interactive terminal session (this requires that the host support TN3270E).
Otherwise, the value is used as the explicit LU name to associate with the
printer session.
.TP
\fB\-secure\fP
Disables the interactive \fBc3270>\fP prompt.
When used, a hostname must be provided on the command line.
.TP
\fB\-set\fP \fItoggle\fP
Sets the initial value of \fItoggle\fP to \fBtrue\fP.
The list of toggle names is under \s-1TOGGLES\s+1
below.
.TP
\fB\-tn\fP \fIname\fP
Specifies the terminal name to be transmitted over the telnet connection.
The default name is
\fBIBM\-\fP\fImodel_name\fP\fB\-E\fP,
for example,
\fBIBM\-3279\-4\-E\fP 
for a color display, or
\fBIBM\-3278\-4\-E\fP
for a monochrome display.
.IP
Some hosts are confused by the \fB\-E\fP
suffix on the terminal name, and will ignore the extra screen area on
models 3, 4 and 5.
Prepending an \fBs:\fP on the hostname, or setting the "c3270.extended"
resource to "false", removes the \fB\-E\fP
from the terminal name when connecting to such hosts.
.IP
The name can also be specified with the "c3270.termName" resource.
.TP
\fB\-trace\fP
Turns on data stream and event tracing at startup.
The default trace file name is
\fB/tmp/x3trc.\fP\fIprocess_id\fP.
.TP
\fB\-tracefile\fP \fIfile\fP
Specifies a file to save data stream and event traces into, overriding the
default of
\fB/tmp/x3trc.\fP\fIprocess_id\fP.
.TP
\fB\-tracefilesize\fP \fIsize\fP
Places a limit on the size of a trace file.
If this option is not specified, or is specified as \fB0\fP or \fBnone\fP,
the trace file will be unlimited.
If specified, the trace file cannot already exist, and the (silently enforced)
minimum size is 64 Kbytes.
The value of \fIsize\fP can have a \fBK\fP or \fBM\fP suffix, indicating
kilobytes or megabytes respectively.
.TP
\fB\-xrm\fP "c3270.\fIresource\fP: \fIvalue\fP"
Sets the value of the named \fIresource\fP to \fIvalue\fP.
Resources control less common \fBc3270\fP
options, and are defined under \s-1RESOURCES\s+1 below.
.SH "CHARACTER SETS"
The \fB\-charset\fP
option or the "c3270.charset" resource controls the \s-1EBCDIC\s+1
host character set used by \fBc3270\fP.
Available sets include:
.PP
.TS
center;
l l l
lfB l l.
T{
.na
.nh
Charset Name
T}	T{
.na
.nh
Code Page
T}	T{
.na
.nh
Display Character Sets
T}
_
T{
.na
.nh
apl
T}	T{
.na
.nh
37
T}	T{
.na
.nh
3270cg-1a
T}
T{
.na
.nh
belgian
T}	T{
.na
.nh
500
T}	T{
.na
.nh
3270cg-1a 3270-cg1 iso8859-1
T}
T{
.na
.nh
bracket
T}	T{
.na
.nh
37
T}	T{
.na
.nh
3270cg-1a 3270-cg1 iso8859-1
T}
T{
.na
.nh
brazilian
T}	T{
.na
.nh
275
T}	T{
.na
.nh
3270cg-1a 3270-cg1 iso8859-1
T}
T{
.na
.nh
finnish
T}	T{
.na
.nh
278
T}	T{
.na
.nh
3270cg-1a 3270-cg1 iso8859-1
T}
T{
.na
.nh
french
T}	T{
.na
.nh
297
T}	T{
.na
.nh
3270cg-1a 3270-cg1 iso8859-1
T}
T{
.na
.nh
german
T}	T{
.na
.nh
273
T}	T{
.na
.nh
3270cg-1a 3270-cg1 iso8859-1
T}
T{
.na
.nh
icelandic
T}	T{
.na
.nh
871
T}	T{
.na
.nh
3270cg-1a 3270-cg1 iso8859-1
T}
T{
.na
.nh
iso-hebrew
T}	T{
.na
.nh
424
T}	T{
.na
.nh
iso8859-8
T}
T{
.na
.nh
iso-turkish
T}	T{
.na
.nh
1026
T}	T{
.na
.nh
iso8859-9
T}
T{
.na
.nh
italian
T}	T{
.na
.nh
280
T}	T{
.na
.nh
3270cg-1a 3270-cg1 iso8859-1
T}
T{
.na
.nh
japanese
T}	T{
.na
.nh
1027+300
T}	T{
.na
.nh
jisx0201.1976-0 + jisx0208.1983-0
T}
T{
.na
.nh
norwegian
T}	T{
.na
.nh
277
T}	T{
.na
.nh
3270cg-1a 3270-cg1 iso8859-1
T}
T{
.na
.nh
russian
T}	T{
.na
.nh
880
T}	T{
.na
.nh
koi8-r
T}
T{
.na
.nh
simplified-chinese
T}	T{
.na
.nh
836+837
T}	T{
.na
.nh
3270cg-1a iso8859-1 + gb2312.1980-0
T}
T{
.na
.nh
slovenian
T}	T{
.na
.nh
870
T}	T{
.na
.nh
iso8859-2
T}
T{
.na
.nh
thai
T}	T{
.na
.nh
838
T}	T{
.na
.nh
iso8859-11 tis620.2529-0
T}
T{
.na
.nh
uk
T}	T{
.na
.nh
285
T}	T{
.na
.nh
3270cg-1a 3270-cg1 iso8859-1
T}
T{
.na
.nh
us-intl
T}	T{
.na
.nh
37
T}	T{
.na
.nh
3270cg-1a 3270-cg1 iso8859-1
T}
.TE
.PP
The default character set is
\fBbracket\fP,
which is useful for common \s-1IBM\s+1 hosts which use \s-1EBCDIC\s+1
codes 0xAD and 0xBD for the `[' and `]' characters,
respectively.
.SH "HOSTS DATABASE"
\fBc3270\fP uses the \fIibm_hosts\fP database to
define aliases for host names, and to specify
macros to be executed when a connection is first made.
See \fIibm_hosts\fP(5) for details.
.LP
You may specify a different \fIibm_hosts\fP
database with the "c3270.hostsFile" resource.
.SH "NVT (ANSI) MODE"
Some hosts use an \s-1ASCII\s+1 front-end to do initial login negotiation,
then later switch to 3270 mode.
\fBc3270\fP will emulate an \s-1ANSI\s+1 X.64 terminal until the host
places it in 3270 mode (telnet \s-1BINARY\s+1 and \s-1SEND EOR\s+1 modes, or
\s-1TN3270E\s+1 mode negotiation).
.PP
If the host later negotiates to stop functioning in 3270 mode,
\fBc3270\fP will return to \s-1ANSI\s+1 emulation.
.PP
In \s-1NVT\s+1 mode, \fBc3270\fP
supports both character-at-a-time mode and line mode operation.
You may select the mode with a menu option.
When in line mode, the special characters and operational characteristics are
defined by resources:
.PP
.TS
center;
l c c.
T{
.na
.nh
Mode/Character
T}	T{
.na
.nh
Resource
T}	T{
.na
.nh
Default
T}
_
T{
.na
.nh
Translate CR to NL
T}	T{
.na
.nh
c3270.icrnl
T}	T{
.na
.nh
true
T}
T{
.na
.nh
Translate NL to CR
T}	T{
.na
.nh
c3270.inlcr
T}	T{
.na
.nh
false
T}
T{
.na
.nh
Erase previous character
T}	T{
.na
.nh
c3270.erase
T}	T{
.na
.nh
^?
T}
T{
.na
.nh
Erase entire line
T}	T{
.na
.nh
c3270.kill
T}	T{
.na
.nh
^U
T}
T{
.na
.nh
Erase previous word
T}	T{
.na
.nh
c3270.werase
T}	T{
.na
.nh
^W
T}
T{
.na
.nh
Redisplay line
T}	T{
.na
.nh
c3270.rprnt
T}	T{
.na
.nh
^R
T}
T{
.na
.nh
Ignore special meaning of next character
T}	T{
.na
.nh
c3270.lnext
T}	T{
.na
.nh
^V
T}
T{
.na
.nh
Interrupt
T}	T{
.na
.nh
c3270.intr
T}	T{
.na
.nh
^C
T}
T{
.na
.nh
Quit
T}	T{
.na
.nh
c3270.quit
T}	T{
.na
.nh
^\e
T}
T{
.na
.nh
End of file
T}	T{
.na
.nh
c3270.eof
T}	T{
.na
.nh
^D
T}
.TE
.LP
Separate keymaps can be defined for use only when \fBc3270\fP is in
3270 mode or \s-1NVT\s+1 mode.
See \s-1KEYMAPS\s+1 for details.
.SH "TOGGLES"
\fBc3270\fP has a number of configurable modes which may be selected by
the \fB\-set\fP and \fB\-clear\fP options.
.TP
\fBmonoCase\fP
If set, \fBc3270\fP operates in uppercase-only mode.
.TP
\fBblankFill\fP
If set, \fBc3270\fP behaves in some un-3270-like ways.
First, when a character is typed into a field, all nulls in the field to the
left of that character are changed to blanks.
This eliminates a common 3270 data-entry surprise.
Second, in insert mode, trailing blanks in a field are treated like nulls,
eliminating the annoying `lock-up' that often occurs when inserting
into an field with (apparent) space at the end.
.TP
\fBlineWrap\fP
If set, the \s-1ANSI\s+1 terminal emulator automatically assumes
a \s-1NEWLINE\s+1 character when it reaches the end of a line.
.LP
The names of the toggles for use with the \fB\-set\fP
and \fB\-clear\fP
options are as follows:
.LP
.TS
center;
l l .
T{
.na
.nh
Option
T}	T{
.na
.nh
Name
T}
_
T{
.na
.nh
Monocase
T}	T{
.na
.nh
monoCase
T}
T{
.na
.nh
Blank Fill
T}	T{
.na
.nh
blankFill
T}
T{
.na
.nh
Track Cursor
T}	T{
.na
.nh
cursorPos
T}
T{
.na
.nh
Trace Data Stream
T}	T{
.na
.nh
dsTrace
T}
T{
.na
.nh
Trace Events
T}	T{
.na
.nh
eventTrace
T}
T{
.na
.nh
Save Screen(s) in File
T}	T{
.na
.nh
screenTrace
T}
T{
.na
.nh
Wraparound
T}	T{
.na
.nh
lineWrap
T}
.TE
.LP
These names are also used as the first parameter to the \fBToggle\fP
action.
.SH "STATUS LINE"
If the terminal that \fBc3270\fP is running on
has at least one more row that the 3270 model requires (e.g., 25 rows for a
model 2), \fBc3270\fP will display a status line.
The \fBc3270\fP status line contains a variety of information.
From left to right, the fields are:
.TP
\fBcomm status\fP
Three symbols indicate the state of the connection to the host.
If connected, the right-hand symbol is a solid box; if not, it is a
question mark.
.TP
\fBkeyboard lock\fP
If the keyboard is locked, an "X" symbol and a message field indicate the
reason for the keyboard lock.
.TP
\fBtypeahead\fP
The letter "T" indicates that one or more keystrokes are in the typeahead
buffer.
.TP
\fBtemporary keymap\fP
The letter "K" indicates that a temporary keymap is in effect.
.TP
\fBreverse\fP
The letter "R" indicates that the keyboard is in reverse field entry mode.
.TP
\fBinsert mode\fP
The 
letter "I" indicates that the keyboard is in insert mode.
.TP
\fBprinter session\fP
The letter "P" indicates that a \fIpr3287\fP session is active.
.TP
\fBLU name\fP
The LU name associated with the session, if there is one.
.TP
\fBcursor position\fP
The cursor row and column are optionally displayed, separated by a "/".
.SH "ACTIONS"
Here is a complete list of basic c3270 actions.
Script-specific actions are described on the
\fIx3270-script\fP(1) manual page.
.PP
Actions marked with an asterisk (*) may block, sending data to the host and
possibly waiting for a response.
.PP
.TS
center; lw(3i) lw(3i).
T{
.na
.nh
.in +2
.ti -2
*Attn
T}	T{
.na
.nh
attention key
T}
T{
.na
.nh
.in +2
.ti -2
BackSpace
T}	T{
.na
.nh
move cursor left (or send \s-1ASCII BS\s+1)
T}
T{
.na
.nh
.in +2
.ti -2
BackTab
T}	T{
.na
.nh
tab to start of previous input field
T}
T{
.na
.nh
.in +2
.ti -2
CircumNot
T}	T{
.na
.nh
input "^" in \s-1NVT\s+1 mode, or "notsign" in 3270 mode
T}
T{
.na
.nh
.in +2
.ti -2
*Clear
T}	T{
.na
.nh
clear screen
T}
T{
.na
.nh
.in +2
.ti -2
Compose
T}	T{
.na
.nh
next two keys form a special symbol
T}
T{
.na
.nh
.in +2
.ti -2
*Connect(\fIhost\fP)
T}	T{
.na
.nh
connect to \fIhost\fP
T}
T{
.na
.nh
.in +2
.ti -2
*CursorSelect
T}	T{
.na
.nh
Cursor Select \s-1AID\s+1
T}
T{
.na
.nh
.in +2
.ti -2
Delete
T}	T{
.na
.nh
delete character under cursor (or send \s-1ASCII DEL\s+1)
T}
T{
.na
.nh
.in +2
.ti -2
DeleteField
T}	T{
.na
.nh
delete the entire field
T}
T{
.na
.nh
.in +2
.ti -2
DeleteWord
T}	T{
.na
.nh
delete the current or previous word
T}
T{
.na
.nh
.in +2
.ti -2
*Disconnect
T}	T{
.na
.nh
disconnect from host
T}
T{
.na
.nh
.in +2
.ti -2
Down
T}	T{
.na
.nh
move cursor down
T}
T{
.na
.nh
.in +2
.ti -2
Dup
T}	T{
.na
.nh
duplicate field
T}
T{
.na
.nh
.in +2
.ti -2
*Enter
T}	T{
.na
.nh
Enter \s-1AID\s+1 (or send \s-1ASCII CR\s+1)
T}
T{
.na
.nh
.in +2
.ti -2
Erase
T}	T{
.na
.nh
erase previous character (or send \s-1ASCII BS\s+1)
T}
T{
.na
.nh
.in +2
.ti -2
EraseEOF
T}	T{
.na
.nh
erase to end of current field
T}
T{
.na
.nh
.in +2
.ti -2
EraseInput
T}	T{
.na
.nh
erase all input fields
T}
T{
.na
.nh
.in +2
.ti -2
Escape
T}	T{
.na
.nh
escape to \fBc3270>\fP prompt
T}
T{
.na
.nh
.in +2
.ti -2
Execute(\fIcmd\fP)
T}	T{
.na
.nh
execute a command in a shell
T}
T{
.na
.nh
.in +2
.ti -2
FieldEnd
T}	T{
.na
.nh
move cursor to end of field
T}
T{
.na
.nh
.in +2
.ti -2
FieldMark
T}	T{
.na
.nh
mark field
T}
T{
.na
.nh
.in +2
.ti -2
HexString(\fIhex_digits\fP)
T}	T{
.na
.nh
insert control-character string
T}
T{
.na
.nh
.in +2
.ti -2
Home
T}	T{
.na
.nh
move cursor to first input field
T}
T{
.na
.nh
.in +2
.ti -2
Insert
T}	T{
.na
.nh
set insert mode
T}
T{
.na
.nh
.in +2
.ti -2
*Interrupt
T}	T{
.na
.nh
send \s-1TELNET IP\s+1 to host
T}
T{
.na
.nh
.in +2
.ti -2
Key(\fIkeysym\fP)
T}	T{
.na
.nh
insert key \fIkeysym\fP
T}
T{
.na
.nh
.in +2
.ti -2
Key(0x\fIxx\fP)
T}	T{
.na
.nh
insert key with \s-1ASCII\s+1 code \fIxx\fP
T}
T{
.na
.nh
.in +2
.ti -2
Left
T}	T{
.na
.nh
move cursor left
T}
T{
.na
.nh
.in +2
.ti -2
Left2
T}	T{
.na
.nh
move cursor left 2 positions
T}
T{
.na
.nh
.in +2
.ti -2
MonoCase
T}	T{
.na
.nh
toggle uppercase-only mode
T}
T{
.na
.nh
.in +2
.ti -2
MoveCursor(\fIrow\fP, \fIcol\fP)
T}	T{
.na
.nh
move cursor to (\fIrow\fP,\fIcol\fP)
T}
T{
.na
.nh
.in +2
.ti -2
Newline
T}	T{
.na
.nh
move cursor to first field on next line (or send \s-1ASCII LF\s+1)
T}
T{
.na
.nh
.in +2
.ti -2
NextWord
T}	T{
.na
.nh
move cursor to next word
T}
T{
.na
.nh
.in +2
.ti -2
*PA(\fIn\fP)
T}	T{
.na
.nh
Program Attention \s-1AID\s+1 (\fIn\fP from 1 to 3)
T}
T{
.na
.nh
.in +2
.ti -2
*PF(\fIn\fP)
T}	T{
.na
.nh
Program Function \s-1AID\s+1 (\fIn\fP from 1 to 24)
T}
T{
.na
.nh
.in +2
.ti -2
PreviousWord
T}	T{
.na
.nh
move cursor to previous word
T}
T{
.na
.nh
.in +2
.ti -2
Printer(Start[,\fIlu\fP]|Stop)
T}	T{
.na
.nh
Start or stop printer session
T}
T{
.na
.nh
.in +2
.ti -2
PrintText(\fIcommand\fP)
T}	T{
.na
.nh
print screen text on printer
T}
T{
.na
.nh
.in +2
.ti -2
Quit
T}	T{
.na
.nh
exit \fBc3270\fP
T}
T{
.na
.nh
.in +2
.ti -2
Redraw
T}	T{
.na
.nh
redraw window
T}
T{
.na
.nh
.in +2
.ti -2
Reset
T}	T{
.na
.nh
reset locked keyboard
T}
T{
.na
.nh
.in +2
.ti -2
Right
T}	T{
.na
.nh
move cursor right
T}
T{
.na
.nh
.in +2
.ti -2
Right2
T}	T{
.na
.nh
move cursor right 2 positions
T}
T{
.na
.nh
.in +2
.ti -2
*Script(\fIcommand\fP[,\fIarg\fP...])
T}	T{
.na
.nh
run a script
T}
T{
.na
.nh
.in +2
.ti -2
*String(\fIstring\fP)
T}	T{
.na
.nh
insert string (simple macro facility)
T}
T{
.na
.nh
.in +2
.ti -2
*SysReq
T}	T{
.na
.nh
System Request \s-1AID\s+1
T}
T{
.na
.nh
.in +2
.ti -2
Tab
T}	T{
.na
.nh
move cursor to next input field
T}
T{
.na
.nh
.in +2
.ti -2
Toggle(\fIoption\fP[,\fIset|clear\fP])
T}	T{
.na
.nh
toggle an option
T}
T{
.na
.nh
.in +2
.ti -2
ToggleInsert
T}	T{
.na
.nh
toggle insert mode
T}
T{
.na
.nh
.in +2
.ti -2
ToggleReverse
T}	T{
.na
.nh
toggle reverse-input mode
T}
T{
.na
.nh
.in +2
.ti -2
*Transfer(\fIoption\fP=\fIvalue\fP...)
T}	T{
.na
.nh
file transfer
T}
T{
.na
.nh
.in +2
.ti -2
Up
T}	T{
.na
.nh
move cursor up
T}
T{
.na
.nh
.in +2
.ti -2
ignore
T}	T{
.na
.nh
do nothing
T}
.TE
.LP
Any of the above actions may be entered at the \fBc3270>\fP prompt;
these commands are also available for use in keymaps
(see \s-1KEYMAPS\s+1).
Command names are case-insensitive.
Parameters can be specified with parentheses and commas, e.g.:
.RS
PF(1)
.RE
or with spaces, e.g.:
.RS
PF 1
.RE
Parameters can be quoted with double-quote characters, to allow spaces,
commas, and parentheses to be used.
.LP
\fBc3270\fP also supports the following interactive commands:
.TP
\fBHelp\fP
Displays a list of available commands.
.TP
\fBShow\fP
Displays statistics and settings.
.TP
\fBTrace\fP
Turns tracing on or off.
The command \fBtrace on\fP enables data stream and keyboard event tracing;
the command \fBtrace off\fP disables it.
The qualifier \fBdata\fP or \fBkeyboard\fP can be specified
before \fBon\fP or \fBoff\fP to enable or disable a particular trace.
After \fBon\fP, a filename may be specified to override the default
trace file name of \fB/tmp/x3trc.\fP\fIpid\fP.
.SH "KEYMAPS"
The \fB\-keymap\fP option allows a \fBkeymap\fP to be specified.
If the option \fB\-keymap\fP \fIxxx\fP is given, then \fBc3270\fP
will first look for a resource named \fBc3270.keymap.\fP\fIxxx\fP;
if that is not found, then it will look for a file named \fIxxx\fP.
.LP
Multiple keymaps may be specified be separating their names with commas.
Definitions in later keymaps supercede those in earlier keymaps.
.LP
In addition, separate keymaps may be defined that apply only in 3270 mode or
only in \s-1NVT\s+1 mode.
For example, the resource definition
\fBc3270.keymap.\fP\fIxxx\fP\fB.nvt\fP will augment the definition
of \fBc3270.keymap.\fP\fIxxx\fP, when \fBc3270\fP is in \s-1NVT\s+1
mode.
Similarly, the resource definition
\fBc3270.keymap.\fP\fIxxx\fP\fB.3270\fP will augment the definition
of \fBc3270.keymap.\fP\fIxxx\fP, when \fBc3270\fP is in 3270
mode.
.LP
Keymaps specify actions to perform when a particular sequence of keys is
pressed.
Each line in a keymap has the following syntax:
.LP
.RS
[\fBMeta\fP][\fBCtrl\fP]\fB<Key>\fP\fIkey\fP...: \fIAction\fP[(\fIparam\fP[,...])] ...
.RE
.LP
For example:
.LP
.RS
Meta<Key>c: Clear()
.br
<Key>PPAGE: PF(7)
.br
Ctrl<Key>A <Key>F1: PF(13)
.RE
.br
.LP
The optional \fBMeta\fP or \fBCtrl\fP qualifiers specify that
the \fBMeta\fP and \fBCtrl\fP keys are pressed along with the
specified \fIkey\fP, respectively.
The \fIkey\fP is either a valid X11 keysym (these are
the \s-1ISO\s+1 8859-1 symbol names, such as \fBequal\fP for `='
and \fBa\fP for `a') or a valid symbolic \fBncurses\fP key name,
such as \fBUP\fP.
The \fIAction\fP is an action from the \s-1ACTIONS\s+1 list, above.
More than one action may be specified.
(Note that symbolic \fBncurses\fP key names can be used only if the
\fBc3270.cursesKeymap\fP resource is set to \fBTrue\fP, which enables
ncurses keymap mode.)
.LP
Keymap entries are case-sensitive and modifier-specific.
This means that a keymap for the \fBb\fP key will match only a
lowercase \fBb\fP.
Actions for uppercase \fBB\fP, or for \fBMeta-b\fP or \fBControl-B\fP,
must be specified separately.
.LP
The base keymap is:
.LP
.TS
l l.
T{
.na
.nh
Key
T}	T{
.na
.nh
Action
T}
_
T{
.na
.nh
Ctrl<Key>]
T}	T{
.na
.nh
Escape
T}
T{
.na
.nh
Ctrl<Key>a Ctrl<Key>a
T}	T{
.na
.nh
Key(0x01)
T}
T{
.na
.nh
Ctrl<Key>a Ctrl<Key>]
T}	T{
.na
.nh
Key(0x1d)
T}
T{
.na
.nh
Ctrl<Key>a <Key>Tab
T}	T{
.na
.nh
BackTab
T}
T{
.na
.nh
Ctrl<Key>a <Key>c
T}	T{
.na
.nh
Clear
T}
T{
.na
.nh
Ctrl<Key>a <Key>e
T}	T{
.na
.nh
Escape
T}
T{
.na
.nh
Ctrl<Key>a <Key>r
T}	T{
.na
.nh
Reset
T}
T{
.na
.nh
Ctrl<Key>a <Key>l
T}	T{
.na
.nh
Redraw
T}
T{
.na
.nh
Ctrl<Key>a <Key>m
T}	T{
.na
.nh
Compose
T}
T{
.na
.nh
Ctrl<Key>a <Key>^
T}	T{
.na
.nh
Key(notsign)
T}
T{
.na
.nh
<Key>UP
T}	T{
.na
.nh
Up
T}
T{
.na
.nh
<Key>DOWN
T}	T{
.na
.nh
Down
T}
T{
.na
.nh
<Key>LEFT
T}	T{
.na
.nh
Left
T}
T{
.na
.nh
<Key>RIGHT
T}	T{
.na
.nh
Right
T}
T{
.na
.nh
<Key>F(\fIn\fP)
T}	T{
.na
.nh
PF(\fIn\fP)
T}
T{
.na
.nh
Ctrl<Key>a <Key>F(\fIn\fP)
T}	T{
.na
.nh
PF(\fIn\fP+12)
T}
T{
.na
.nh
Ctrl<Key>a <Key>1
T}	T{
.na
.nh
PA(1)
T}
T{
.na
.nh
Ctrl<Key>a <Key>2
T}	T{
.na
.nh
PA(2)
T}
T{
.na
.nh
Ctrl<Key>a <Key>3
T}	T{
.na
.nh
PA(3)
T}
.TE
.LP
The base 3270-mode keymap adds:
.LP
.TS
l l.
T{
.na
.nh
Key
T}	T{
.na
.nh
Action
T}
_
T{
.na
.nh
Ctrl<Key>c
T}	T{
.na
.nh
Clear
T}
T{
.na
.nh
Ctrl<Key>r
T}	T{
.na
.nh
Reset
T}
T{
.na
.nh
Ctrl<Key>l
T}	T{
.na
.nh
Redraw
T}
T{
.na
.nh
<Key>Tab
T}	T{
.na
.nh
Tab
T}
T{
.na
.nh
<Key>DC
T}	T{
.na
.nh
Delete
T}
T{
.na
.nh
<Key>BACKSPACE
T}	T{
.na
.nh
BackSpace
T}
T{
.na
.nh
<Key>BackSpace
T}	T{
.na
.nh
BackSpace
T}
T{
.na
.nh
<Key>Return
T}	T{
.na
.nh
Enter
T}
T{
.na
.nh
<Key>Linefeed
T}	T{
.na
.nh
Newline
T}
.TE
.SH "THE META OR ALT KEY"
Some keyboards do not have a \fBMeta\fP key.
Instead, they have an \fBAlt\fP key.
Sometimes this key acts as a proper
\fBMeta\fP key, that is, it is a modifier key that sets the high-order bit
(0x80) in the code that is transmitted for each key.
Other keyboards send a two-character sequence when
the \fBAlt\fP key is pressed with another key: the Escape character (0x1b),
followed by the code for the other key.
.LP
The resource \fBc3270.metaEscape\fP and the termcap \fBkm\fP attribute
control how \fBc3270\fP will interpret these sequences.
When \fBc3270.metaEscape\fP is set to \fBtrue\fP, or when
\fBc3270.metaEscape\fP is set to \fBauto\fP and the termcap \fBkm\fP
attribute is set, the keyboard is assumed to have a separate \fBMeta\fP key.
The Escape key can be used as an ordinary data key and has no special meaning.
.LP
When \fBc3270.metaEscape\fP is set to \fBtrue\fP, or when
\fBc3270.metaEscape\fP is set to \fBauto\fP and the termcap \fBkm\fP
attribute is not set, the keyboard is assumed to use the Escape character
as a prefix to indicate that the following character is supposed to have the
high-order bit set.
When \fBc3270\fP sees an Escape character from the keyboard, it sets a short
timeout.
If another character arrives before the timeout expires, then \fBc3270\fP
will combine the two characters, setting the high-order bit of the second.
In an event trace file, the combined character is listed as \fIderived\fP.
In a keymap, only the combined character or the \fBMeta\fP prefix may be used.
The Escape key can still be used by itself, but only if there is a short pause
before pressing another key.
.LP
The default value for \fBc3270.metaEscape\fP is \fBauto\fP.
.SH "FILE TRANSFER"
The \fBTransfer\fP action implements \fBIND$FILE\fP file transfer.
This action requires that the \fBIND$FILE\fP
program be installed on the \s-1IBM\s+1 host, and that the 3270 cursor
be located in a field that will accept a \s-1TSO\s+1 or \s-1VM/CMS\s+1 command.
.LP
Because of the complexity and number of options for file transfer, the
parameters to the \fBTransfer\fP action take the unique form
of \fIoption\fP=\fIvalue\fP, and can appear in any order.
The options are:
.LP
.TS
l c l l.
T{
.na
.nh
Option
T}	T{
.na
.nh
Required?
T}	T{
.na
.nh
Default
T}	T{
.na
.nh
Other Values
T}
_
T{
.na
.nh
Direction
T}	T{
.na
.nh
No
T}	T{
.na
.nh
send
T}	T{
.na
.nh
receive
T}
T{
.na
.nh
HostFile
T}	T{
.na
.nh
Yes
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
LocalFile
T}	T{
.na
.nh
Yes
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
Host
T}	T{
.na
.nh
No
T}	T{
.na
.nh
tso
T}	T{
.na
.nh
vm
T}
T{
.na
.nh
Mode
T}	T{
.na
.nh
No
T}	T{
.na
.nh
ascii
T}	T{
.na
.nh
binary
T}
T{
.na
.nh
Cr
T}	T{
.na
.nh
No
T}	T{
.na
.nh
remove
T}	T{
.na
.nh
add, keep
T}
T{
.na
.nh
Exist
T}	T{
.na
.nh
No
T}	T{
.na
.nh
keep
T}	T{
.na
.nh
replace, append
T}
T{
.na
.nh
Recfm
T}	T{
.na
.nh
No
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
fixed, variable, undefined
T}
T{
.na
.nh
Lrecl
T}	T{
.na
.nh
No
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
Blksize
T}	T{
.na
.nh
No
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
Allocation
T}	T{
.na
.nh
No
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
tracks, cylinders, avblock
T}
T{
.na
.nh
PrimarySpace
T}	T{
.na
.nh
No
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
SecondarySpace
T}	T{
.na
.nh
No
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
BufferSize
T}	T{
.na
.nh
No
T}	T{
.na
.nh
4096
T}	T{
.na
.nh
\ 
T}
.TE
.LP
The option details are as follows.
.TP
\fBDirection\fP
\fBsend\fP (the default) to send a file to the host,
\fBreceive\fP to receive a file from the host.
.TP
\fBHostFile\fP
The name of the file on the host.
.TP
\fBLocalFile\fP
The name of the file on the local workstation.
.TP
\fBHost\fP
The type of host (which dictates the form of the \fBIND$FILE\fP command):
\fBtso\fP (the default) or \fBvm\fP.
.TP
\fBMode\fP
Use \fBascii\fP (the default) for a text file, which will be translated
between \s-1EBCDIC\s+1 and \s-1ASCII\s+1 as necessary.
Use \fBbinary\fP for non-text files.
.TP
\fBCr\fP
Controls how \fBNewline\fP characters are handled when transferring
\fBMode=ascii\fP files.
\fBremove\fP (the default) strips \fBNewline\fP characters in local files
before transferring them to the host.
\fBadd\fP adds \fBNewline\fP characters to each host file record before
transferring it to the local workstation.
\fBkeep\fP preserves \fBNewline\fP characters when transferring a local file
to the host.
.TP
\fBExist\fP
Controls what happens when the destination file already exists.
\fBkeep\fP (the default) preserves the file, causing the
\fBTransfer\fP action to fail.
\fBreplace\fP overwrites the destination file with the source file.
\fBappend\fP appends the source file to the destination file.
.TP
\fBRecfm\fP
Controls the record  of files created on the host.
\fBfixed\fP creates a file with fixed-length records.
\fBvariable\fP creates a file with variable-length records.
\fBundefined\fP creates a file with undefined-length records (\s-1TSO\s+1 hosts only).
The \fBLrecl\fP option controls the record length or maximum record length for
\fBRecfm=fixed\fP and \fBRecfm=variable\fP files, respectively.
.TP
\fBLrecl\fP
Specifies the record length (or maximum record length) for files created on
the host.
.TP
\fBBlksize\fP
Specifies the block size for files created on the host.  (\s-1TSO\s+1 hosts only.)
.TP
\fBAllocation\fP
Specifies the units for the \s-1TSO\s+1 host \fBPrimarySpace\fP and
\fBSecondarySpace\fP options: \fBtracks\fP, \fBcylinders\fP or
\fBavblock\fP.
.TP
\fBPrimarySpace\fP
Primary allocation for a file created on a \s-1TSO\s+1 host.
The units are given by the \fBAllocation\fP option.
.TP
\fBSecondarySpace\fP
Secondary allocation for a file created on a \s-1TSO\s+1 host.
The units are given by the \fBAllocation\fP option.
.TP
\fBBufferSize\fP
Buffer size for DFT-mode transfers.
Can range from 256 to 32768.
Larger values give better performance, but some hosts may not be able to
support them.
.SH "SCRIPTS"
There are several types of
script functions available.
.TP
\fBThe String Action\fP
The simplest method for
scripting is provided via the \fBString\fP
action.
The arguments to \fBString\fP are one or more double-quoted strings which are
inserted directly as if typed.
The C backslash conventions are honored as follows.
(Entries marked * mean that after sending the \s-1AID\s+1 code to the host,
\fBc3270\fP will wait for the host to unlock the keyboard before further
processing the string.)
.TS
l l.
T{
.na
.nh
\eb
T}	T{
.na
.nh
Left
T}
T{
.na
.nh
\ef
T}	T{
.na
.nh
Clear*
T}
T{
.na
.nh
\en
T}	T{
.na
.nh
Enter*
T}
T{
.na
.nh
\epa\fIn\fP
T}	T{
.na
.nh
PA(\fIn\fP)*
T}
T{
.na
.nh
\epf\fInn\fP
T}	T{
.na
.nh
PF(\fInn\fP)*
T}
T{
.na
.nh
\er
T}	T{
.na
.nh
Newline
T}
T{
.na
.nh
\et
T}	T{
.na
.nh
Tab
T}
T{
.na
.nh
\eT
T}	T{
.na
.nh
BackTab
T}
.TE
.IP
An example keymap entry would be:
.RS
Meta<Key>p: String("probs clearrdr\en")
.RE
.IP
\fBNote:\fP
The strings are in \s-1ASCII\s+1 and converted to \s-1EBCDIC\s+1,
so beware of inserting
control codes.
.IP
There is also an alternate form of the \fBString\fP action, \fBHexString\fP,
which is used to enter non-printing data.
The argument to \fBHexString\fP is a string of hexadecimal digits, two per
character.  A leading 0x or 0X is optional.
In 3270 mode, the hexadecimal data represent \s-1EBCDIC\s+1 characters, which
are entered into the current field.
In \s-1NVT\s+1 mode, the hexadecimal data represent \s-1ASCII\s+1 characters,
which are sent directly to the host.
.TP
\fBThe Script Action\fP
This action causes \fBc3270\fP to start a child process which can
execute \fBc3270\fP actions.
Standard input and output from the child process are piped back to
\fBc3270\fP.
The \fBScript\fP action is fully documented in
\fIx3270-script\fP(1).
.SH "COMPOSITE CHARACTERS"
\fBc3270\fP
allows the direct entry of accented letters and special symbols.
Pressing and releasing the "Compose" key, followed by two other keys, causes
entry of the symbol combining those two keys.
For example, "Compose" followed by the "C" key and the "," (comma) key, enters
the "C-cedilla" symbol.
A C on the status line indicates a pending composite character.
.PP
The mappings between these pairs of ordinary keys and the symbols they
represent is controlled by the "c3270.composeMap" resource; it gives the
name of the map to use.
The maps themselves are named "c3270.composeMap.\fIname\fP".
The default is "latin1", which gives mappings for most of the symbols in
the \s-1ISO\s+1 8859-1 Latin-1 character set that are not in the
7-bit \s-1ASCII\s+1
character set.
.PP
\fBNote:\fP
The default keymap defines
Meta<Key>m
as the "Compose" key.
You
may set up your own "Compose" key with
a keymap that maps some other keysym onto the \fBCompose\fP action.
.SH "PRINTER SUPPORT"
c3270 supports associated printer sessions via the \fIpr3287\fP(1)
program.
The \fBPrinter\fP action is used to start or stop a \fIpr3287\fP session.
.LP
The action \fBPrinter Start\fP starts a printer session, associated with the
current LU.  (This works only if the host supports TN3270E.)
.LP
The action \fBPrinter Start\fP \fIlu\fP starts a printer session, associated
with a specific \fIlu\fP.
.LP
The action \fBPrinter Stop\fP stops a printer session.
.LP
The resource \fBc3270.printer.command\fP specifies the command used to print
each job; it defaults to \fBlpr\fP.
The resource \fBc3270.printer.assocCommandLine\fP specifies the command
used to start an associated printer session.  It defaults to:
.LP
.RS
pr3287 -assoc %L% -command "%C%" %H%
.RE
.LP
The resource \fBc3270.printer.luCommandLine\fP specifies the command used
to start a specific-LU printer session.  It defaults to:
.LP
.RS
pr3287 -command "%C%" %L%@%H%
.RE
.LP
When the printer session command is run, the following substitutions are made:
.LP
.TS
l l.
T{
.na
.nh
Token
T}	T{
.na
.nh
Substitition
T}
T{
.na
.nh
%C%
T}	T{
.na
.nh
Command (value of \fBc3270.printer.command\fP)
T}
T{
.na
.nh
%H%
T}	T{
.na
.nh
Host IP address
T}
T{
.na
.nh
%L%
T}	T{
.na
.nh
Current or specified LU
T}
.TE
.LP
See \fIpr3287\fP(1) for further details.
.SH "PASSTHRU"
\fBc3270\fP supports the Sun \fItelnet-passthru\fP
service provided by the \fIin.telnet-gw\fP server.
This allows outbound telnet connections through a firewall machine.
When a \fBp:\fP is prepended to a hostname, \fBc3270\fP
acts much like the \fIitelnet\fP(1) command.
It contacts the machine named \fBinternet-gateway\fP at the port defined in
\fB/etc/services\fP as \fBtelnet-passthru\fP
(which defaults to 3514).
It then passes the requested hostname and port to the
\fBin.telnet-gw\fP server.
.SH "SCREEN SIZE SWITCHING"
When running as a 3270 Model 5, \fBc3270\fP can take advantage of terminals
that can switch between 80 and 132 column modes.
.LP
Because the curses library does not support mode switching, the escape
sequences and resulting screen dimensions must be specified explicitly to
\fBc3270\fP.
These are specified with the \fB\-altscreen\fP and
\fB\-defscreen\fP command-line options, or the
\fBaltScreen\fP and \fBdefScreen\fP resources.
\fB\-altscreen\fP or \fBaltScreen\fP defines the alternate
(132-column) mode; \fB\-defscreen\fP or \fBdefScreen\fP defines the
default (80-column) mode.
.LP
The syntax for the options and resources is
\fIrows\fP\fBx\fP\fIcols\fP\fB=\fP\fIinit_string\fP,
where \fIrows\fP and \fIcols\fP give the screen dimensions, and
\fIinit_string\fP is the escape sequence to transmit to the terminal to
enter that mode.
For \fBdefscreen\fP, the minimum dimensions are 24 rows and 80 columns.
For \fBaltscreen\fP, the minimum dimensions are 27 rows and 132 columns.
Within \fIinit_string\fP, the usual escape sequences are supported
(\\E for escape, \\r, \\b, etc.).
For example, the init string for a 132-column xterm is:
.IP
\\E[?40h\\E[?3h
.LP
Note: When \fBdefscreen\fP and \fBaltscreen\fP are specified, the model
number is always set to 5.
.SH "RESOURCES"
Certain \fBc3270\fP
options can be configured via resources.
Resources are defined
in the file \fB.c3270pro\fP in the user's
home directory, and
by \fB\-xrm\fP options.
The definitions are similar to X11 resources, and use a similar syntax.
The resources available in \fBc3270\fP are:
.LP
.TS
l l l l.
T{
.na
.nh
Resource
T}	T{
.na
.nh
Default
T}	T{
.na
.nh
Option
T}	T{
.na
.nh
Purpose
T}
_
T{
.na
.nh
allBold
T}	T{
.na
.nh
Auto
T}	T{
.na
.nh
\-allbold
T}	T{
.na
.nh
Display all characters bold
T}
T{
.na
.nh
altScreen
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\-altscreen
T}	T{
.na
.nh
132-col screen definition
T}
T{
.na
.nh
blankFill
T}	T{
.na
.nh
False
T}	T{
.na
.nh
\-set blankFill
T}	T{
.na
.nh
Blank Fill mode
T}
T{
.na
.nh
charset
T}	T{
.na
.nh
bracket
T}	T{
.na
.nh
\-charset
T}	T{
.na
.nh
\s-1EBCDIC\s+1 character set
T}
T{
.na
.nh
charset.\fIfoo\fP
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Definition of character set \fIfoo\fP
T}
T{
.na
.nh
composeMap
T}	T{
.na
.nh
latin1
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Name of composed-character map
T}
T{
.na
.nh
cursesKeymap
T}	T{
.na
.nh
True
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Set curses keymap option
T}
T{
.na
.nh
defScreen
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\-defscreen
T}	T{
.na
.nh
80-col screen definition
T}
T{
.na
.nh
dsTrace
T}	T{
.na
.nh
False
T}	T{
.na
.nh
\-trace
T}	T{
.na
.nh
Data stream tracing
T}
T{
.na
.nh
eof
T}	T{
.na
.nh
^D
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\s-1NVT\s+1-mode \s-1EOF\s+1 character
T}
T{
.na
.nh
erase
T}	T{
.na
.nh
^H
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\s-1NVT\s+1-mode erase character
T}
T{
.na
.nh
extended
T}	T{
.na
.nh
True
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Use 3270 extended data stream
T}
T{
.na
.nh
eventTrace
T}	T{
.na
.nh
False
T}	T{
.na
.nh
\-trace
T}	T{
.na
.nh
Event tracing
T}
T{
.na
.nh
ftCommand
T}	T{
.na
.nh
ind$file
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Host file transfer command
T}
T{
.na
.nh
hostsFile
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\-hostsfile
T}	T{
.na
.nh
Host alias/macro file
T}
T{
.na
.nh
icrnl
T}	T{
.na
.nh
False
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Map \s-1CR\s+1 to \s-1NL\s+1 on \s-1NVT\s+1-mode input
T}
T{
.na
.nh
inlcr
T}	T{
.na
.nh
False
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Map \s-1NL\s+1 to \s-1CR\s+1 in \s-1NVT\s+1-mode input
T}
T{
.na
.nh
intr
T}	T{
.na
.nh
^C
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\s-1NVT\s+1-mode interrupt character
T}
T{
.na
.nh
keymap
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\-keymap
T}	T{
.na
.nh
Keyboard map name
T}
T{
.na
.nh
keymap.\fIfoo\fP
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Definition of keymap \fIfoo\fP
T}
T{
.na
.nh
kill
T}	T{
.na
.nh
^U
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\s-1NVT\s+1-mode kill character
T}
T{
.na
.nh
lineWrap
T}	T{
.na
.nh
False
T}	T{
.na
.nh
\-set lineWrap
T}	T{
.na
.nh
\s-1NVT\s+1 line wrap mode
T}
T{
.na
.nh
lnext
T}	T{
.na
.nh
^V
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\s-1NVT\s+1-mode lnext character
T}
T{
.na
.nh
m3279
T}	T{
.na
.nh
(note 1)
T}	T{
.na
.nh
\-mono
T}	T{
.na
.nh
3279 (color) emulation
T}
T{
.na
.nh
metaEscape
T}	T{
.na
.nh
Auto
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Interpret ESC-x as Meta-x
T}
T{
.na
.nh
monoCase
T}	T{
.na
.nh
False
T}	T{
.na
.nh
\-set monoCase
T}	T{
.na
.nh
Mono-case mode
T}
T{
.na
.nh
numericLock
T}	T{
.na
.nh
False
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Lock keyboard for numeric field error
T}
T{
.na
.nh
oerrLock
T}	T{
.na
.nh
True
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Lock keyboard for input error
T}
T{
.na
.nh
oversize
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\-oversize
T}	T{
.na
.nh
Oversize screen dimensions
T}
T{
.na
.nh
port
T}	T{
.na
.nh
telnet
T}	T{
.na
.nh
\-port
T}	T{
.na
.nh
Non-default TCP port
T}
T{
.na
.nh
printer.*
T}	T{
.na
.nh
(note 4)
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Printer session config
T}
T{
.na
.nh
quit
T}	T{
.na
.nh
^\e
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\s-1NVT\s+1-mode quit character
T}
T{
.na
.nh
rprnt
T}	T{
.na
.nh
^R
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\s-1NVT\s+1-mode reprint character
T}
T{
.na
.nh
secure
T}	T{
.na
.nh
False
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Disable "dangerous" options
T}
T{
.na
.nh
termName
T}	T{
.na
.nh
(note 2)
T}	T{
.na
.nh
\-tn
T}	T{
.na
.nh
\s-1TELNET\s+1 terminal type string
T}
T{
.na
.nh
traceDir
T}	T{
.na
.nh
/tmp
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Directory for trace files
T}
T{
.na
.nh
traceFile
T}	T{
.na
.nh
(note 3)
T}	T{
.na
.nh
\-tracefile
T}	T{
.na
.nh
File for trace output
T}
T{
.na
.nh
typeahead
T}	T{
.na
.nh
True
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Allow typeahead
T}
T{
.na
.nh
werase
T}	T{
.na
.nh
^W
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\s-1NVT\s+1-mode word-erase character
T}
.TE
.LP
.RS
\fINote 1\fP: \fBm3279\fP defaults to
\fBTrue\fP if the terminal supports color,
\fBFalse\fP otherwise.
It can be forced to \fBFalse\fP with the \fB\-mono\fP option.
.LP
\fINote 2\fP:
The default terminal type string is constructed from the model number, color
emulation, and extended data stream modes.
E.g., a model 2 with color emulation and the extended data stream option
would be sent as \fBIBM-3279-2-E\fP.
Note also that when \s-1TN3270E\s+1
mode is used, the terminal type is always sent as some type of 3278.
.LP
\fINote 3\fP: The default trace file is \fBx3trc.\fP\fIpid\fP
in the directory specified by the \fBtraceDir\fP resource.
.LP
\fINote 4\fP: See \s-1PRINTER SUPPORT\s+1 for details.
.RE
.LP
In \fB.c3270pro\fP, lines are continued with a
backslash character.
.LP
\fB\-xrm\fP options override definitions found in \fB.c3270pro\fP.
If more than one \fB\-xrm\fP option is given for the same resource,
the last one on the command line is used.
.SH "FILES"
/usr/local/lib/x3270/ibm_hosts
.br
$HOME/.c3270pro

.SH "SEE ALSO"
x3270(1), s3270(1), tcl3270(1), ibm_hosts(5), x3270-script(1), pr3287(1), telnet(1), tn3270(1)
.br
Data Stream Programmer's Reference, IBM GA23-0059
.br
Character Set Reference, IBM GA27-3831
.br
RFC 1576, TN3270 Current Practices
.br
RFC 1646, TN3270 Extensions for LUname and Printer Selection
.br
RFC 2355, TN3270 Enhancements
.SH "COPYRIGHTS"
.LP
Modifications Copyright 1993, 1994, 1995, 1996, 1997, 1999, 2000, 2001, 2002, 2004 by Paul Mattes.
.br
Original X11 Port Copyright 1990 by Jeff Sparkes.
.RS
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.
.RE
Copyright 1989 by Georgia Tech Research Corporation, Atlanta, GA 30332.
.RS
All Rights Reserved.  GTRC hereby grants public use of this software.
Derivative works based on this software must incorporate this copyright
notice.
.RE
.br
c3270 is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the file LICENSE for more details.
.SH "VERSION"
c3270 3.3.4
