/*
#   dsp.c: DSP routines for the IDJC mixer.
#   Copyright (C) 2005-2006 Stephen Fairchild
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <stdlib.h>
#include <string.h>
#include "dsp.h"

/* return a pointer to a new digital filter or NULL if memory allocation failed */
struct digital_filter *new_digital_filter(size_t siz_a, dfilter_t *co_a, size_t siz_b, dfilter_t *co_b, dfilter_t gain)
   {
   struct digital_filter *self;
  
   if((self = (struct digital_filter *)malloc(sizeof (struct digital_filter)))== NULL)
      return NULL;
   if (siz_a >= siz_b)
      self->siz = siz_a;
   else
      self->siz = siz_b;
   self->gain = gain;
   self->y = calloc(self->siz, sizeof (dfilter_t));
   self->x = calloc(self->siz, sizeof (dfilter_t));
   self->a = calloc(self->siz, sizeof (dfilter_t));
   self->b = calloc(self->siz, sizeof (dfilter_t));
   if (self->a && self->b)
      {
      memcpy(self->a, co_a, sizeof (dfilter_t) * siz_a);
      memcpy(self->b, co_b, sizeof (dfilter_t) * siz_b);
      }
   return (self->a && self->b && self->x && self->y) ? self : NULL;   
   }

/* frees up memory used by the digital filter */
void free_digital_filter(struct digital_filter *self)
   {
   free(self->y);
   free(self->x);
   free(self->a);
   free(self->b);
   free(self);
   }
   
dfilter_t digital_filter(struct digital_filter *self, dfilter_t newx)
   {
   dfilter_t newy = 0.0;
   int i;
    
   i = self->siz;
   while (--i)
      {
      /* move x data along the chain */
      self->x[i] = self->x[i-1];	
      /* update running total for new output */
      newy += ((self->a[i] * self->x[i]) + (self->b[i] * self->y[i])); 
      /* move y data along the chain */   
      self->y[i] = self->y[i-1];	
      }
   return self->y[0] = (newy + (self->a[0] * (self->x[0] = newx/self->gain)) + (self->b[0] * self->y[i]));
   }
