#!/usr/bin/python

#   IDJCmultitagger.py: GTK based id3 and vorbis tagger for mp3/ogg/flac files.
#   Copyright (C) 2006 Stephen Fairchild
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

import pygtk
pygtk.require('2.0')
import gtk, os, eyeD3, sys
from IDJCfree import *
from idjc_config import *
from langheader import *

class mp4tagger(gtk.VBox):
   def load_tag(self, pathname):
      self.idjc.mixer_write("MP4P=%s\nACTN=mp4readtagrequest\nend\n" % pathname, True)
      data = ""
      while 1:
         line = self.idjc.mixer_read()
         if line == "":
            print "mixer crashed during mp4 tag read operation"
            return
         if line == "idjcmixer: mp4fileinfo Not Valid\n":
            return
         if line == "idjcmixer: mp4tagread end\n":
            break
         if line.startswith("idjcmixer: mp4tagread "):
            data += line[22:]
      kvplist = self.make_pairs(data)
      recommended = [ u"artist", u"title", u"track", u"totaltracks", u"album", u"genre", u"date", u"comment" ]
      precede = u""
      for recommend in recommended:
         for key, value in kvplist:
            if key == recommend:
               break
         else:
            precede = precede + recommend + u"=\n"
      self.textbuffer.set_text(precede + data)
      
   def save_tag(self, pathname):
      kvp = self.make_pairs()
      text = u""
      self.idjc.mixer_write("MP4T=\n")
      for key, value in kvp:
         self.idjc.mixer_write("+MP4T=" + key + "=" + value + "\n")
      self.idjc.mixer_write("MP4P=" + pathname + "\n")
      self.idjc.mixer_write("ACTN=mp4writetagrequest\nend\n", True)
      print "mp4 tag saved"

   def make_pairs(self, data = None):	# Returns a list of tuples of key value pairs
      kvp = [ ]			# Any keys containing a space are rejected
      if data == None:
         textiter = self.textbuffer.get_start_iter()
         data = textiter.get_text(self.textbuffer.get_end_iter())
      data = data.splitlines()
      for line in data:
         if line.count("="):
            key, value = line.split("=", 1)
            key = key.strip()
            value = value.strip()
            if key != "" and value != "" and key.count(" ") == 0:
               kvp.append((key.strip(), value.strip()))
      return kvp

   def __init__(self, pathname, idjcroot):
      self.idjc = idjcroot
      gtk.VBox.__init__(self)
      scrolled_window = gtk.ScrolledWindow()
      scrolled_window.set_size_request(350, 250)
      scrolled_window.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
      textview = gtk.TextView()
      self.textbuffer = textview.get_buffer()
      scrolled_window.add(textview)
      textview.show()
      gtk.VBox.add(self, scrolled_window)
      scrolled_window.show()
      textview.set_editable(True)
      textview.set_cursor_visible(True)
      textview.set_wrap_mode(gtk.WRAP_NONE)
      textview.set_justification(gtk.JUSTIFY_LEFT)

class vorbistagger(gtk.VBox):
   def load_ogg_tag(self, pathname):
      self.vc = os.getenv("vorbiscomment")
      if self.vc == "" or self.vc == None:
         self.vc = "vorbiscomment"	# For standalone version
      if self.vc != "missing":
         try:
            (write, read) = os.popen2([ self.vc, "--raw", pathname ])
            write.close()
            data = read.read()
            read.close()
         except:
            print "Problem reading in file", pathname
         else:
            self.load_tag(data)
      
   def load_flac_tag(self, pathname):
      self.mf = os.getenv("metaflac")
      if self.mf == "" or self.mf == None:
         self.mf = "metaflac"	# For standalone version
      if self.mf != "missing":
         try:
            (write, read) = os.popen2([ self.mf, "--no-utf8-convert", "--export-tags-to=-" , pathname ])
            write.close()
            data = read.read()
            read.close()
         except:
            print "Problem reading in file", pathname
         else:
            self.load_tag(data)
      
   def load_tag(self, data):
      # Have some fun here by adding empty keys that are recommended like ALBUM=
      # whenever none is present in the tag.  It saves the user from having to type them.
      kvplist = self.make_pairs(data)
      recommended = [ u"ARTIST", u"TITLE", u"TRACKNUMBER", u"ALBUM", u"GENRE", u"DATE" ]
      precede = u""
      for recommend in recommended:
         for key, value in kvplist:
            if key == recommend:
               break
         else:
            precede = precede + recommend + u"=\n"
      self.textbuffer.set_text(precede + data)
      
   def save_ogg_tag(self, pathname):
      if self.vc != "missing":
         kvp = self.make_pairs()
         text = u""
         for key, value in kvp:
            text = text + key + "=" + value + "\n"
         write, read = os.popen2([self.vc, "--raw", "-w", pathname]) 
         try:
            write.write(text)
            write.close()
            read.read()
            read.close()
         except BrokenPipe:
            pass
	 print "Ogg tag saved"
      
   def save_flac_tag(self, pathname):
      if self.mf != "missing":
         kvp = self.make_pairs()
         text = u""
         for key, value in kvp:
            text = text + key + "=" + value + "\n"
         write, read = os.popen2(["metaflac", "--no-utf8-convert", "--remove-all-tags", "--import-tags-from=-", pathname])
	 try:
            write.write(text)
            write.close()
            read.read()
            read.close()
         except BrokenPipe:
            pass
         print "Flac tag saved"
      
   def make_pairs(self, data = None):	# Returns a list of tuples of key value pairs
      kvp = [ ]			# Any keys containing a space are rejected
      if data == None:
         textiter = self.textbuffer.get_start_iter()
         data = textiter.get_text(self.textbuffer.get_end_iter())
      data = data.splitlines()
      for line in data:
         if line.count("="):
            key, value = line.split("=", 1)
            key = key.strip()
            value = value.strip()
            if key != "" and value != "" and key.count(" ") == 0:
               kvp.append((key.strip(), value.strip()))
      return kvp

   def __init__(self, pathname):
      gtk.VBox.__init__(self)
      scrolled_window = gtk.ScrolledWindow()
      scrolled_window.set_size_request(350, 250)
      scrolled_window.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
      textview = gtk.TextView()
      self.textbuffer = textview.get_buffer()
      scrolled_window.add(textview)
      textview.show()
      gtk.VBox.add(self, scrolled_window)
      scrolled_window.show()
      textview.set_editable(True)
      textview.set_cursor_visible(True)
      textview.set_wrap_mode(gtk.WRAP_NONE)
      textview.set_justification(gtk.JUSTIFY_LEFT)

class id3tagger(gtk.VBox):
   def textfilter(self, text):
      if text == None:
         text = ""
      while text != "" and text[-1] == "\x00":
         text = text[:-1]
      return unicode(text.strip())
      
   def cb_genre(self, combo, textbox):
      if combo.get_active() != 255:
         newtext = eyeD3.genres[combo.get_active()]
         textbox.set_text(newtext)
         if newtext == "Unknown":
            combo.set_active(255)
      
   def cb_genre_unpress(self, textbox, event, combo):
      lt = textbox.get_text().lstrip()
      textbox.set_text(lt)
      lt = lt.lower().strip()
      cursor_pos = textbox.get_position()
      if lt == "unknown":
         combo.set_active(255)
      else:
         value = 0
         for each in eyeD3.genres:
            if each.lower() == lt:
               combo.set_active(value)
               break
            value = value + 1
         else:
            combo.set_active(255)
      textbox.set_position(cursor_pos)
      return False
         
   def load_tag(self, pathname, extension):
      self.tag = eyeD3.Tag()
      exception = False
      if True or extension == "mp3":
         try:
            self.tagv2found = self.tag.link(pathname, eyeD3.ID3_V2)
         except:
            self.tagv2found = 0
      else:
         self.tagv2found = 0
      if self.tagv2found == 0:
         try:
            self.tagv1found = self.tag.link(pathname, eyeD3.ID3_V1)
         except eyeD3.tag.TagException:
            self.tagv2found = 1
            self.tag.link(pathname, eyeD3.ID3_V2)	# Use a blank v2 tag as the basis
      # Now we can load up the fields from what is in the tag.
      self.title.set_text(self.textfilter(self.tag.getTitle()))
      self.artist.set_text(self.textfilter(self.tag.getArtist()))
      self.album.set_text(self.textfilter(self.tag.getAlbum()))
      self.year.set_text(self.textfilter(self.tag.getYear()))
      genre = self.tag.getGenre()
      if genre == None or genre.id == None or genre.id == 255:
         genre_value = 255
         self.genre_text.set_text("Unknown")
      else:
         genre_value = genre.id
      self.std_genre.set_active(genre_value)
      track = self.tag.getTrackNum()
      if type(track[0]) is int:
         tracktext = str(track[0])
         if type(track[1]) is int and track[1] > 0:
            tracktext = tracktext + "/" + str(track[1])
         self.track.set_text(tracktext)
      comments = self.tag.getComments()
      if len(comments):
         for self.ourcomment in comments: # Show the idjc comment in preference to the others
            if self.ourcomment.description == self.idjc_comment_desc:
               break
         else:
            self.ourcomment = comments[0]
         self.comment.set_text(self.textfilter(self.ourcomment.comment))
      else:
         self.ourcomment = None
   
   def save_tag(self, pathname):
      self.tag.setVersion(eyeD3.ID3_V2_4)
      self.tag.setTextEncoding(eyeD3.UTF_8_ENCODING)
      self.tag.setArtist(self.textfilter(self.artist.get_text()))
      self.tag.setTitle(self.textfilter(self.title.get_text()))
      self.tag.setAlbum(self.textfilter(self.album.get_text()))
      trackstring = self.track.get_text().split("/")
      if len(trackstring) >= 1 and len(trackstring) <= 2:
         try:
            tracknum = int(trackstring[0].strip())
            if tracknum < 0:
               raise ValueError
            if len(trackstring) == 2:
               tracktotal = int(trackstring[1].strip())
               if tracktotal < 0:
                  raise ValueError
            else:
               tracktotal = None
         except ValueError:
            print "Bad entry for track"
            self.tag.setTrackNum([ None, None ])
         else:
            self.tag.setTrackNum([ tracknum, tracktotal])
      self.tag.frames.removeFramesByID("TYER")
      try:
         datevalue = int(self.textfilter(self.year.get_text()))
         if datevalue >= 1000 and datevalue <= 9999:
            self.tag.setDate(int(self.textfilter(self.year.get_text())))
         else:
            raise ValueError
      except ValueError:
         print "Year field will be left blank"
      self.tag.setGenre(self.std_genre.get_active())   
      self.tag.addComment(self.textfilter(self.comment.get_text()), self.idjc_comment_desc, self.idjc_comment_lang)
      try:
         self.tag.update(eyeD3.ID3_V1_1)
      except UnicodeEncodeError:
         print "ID3 v1.1 tag was not written because of an illegal character in one of the fields (not a member of the ISO-8859-1 character set)"
      else:
         print "Wrote ID3 v1.1 tag."
      if True or os.path.splitext(pathname)[1] == ".mp3":
         self.tag.update(eyeD3.ID3_V2_4)
         print "Wrote ID3 v2.4 tag."
      else:
         print "ID3 v2.4 tag not written for non-mp3 files."
   
   def __init__(self, pathname):
      gtk.VBox.__init__(self)
      self.idjc_comment_desc = "idjc-comment"
      self.idjc_comment_lang = "XXX"
      
      frame = gtk.Frame(" " + standard_tags_text + " ")
      frame.set_border_width(6)
      gtk.VBox.pack_start(self, frame, False, False, 0)
      sthbox = gtk.HBox()
      sthbox.set_spacing(2)
      sthbox.set_border_width(8)
      frame.add(sthbox)
      frame.show()
      sthbox.show()
      stlvbox = gtk.VBox()
      sthbox.pack_start(stlvbox, False, False, 1)
      stlvbox.show()
      strvbox = gtk.VBox()
      sthbox.pack_start(strvbox, True, True, 1)
      strvbox.show()
      
      title = gtk.Label(tag_title_text)
      stlvbox.add(title)
      title.show()
      
      self.title = gtk.Entry()
      self.title.set_width_chars(30)
      strvbox.add(self.title)
      self.title.show()
      
      artist = gtk.Label(tag_artist_text)
      stlvbox.add(artist)
      artist.show()
      
      self.artist = gtk.Entry()
      strvbox.add(self.artist)
      self.artist.show()
      
      album = gtk.Label(tag_album_text)
      stlvbox.add(album)
      album.show()
      
      self.album = gtk.Entry()
      strvbox.add(self.album)
      self.album.show()
      
      track = gtk.Label(tag_track_text)
      stlvbox.add(track)
      track.show()
      
      self.track = gtk.Entry()
      strvbox.add(self.track)
      self.track.show()
      
      year = gtk.Label(tag_year_text)
      stlvbox.add(year)
      year.show()
      
      self.year = gtk.Entry()
      strvbox.add(self.year)
      self.year.show()
      
      genre = gtk.Label(tag_genre_text)
      stlvbox.add(genre)
      genre.show()
      
      genre_box = gtk.HBox()
      self.genre_text = gtk.Entry()
      genre_box.pack_start(self.genre_text, True, True, 0)
      self.genre_text.show()
      self.genre_text.set_text("Unknown")
      self.std_genre = gtk.combo_box_new_text()
      self.std_genre.set_wrap_width(5)
      value = 0
      for each in eyeD3.genres:
         self.std_genre.append_text(each + " (" + str(value) + ")")
         value = value + 1
      self.std_genre.connect("changed", self.cb_genre, self.genre_text)
      self.genre_text.connect("key_release_event", self.cb_genre_unpress, self.std_genre)
      self.std_genre.set_active(255)
      genre_box.pack_end(self.std_genre, False, False, 0)
      self.std_genre.show()
      strvbox.add(genre_box)
      genre_box.show()
      
      comment = gtk.Label(tag_comment_text)
      stlvbox.add(comment)
      comment.show()
      
      self.comment = gtk.Entry()
      strvbox.add(self.comment)
      self.comment.show()


class multitag:
   def destroy_and_quit(self, widget, data = None):
      gtk.main_quit()
      sys.exit(0)
   
   def update_playlists(self, pathname, idjcroot):
      newplaylistdata = idjcroot.player_left.get_media_metadata(pathname)
      idjcroot.player_left.update_playlist(newplaylistdata)
      idjcroot.player_right.update_playlist(newplaylistdata)
   
   def is_supported(self, pathname):
      supported = [ "mp3", "ogg", "flac" ]
      try:
         if mp4enabled:
            supported.append("mp4")
            supported.append("m4a")
      except:
         pass
      extension = os.path.splitext(pathname)[1][1:].lower()
      if supported.count(extension) != 1:
         print "File type", extension, "is not supported."
         return False
      else:
         return extension
   
   def __init__(self, pathname = None, encoding = "latin1", idjcroot = None):
      if pathname == None:
         return
      extension = self.is_supported(pathname)
      if extension == False:
         return
      
      self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
      if idjcroot is not None:
         idjcroot.window_group.add_window(self.window)
      self.window.set_title(tagger_window_title_text)
      self.window.set_destroy_with_parent(True)
      self.window.set_border_width(9)
      self.window.set_resizable(True)
      self.window.set_icon_from_file(pkgdatadir + "icon" + gfext)
      if idjcroot == None:
         self.window.connect("destroy", self.destroy_and_quit)
      vbox = gtk.VBox()
      self.window.add(vbox)
      vbox.show()
      label = gtk.Label()
      if idjcroot:
         label.set_markup(u"<b>" + tagger_filename_text + u" " + rich_safe(unicode(os.path.split(pathname)[1], encoding).encode("utf-8", "replace")) + u"</b>")
      else:
         label.set_markup(u"<b>" + tagger_filename_text + u" " + rich_safe(unicode(os.path.split(pathname)[1], "latin1").encode("utf-8", "replace")) + u"</b>")
      vbox.pack_start(label, False, False, 6)
      label.show()
      
      hbox = gtk.HBox()
      hbox.set_border_width(2)
      apply_button = gtk.Button(None, gtk.STOCK_APPLY)
      if idjcroot is not None:
         apply_button.connect_object_after("clicked", self.update_playlists, pathname, idjcroot)
      hbox.pack_end(apply_button, False, False, 0)
      apply_button.show()
      close_button = gtk.Button(None, gtk.STOCK_CLOSE)
      close_button.connect_object("clicked", gtk.Window.destroy, self.window)
      hbox.pack_end(close_button, False, False, 10)
      close_button.show()
      reload_button = gtk.Button(None, gtk.STOCK_REVERT_TO_SAVED)
      hbox.pack_start(reload_button, False, False, 10)
      reload_button.show()
      vbox.pack_end(hbox, False, False, 0)
      hbox.show()
      hbox = gtk.HBox()
      vbox.pack_end(hbox, False, False, 2)
      hbox.show()
      
      notebook = gtk.Notebook()
      notebook.set_border_width(2)
      vbox.pack_start(notebook, True, True, 0)
      notebook.show()
      if (extension == "mp4" or extension == "m4a") and idjcroot != None and mp4enabled:
         self.mp4 = mp4tagger(pathname, idjcroot)
         reload_button.connect_object("clicked", self.mp4.load_tag, pathname)
         apply_button.connect_object("clicked", self.mp4.save_tag, pathname)
         reload_button.clicked()
         label = gtk.Label("MP4 Tag")
         notebook.append_page(self.mp4, label)
         label.show()
         self.mp4.show()
      elif extension == "mp3":
         self.id3 = id3tagger(pathname)
         reload_button.connect_object("clicked", self.id3.load_tag, pathname, extension)
         apply_button.connect_object("clicked", self.id3.save_tag, pathname)
         reload_button.clicked()
         self.vorbis = None
         label = gtk.Label("ID3 Tag")
         notebook.append_page(self.id3, label)
         self.id3.show()
         label.show()
      else:
         self.vorbis = vorbistagger(pathname)
         if extension == "ogg":
            reload_button.connect_object("clicked", self.vorbis.load_ogg_tag, pathname)
            apply_button.connect_object("clicked", self.vorbis.save_ogg_tag, pathname)
         elif extension == "flac":
            reload_button.connect_object("clicked", self.vorbis.load_flac_tag, pathname)
            apply_button.connect_object("clicked", self.vorbis.save_flac_tag, pathname)
         reload_button.clicked()
         label = gtk.Label(vorbis_tag_text)
         notebook.append_page(self.vorbis, label)
         self.vorbis.show()
         label.show()
         self.id3 = id3tagger(pathname)
         self.id3.load_tag(pathname, extension)
	 if (self.id3.tagv2found == 0 and self.id3.tagv1found == 0) or extension == "ogg":
            self.id3.destroy()
            self.id3 = None
         else:
            reload_button.connect_object("clicked", self.id3.load_tag, pathname, extension)
            apply_button.connect_object("clicked", self.id3.save_tag, pathname)
            label = gtk.Label(id3_tag_text)
            notebook.append_page(self.id3, label)
            self.id3.show()
            label.show()
      apply_button.connect_object_after("clicked", gtk.Window.destroy, self.window)
      self.window.show()

if __name__ == "__main__":
   os.environ["CHARSET"]="UTF-8"
   if len(sys.argv) != 2 or os.path.isfile(sys.argv[1]) == False:
      print "The media tagger from IDJC.  Copyright Stephen Fairchild 2006\nReleased under the GNU General Public License V2.0\nUsage:", sys.argv[0], "filename"
   else:
      multitag(sys.argv[1])
      gtk.main()
