#   IDJCservergui.py: Server window GUI code for IDJC
#   Copyright (C) 2005 Stephen Fairchild
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

import pygtk
pygtk.require('2.0')
import gtk, os, time, gobject, fcntl, sys
from idjc_config import *
from IDJCservdialog import *
from langheader import *

class encRadioButton(gtk.RadioButton):
   def __init__(self, group, text, format, bandwidth):
      gtk.RadioButton.__init__(self, group, text)
      self.format = format
      self.bandwidth = bandwidth

class server_window:
   server_errmsg = "idjc: the server module appears to have crashed -- possible segfault"
   no_relaunch = "idjc: unable to relaunch the server module -- exiting\n"
   def servermodule_write(self, control_string):
      try:
         self.serv_cmd.write(control_string)
         self.serv_cmd.flush()
      except (ValueError, IOError):
         try:
            close(self.serv_cmd)
            close(self.serv_rply)
         except:
            pass
         print self.server_errmsg
         time.sleep(1.0)	# allow time for jack to unregister the old client
         self.is_saving = False
         (self.serv_cmd, self.serv_rply) = os.popen2([libexecdir + "idjcserver"], 4096)
         while 1:
            reply = self.serv_rply.readline()
            if reply == "" or reply == "Segmentation Fault\n" or reply == "up\n":
               break
         if reply != "up\n":
            print self.no_relaunch
            print "reply was:", reply
            self.parent.destroy()
            gtk.gdk.threads_leave()
            return True
         else:
            try:
               if self.connect_button.get_active():
                  print "was streaming -- will attempt automatic reconnection in 2 seconds"
                  self.connect_button.set_active(False)
                  gobject.timeout_add(2000, self.autoreconnect)
               if self.record_button.get_active():
                  print "unable to resume the recording"
                  self.stop_button.clicked()
               self.serv_cmd.write(control_string)
               self.serv_cmd.flush()
            except:
               print self.no_relaunch
               self.parent.destroy()
               gtk.gdk.threads_leave()
               return True
   
   def servermodule_read(self, tag):
      ioerrcount = 0
      while 1:
         try:
            reply = self.serv_rply.readline()
         except IOError:
            print "servermodule_read: IOError detected"
            ioerrcount += 1
            if ioerrcount == 5:
               self.parent.destroy_hard()
            continue
         ioerrcount = 0
         if len(reply) == 0:
            # the following function will do the relaunching duties
            self.servermodule_write("ACTN=status\nSTAG=%s\nend\n" % tag)
            continue
         if reply.startswith("IDJCserver: "):
            reply = reply[12:-1].split(" ")
            if reply[1] == tag:
               break
         else:
            print "idjc: got the following from the server module...\n" + reply
      return reply
         
   def autoreconnect(self):
      gtk.gdk.threads_enter()
      self.dialog_group.hide()
      self.connect_button.set_active(True)
      self.autoreconnect_dialog.present()
      gtk.gdk.threads_leave()
      return False

   def delete_event(self, widget, event, data=None):
      self.window.hide()	# We don't really destroy the window
      return True
       
   def disconnect(self):
      self.servermodule_write("ACTN=disconnect\nend\n")
      self.update_button.set_sensitive(False)
      
   def new_meta(self, songname, artist, title):
      newmetatext = self.metadata_entry.get_text().replace("%s", songname)
      newmetatext = newmetatext.replace("%n", self.name_entry.get_text())
      newmetatext = newmetatext.replace("%u", self.url_entry.get_text())
      newmetatext = newmetatext.replace("%d", self.description_entry.get_text())
      newmetatext = newmetatext.replace("%g", self.genre_entry.get_text())
      # Dunno what the preferred encoding is supposed to be but XMMS likes latin1 for mp3.
      if newmetatext != songname:
         artist = ""
         title = newmetatext
      if self.parent.prefs_window.mp3_utf8.get_active():
         encodedmetatext = newmetatext.encode("utf8", "replace").strip()
      else:
         encodedmetatext = newmetatext.encode("latin1", "replace").strip()
      if len(encodedmetatext) > 512:
         encodedmetatext = encodedmetatext[:512]
      self.servermodule_write("META=%s\nMART=%s\nMTIT=%s\nACTN=newmeta\nend\n" % (encodedmetatext, artist, title))
      print "updated metadata with:", newmetatext.encode(self.parent.denc, "replace").strip()

   def connect(self):
      # these are stored in the event of a server module crash
      self.servertype = self.server_type.get_active_text()
      self.host = self.server_entry.get_text()
      self.port = self.port_entry.get_value_as_int()
      self.passwd = self.password_entry.get_text()
      self.loginname = self.login_entry.get_text()
      self.metastring = self.parent.metadata
      self.streamname = self.name_entry.get_text()
      self.streamurl = self.url_entry.get_text()
      self.streamdesc = self.description_entry.get_text()
      self.streamgenre = self.genre_entry.get_text()
      self.public = self.publish_check.get_active()
      self.meta = self.metadata_check.get_active()
      self.mount = self.mount_entry.get_text()
      self.stereo = self.stereo_checkbox.get_active()
      self.stformat = self.format
      self.stbandwidth = self.bandwidth
      self.stabr_flag = self.abr_flag
      self.quality = self.hq_checkbox.get_active()
      self.send_connect_command()
      self.update_button.set_sensitive(self.meta)
      
   def send_connect_command(self):
      cs = "SERV=%s\nHOST=%s\nPORT=%d\nPASS=%s\n" % (
      				self.servertype, self.host, self.port, self.passwd)
      cs += "NAME=%s\nMETA=%s\nFORM=%s\nBAND=%s\n" % (
      				self.loginname, self.metastring, self.stformat, self.stbandwidth)
      cs += "ACTN=%s\nSNAM=%s\nSURL=%s\nSDES=%s\n" % (
      				"connect", self.streamname, self.streamurl, self.streamdesc)
      cs += "SGEN=%s\nPUBF=%d\nMETF=%d\nMOUN=%s\n" % (
      				self.streamgenre, self.public, self.meta, self.mount)
      cs += "ABRF=%d\nSTER=%d\nQUAL=%d\nend\n" % (self.stabr_flag, self.stereo, self.quality)
      self.servermodule_write(cs)
      self.new_meta(self.parent.metadata, self.parent.artist, self.parent.title)
      self.last_message_time = 0
      self.timeoutcount = 0
      self.lasttotal = ""
      
   class bad_24h:
      def __init__(self):
         pass 
     
   def server_monitor(self):
      gtk.gdk.threads_enter()
      if self.time_entry.flags() & gtk.SENSITIVE:
         hours = self.time_entry.get_text()[:2]
         mins = self.time_entry.get_text()[2:] 
	 
         try:
            if mins[0] != ":" or len(hours.strip()) != 2 or len(mins.strip()) != 3:
               raise self.bad_24h
            hours = int(hours)
            mins = int(mins[1:])
            if hours > 23 or hours < 0 or mins > 59 or mins < 0:
               raise self.bad_24h
	 except IndexError, self.bad_24h:
	    #print "Disconnection time not a valid 24H time e.g. 14:35 or 00:00"
            pass
         else:
            tm = time.localtime()
            if tm[3] == hours and tm[4] == mins and tm[5] == 0:
               self.connect_button.set_active(False)
               self.autoshutdown_dialog.present()
            tm_plus_a_minute = time.localtime(time.time() + 60.0)
            if tm_plus_a_minute[3] == hours and tm_plus_a_minute[4] == mins and tm_plus_a_minute[5] == 0:
               self.oneminwarn.present()
   
      tag = "%f" % time.time()
      self.servermodule_write("ACTN=status\nSTAG=%s\nend\n" % tag)
      reply = self.servermodule_read(tag)
      self.is_saving = int(reply[3])
      self.is_paused = int(reply[4])
      
      if self.is_saving == False:
         self.parent.left_unlit_image.show()
         self.parent.left_amber_image.hide()
         self.parent.left_red_image.hide()
      elif self.is_paused:
         self.parent.left_unlit_image.hide()
         self.parent.left_amber_image.show()
         self.parent.left_red_image.hide()
      else:
         self.parent.left_unlit_image.hide()
         self.parent.left_amber_image.hide()
         self.parent.left_red_image.show()

      if reply[2] != self.lasttotal:	    
	 self.lasttotal = reply[2]
	 self.timeoutcount = 0
      else:
         self.timeoutcount = self.timeoutcount + 1
	 
      if reply[0] == "connecting":		# keep monitoring
         if self.timeoutcount % 2 == 0:
            self.parent.right_unlit_image.hide()
            self.parent.right_amber_image.show()
            self.parent.right_green_image.hide()
	    #self.parent.server_button.set_label("-- " + server_button_text + " --")
	 else:
            self.parent.right_unlit_image.show()
            self.parent.right_amber_image.hide()
            self.parent.right_green_image.hide()
            #self.parent.server_button.set_label(server_button_text)
	    if self.timeoutcount > 60:
	       self.connect_button.set_active(False)
               self.timed_out_dialog.present()
         gtk.gdk.threads_leave()
         return True
      if reply[0] == "disconnected":
         if self.server_on_f == True:
            try:
               file = open(self.parent.idjc + "history.log", "a")
            except IOError:
               print "unable to open history.log for writing"
            else:
               try:
                  file.write(time.strftime("%x %X ") + disconnected_history_text + "\n")
               except:
                  print "unable to append to file \"history.log\""
               file.close()
         if self.connect_button.get_active() == True:
            self.disconnected_dialog.present()
         self.connect_button.set_active(False)	# Toggle the connect button off
         self.parent.right_unlit_image.show()
         self.parent.right_amber_image.hide()
         self.parent.right_green_image.hide()
         #self.parent.server_button.set_label(server_button_text)
         self.server_on_f = False
         gtk.gdk.threads_leave()
	 return True
      if reply[0] == "connected":
         if self.server_on_f == False:
            try:
               file = open(self.parent.idjc + "history.log", "a")
            except IOError:
               print "unable to open history.log for writing"
            else:
               try:
                  file.write(time.strftime("%x %X ") + connected_to_history_text + " " + self.host + ":" + str(self.port) + self.mount + "\n")
               except IOError:
                  print "unable to append to file \"history.log\""
               file.close()
         self.server_on_f = True
         if self.timeoutcount < 4:
            self.parent.right_unlit_image.hide()
            self.parent.right_amber_image.hide()
            self.parent.right_green_image.show()
	    #self.parent.server_button.set_label("** " + server_button_text + " **")
            if self.parent.prefs_window.timer_enable.get_active() and (self.last_message_time + (self.parent.prefs_window.intervaladj.get_value() * 60) < time.time()):
               self.last_message_time = time.time()
               try:
	          file = open(self.parent.idjcroot + "timer.xchat", "w")
	          fcntl.flock(file.fileno(), fcntl.LOCK_EX)
	          file.write("d" + str(len(self.parent.prefs_window.timernickentry.get_text().encode("utf-8"))) + ":" + self.parent.prefs_window.timernickentry.get_text().encode("utf-8"))
	          file.write("d" + str(len(self.parent.prefs_window.timerchannelsentry.get_text().encode("utf-8"))) + ":" + self.parent.prefs_window.timerchannelsentry.get_text().encode("utf-8"))
	          cookedmessage = self.parent.cook(self.parent.prefs_window.timermessageentry.get_text())
	          file.write("d" + str(len(cookedmessage)) + ":" + cookedmessage)
	          timestr = str(int(time.time()))
	          file.write("d" + str(len(timestr)) + ":" + timestr)
	          fcntl.flock(file.fileno(), fcntl.LOCK_UN)
	          file.close()
	       except IOError:
	          print "Problem writing the timer file to disk"  
         else:
	    if self.timeoutcount % 2 == 0:
               self.parent.right_unlit_image.hide()
               self.parent.right_amber_image.hide()
               self.parent.right_green_image.show()
               #self.parent.server_button.set_label("** " + server_button_text + " **")
	    else:
               self.parent.right_unlit_image.show()
               self.parent.right_amber_image.hide()
               self.parent.right_green_image.hide()
	       #self.parent.server_button.set_label(server_button_text)
	       if self.timeoutcount > 120:	# Remake the connection after 1 minute.
	          print "Attempting reconnection"
	          self.connect_button.set_active(False)	
		  self.connect_button.set_active(True)
                  gtk.gdk.threads_leave()
		  return False
      gtk.gdk.threads_leave()
      return True				# Keep monitoring
  
   def cb_connect(self, widget, data):
      if data == "pwtrigger" and self.connect_button.get_active() == False:
         print "Connection triggered by entering the password"
         self.connect_button.set_active(True)
      if data == "connect":
         if widget.get_active() == True:
            self.dialog_group.hide()
            self.connect()
         else:
            self.disconnect()

            
   def cb_update(self, widget):
      print "Update was pressed"
      self.new_meta(self.parent.metadata, self.parent.artist, self.parent.title)         

   def cb_servertype(self, widget):
      if widget.get_active() == 0:
         self.mask_non_shoutcast_options(True)        
      else:
         self.mask_non_shoutcast_options(False)
	 
   def cb_encoding(self, widget, data = None):
      if data == "format":
         self.format = widget.get_active_text()
         if self.format == "mp3":
            self.mp3_stream_bitrate.show()
            self.ogg_stream_bitrate.hide()
            self.mp3_stream_bitrate.emit("changed")	# cause stereo box to be updated
            self.hq_checkbox.set_sensitive(True)
         if self.format == "ogg":
            self.mp3_stream_bitrate.hide()
            self.ogg_stream_bitrate.show()
            self.ogg_stream_bitrate.emit("changed")
            self.hq_checkbox.set_sensitive(False)
      if data == "mp3bitrate":
         self.stereo_checkbox.set_active(self.mp3_stereolist[widget.get_active()] == "1")
         self.bandwidth = widget.get_active_text()
         self.abr_flag = 0
      if data == "oggbitrate":
         self.stereo_checkbox.set_active(self.ogg_stereolist[widget.get_active()] == "1")
         self.bandwidth = widget.get_active_text().strip(" ABR")
         self.abr_flag = widget.get_active_text().endswith("ABR")
      if data == "stereotoggle":
         index1 = self.stream_format.get_active()
         index2 = self.bitratewidgetlist[index1].get_active()
         if index1 == 0:
            self.mp3_stereolist[index2] = ("0", "1")[widget.get_active()]
         if index1 == 1:
            self.ogg_stereolist[index2] = ("0", "1")[widget.get_active()]
         
   def mask_non_shoutcast_options(self, value):
      value = not value
      self.mount_entry.set_sensitive(value)
      self.login_entry.set_sensitive(value)
      
   def cb_stream_format(self, widget):
      if widget.get_active():
         if widget.format == "mp3":
	    self.metadata_check.set_sensitive(True)
	 else:
	    self.metadata_check.set_sensitive(True)
         self.format = widget.format
         self.bandwidth = widget.bandwidth
	 
   def cb_discon(self, widget, data):
      self.time_entry.set_sensitive(widget.get_active())

   def obfuscate(self, intext):		# better than nothing?
      outtext = ""
      for each in intext:
         value = ord(each)
         outtext += chr(((value & 0x7) << 3) ^ value)
      return outtext
      
   def save(self, path):
      file = open(path + "serverdata", "w")
      if file:
         print "Saving server settings"
         file.write("serv=%d\n" % self.server_type.get_active())
	 file.write("host=%s\n" % self.server_entry.get_text())
	 file.write("port=%d\n" % self.port_entry.get_value_as_int())
	 file.write("moun=%s\n" % self.mount_entry.get_text())
	 file.write("lnam=%s\n" % self.login_entry.get_text())
	 file.write("snam=%s\n" % self.name_entry.get_text())
	 file.write("urle=%s\n" % self.url_entry.get_text())
	 file.write("desc=%s\n" % self.description_entry.get_text())
	 file.write("genr=%s\n" % self.genre_entry.get_text())
	 file.write("meta=%d\n" % self.metadata_check.get_active())
	 file.write("publ=%d\n" % self.publish_check.get_active())
         file.write("mets=%s\n" % self.metadata_entry.get_text())
         file.write("format=%d\n" % self.stream_format.get_active())
         file.write("mp3bitrate=%d\n" % self.mp3_stream_bitrate.get_active())
         file.write("oggbitrate=%d\n" % self.ogg_stream_bitrate.get_active())
         file.write("highqualitymp3=%d\n" % self.hq_checkbox.get_active())
         file.write("mp3stereo=")	# saves state of stereo for each encoding
         for each in self.mp3_stereolist: file.write(each)
         file.write("\noggstereo=")
         for each in self.ogg_stereolist: file.write(each)
         file.write("\n")
         file.write("stereostate=%d\n" % self.stereo_checkbox.get_active())
         if self.parent.prefs_window.keeppass.get_active():
            file.write("pass=%s\n" % self.obfuscate(self.password_entry.get_text()))

   def load(self, path):
      try :
         file = open(path + "serverdata", "r")
         while 1:
	    text = file.readline()
	    if len(text) == 0:
	       break     
	    index = text.find("=")
	    if index < 1:
	       continue
	    key = text[:index]
	    data = text[index+1:-1]
	    
	    if key == "serv":
	       try:
	          self.server_type.set_active(int(data))
	       except:
	          print "serv must be numerical"
	    if key == "host": self.server_entry.set_text(data)
	    if key == "port":
	       try:
	          self.port_entry.set_value(int(data))
	       except:
	          print "port must be numerical"
	    if key == "moun": self.mount_entry.set_text(data)
	    if key == "lnam": self.login_entry.set_text(data)
	    if key == "snam": self.name_entry.set_text(data)
	    if key == "urle": self.url_entry.set_text(data)
	    if key == "desc": self.description_entry.set_text(data)
	    if key == "genr": self.genre_entry.set_text(data)
	    if key == "meta": self.metadata_check.set_active(data == "1")
	    if key == "publ": self.publish_check.set_active(data == "1")
            if key == "mets": self.metadata_entry.set_text(data)
            if key == "format": self.stream_format.set_active(data == "1")
            if key == "mp3bitrate": self.mp3_stream_bitrate.set_active(int(data))
            if key == "oggbitrate": self.ogg_stream_bitrate.set_active(int(data))
            if key == "highqualitymp3": self.hq_checkbox.set_active(int(data))
            if key == "mp3stereo":
               while len(data) < len(self.mp3_stereolist):
                  data += "0"
                  print "extending mp3_stereolist"
               self.mp3_stereolist = list(each for each in data)
            if key == "oggstereo":
               self.ogg_stereolist = list(each for each in data)
            if key == "stereostate": self.stereo_checkbox.set_active(data == "1")
            if key == "pass": self.password_entry.set_text(self.obfuscate(data))
         file.close()          
      except IOError:
         print "No server data file found"
      self.stream_format.emit("changed")
 
   def start_recording(self):
      mp3bitratelist = [ "256", "192", "128", "96", "64", "32" ]
      oggqualitylist = [ "6", "4", "2", "1", "0", "-1" ]
      filename = unicode(self.recfile.get_text()).strip().encode(self.parent.fenc, "replace")
      format = self.rec_mode.get_active()
      if format <= 5:
         filetype = "mp3"
         bitrate = mp3bitratelist[format]
         if filename[-4:] != ".mp3" and filename[-4:] != ".MP3":
            filename = filename + ".mp3"
      else:
         filetype = "ogg"
         bitrate = oggqualitylist[format - 6]
         if filename[-4:] != ".ogg" and filename[-4:] != ".OGG":
            filename = filename + ".ogg"
      if filename[:2] == "~/":
         filename = self.parent.home + filename[1:]
      
      self.servermodule_write("RECP=0\nRECF=%s\nARTI=%s\nTITL=%s\nSFMT=%s\nSRAT=%s\nACTN=RecordStart\nend\n" % (
      		filename, self.artist_entry.get_text().strip(),
                self.title_entry.get_text().strip(),
                filetype, bitrate))
      self.is_recording = True
      self.is_saving = True
      for each in self.save_widgets:
         each.set_sensitive(False)
      try:
         file = open(self.parent.idjc + "history.log", "a")
      except IOError:
         print "unable to open history.log for writing"
      else:
         try:
            file.write(time.strftime("%x %X ") + start_recording_history_text + " \"" + filename + "\"\n")
         except:
            print "unable to append to file \"history.log\""
         file.close()

   def stop_recording(self):
      self.servermodule_write("ACTN=RecordStop\nRECP=0\nend\n")
      self.is_recording = False
      for each in self.save_widgets:
         each.set_sensitive(True)
      self.pause_button.set_active(False)
      try:
         file = open(self.parent.idjc + "history.log", "a")
      except IOError:
         print "unable to open history.log for writing"
      else:
         try:
            file.write(time.strftime("%x %X ") + stop_recording_history_text + "\n")
         except:
            print "unable to append to file \"history.log\""
         file.close()

   def cb_record(self, widget, data):
      if data == "stop button":
         if self.record_button.get_active():
            self.can_stop = True
            self.record_button.set_active(False)
            self.parent.left_unlit_image.show()
            self.parent.left_amber_image.hide()
            self.parent.left_red_image.hide()
      if data == "record button":
         if self.is_recording:
            if self.can_stop == True:
               self.can_stop = False
               self.stop_recording()
            else:
               widget.set_active(True)
         else:
            if self.is_recording == False:
               self.start_recording()
               self.parent.left_unlit_image.hide()
               self.parent.left_amber_image.hide()
               self.parent.left_red_image.show()
               if self.is_recording == False:
                  self.stop_button.clicked()
      if data == "pause button":
         if widget.get_active() and self.is_recording == False:
            widget.set_active(False)
         else:
            self.servermodule_write("RECP=%1d\nACTN=Pause\nend\n" % widget.get_active())
            if widget.get_active():
               self.parent.left_amber_image.show()
               self.parent.left_red_image.hide()
            else:
               self.parent.left_amber_image.hide()
               if self.is_recording:
                  self.parent.left_red_image.show()
      if data == "autopause":
         self.servermodule_write("AUTP=%1d\nACTN=Pause\nend\n" % widget.get_active())
 
   def cancel_autoshutdown(self):
      if self.discon_button.get_active():
         self.discon_button.set_active(False)
         print "Automatic connection shutdown was cancelled"

   def __init__(self, parent):
                             
      self.parent = parent
      
      self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
      self.parent.window_group.add_window(self.window)
      self.window.set_title(server_window_text)
      self.window.set_destroy_with_parent(True)
      self.window.set_border_width(11)
      self.window.set_resizable(False)
      self.window.connect("delete_event", self.delete_event)
      self.window.set_icon_from_file(pkgdatadir + "icon" + gfext)
           
      self.vbox = gtk.VBox()
      self.vbox.set_border_width(0)
      self.window.add(self.vbox)
      self.vbox.show()
      
      self.hbox = gtk.HBox()
      self.hbox.set_border_width(0)
      self.hbox.set_spacing(7)
      self.vbox.pack_start(self.hbox, True, True, 0)
      self.hbox.show()
      
      self.server_frame = gtk.Frame(" " + connection_text + " ")
      self.server_frame.set_sensitive(shoutenabled)
      self.server_frame.set_border_width(5)
      servbox = gtk.VBox()
      servbox.set_border_width(10)
      self.server_frame.add(servbox)
      self.server_frame.show()
      servbox.show()
      
      hbox = gtk.HBox()
      label = gtk.Label(server_type_text)
      label.show()

      self.connection_sizegroup = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)

      self.server_type = gtk.combo_box_new_text()
      self.server_type.append_text("Shoutcast")
      self.server_type.append_text("Icecast 2")
      self.server_type.append_text("Icecast")
      self.connection_sizegroup.add_widget(self.server_type)
      self.server_type.connect("changed", self.cb_servertype)
      self.server_type.show()
      hbox.pack_end(self.server_type, False, False, 4)
      hbox.pack_end(label, False, False, 3)     
      hbox.show()
      servbox.pack_start(hbox, True, True, 0)
      
      hbox = gtk.HBox()
      label = gtk.Label(server_hostname_text)
      label.show()
      self.server_entry = gtk.Entry()
      self.server_entry.set_editable(True)
      self.connection_sizegroup.add_widget(self.server_entry)
      self.server_entry.show()
      hbox.pack_end(self.server_entry, False, False, 4)
      hbox.pack_end(label, False, False, 3)
      hbox.show()
      servbox.pack_start(hbox, True, True, 0)
             
      hbox = gtk.HBox()
      label = gtk.Label(server_port_text)
      label.show()

      self.port_adj = gtk.Adjustment(8000, 0, 65535, 1, 1, 1)
      self.port_entry = gtk.SpinButton(self.port_adj, 0.4, 0)
      self.port_entry.set_name("Port number")
      self.port_entry.set_editable(True)
      self.connection_sizegroup.add_widget(self.port_entry)
      self.port_entry.show()
      hbox.pack_end(self.port_entry, False, False, 4)
      hbox.pack_end(label, False, False, 3)      
      hbox.show()
      servbox.pack_start(hbox, True, True, 0)
      
      hbox = gtk.HBox()
      label = gtk.Label(server_mount_text)
      label.show()
      self.mount_entry = gtk.Entry()
      self.mount_entry.set_editable(True)
      self.connection_sizegroup.add_widget(self.mount_entry)
      self.mount_entry.set_text("/listen.ogg")
      self.mount_entry.show()      
      hbox.pack_end(self.mount_entry, False, False, 4)
      hbox.pack_end(label, False, False, 3)
      hbox.show()
      servbox.pack_start(hbox, True, True, 0)

      hbox = gtk.HBox()
      label = gtk.Label(server_login_text)
      label.show()
      self.login_entry = gtk.Entry()
      self.login_entry.set_editable(True)
      self.connection_sizegroup.add_widget(self.login_entry)
      self.login_entry.set_text("source");
      self.login_entry.show()      
      hbox.pack_end(self.login_entry, False, False, 4)
      hbox.pack_end(label, False, False, 3)
      hbox.show()
      servbox.pack_start(hbox, True, True, 0)
            
      hbox = gtk.HBox()
      label = gtk.Label(server_password_text)
      label.show()
      self.password_entry = gtk.Entry()
      self.password_entry.set_editable(True)
      self.password_entry.set_visibility(False)
      self.connection_sizegroup.add_widget(self.password_entry)
      self.password_entry.connect("activate", self.cb_connect, "pwtrigger")
      self.password_entry.show()      
      hbox.pack_end(self.password_entry, False, False, 4)
      hbox.pack_end(label, False, False, 3)
      hbox.show()
      servbox.pack_start(hbox, True, True, 0)
      
      self.hbox.pack_start(self.server_frame, True, True, 0)
      
      encoding_frame = gtk.Frame (" " + encoding_text + " ")
      encoding_frame.set_sensitive(shoutenabled)
      encoding_frame.set_border_width(5)
      enc_vbox = gtk.VBox()
      enc_vbox.set_border_width(5)
      encoding_frame.add(enc_vbox)
      self.hbox.pack_start(encoding_frame, True, True, 0)
      encoding_frame.show()
      
      format_vbox = gtk.VBox()
      format_vbox.set_spacing(4)
      enc_vbox.pack_start(format_vbox, True, True, 8)
      label = gtk.Label(format_text)
      format_vbox.pack_start(label, False, False, 0)
      label.show()
      
      sizegroup = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
      stream_format_box = gtk.HBox()
      self.stream_format = gtk.combo_box_new_text()
      self.stream_format.append_text("mp3")
      self.stream_format.append_text("ogg")
      self.stream_format.set_active(0)
      self.stream_format.connect("changed", self.cb_encoding, "format")
      stream_format_box.pack_start(self.stream_format, True, False, 0)
      self.stream_format.show()
      format_vbox.pack_start(stream_format_box, False, False, 0)
      stream_format_box.show()
      sizegroup.add_widget(self.stream_format)
      format_vbox.show()
            
      bitrate_vbox = gtk.VBox()
      bitrate_vbox.set_spacing(4)
      enc_vbox.pack_start(bitrate_vbox, True, True, 8)
      label = gtk.Label(bitrate_text)
      bitrate_vbox.pack_start(label, False, False, 0)
      label.show() 
            
      stream_bitrate_box = gtk.HBox()
      bitrate_vbox.pack_start(stream_bitrate_box, False, False, 0)
            
      self.mp3_stream_bitrate = gtk.combo_box_new_text()
      self.mp3_stereolist = []
      for each in ("320", "256", "192", "160", "128", "96", "64", "48", "32", "24"):
         self.mp3_stream_bitrate.append_text(each)
         self.mp3_stereolist.append("1")
      self.mp3_stereolist[-1] = "0"
      self.mp3_stereolist[-2] = "0"
      self.mp3_stereolist[-3] = "0"
      self.mp3_stream_bitrate.set_active(4)
      self.mp3_stream_bitrate.connect("changed", self.cb_encoding, "mp3bitrate")
      stream_bitrate_box.pack_start(self.mp3_stream_bitrate, True, False, 0)
      self.mp3_stream_bitrate.show()
      sizegroup.add_widget(self.mp3_stream_bitrate)
      
      self.ogg_stream_bitrate = gtk.combo_box_new_text()
      self.ogg_stereolist = []
      for each in ("320", "256", "192", "160", "128", "96", "64", "48", "32", "320 ABR", "256 ABR", "192 ABR", "160 ABR", "128 ABR", "96 ABR", "64 ABR", "48 ABR", "32 ABR"):
         self.ogg_stream_bitrate.append_text(each)
         self.ogg_stereolist.append("1")
      self.ogg_stereolist[-1] = "0"
      self.ogg_stereolist[8] = "0"
      self.ogg_stream_bitrate.set_active(4)
      self.ogg_stream_bitrate.connect("changed", self.cb_encoding, "oggbitrate")
      stream_bitrate_box.pack_start(self.ogg_stream_bitrate, True, False, 0)
      sizegroup.add_widget(self.ogg_stream_bitrate)
      
      self.bitratewidgetlist = (self.mp3_stream_bitrate, self.ogg_stream_bitrate)
       
      stream_bitrate_box.show()
      bitrate_vbox.show()
      
      stereo_checkbox_hbox = gtk.HBox()
      self.stereo_checkbox = gtk.CheckButton(stereo_text)
      self.stereo_checkbox.set_active(True)
      self.stereo_checkbox.connect("toggled", self.cb_encoding, "stereotoggle")
      stereo_checkbox_hbox.pack_start(self.stereo_checkbox, True, False, 0)
      self.stereo_checkbox.show()
      self.hq_checkbox = gtk.CheckButton(high_quality_abbrev_text)
      stereo_checkbox_hbox.pack_start(self.hq_checkbox, True, False, 0)
      self.hq_checkbox.show()
      
      enc_vbox.pack_start(stereo_checkbox_hbox, True, False, 8)
      stereo_checkbox_hbox.show()
      
      enc_vbox.show()
      
      other_data_box = gtk.VBox()
      other_data_box.set_border_width(7)
            
      self.misc_data_box = gtk.HBox()
      self.misc_data_box.set_border_width(4)
      other_data_box.pack_start(self.misc_data_box, True, True, 0)
      self.misc_data_box.show()
      
      self.misc_data_label_box = gtk.VBox()
      self.misc_data_label_box.set_border_width(0)
      self.misc_data_box.pack_start(self.misc_data_label_box, False, False, 0)
      self.misc_data_label_box.show()
      
      self.misc_data_entry_box = gtk.VBox()
      self.misc_data_entry_box.set_border_width(0)
      self.misc_data_box.pack_start(self.misc_data_entry_box, True, True, 0)
      self.misc_data_entry_box.show()
      
      label = gtk.Label(dj_name_text)
      box = gtk.HBox()
      box.pack_end(label, False, False, 3)
      box.show()
      self.misc_data_label_box.pack_start(box, True, True, 0)
      label.show()
      
      self.name_entry = gtk.Entry()
      self.name_entry.set_editable(True)
      self.name_entry.set_size_request(10, -1)
      box = gtk.HBox()
      box.pack_start(self.name_entry, True, True, 3)
      box.show()
      self.misc_data_entry_box.pack_start(box, True, True, 0)
      self.name_entry.show()
      
      label = gtk.Label(listen_url_text)
      box = gtk.HBox()
      box.pack_end(label, False, False, 3)
      box.show()
      self.misc_data_label_box.pack_start(box, True, True, 0)
      label.show()
      
      self.url_entry = gtk.Entry()
      self.url_entry.set_editable(True)
      self.url_entry.set_size_request(10, -1)
      box = gtk.HBox()
      box.pack_start(self.url_entry, True, True, 3)
      box.show()
      self.misc_data_entry_box.pack_start(box, True, True, 0)
      self.url_entry.show()
      
      label = gtk.Label(description_text)
      box = gtk.HBox()
      box.pack_end(label, False, False, 3)
      box.show()
      self.misc_data_label_box.pack_start(box, True, True, 0)
      label.show()
      
      self.description_entry = gtk.Entry()
      self.description_entry.set_editable(True)
      self.description_entry.set_size_request(10, -1)
      box = gtk.HBox()
      box.pack_start(self.description_entry, True, True, 3)
      box.show()
      self.misc_data_entry_box.pack_start(box, True, True, 0)
      self.description_entry.show()
      
      label = gtk.Label(genre_text)
      box = gtk.HBox()
      box.pack_end(label, False, False, 3)
      box.show()
      self.misc_data_label_box.pack_start(box, True, True, 0)
      label.show()
      
      self.genre_entry = gtk.Entry()
      self.genre_entry.set_editable(True)
      self.genre_entry.set_size_request(10, -1)
      box = gtk.HBox()
      box.pack_start(self.genre_entry, True, True, 3)
      box.show()
      self.misc_data_entry_box.pack_start(box, True, True, 0)
      self.genre_entry.show()
      
      label = gtk.Label(metadata_text)
      box = gtk.HBox()
      box.pack_end(label, False, False, 3)
      box.show()
      self.misc_data_label_box.pack_start(box, True, True, 0)
      label.show()
      
      self.metadata_entry = gtk.Entry()
      self.metadata_entry.set_text("%s")
      self.metadata_entry.set_editable(True)
      self.metadata_entry.set_size_request(10, -1)
      box = gtk.HBox()
      box.pack_start(self.metadata_entry, True, True, 3)
      box.show()
      self.misc_data_entry_box.pack_start(box, True, True, 0)
      self.metadata_entry.show()
      
      self.update_button = gtk.Button(update_text)
      self.update_button.set_sensitive(False)
      self.update_button.connect("clicked", self.cb_update)
      box.pack_start(self.update_button, False, False, 4)
      self.update_button.show()
      
      other_option_box = gtk.HBox()
      other_option_box.set_border_width(7)
      other_data_box.pack_start(other_option_box, True, True, 0)
      other_option_box.show()
      
      self.metadata_check = gtk.CheckButton(send_metadata_text)
      self.metadata_check.set_active(True)
      other_option_box.pack_start(self.metadata_check, True, False, 10)
      self.metadata_check.show()
      
      self.publish_check = gtk.CheckButton(make_public_text)
      other_option_box.pack_start(self.publish_check, True, False, 10)
      self.publish_check.show()
 
      other_data_box.show()
      other_frame = gtk.Frame(" " + stream_info_text + " ")
      other_frame.set_sensitive(shoutenabled)
      other_frame.set_border_width(5)
      other_frame.add(other_data_box)
      self.vbox.pack_start(other_frame)
      other_frame.show()
      
      self.connect_box = gtk.HBox()
      self.connect_box.set_sensitive(shoutenabled)
      self.connect_box.set_border_width(5)
      self.connect_box.set_spacing(20)
      self.connect_button = gtk.ToggleButton(server_connect_text)
      self.connect_button.connect("toggled", self.cb_connect, "connect")
      self.connect_button.show()
      self.connect_box.pack_start(self.connect_button, True, True, 0)
      
      self.discon_box = gtk.HBox()
      self.discon_box.set_sensitive(shoutenabled)
      self.discon_box.set_spacing(5)
      self.connect_box.pack_end(self.discon_box, False, False, 0)
      self.discon_box.show()
      
      self.discon_button = gtk.CheckButton(until_text)
      self.discon_button.connect("toggled", self.cb_discon, "Disconnect")
      self.discon_button.show()
      self.discon_box.pack_start(self.discon_button, False, False, 0)
      
      self.time_entry = gtk.Entry(5)
      self.time_entry.set_sensitive(False)
      self.time_entry.set_width_chars(5)
      self.time_entry.show()
      self.discon_box.pack_start(self.time_entry, False, False, 0)
      
      self.vbox.pack_start(self.connect_box, True, True, 2)
      self.connect_box.show()
      
      self.server_type.set_active(0)
      
      self.server_on_f = False
      
      frame = gtk.Frame(" " + record_text + " ")
      frame.set_border_width(5)
      self.vbox.pack_start(frame, False, False, 0)
      recordvbox = gtk.VBox()
      recordvbox.set_border_width(6)
      frame.add(recordvbox)
      frame.show()
      recordline1box = gtk.HBox()
      recordline1box.set_border_width(4)
      recordline1box.set_spacing(6)
      recordvbox.pack_start(recordline1box, False, False, 0)
      recordline1box.show()
      recordline2box = gtk.HBox()
      recordline2box.set_border_width(4)
      recordline2box.set_spacing(6)
      recordvbox.pack_start(recordline2box, False, False, 0)
      recordline2box.show()
      recordvbox.show()

      pixbuf = gtk.gdk.pixbuf_new_from_file(pkgdatadir + "rec" + gfext)
      pixbuf = pixbuf.scale_simple(14, 14, gtk.gdk.INTERP_BILINEAR)
      recimage = gtk.Image()
      recimage.set_from_pixbuf(pixbuf)
      self.record_button = gtk.ToggleButton()
      self.record_button.add(recimage)
      recimage.show()
      recordline1box.pack_start(self.record_button, False, False, 0)
      self.record_button.connect("toggled", self.cb_record, "record button")
      self.record_button.show()
      
      stopimage = gtk.Image()
      stopimage.set_from_file(pkgdatadir + "stop" + gfext)
      self.stop_button = gtk.Button()
      self.stop_button.add(stopimage)
      stopimage.show()
      recordline1box.pack_start(self.stop_button, False, False, 1)
      self.stop_button.connect("clicked", self.cb_record, "stop button")
      self.stop_button.show()
      
      label = gtk.Label(record_filename_text)
      recordline1box.pack_start(label, False, False, 0)
      label.show()
      
      self.recfile = gtk.Entry()
      self.recfile.set_text("~/savefile")
      self.recfile.set_width_chars(10)
      recordline1box.pack_start(self.recfile, True, True, 0)
      self.recfile.show()
      
      self.rec_mode = gtk.combo_box_new_text()
      self.rec_mode.append_text("MP3 256")
      self.rec_mode.append_text("MP3 192")
      self.rec_mode.append_text("MP3 128")
      self.rec_mode.append_text("MP3 96")
      self.rec_mode.append_text("MP3 64")
      self.rec_mode.append_text("MP3 32")
      self.rec_mode.append_text("OGG Q6")
      self.rec_mode.append_text("OGG Q4")
      self.rec_mode.append_text("OGG Q2")
      self.rec_mode.append_text("OGG Q1")
      self.rec_mode.append_text("OGG Q0")
      self.rec_mode.append_text("OGG Q-1")
      self.rec_mode.set_active(1)
      recordline1box.pack_start(self.rec_mode, False, False, 0)
      self.rec_mode.show()
      
      autopauseimage = gtk.Image()
      autopauseimage.set_from_file(pkgdatadir + "pause_yellow" + gfext)
      self.autopausebutton = gtk.ToggleButton()
      self.autopausebutton.add(autopauseimage)
      autopauseimage.show()
      recordline1box.pack_start(self.autopausebutton, False, False, 1)
      self.autopausebutton.connect("toggled", self.cb_record, "autopause")
      self.autopausebutton.show()
      
      pauseimage = gtk.Image()
      pauseimage.set_from_file(pkgdatadir + "pause" + gfext)
      self.pause_button = gtk.ToggleButton()
      self.pause_button.add(pauseimage)
      pauseimage.show()
      recordline1box.pack_start(self.pause_button, False, False, 1)
      self.pause_button.connect("toggled", self.cb_record, "pause button")
      self.pause_button.show()     
      
      label = gtk.Label(record_artist_text)
      recordline2box.pack_start(label, False, False, 0)
      label.show()
      self.artist_entry = gtk.Entry()
      self.artist_entry.set_width_chars(10)
      self.artist_entry.set_max_length(30)
      recordline2box.pack_start(self.artist_entry, True, True, 0)
      self.artist_entry.show()
      
      label = gtk.Label(record_title_text)
      recordline2box.pack_start(label, False, False, 0)
      label.show()
      self.title_entry = gtk.Entry()
      self.title_entry.set_width_chars(10)
      self.title_entry.set_max_length(30)
      recordline2box.pack_start(self.title_entry, True, True, 0)
      self.title_entry.show()
      
      self.can_stop = False
      self.is_recording = False
      self.is_saving = False
      self.is_paused = False
      self.lasttotal = 0
      
      self.save_widgets = [ self.recfile, self.rec_mode, self.artist_entry, self.title_entry ]
      
      # Dialog windows for when there is a problem with the server connection.
      
      self.dialog_group = dialog_group()
      self.disconnected_dialog = error_notification_dialog(self.dialog_group, self.parent.window_group, disconnected_text, unexpected_text)
      self.timed_out_dialog = error_notification_dialog(self.dialog_group, self.parent.window_group, disconnected_text, timed_out_text)
      self.autoshutdown_dialog = error_notification_dialog(self.dialog_group, self.parent.window_group, disconnected_text, autoshutdown_text)
      self.oneminwarn = autodisconnection_notification_dialog(self.dialog_group, self.parent.window_group, disconnection_text, discon_warn_text, None, self.cancel_autoshutdown)
      self.autoreconnect_dialog = error_notification_dialog(self.dialog_group, self.parent.window_group, reconnected_text, reconnected_additional_text)

      # Launch the server connection client
      (self.serv_cmd, self.serv_rply) = os.popen2([libexecdir + "idjcserver"], 16384)
      reply = self.serv_rply.readline()
      if reply != "up\n":
         print "Bad reply from idjc-server\n"
	 sys.exit(5)
         
      # This will poll the server code asking for updates on the connection status once every 500ms.
      self.servmon_source_id = gobject.timeout_add(250, self.server_monitor)
