/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

/*
 * $Id: imaux-int.h,v 1.3 2004/02/19 00:51:53 tajima Exp $
 */

#ifndef _IIIMP_AUX_P_H
#define _IIIMP_AUX_P_H

#include <iiimcf.h>
#include <X11/Xlib.h>		/* inevitable X dependency */
#include "imaux.h"

#define AUX_DIR_SYMBOL		"aux_dir"
#define AUX_CONF_MAGIC		"# IIIM X auxiliary"
#define AUX_INFO_SYMBOL		"aux_info"

typedef struct _aux aux_t;
typedef struct _aux_ic_data	aux_ic_data_t;
typedef struct _aux_service	aux_service_t;
typedef struct _aux_im_data	aux_im_data_t;

struct _aux {
  aux_ic_data_t *ic;		/* input context */
  aux_service_t *service;	/* Aux service method */
  aux_im_data_t *im;		/* current IM */
  aux_im_data_t *im_list;	/* list of IM structure */
};

typedef enum {
  AUX_DATA_NONE = 0,
  AUX_DATA_START = 1,
  AUX_DATA_DRAW = 2,
  AUX_DATA_DONE = 3,
  AUX_DATA_SETVALUE = 4,
  AUX_DATA_GETVALUE = 5,
  AUX_DATA_GETVALUE_REPLY = 6
} aux_data_type_t;

typedef struct {
  int length;
  unsigned char *ptr;
} aux_string_t;

typedef struct {
  aux_data_type_t type;
  int im;
  int ic;
  int aux_index;
  int aux_name_length;
  unsigned char *aux_name;
  int integer_count;
  int *integer_list;
  int string_count;
  aux_string_t *string_list;
  unsigned char *string_ptr;
} aux_data_t;

struct _aux_service {
  void (*aux_setvalue)(aux_t *, const unsigned char *, int);
  int  (*im_id)(aux_t *);
  int  (*ic_id)(aux_t *);
  void (*data_set)(aux_t *, int, void *);
  void *(*data_get)(aux_t *, int);
  Display *(*display)(aux_t *);
  Window (*window)(aux_t *);
  XPoint *(*point)(aux_t *, XPoint *);
  XPoint *(*point_caret)(aux_t *, XPoint *);
  size_t (*utf16_mb)(const char **, size_t *,
		     char **, size_t *);
  size_t (*mb_utf16)(const char **, size_t *,
		     char **, size_t *);
  unsigned char *(*compose)(const aux_data_t *, int *);
  int (* compose_size)(aux_data_type_t,
		       const unsigned char *);
  aux_data_t *(*decompose)(aux_data_type_t, const unsigned char *);
  void (*decompose_free)(aux_data_t *);
  void (*register_X_filter)(Display *, Window, int, int, 
			    Bool (*filter)(Display *,
					   Window,
					   XEvent *,
					   XPointer),
			    XPointer);
  void (*unregister_X_filter)(Display *, Window,
			      Bool (* filter)(Display *,
					      Window,
					      XEvent *,
					      XPointer),
			      XPointer);
  Bool (*server)(aux_t *);
  Window (*client_window)(aux_t *);
  Window (*focus_window)(aux_t *);
  int (*screen_number)(aux_t *);
  int (*point_screen)(aux_t *, XPoint *);
  int (*point_caret_screen)(aux_t *, XPoint *);
  Bool (*get_conversion_mode)(aux_t*);
  void (*set_conversion_mode)(aux_t*, int);
	/* if_version(1st arg of register_service()) >= AUX_IF_VERSION_2 */
  void (*aux_getvalue)(aux_t *, const unsigned char *, int);
  aux_t *(* aux_get_from_id)(int im_id, int ic_id,
			     IIIMP_card16 *aux_name, int aux_name_length);
};

typedef struct _aux_method {
  gboolean (*create)(aux_t *);
  gboolean (*start)(aux_t *, const unsigned char *, int);
  gboolean (*draw)(aux_t *, const unsigned char *, int);
  gboolean (*done)(aux_t *, const unsigned char *, int);
  gboolean (*switched)(aux_t *, int, int);
  gboolean (*destroy)(aux_t *);
	/* aux_info_t.if_version >= AUX_IF_VERSION_2 */
  gboolean (*getvalues_reply)(aux_t *, const unsigned char *, int);
  gboolean (*destroy_ic)(aux_t *);
  gboolean (*set_icforcus)(aux_t *);
  gboolean (*unset_icforcus)(aux_t *);
} aux_method_t;

typedef struct {
  int len;
  IIIMP_card16 *ptr;
} aux_name_t;

typedef struct {
  aux_name_t name;
  aux_method_t *method;
} aux_dir_t;

typedef struct {
  unsigned int if_version;		/* >= AUX_IF_VERSION_2 */
  gboolean (* register_service)(unsigned int  if_version,
				aux_service_t *service);
  aux_dir_t *dir;
} aux_info_t;
#define	AUX_IF_VERSION_2	0x00020000

typedef struct _aux_entry {
  int created;
  aux_dir_t dir;
  struct _aux_entry *next;
  unsigned int if_version;
} aux_entry_t;

typedef struct _aux_handle {
  aux_name_t aux_name;
  char *file_name;
  void *handle;
  aux_entry_t *ae;
  int ae_num;
  struct _aux_handle *next;
} aux_handle_t;

struct _aux_im_data {
  int im_id;
  int ic_id;
  aux_entry_t *ae;
  void *data;
  aux_im_data_t *next;
};

typedef struct _aux_ic_info {
  int im_id;
  int ic_id;
  aux_ic_data_t *ic_data;
  struct _aux_ic_info *next;
} aux_ic_info_t;

#endif

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
