#ifndef ICHANDLER_HH_
#define ICHANDLER_HH_
#include <string>
#include <vector>
#include <SunIM.h>
#include "basictype.hh"

class IMCharSubsets
{
    typedef vector<int> IMCharSubsetIDXVec;
    IMCharSubsetIDXVec imcsvec;

  public:
    const int* get_c_csidices();
    void add_csidx(int idx);

    IMCharSubsets();
};

class ICAttribute
{
  private:
    u16string inputmethod;
    u16string inputlanguage;
    u16string inputengine;
    IMCharSubsets charsubsets;

  public:
    void set_inputmethod(const u16string& imname)
    { inputmethod = imname; }
    void set_inputlanguage(const u16string& langname)
    { inputlanguage = langname; }
    void set_inputengine(const u16string& imename)
    { inputengine = imename; }
    void set_charsubsets(const IMCharSubsets &subsets)
    { charsubsets = subsets; }

    // void merge(ICAttribute &attr);

    const u16string& get_inputmethod() const { return inputmethod; }
    const u16string& get_inputlanguage() const { return inputlanguage; }
    const u16string& get_inputengine() const { return inputengine; }
    IMCharSubsets& get_character_subsets() { return charsubsets; }
};

class IMLExec
{
  public:
    enum IML_EXITCODE {
	    IML_EXIT_SUCCESS = 1
    };
    virtual iml_inst* push_insts(
	iml_inst **rrv
    ) = 0;
    virtual ~IMLExec() {}
};

class ICHandler
{
  public:
    virtual bool send_event(
	IMLExec* pimlex,
	IMInputEvent* pimevent
    ) = 0;
    virtual bool send_event_getvalues(
	IMLExec* pimlex,
	IMInputEvent* pimevent
    ) = 0;
    virtual bool send_event_getvalues_finished(
	IMLExec* pimlex
    ) = 0;
    virtual const ICAttribute& get_icattr() = 0;
    virtual bool set_icattr(
    	const ICAttribute &attr
    ) = 0;
    virtual bool invoke_desktop_listener(
	IMLExec *pimlex,
        int listener_id,
        int file_size,
        void *ptr
    ) = 0;
    virtual iml_desktop_t *get_current_desktop() = 0;
    virtual bool toggle_conversion(
	IMLExec *pimlex,
	bool flag
    ) = 0;
    virtual bool reset(
	IMLExec *pimlex
    ) = 0;
    virtual bool destroy(
	IMLExec *pimlex
    ) = 0;
    virtual void destroy() = 0;

    /* obsolete API!!!! */
    virtual bool toggle_focus(
	IMLExec *pimlex,
	bool flag
    ) = 0;
};

#endif /* not ICHANDLER_HH_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
