/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdlib.h>
#include <string.h>

#ifdef HAVE_CRYPT
#ifdef HAVE_CRYPT_H
#include <crypt.h>
#else
#include <unistd.h>
#endif
#endif

#ifdef HAVE_PWENT
#include <sys/types.h>
#include <pwd.h>
#endif

#include "iwrap.h"
#include "IMUserMgr.hh"

int
IMUserMgr::
adjust_pue_slot_size(int num)
{
  alloced_ue_num = num;
  pue = (userentry*) realloc(pue, sizeof(userentry) * alloced_ue_num);
  if (!pue) return 0;
  return 1;
}

int
IMUserMgr::
check_password_with_crypt(
    const char *pwd,
    const char *enc_pwd
)
{
  char *p;
#ifdef HAVE_CRYPT
  if (!(p = crypt(pwd, enc_pwd)))
    return 0;
  if (!strcmp(p, enc_pwd))
    return 1;
  return 0;
#else
  return 0;
#endif
}


IMAuth::access_type
IMUserMgr::
get_internal_userentry(
    const char *user,
    const char *password
)
{
  int i;
  userentry *pe;

  pe = pue;
  for (i = 0;i < ue_num;i++, pe++)
    {
      if (strcmp(pe->username, user) != 0) continue;
      if (pe->at == IMAuth::PASSWORD)
	{
	  if (password
	      && pe->password
	      && (check_password_with_crypt(password, pe->password)))
	    return IMAuth::PERMIT;
	  return IMAuth::DENY;
	}
      else
	return pe->at;
    }
  return IMAuth::UNKNOWN;
}

int
IMUserMgr::
check_password(
    int fd,
    const char *user,
    const char *password
)
{
  IMAuth::access_type at;

  at = get_internal_userentry(user, password);

#ifdef HAVE_UNIX_SOCKET
  // when a user connects with unix domain,
  // try to authenicate with unix credential.
  int auth_type = get_auth_type();
  if (auth_type == IMAuth::UNIX) {
    // in the case of user doesn't specify a configuration file
    // we use at instead of sysuser_at.
    if (at != IMAuth::DENY) {
      int ret = authenticate_with_unix(fd, user, NULL,
				      get_command_name(),
				      get_from_hostname());
      if (ret >= 0) {
	return ret;
      }
      // if this system doesn't support it,
      // fall through to the normal operation.
    } else {
        return 0;
    }
  }
#endif
  if (at == IMAuth::PERMIT) return 1;
  else if (at == IMAuth::DENY) return 0;
#ifdef HAVE_PAM
  if (sysuser_at == IMAuth::PERMIT)
    return authenticate_with_pam(user, NULL,
				 get_command_name(),
				 get_from_hostname());
  else if (password && (sysuser_at == IMAuth::PASSWORD))
    return authenticate_with_pam(user, password,
				 get_command_name(),
				 get_from_hostname());
  else
    return 0;
#else
#ifdef HAVE_PWENT
  {
    struct passwd *pwd;
#ifdef HAVE_PWNAM_R
#ifndef NSS_BUFLEN_PASSWD
#define NSS_BUFLEN_PASSWD 1024
#endif
    struct passwd pwd_buf;
    char buf[NSS_BUFLEN_PASSWD];

    if ((getpwnam_r(user, &pwd_buf, buf, sizeof(buf), &pwd)) != 0) return 0;
#else
    if (!(pwd = getpwnam(user))) return 0;
#endif
    if (sysuser_at == IMAuth::PERMIT) return 1;
    if (sysuser_at == IMAuth::PASSWORD)
      {
	if (password
	    &&(check_password_with_crypt(password, pwd->pw_passwd)))
	  return 1;
	return 0;
      }
  }
#endif
#endif
  return 0;
}

int
IMUserMgr::
add_user(
    const char *user,
    const char *password,
    access_type at
)
{
  char *u1, *p1;

  if (alloced_ue_num <= ue_num)
    {
      if (!adjust_pue_slot_size((alloced_ue_num + 1) * 2))
	return 0;
    }

  u1= strdup(user);
  if (!u1) return 0;
  if (password)
    {
      p1 = strdup(password);
      if (!p1)
	{
	  free(u1);
	  return 0;
	}
    }
  else
    p1 = NULL;
  pue[ue_num].username = u1;
  pue[ue_num].password = p1;
  pue[ue_num].at = at;
  ue_num++;

  return 1;
}

IMUser*
IMUserMgr::
create_imuser(
    int fd,
    const char *user,
    const char *password
)
{
    IMUser *puser;
    IMUserMap::iterator it;

    if (!auth_fd(fd, user, password)) return NULL;
    u16string ustr = user;
    
    it = usermap.find(ustr);
    if (it != usermap.end()) return it->second;
    puser = new IMUser(u16string(user));

    pair<IMUserMap::iterator, bool> r =  usermap.insert(IMUserMap::value_type(ustr, puser));
    if (!r.second) return NULL;

    return puser;
}


IMUserMgr::
IMUserMgr()
  : IMAuth()
{
  pue = NULL;
  ue_num = alloced_ue_num = 0;
  sysuser_at = IMAuth::DENY;
}

IMUserMgr::
~IMUserMgr()
{
  int i;
  for (i = 0;i < ue_num;i++)
    {
      if (pue[i].username) free(pue[i].username);
      if (pue[i].password) free(pue[i].password);
    }
  if (pue) free(pue);

  delete_all(usermap);
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
