/******************************************************************
 
         Copyright 1994, 1995 by Sun Microsystems, Inc.
         Copyright 1993, 1994 by Hewlett-Packard Company
 
Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Sun Microsystems, Inc.
and Hewlett-Packard not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.
Sun Microsystems, Inc. and Hewlett-Packard make no representations about
the suitability of this software for any purpose.  It is provided "as is"
without express or implied warranty.
 
SUN MICROSYSTEMS INC. AND HEWLETT-PACKARD COMPANY DISCLAIMS ALL
WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SUN MICROSYSTEMS, INC. AND HEWLETT-PACKARD COMPANY BE LIABLE FOR ANY
SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 
  Author: Hidetoshi Tajima(tajima@Eng.Sun.COM) Sun Microsystems, Inc.
 
******************************************************************/
#include <X11/Xlib.h>
#include "X11R6IMProtoData.h"
#include "Xi18n.h"
#include "FrameMgr.h"

extern int _Xi18nNeedSwap(Xi18n i18n_core, CARD16 connect_id);
extern void _Xi18nSendMessage(XIMS ims, CARD16 connect_id,
			      CARD8 major_opcode, CARD8 minor_opcode,
			      unsigned char *data, long length);

int
_Xi18nGeometryCallback(XIMS ims, X11R6IMProtocol call_data)
{
    Xi18n i18n_core = ims->protocol;
    FrameMgr fm;
    extern XimFrameRec geometry_fr[];
    int total_size;
    unsigned char *reply = NULL;
    IMGeometryCBStruct *geometry_CB =
      (IMGeometryCBStruct*)&call_data->geometry_callback;
    CARD16 connect_id = call_data->any.connect_id;

    /* create FrameMgr */
    fm = FrameMgrInit(geometry_fr, NULL,
		      _Xi18nNeedSwap(i18n_core, connect_id));

    total_size = FrameMgrGetTotalSize(fm);
    reply = (unsigned char *)malloc(total_size);
    if (!reply) {
	_Xi18nSendMessage(ims, connect_id, XIM_ERROR, 0, 0, 0);
	return False;
    }
    memset(reply, 0, total_size);
    FrameMgrSetBuffer(fm, reply);

    FrameMgrPutToken(fm, connect_id);
    FrameMgrPutToken(fm, geometry_CB->icid);

    _Xi18nSendMessage(ims, connect_id,
		      XIM_GEOMETRY, 0, reply, total_size);
    /* free FrameMgr */
    FrameMgrFree(fm);
    XFree(reply);

    /* XIM_GEOMETRY is an asyncronous protocol,
       so return immediately. */
    return True;
}

int
_Xi18nPreeditStartCallback(XIMS ims, X11R6IMProtocol call_data)
{
    Xi18n i18n_core = ims->protocol;
    FrameMgr fm;
    extern XimFrameRec preedit_start_fr[];
    int total_size;
    unsigned char *reply = NULL;
    IMPreeditCBStruct *preedit_CB =
      (IMPreeditCBStruct*)&call_data->preedit_callback;
    CARD16 connect_id = call_data->any.connect_id;

    /* create FrameMgr */
    fm = FrameMgrInit(preedit_start_fr, NULL,
		      _Xi18nNeedSwap(i18n_core, connect_id));
    total_size = FrameMgrGetTotalSize(fm);
    reply = (unsigned char *)malloc(total_size);
    if (!reply) {
	_Xi18nSendMessage(ims, connect_id, XIM_ERROR, 0, 0, 0);
	return False;
    }
    memset(reply, 0, total_size);
    FrameMgrSetBuffer(fm, reply);

    FrameMgrPutToken(fm, connect_id);
    FrameMgrPutToken(fm, preedit_CB->icid);

    _Xi18nSendMessage(ims, connect_id,
		      XIM_PREEDIT_START, 0, reply, total_size);
    /* free FrameMgr */
    FrameMgrFree(fm);
    XFree(reply);

    return True;
}

int
_Xi18nPreeditDrawCallback(XIMS ims, X11R6IMProtocol call_data)
{
    Xi18n i18n_core = ims->protocol;
    FrameMgr fm;
    extern XimFrameRec preedit_draw_fr[];
    int total_size;
    unsigned char *reply = NULL;
    IMPreeditCBStruct *preedit_CB =
      (IMPreeditCBStruct*)&call_data->preedit_callback;
    XIMPreeditDrawCallbackStruct *draw =
      (XIMPreeditDrawCallbackStruct *)&preedit_CB->todo.draw;
    CARD16 connect_id = call_data->any.connect_id;
    int feedback_count, i;
    BITMASK32 status = 0x0;
    CARD16 str_length;

    if (draw->text == 0 || draw->text->length == 0) {
      status = 0x00000001;	/* no text */
      feedback_count = 0;
    } else if (draw->text->feedback[0] == 0) {
      status = 0x00000002;	/* no feedback */
      feedback_count = 0;
    } else {
      /* set iteration count for list of feedback */
      for (i = 0;
	   i < draw->text->length && draw->text->feedback[i] != 0;
	   i++)
	;
      feedback_count = i;
    }
    /* create FrameMgr */
    fm = FrameMgrInit(preedit_draw_fr, NULL,
		      _Xi18nNeedSwap(i18n_core, connect_id));

    /* set length of preedit string */
    if (draw->text) {
      str_length = strlen(draw->text->string.multi_byte);
    } else {
      str_length = 0;
    }
    FrameMgrSetSize(fm, str_length);

    FrameMgrSetIterCount(fm, feedback_count);

    total_size = FrameMgrGetTotalSize(fm);
    reply = (unsigned char *)malloc(total_size);
    if (!reply) {
	_Xi18nSendMessage(ims, connect_id, XIM_ERROR, 0, 0, 0);
	return False;
    }
    memset(reply, 0, total_size);
    FrameMgrSetBuffer(fm, reply);

    FrameMgrPutToken(fm, connect_id);
    FrameMgrPutToken(fm, preedit_CB->icid);
    FrameMgrPutToken(fm, draw->caret);
    FrameMgrPutToken(fm, draw->chg_first);
    FrameMgrPutToken(fm, draw->chg_length);
    FrameMgrPutToken(fm, status);
    FrameMgrPutToken(fm, str_length);
    if (draw->text) {
      FrameMgrPutToken(fm, draw->text->string.multi_byte);
      for (i = 0; i < feedback_count; i++) {
	FrameMgrPutToken(fm, draw->text->feedback[i]);
      }
    }
    _Xi18nSendMessage(ims, connect_id,
		      XIM_PREEDIT_DRAW, 0, reply, total_size);
    /* free FrameMgr */
    FrameMgrFree(fm);
    XFree(reply);

    /* XIM_PREEDIT_DRAW is an asyncronous protocol,
       so return immediately. */
    return True;
}

int
_Xi18nPreeditCaretCallback(XIMS ims, X11R6IMProtocol call_data)
{
    Xi18n i18n_core = ims->protocol;
    FrameMgr fm;
    extern XimFrameRec preedit_caret_fr[];
    int total_size;
    unsigned char *reply = NULL;
    IMPreeditCBStruct *preedit_CB =
      (IMPreeditCBStruct*)&call_data->preedit_callback;
    XIMPreeditCaretCallbackStruct *caret =
      (XIMPreeditCaretCallbackStruct *)&preedit_CB->todo.caret;
    CARD16 connect_id = call_data->any.connect_id;

    /* create FrameMgr */
    fm = FrameMgrInit(preedit_caret_fr, NULL,
		      _Xi18nNeedSwap(i18n_core, connect_id));

    total_size = FrameMgrGetTotalSize(fm);
    reply = (unsigned char *)malloc(total_size);
    if (!reply) {
	_Xi18nSendMessage(ims, connect_id, XIM_ERROR, 0, 0, 0);
	return False;
    }
    memset(reply, 0, total_size);
    FrameMgrSetBuffer(fm, reply);

    FrameMgrPutToken(fm, connect_id);
    FrameMgrPutToken(fm, preedit_CB->icid);
    FrameMgrPutToken(fm, caret->position);
    FrameMgrPutToken(fm, caret->direction);
    FrameMgrPutToken(fm, caret->style);

    _Xi18nSendMessage(ims, connect_id,
		      XIM_PREEDIT_CARET, 0, reply, total_size);
    /* free FrameMgr */
    FrameMgrFree(fm);
    XFree(reply);

    return True;
}

int
_Xi18nPreeditDoneCallback(XIMS ims, X11R6IMProtocol call_data)
{
    Xi18n i18n_core = ims->protocol;
    FrameMgr fm;
    extern XimFrameRec preedit_done_fr[];
    int total_size;
    unsigned char *reply = NULL;
    IMPreeditCBStruct *preedit_CB =
      (IMPreeditCBStruct*)&call_data->preedit_callback;
    CARD16 connect_id = call_data->any.connect_id;

    /* create FrameMgr */
    fm = FrameMgrInit(preedit_done_fr, NULL,
		      _Xi18nNeedSwap(i18n_core, connect_id));

    total_size = FrameMgrGetTotalSize(fm);
    reply = (unsigned char *)malloc(total_size);
    if (!reply) {
	_Xi18nSendMessage(ims, connect_id, XIM_ERROR, 0, 0, 0);
	return False;
    }
    memset(reply, 0, total_size);
    FrameMgrSetBuffer(fm, reply);

    FrameMgrPutToken(fm, connect_id);
    FrameMgrPutToken(fm, preedit_CB->icid);

    _Xi18nSendMessage(ims, connect_id,
		      XIM_PREEDIT_DONE, 0, reply, total_size);
    /* free FrameMgr */
    FrameMgrFree(fm);
    XFree(reply);

    /* XIM_PREEDIT_DONE is an asyncronous protocol,
       so return immediately. */
    return True;
}

int
_Xi18nStatusStartCallback(XIMS ims, X11R6IMProtocol call_data)
{
    Xi18n i18n_core = ims->protocol;
    FrameMgr fm;
    extern XimFrameRec status_start_fr[];
    int total_size;
    unsigned char *reply = NULL;
    IMStatusCBStruct *status_CB =
      (IMStatusCBStruct*)&call_data->status_callback;
    CARD16 connect_id = call_data->any.connect_id;

#ifdef  FIX_APPLIXWARE_TURBOLINUX42
	if(getenv("HTT_DISABLE_STATUS_CALLBACK")){
		return True;
	}
#endif

    /* create FrameMgr */
    fm = FrameMgrInit(status_start_fr, NULL,
		      _Xi18nNeedSwap(i18n_core, connect_id));
    total_size = FrameMgrGetTotalSize(fm);
    reply = (unsigned char *)malloc(total_size);
    if (!reply) {
	_Xi18nSendMessage(ims, connect_id, XIM_ERROR, 0, 0, 0);
	return False;
    }
    memset(reply, 0, total_size);
    FrameMgrSetBuffer(fm, reply);

    FrameMgrPutToken(fm, connect_id);
    FrameMgrPutToken(fm, status_CB->icid);

    _Xi18nSendMessage(ims, connect_id,
		      XIM_STATUS_START, 0, reply, total_size);
    /* free FrameMgr */
    FrameMgrFree(fm);
    XFree(reply);

    /* XIM_STATUS_START is an asyncronous protocol,
       so return immediately. */
    return True;
}

int
_Xi18nStatusDrawCallback(XIMS ims, X11R6IMProtocol call_data)
{
    Xi18n i18n_core = ims->protocol;
    FrameMgr fm = NULL;
    extern XimFrameRec status_draw_text_fr[], status_draw_bitmap_fr[];
    int total_size = 0;
    unsigned char *reply = NULL;
    IMStatusCBStruct *status_CB =
      (IMStatusCBStruct*)&call_data->status_callback;
    XIMStatusDrawCallbackStruct *draw =
      (XIMStatusDrawCallbackStruct *)&status_CB->todo.draw;
    CARD16 connect_id = call_data->any.connect_id;
    int feedback_count, i;
    BITMASK32 status = 0x0;
    CARD16 str_length;

#ifdef  FIX_APPLIXWARE_TURBOLINUX42
	if(getenv("HTT_DISABLE_STATUS_CALLBACK")){
		return True;
	}
#endif

    switch (draw->type) {
      case XIMTextType:
	/* create FrameMgr */
	fm = FrameMgrInit(status_draw_text_fr, NULL,
			  _Xi18nNeedSwap(i18n_core, connect_id));

	if (draw->data.text == 0 || draw->data.text->length == 0) {
	  status = 0x00000001;	/* no text */
	  feedback_count = 0;
	} else if (draw->data.text->feedback[0] == 0) {
	  status = 0x00000002;	/* no feedback */
	  feedback_count = 0;
	} else {
	  /* set iteration count for list of feedback */
	  for (i = 0;
	       i < draw->data.text->length && draw->data.text->feedback[i] != 0;
	       i++)
	    ;
	  feedback_count = i;
	}

	/* set length of status string */
	if (draw->data.text) {
	  str_length = strlen(draw->data.text->string.multi_byte);
	} else {
	  str_length = 0;
	}
	FrameMgrSetSize(fm, str_length);

	FrameMgrSetIterCount(fm, feedback_count);

	total_size = FrameMgrGetTotalSize(fm);
	reply = (unsigned char *)malloc(total_size);
	if (!reply) {
	    _Xi18nSendMessage(ims, connect_id, XIM_ERROR, 0, 0, 0);
	    return False;
	}
	memset(reply, 0, total_size);
	FrameMgrSetBuffer(fm, reply);

	FrameMgrPutToken(fm, connect_id);
	FrameMgrPutToken(fm, status_CB->icid);
	FrameMgrPutToken(fm, draw->type);
	FrameMgrPutToken(fm, status);
	FrameMgrPutToken(fm, str_length);
	if (draw->data.text) {
	  FrameMgrPutToken(fm, draw->data.text->string.multi_byte);
	  for (i = 0; i < feedback_count; i++) {
	    FrameMgrPutToken(fm, draw->data.text->feedback[i]);
	  }
	}
	break;
      case XIMBitmapType:
	/* create FrameMgr */
	fm = FrameMgrInit(status_draw_bitmap_fr, NULL,
			  _Xi18nNeedSwap(i18n_core, connect_id));

	total_size = FrameMgrGetTotalSize(fm);
	reply = (unsigned char *)malloc(total_size);
	if (!reply) {
	    _Xi18nSendMessage(ims, connect_id, XIM_ERROR, 0, 0, 0);
	    return False;
	}
	memset(reply, 0, total_size);
	FrameMgrSetBuffer(fm, reply);

	FrameMgrPutToken(fm, connect_id);
	FrameMgrPutToken(fm, status_CB->icid);
	FrameMgrPutToken(fm, draw->data.bitmap);
	break;
    }
    _Xi18nSendMessage(ims, connect_id,
		      XIM_STATUS_DRAW, 0, reply, total_size);
    /* free FrameMgr */
    FrameMgrFree(fm);
    XFree(reply);

    /* XIM_STATUS_DRAW is an asyncronous protocol,
       so return immediately. */
    return True;
}

int
_Xi18nStatusDoneCallback(XIMS ims, X11R6IMProtocol call_data)
{
    Xi18n i18n_core = ims->protocol;
    FrameMgr fm;
    extern XimFrameRec status_done_fr[];
    int total_size;
    unsigned char *reply = NULL;
    IMStatusCBStruct *status_CB =
      (IMStatusCBStruct*)&call_data->status_callback;
    CARD16 connect_id = call_data->any.connect_id;

#ifdef  FIX_APPLIXWARE_TURBOLINUX42
	if(getenv("HTT_DISABLE_STATUS_CALLBACK")){
		return True;
	}
#endif

    /* create FrameMgr */
    fm = FrameMgrInit(status_done_fr, NULL,
		      _Xi18nNeedSwap(i18n_core, connect_id));

    total_size = FrameMgrGetTotalSize(fm);
    reply = (unsigned char *)malloc(total_size);
    if (!reply) {
	_Xi18nSendMessage(ims, connect_id, XIM_ERROR, 0, 0, 0);
	return False;
    }
    memset(reply, 0, total_size);
    FrameMgrSetBuffer(fm, reply);

    FrameMgrPutToken(fm, connect_id);
    FrameMgrPutToken(fm, status_CB->icid);

    _Xi18nSendMessage(ims, connect_id,
		      XIM_STATUS_DONE, 0, reply, total_size);
    /* free FrameMgr */
    FrameMgrFree(fm);
    XFree(reply);

    /* XIM_STATUS_DONE is an asyncronous protocol,
       so return immediately. */
    return True;
}

int
_Xi18nStringConversionCallback(XIMS ims, X11R6IMProtocol call_data)
{
    Xi18n i18n_core = ims->protocol;
    FrameMgr fm;
    extern XimFrameRec str_conversion_fr[];
    int total_size;
    unsigned char *reply = NULL;
    IMStrConvCBStruct *call_back =
      (IMStrConvCBStruct*)&call_data->strconv_callback;
    XIMStringConversionCallbackStruct *strconv =
      (XIMStringConversionCallbackStruct *)&call_back->strconv;
    CARD16 connect_id = call_data->any.connect_id;

    /* create FrameMgr */
    fm = FrameMgrInit(str_conversion_fr, NULL,
		      _Xi18nNeedSwap(i18n_core, connect_id));
    total_size = FrameMgrGetTotalSize(fm);
    reply = (unsigned char *)malloc(total_size);
    if (!reply) {
	_Xi18nSendMessage(ims, connect_id, XIM_ERROR, 0, 0, 0);
	return False;
    }
    memset(reply, 0, total_size);
    FrameMgrSetBuffer(fm, reply);

    FrameMgrPutToken(fm, connect_id);
    FrameMgrPutToken(fm, call_back->icid);
    FrameMgrPutToken(fm, strconv->position);
    FrameMgrPutToken(fm, strconv->factor);
    FrameMgrPutToken(fm, strconv->direction);
    FrameMgrPutToken(fm, strconv->operation);
    _Xi18nSendMessage(ims, connect_id,
		      XIM_STR_CONVERSION, 0, reply, total_size);
    /* free FrameMgr */
    FrameMgrFree(fm);
    XFree(reply);

    /* XIM_STR_CONVERSION is a syncronous protocol,
       so should wait here for XIM_STR_CONVERSION_REPLY. */
    if (i18n_core->methods.wait(ims, connect_id,
				XIM_STR_CONVERSION_REPLY, 0) == False)
      return False;
    return True;
}
