/* GDK - The GIMP Drawing Kit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GTK+ Team and others 1997-2001.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __X11_KEYSYMS_H__
#define __X11_KEYSYMS_H__


#define X11_VoidSymbol 0xFFFFFF
#define X11_BackSpace 0xFF08
#define X11_Tab 0xFF09
#define X11_Linefeed 0xFF0A
#define X11_Clear 0xFF0B
#define X11_Return 0xFF0D
#define X11_Pause 0xFF13
#define X11_Scroll_Lock 0xFF14
#define X11_Sys_Req 0xFF15
#define X11_Escape 0xFF1B
#define X11_Delete 0xFFFF
#define X11_Multi_key 0xFF20
#define X11_Codeinput 0xFF37
#define X11_SingleCandidate 0xFF3C
#define X11_MultipleCandidate 0xFF3D
#define X11_PreviousCandidate 0xFF3E
#define X11_Kanji 0xFF21
#define X11_Muhenkan 0xFF22
#define X11_Henkan_Mode 0xFF23
#define X11_Henkan 0xFF23
#define X11_Romaji 0xFF24
#define X11_Hiragana 0xFF25
#define X11_Katakana 0xFF26
#define X11_Hiragana_Katakana 0xFF27
#define X11_Zenkaku 0xFF28
#define X11_Hankaku 0xFF29
#define X11_Zenkaku_Hankaku 0xFF2A
#define X11_Touroku 0xFF2B
#define X11_Massyo 0xFF2C
#define X11_Kana_Lock 0xFF2D
#define X11_Kana_Shift 0xFF2E
#define X11_Eisu_Shift 0xFF2F
#define X11_Eisu_toggle 0xFF30
#define X11_Kanji_Bangou 0xFF37
#define X11_Zen_Koho 0xFF3D
#define X11_Mae_Koho 0xFF3E
#define X11_Home 0xFF50
#define X11_Left 0xFF51
#define X11_Up 0xFF52
#define X11_Right 0xFF53
#define X11_Down 0xFF54
#define X11_Prior 0xFF55
#define X11_Page_Up 0xFF55
#define X11_Next 0xFF56
#define X11_Page_Down 0xFF56
#define X11_End 0xFF57
#define X11_Begin 0xFF58
#define X11_Select 0xFF60
#define X11_Print 0xFF61
#define X11_Execute 0xFF62
#define X11_Insert 0xFF63
#define X11_Undo 0xFF65
#define X11_Redo 0xFF66
#define X11_Menu 0xFF67
#define X11_Find 0xFF68
#define X11_Cancel 0xFF69
#define X11_Help 0xFF6A
#define X11_Break 0xFF6B
#define X11_Mode_switch 0xFF7E
#define X11_script_switch 0xFF7E
#define X11_Num_Lock 0xFF7F
#define X11_KP_Space 0xFF80
#define X11_KP_Tab 0xFF89
#define X11_KP_Enter 0xFF8D
#define X11_KP_F1 0xFF91
#define X11_KP_F2 0xFF92
#define X11_KP_F3 0xFF93
#define X11_KP_F4 0xFF94
#define X11_KP_Home 0xFF95
#define X11_KP_Left 0xFF96
#define X11_KP_Up 0xFF97
#define X11_KP_Right 0xFF98
#define X11_KP_Down 0xFF99
#define X11_KP_Prior 0xFF9A
#define X11_KP_Page_Up 0xFF9A
#define X11_KP_Next 0xFF9B
#define X11_KP_Page_Down 0xFF9B
#define X11_KP_End 0xFF9C
#define X11_KP_Begin 0xFF9D
#define X11_KP_Insert 0xFF9E
#define X11_KP_Delete 0xFF9F
#define X11_KP_Equal 0xFFBD
#define X11_KP_Multiply 0xFFAA
#define X11_KP_Add 0xFFAB
#define X11_KP_Separator 0xFFAC
#define X11_KP_Subtract 0xFFAD
#define X11_KP_Decimal 0xFFAE
#define X11_KP_Divide 0xFFAF
#define X11_KP_0 0xFFB0
#define X11_KP_1 0xFFB1
#define X11_KP_2 0xFFB2
#define X11_KP_3 0xFFB3
#define X11_KP_4 0xFFB4
#define X11_KP_5 0xFFB5
#define X11_KP_6 0xFFB6
#define X11_KP_7 0xFFB7
#define X11_KP_8 0xFFB8
#define X11_KP_9 0xFFB9
#define X11_F1 0xFFBE
#define X11_F2 0xFFBF
#define X11_F3 0xFFC0
#define X11_F4 0xFFC1
#define X11_F5 0xFFC2
#define X11_F6 0xFFC3
#define X11_F7 0xFFC4
#define X11_F8 0xFFC5
#define X11_F9 0xFFC6
#define X11_F10 0xFFC7
#define X11_F11 0xFFC8
#define X11_L1 0xFFC8
#define X11_F12 0xFFC9
#define X11_L2 0xFFC9
#define X11_F13 0xFFCA
#define X11_L3 0xFFCA
#define X11_F14 0xFFCB
#define X11_L4 0xFFCB
#define X11_F15 0xFFCC
#define X11_L5 0xFFCC
#define X11_F16 0xFFCD
#define X11_L6 0xFFCD
#define X11_F17 0xFFCE
#define X11_L7 0xFFCE
#define X11_F18 0xFFCF
#define X11_L8 0xFFCF
#define X11_F19 0xFFD0
#define X11_L9 0xFFD0
#define X11_F20 0xFFD1
#define X11_L10 0xFFD1
#define X11_F21 0xFFD2
#define X11_R1 0xFFD2
#define X11_F22 0xFFD3
#define X11_R2 0xFFD3
#define X11_F23 0xFFD4
#define X11_R3 0xFFD4
#define X11_F24 0xFFD5
#define X11_R4 0xFFD5
#define X11_F25 0xFFD6
#define X11_R5 0xFFD6
#define X11_F26 0xFFD7
#define X11_R6 0xFFD7
#define X11_F27 0xFFD8
#define X11_R7 0xFFD8
#define X11_F28 0xFFD9
#define X11_R8 0xFFD9
#define X11_F29 0xFFDA
#define X11_R9 0xFFDA
#define X11_F30 0xFFDB
#define X11_R10 0xFFDB
#define X11_F31 0xFFDC
#define X11_R11 0xFFDC
#define X11_F32 0xFFDD
#define X11_R12 0xFFDD
#define X11_F33 0xFFDE
#define X11_R13 0xFFDE
#define X11_F34 0xFFDF
#define X11_R14 0xFFDF
#define X11_F35 0xFFE0
#define X11_R15 0xFFE0
#define X11_Shift_L 0xFFE1
#define X11_Shift_R 0xFFE2
#define X11_Control_L 0xFFE3
#define X11_Control_R 0xFFE4
#define X11_Caps_Lock 0xFFE5
#define X11_Shift_Lock 0xFFE6
#define X11_Meta_L 0xFFE7
#define X11_Meta_R 0xFFE8
#define X11_Alt_L 0xFFE9
#define X11_Alt_R 0xFFEA
#define X11_Super_L 0xFFEB
#define X11_Super_R 0xFFEC
#define X11_Hyper_L 0xFFED
#define X11_Hyper_R 0xFFEE
#define X11_ISO_Lock 0xFE01
#define X11_ISO_Level2_Latch 0xFE02
#define X11_ISO_Level3_Shift 0xFE03
#define X11_ISO_Level3_Latch 0xFE04
#define X11_ISO_Level3_Lock 0xFE05
#define X11_ISO_Group_Shift 0xFF7E
#define X11_ISO_Group_Latch 0xFE06
#define X11_ISO_Group_Lock 0xFE07
#define X11_ISO_Next_Group 0xFE08
#define X11_ISO_Next_Group_Lock 0xFE09
#define X11_ISO_Prev_Group 0xFE0A
#define X11_ISO_Prev_Group_Lock 0xFE0B
#define X11_ISO_First_Group 0xFE0C
#define X11_ISO_First_Group_Lock 0xFE0D
#define X11_ISO_Last_Group 0xFE0E
#define X11_ISO_Last_Group_Lock 0xFE0F
#define X11_ISO_Left_Tab 0xFE20
#define X11_ISO_Move_Line_Up 0xFE21
#define X11_ISO_Move_Line_Down 0xFE22
#define X11_ISO_Partial_Line_Up 0xFE23
#define X11_ISO_Partial_Line_Down 0xFE24
#define X11_ISO_Partial_Space_Left 0xFE25
#define X11_ISO_Partial_Space_Right 0xFE26
#define X11_ISO_Set_Margin_Left 0xFE27
#define X11_ISO_Set_Margin_Right 0xFE28
#define X11_ISO_Release_Margin_Left 0xFE29
#define X11_ISO_Release_Margin_Right 0xFE2A
#define X11_ISO_Release_Both_Margins 0xFE2B
#define X11_ISO_Fast_Cursor_Left 0xFE2C
#define X11_ISO_Fast_Cursor_Right 0xFE2D
#define X11_ISO_Fast_Cursor_Up 0xFE2E
#define X11_ISO_Fast_Cursor_Down 0xFE2F
#define X11_ISO_Continuous_Underline 0xFE30
#define X11_ISO_Discontinuous_Underline 0xFE31
#define X11_ISO_Emphasize 0xFE32
#define X11_ISO_Center_Object 0xFE33
#define X11_ISO_Enter 0xFE34
#define X11_dead_grave 0xFE50
#define X11_dead_acute 0xFE51
#define X11_dead_circumflex 0xFE52
#define X11_dead_tilde 0xFE53
#define X11_dead_macron 0xFE54
#define X11_dead_breve 0xFE55
#define X11_dead_abovedot 0xFE56
#define X11_dead_diaeresis 0xFE57
#define X11_dead_abovering 0xFE58
#define X11_dead_doubleacute 0xFE59
#define X11_dead_caron 0xFE5A
#define X11_dead_cedilla 0xFE5B
#define X11_dead_ogonek 0xFE5C
#define X11_dead_iota 0xFE5D
#define X11_dead_voiced_sound 0xFE5E
#define X11_dead_semivoiced_sound 0xFE5F
#define X11_dead_belowdot 0xFE60
#define X11_First_Virtual_Screen 0xFED0
#define X11_Prev_Virtual_Screen 0xFED1
#define X11_Next_Virtual_Screen 0xFED2
#define X11_Last_Virtual_Screen 0xFED4
#define X11_Terminate_Server 0xFED5
#define X11_AccessX_Enable 0xFE70
#define X11_AccessX_Feedback_Enable 0xFE71
#define X11_RepeatKeys_Enable 0xFE72
#define X11_SlowKeys_Enable 0xFE73
#define X11_BounceKeys_Enable 0xFE74
#define X11_StickyKeys_Enable 0xFE75
#define X11_MouseKeys_Enable 0xFE76
#define X11_MouseKeys_Accel_Enable 0xFE77
#define X11_Overlay1_Enable 0xFE78
#define X11_Overlay2_Enable 0xFE79
#define X11_AudibleBell_Enable 0xFE7A
#define X11_Pointer_Left 0xFEE0
#define X11_Pointer_Right 0xFEE1
#define X11_Pointer_Up 0xFEE2
#define X11_Pointer_Down 0xFEE3
#define X11_Pointer_UpLeft 0xFEE4
#define X11_Pointer_UpRight 0xFEE5
#define X11_Pointer_DownLeft 0xFEE6
#define X11_Pointer_DownRight 0xFEE7
#define X11_Pointer_Button_Dflt 0xFEE8
#define X11_Pointer_Button1 0xFEE9
#define X11_Pointer_Button2 0xFEEA
#define X11_Pointer_Button3 0xFEEB
#define X11_Pointer_Button4 0xFEEC
#define X11_Pointer_Button5 0xFEED
#define X11_Pointer_DblClick_Dflt 0xFEEE
#define X11_Pointer_DblClick1 0xFEEF
#define X11_Pointer_DblClick2 0xFEF0
#define X11_Pointer_DblClick3 0xFEF1
#define X11_Pointer_DblClick4 0xFEF2
#define X11_Pointer_DblClick5 0xFEF3
#define X11_Pointer_Drag_Dflt 0xFEF4
#define X11_Pointer_Drag1 0xFEF5
#define X11_Pointer_Drag2 0xFEF6
#define X11_Pointer_Drag3 0xFEF7
#define X11_Pointer_Drag4 0xFEF8
#define X11_Pointer_Drag5 0xFEFD
#define X11_Pointer_EnableKeys 0xFEF9
#define X11_Pointer_Accelerate 0xFEFA
#define X11_Pointer_DfltBtnNext 0xFEFB
#define X11_Pointer_DfltBtnPrev 0xFEFC
#define X11_3270_Duplicate 0xFD01
#define X11_3270_FieldMark 0xFD02
#define X11_3270_Right2 0xFD03
#define X11_3270_Left2 0xFD04
#define X11_3270_BackTab 0xFD05
#define X11_3270_EraseEOF 0xFD06
#define X11_3270_EraseInput 0xFD07
#define X11_3270_Reset 0xFD08
#define X11_3270_Quit 0xFD09
#define X11_3270_PA1 0xFD0A
#define X11_3270_PA2 0xFD0B
#define X11_3270_PA3 0xFD0C
#define X11_3270_Test 0xFD0D
#define X11_3270_Attn 0xFD0E
#define X11_3270_CursorBlink 0xFD0F
#define X11_3270_AltCursor 0xFD10
#define X11_3270_KeyClick 0xFD11
#define X11_3270_Jump 0xFD12
#define X11_3270_Ident 0xFD13
#define X11_3270_Rule 0xFD14
#define X11_3270_Copy 0xFD15
#define X11_3270_Play 0xFD16
#define X11_3270_Setup 0xFD17
#define X11_3270_Record 0xFD18
#define X11_3270_ChangeScreen 0xFD19
#define X11_3270_DeleteWord 0xFD1A
#define X11_3270_ExSelect 0xFD1B
#define X11_3270_CursorSelect 0xFD1C
#define X11_3270_PrintScreen 0xFD1D
#define X11_3270_Enter 0xFD1E
#define X11_space 0x020
#define X11_exclam 0x021
#define X11_quotedbl 0x022
#define X11_numbersign 0x023
#define X11_dollar 0x024
#define X11_percent 0x025
#define X11_ampersand 0x026
#define X11_apostrophe 0x027
#define X11_quoteright 0x027
#define X11_parenleft 0x028
#define X11_parenright 0x029
#define X11_asterisk 0x02a
#define X11_plus 0x02b
#define X11_comma 0x02c
#define X11_minus 0x02d
#define X11_period 0x02e
#define X11_slash 0x02f
#define X11_0 0x030
#define X11_1 0x031
#define X11_2 0x032
#define X11_3 0x033
#define X11_4 0x034
#define X11_5 0x035
#define X11_6 0x036
#define X11_7 0x037
#define X11_8 0x038
#define X11_9 0x039
#define X11_colon 0x03a
#define X11_semicolon 0x03b
#define X11_less 0x03c
#define X11_equal 0x03d
#define X11_greater 0x03e
#define X11_question 0x03f
#define X11_at 0x040
#define X11_A 0x041
#define X11_B 0x042
#define X11_C 0x043
#define X11_D 0x044
#define X11_E 0x045
#define X11_F 0x046
#define X11_G 0x047
#define X11_H 0x048
#define X11_I 0x049
#define X11_J 0x04a
#define X11_K 0x04b
#define X11_L 0x04c
#define X11_M 0x04d
#define X11_N 0x04e
#define X11_O 0x04f
#define X11_P 0x050
#define X11_Q 0x051
#define X11_R 0x052
#define X11_S 0x053
#define X11_T 0x054
#define X11_U 0x055
#define X11_V 0x056
#define X11_W 0x057
#define X11_X 0x058
#define X11_Y 0x059
#define X11_Z 0x05a
#define X11_bracketleft 0x05b
#define X11_backslash 0x05c
#define X11_bracketright 0x05d
#define X11_asciicircum 0x05e
#define X11_underscore 0x05f
#define X11_grave 0x060
#define X11_quoteleft 0x060
#define X11_a 0x061
#define X11_b 0x062
#define X11_c 0x063
#define X11_d 0x064
#define X11_e 0x065
#define X11_f 0x066
#define X11_g 0x067
#define X11_h 0x068
#define X11_i 0x069
#define X11_j 0x06a
#define X11_k 0x06b
#define X11_l 0x06c
#define X11_m 0x06d
#define X11_n 0x06e
#define X11_o 0x06f
#define X11_p 0x070
#define X11_q 0x071
#define X11_r 0x072
#define X11_s 0x073
#define X11_t 0x074
#define X11_u 0x075
#define X11_v 0x076
#define X11_w 0x077
#define X11_x 0x078
#define X11_y 0x079
#define X11_z 0x07a
#define X11_braceleft 0x07b
#define X11_bar 0x07c
#define X11_braceright 0x07d
#define X11_asciitilde 0x07e
#define X11_nobreakspace 0x0a0
#define X11_exclamdown 0x0a1
#define X11_cent 0x0a2
#define X11_sterling 0x0a3
#define X11_currency 0x0a4
#define X11_yen 0x0a5
#define X11_brokenbar 0x0a6
#define X11_section 0x0a7
#define X11_diaeresis 0x0a8
#define X11_copyright 0x0a9
#define X11_ordfeminine 0x0aa
#define X11_guillemotleft 0x0ab
#define X11_notsign 0x0ac
#define X11_hyphen 0x0ad
#define X11_registered 0x0ae
#define X11_macron 0x0af
#define X11_degree 0x0b0
#define X11_plusminus 0x0b1
#define X11_twosuperior 0x0b2
#define X11_threesuperior 0x0b3
#define X11_acute 0x0b4
#define X11_mu 0x0b5
#define X11_paragraph 0x0b6
#define X11_periodcentered 0x0b7
#define X11_cedilla 0x0b8
#define X11_onesuperior 0x0b9
#define X11_masculine 0x0ba
#define X11_guillemotright 0x0bb
#define X11_onequarter 0x0bc
#define X11_onehalf 0x0bd
#define X11_threequarters 0x0be
#define X11_questiondown 0x0bf
#define X11_Agrave 0x0c0
#define X11_Aacute 0x0c1
#define X11_Acircumflex 0x0c2
#define X11_Atilde 0x0c3
#define X11_Adiaeresis 0x0c4
#define X11_Aring 0x0c5
#define X11_AE 0x0c6
#define X11_Ccedilla 0x0c7
#define X11_Egrave 0x0c8
#define X11_Eacute 0x0c9
#define X11_Ecircumflex 0x0ca
#define X11_Ediaeresis 0x0cb
#define X11_Igrave 0x0cc
#define X11_Iacute 0x0cd
#define X11_Icircumflex 0x0ce
#define X11_Idiaeresis 0x0cf
#define X11_ETH 0x0d0
#define X11_Eth 0x0d0
#define X11_Ntilde 0x0d1
#define X11_Ograve 0x0d2
#define X11_Oacute 0x0d3
#define X11_Ocircumflex 0x0d4
#define X11_Otilde 0x0d5
#define X11_Odiaeresis 0x0d6
#define X11_multiply 0x0d7
#define X11_Ooblique 0x0d8
#define X11_Ugrave 0x0d9
#define X11_Uacute 0x0da
#define X11_Ucircumflex 0x0db
#define X11_Udiaeresis 0x0dc
#define X11_Yacute 0x0dd
#define X11_THORN 0x0de
#define X11_Thorn 0x0de
#define X11_ssharp 0x0df
#define X11_agrave 0x0e0
#define X11_aacute 0x0e1
#define X11_acircumflex 0x0e2
#define X11_atilde 0x0e3
#define X11_adiaeresis 0x0e4
#define X11_aring 0x0e5
#define X11_ae 0x0e6
#define X11_ccedilla 0x0e7
#define X11_egrave 0x0e8
#define X11_eacute 0x0e9
#define X11_ecircumflex 0x0ea
#define X11_ediaeresis 0x0eb
#define X11_igrave 0x0ec
#define X11_iacute 0x0ed
#define X11_icircumflex 0x0ee
#define X11_idiaeresis 0x0ef
#define X11_eth 0x0f0
#define X11_ntilde 0x0f1
#define X11_ograve 0x0f2
#define X11_oacute 0x0f3
#define X11_ocircumflex 0x0f4
#define X11_otilde 0x0f5
#define X11_odiaeresis 0x0f6
#define X11_division 0x0f7
#define X11_oslash 0x0f8
#define X11_ugrave 0x0f9
#define X11_uacute 0x0fa
#define X11_ucircumflex 0x0fb
#define X11_udiaeresis 0x0fc
#define X11_yacute 0x0fd
#define X11_thorn 0x0fe
#define X11_ydiaeresis 0x0ff
#define X11_Aogonek 0x1a1
#define X11_breve 0x1a2
#define X11_Lstroke 0x1a3
#define X11_Lcaron 0x1a5
#define X11_Sacute 0x1a6
#define X11_Scaron 0x1a9
#define X11_Scedilla 0x1aa
#define X11_Tcaron 0x1ab
#define X11_Zacute 0x1ac
#define X11_Zcaron 0x1ae
#define X11_Zabovedot 0x1af
#define X11_aogonek 0x1b1
#define X11_ogonek 0x1b2
#define X11_lstroke 0x1b3
#define X11_lcaron 0x1b5
#define X11_sacute 0x1b6
#define X11_caron 0x1b7
#define X11_scaron 0x1b9
#define X11_scedilla 0x1ba
#define X11_tcaron 0x1bb
#define X11_zacute 0x1bc
#define X11_doubleacute 0x1bd
#define X11_zcaron 0x1be
#define X11_zabovedot 0x1bf
#define X11_Racute 0x1c0
#define X11_Abreve 0x1c3
#define X11_Lacute 0x1c5
#define X11_Cacute 0x1c6
#define X11_Ccaron 0x1c8
#define X11_Eogonek 0x1ca
#define X11_Ecaron 0x1cc
#define X11_Dcaron 0x1cf
#define X11_Dstroke 0x1d0
#define X11_Nacute 0x1d1
#define X11_Ncaron 0x1d2
#define X11_Odoubleacute 0x1d5
#define X11_Rcaron 0x1d8
#define X11_Uring 0x1d9
#define X11_Udoubleacute 0x1db
#define X11_Tcedilla 0x1de
#define X11_racute 0x1e0
#define X11_abreve 0x1e3
#define X11_lacute 0x1e5
#define X11_cacute 0x1e6
#define X11_ccaron 0x1e8
#define X11_eogonek 0x1ea
#define X11_ecaron 0x1ec
#define X11_dcaron 0x1ef
#define X11_dstroke 0x1f0
#define X11_nacute 0x1f1
#define X11_ncaron 0x1f2
#define X11_odoubleacute 0x1f5
#define X11_udoubleacute 0x1fb
#define X11_rcaron 0x1f8
#define X11_uring 0x1f9
#define X11_tcedilla 0x1fe
#define X11_abovedot 0x1ff
#define X11_Hstroke 0x2a1
#define X11_Hcircumflex 0x2a6
#define X11_Iabovedot 0x2a9
#define X11_Gbreve 0x2ab
#define X11_Jcircumflex 0x2ac
#define X11_hstroke 0x2b1
#define X11_hcircumflex 0x2b6
#define X11_idotless 0x2b9
#define X11_gbreve 0x2bb
#define X11_jcircumflex 0x2bc
#define X11_Cabovedot 0x2c5
#define X11_Ccircumflex 0x2c6
#define X11_Gabovedot 0x2d5
#define X11_Gcircumflex 0x2d8
#define X11_Ubreve 0x2dd
#define X11_Scircumflex 0x2de
#define X11_cabovedot 0x2e5
#define X11_ccircumflex 0x2e6
#define X11_gabovedot 0x2f5
#define X11_gcircumflex 0x2f8
#define X11_ubreve 0x2fd
#define X11_scircumflex 0x2fe
#define X11_kra 0x3a2
#define X11_kappa 0x3a2
#define X11_Rcedilla 0x3a3
#define X11_Itilde 0x3a5
#define X11_Lcedilla 0x3a6
#define X11_Emacron 0x3aa
#define X11_Gcedilla 0x3ab
#define X11_Tslash 0x3ac
#define X11_rcedilla 0x3b3
#define X11_itilde 0x3b5
#define X11_lcedilla 0x3b6
#define X11_emacron 0x3ba
#define X11_gcedilla 0x3bb
#define X11_tslash 0x3bc
#define X11_ENG 0x3bd
#define X11_eng 0x3bf
#define X11_Amacron 0x3c0
#define X11_Iogonek 0x3c7
#define X11_Eabovedot 0x3cc
#define X11_Imacron 0x3cf
#define X11_Ncedilla 0x3d1
#define X11_Omacron 0x3d2
#define X11_Kcedilla 0x3d3
#define X11_Uogonek 0x3d9
#define X11_Utilde 0x3dd
#define X11_Umacron 0x3de
#define X11_amacron 0x3e0
#define X11_iogonek 0x3e7
#define X11_eabovedot 0x3ec
#define X11_imacron 0x3ef
#define X11_ncedilla 0x3f1
#define X11_omacron 0x3f2
#define X11_kcedilla 0x3f3
#define X11_uogonek 0x3f9
#define X11_utilde 0x3fd
#define X11_umacron 0x3fe
#define X11_OE 0x13bc
#define X11_oe 0x13bd
#define X11_Ydiaeresis 0x13be
#define X11_overline 0x47e
#define X11_kana_fullstop 0x4a1
#define X11_kana_openingbracket 0x4a2
#define X11_kana_closingbracket 0x4a3
#define X11_kana_comma 0x4a4
#define X11_kana_conjunctive 0x4a5
#define X11_kana_middledot 0x4a5
#define X11_kana_WO 0x4a6
#define X11_kana_a 0x4a7
#define X11_kana_i 0x4a8
#define X11_kana_u 0x4a9
#define X11_kana_e 0x4aa
#define X11_kana_o 0x4ab
#define X11_kana_ya 0x4ac
#define X11_kana_yu 0x4ad
#define X11_kana_yo 0x4ae
#define X11_kana_tsu 0x4af
#define X11_kana_tu 0x4af
#define X11_prolongedsound 0x4b0
#define X11_kana_A 0x4b1
#define X11_kana_I 0x4b2
#define X11_kana_U 0x4b3
#define X11_kana_E 0x4b4
#define X11_kana_O 0x4b5
#define X11_kana_KA 0x4b6
#define X11_kana_KI 0x4b7
#define X11_kana_KU 0x4b8
#define X11_kana_KE 0x4b9
#define X11_kana_KO 0x4ba
#define X11_kana_SA 0x4bb
#define X11_kana_SHI 0x4bc
#define X11_kana_SU 0x4bd
#define X11_kana_SE 0x4be
#define X11_kana_SO 0x4bf
#define X11_kana_TA 0x4c0
#define X11_kana_CHI 0x4c1
#define X11_kana_TI 0x4c1
#define X11_kana_TSU 0x4c2
#define X11_kana_TU 0x4c2
#define X11_kana_TE 0x4c3
#define X11_kana_TO 0x4c4
#define X11_kana_NA 0x4c5
#define X11_kana_NI 0x4c6
#define X11_kana_NU 0x4c7
#define X11_kana_NE 0x4c8
#define X11_kana_NO 0x4c9
#define X11_kana_HA 0x4ca
#define X11_kana_HI 0x4cb
#define X11_kana_FU 0x4cc
#define X11_kana_HU 0x4cc
#define X11_kana_HE 0x4cd
#define X11_kana_HO 0x4ce
#define X11_kana_MA 0x4cf
#define X11_kana_MI 0x4d0
#define X11_kana_MU 0x4d1
#define X11_kana_ME 0x4d2
#define X11_kana_MO 0x4d3
#define X11_kana_YA 0x4d4
#define X11_kana_YU 0x4d5
#define X11_kana_YO 0x4d6
#define X11_kana_RA 0x4d7
#define X11_kana_RI 0x4d8
#define X11_kana_RU 0x4d9
#define X11_kana_RE 0x4da
#define X11_kana_RO 0x4db
#define X11_kana_WA 0x4dc
#define X11_kana_N 0x4dd
#define X11_voicedsound 0x4de
#define X11_semivoicedsound 0x4df
#define X11_kana_switch 0xFF7E
#define X11_Arabic_comma 0x5ac
#define X11_Arabic_semicolon 0x5bb
#define X11_Arabic_question_mark 0x5bf
#define X11_Arabic_hamza 0x5c1
#define X11_Arabic_maddaonalef 0x5c2
#define X11_Arabic_hamzaonalef 0x5c3
#define X11_Arabic_hamzaonwaw 0x5c4
#define X11_Arabic_hamzaunderalef 0x5c5
#define X11_Arabic_hamzaonyeh 0x5c6
#define X11_Arabic_alef 0x5c7
#define X11_Arabic_beh 0x5c8
#define X11_Arabic_tehmarbuta 0x5c9
#define X11_Arabic_teh 0x5ca
#define X11_Arabic_theh 0x5cb
#define X11_Arabic_jeem 0x5cc
#define X11_Arabic_hah 0x5cd
#define X11_Arabic_khah 0x5ce
#define X11_Arabic_dal 0x5cf
#define X11_Arabic_thal 0x5d0
#define X11_Arabic_ra 0x5d1
#define X11_Arabic_zain 0x5d2
#define X11_Arabic_seen 0x5d3
#define X11_Arabic_sheen 0x5d4
#define X11_Arabic_sad 0x5d5
#define X11_Arabic_dad 0x5d6
#define X11_Arabic_tah 0x5d7
#define X11_Arabic_zah 0x5d8
#define X11_Arabic_ain 0x5d9
#define X11_Arabic_ghain 0x5da
#define X11_Arabic_tatweel 0x5e0
#define X11_Arabic_feh 0x5e1
#define X11_Arabic_qaf 0x5e2
#define X11_Arabic_kaf 0x5e3
#define X11_Arabic_lam 0x5e4
#define X11_Arabic_meem 0x5e5
#define X11_Arabic_noon 0x5e6
#define X11_Arabic_ha 0x5e7
#define X11_Arabic_heh 0x5e7
#define X11_Arabic_waw 0x5e8
#define X11_Arabic_alefmaksura 0x5e9
#define X11_Arabic_yeh 0x5ea
#define X11_Arabic_fathatan 0x5eb
#define X11_Arabic_dammatan 0x5ec
#define X11_Arabic_kasratan 0x5ed
#define X11_Arabic_fatha 0x5ee
#define X11_Arabic_damma 0x5ef
#define X11_Arabic_kasra 0x5f0
#define X11_Arabic_shadda 0x5f1
#define X11_Arabic_sukun 0x5f2
#define X11_Arabic_switch 0xFF7E
#define X11_Serbian_dje 0x6a1
#define X11_Macedonia_gje 0x6a2
#define X11_Cyrillic_io 0x6a3
#define X11_Ukrainian_ie 0x6a4
#define X11_Ukranian_je 0x6a4
#define X11_Macedonia_dse 0x6a5
#define X11_Ukrainian_i 0x6a6
#define X11_Ukranian_i 0x6a6
#define X11_Ukrainian_yi 0x6a7
#define X11_Ukranian_yi 0x6a7
#define X11_Cyrillic_je 0x6a8
#define X11_Serbian_je 0x6a8
#define X11_Cyrillic_lje 0x6a9
#define X11_Serbian_lje 0x6a9
#define X11_Cyrillic_nje 0x6aa
#define X11_Serbian_nje 0x6aa
#define X11_Serbian_tshe 0x6ab
#define X11_Macedonia_kje 0x6ac
#define X11_Ukrainian_ghe_with_upturn 0x6ad
#define X11_Byelorussian_shortu 0x6ae
#define X11_Cyrillic_dzhe 0x6af
#define X11_Serbian_dze 0x6af
#define X11_numerosign 0x6b0
#define X11_Serbian_DJE 0x6b1
#define X11_Macedonia_GJE 0x6b2
#define X11_Cyrillic_IO 0x6b3
#define X11_Ukrainian_IE 0x6b4
#define X11_Ukranian_JE 0x6b4
#define X11_Macedonia_DSE 0x6b5
#define X11_Ukrainian_I 0x6b6
#define X11_Ukranian_I 0x6b6
#define X11_Ukrainian_YI 0x6b7
#define X11_Ukranian_YI 0x6b7
#define X11_Cyrillic_JE 0x6b8
#define X11_Serbian_JE 0x6b8
#define X11_Cyrillic_LJE 0x6b9
#define X11_Serbian_LJE 0x6b9
#define X11_Cyrillic_NJE 0x6ba
#define X11_Serbian_NJE 0x6ba
#define X11_Serbian_TSHE 0x6bb
#define X11_Macedonia_KJE 0x6bc
#define X11_Ukrainian_GHE_WITH_UPTURN 0x6bd
#define X11_Byelorussian_SHORTU 0x6be
#define X11_Cyrillic_DZHE 0x6bf
#define X11_Serbian_DZE 0x6bf
#define X11_Cyrillic_yu 0x6c0
#define X11_Cyrillic_a 0x6c1
#define X11_Cyrillic_be 0x6c2
#define X11_Cyrillic_tse 0x6c3
#define X11_Cyrillic_de 0x6c4
#define X11_Cyrillic_ie 0x6c5
#define X11_Cyrillic_ef 0x6c6
#define X11_Cyrillic_ghe 0x6c7
#define X11_Cyrillic_ha 0x6c8
#define X11_Cyrillic_i 0x6c9
#define X11_Cyrillic_shorti 0x6ca
#define X11_Cyrillic_ka 0x6cb
#define X11_Cyrillic_el 0x6cc
#define X11_Cyrillic_em 0x6cd
#define X11_Cyrillic_en 0x6ce
#define X11_Cyrillic_o 0x6cf
#define X11_Cyrillic_pe 0x6d0
#define X11_Cyrillic_ya 0x6d1
#define X11_Cyrillic_er 0x6d2
#define X11_Cyrillic_es 0x6d3
#define X11_Cyrillic_te 0x6d4
#define X11_Cyrillic_u 0x6d5
#define X11_Cyrillic_zhe 0x6d6
#define X11_Cyrillic_ve 0x6d7
#define X11_Cyrillic_softsign 0x6d8
#define X11_Cyrillic_yeru 0x6d9
#define X11_Cyrillic_ze 0x6da
#define X11_Cyrillic_sha 0x6db
#define X11_Cyrillic_e 0x6dc
#define X11_Cyrillic_shcha 0x6dd
#define X11_Cyrillic_che 0x6de
#define X11_Cyrillic_hardsign 0x6df
#define X11_Cyrillic_YU 0x6e0
#define X11_Cyrillic_A 0x6e1
#define X11_Cyrillic_BE 0x6e2
#define X11_Cyrillic_TSE 0x6e3
#define X11_Cyrillic_DE 0x6e4
#define X11_Cyrillic_IE 0x6e5
#define X11_Cyrillic_EF 0x6e6
#define X11_Cyrillic_GHE 0x6e7
#define X11_Cyrillic_HA 0x6e8
#define X11_Cyrillic_I 0x6e9
#define X11_Cyrillic_SHORTI 0x6ea
#define X11_Cyrillic_KA 0x6eb
#define X11_Cyrillic_EL 0x6ec
#define X11_Cyrillic_EM 0x6ed
#define X11_Cyrillic_EN 0x6ee
#define X11_Cyrillic_O 0x6ef
#define X11_Cyrillic_PE 0x6f0
#define X11_Cyrillic_YA 0x6f1
#define X11_Cyrillic_ER 0x6f2
#define X11_Cyrillic_ES 0x6f3
#define X11_Cyrillic_TE 0x6f4
#define X11_Cyrillic_U 0x6f5
#define X11_Cyrillic_ZHE 0x6f6
#define X11_Cyrillic_VE 0x6f7
#define X11_Cyrillic_SOFTSIGN 0x6f8
#define X11_Cyrillic_YERU 0x6f9
#define X11_Cyrillic_ZE 0x6fa
#define X11_Cyrillic_SHA 0x6fb
#define X11_Cyrillic_E 0x6fc
#define X11_Cyrillic_SHCHA 0x6fd
#define X11_Cyrillic_CHE 0x6fe
#define X11_Cyrillic_HARDSIGN 0x6ff
#define X11_Greek_ALPHAaccent 0x7a1
#define X11_Greek_EPSILONaccent 0x7a2
#define X11_Greek_ETAaccent 0x7a3
#define X11_Greek_IOTAaccent 0x7a4
#define X11_Greek_IOTAdieresis 0x7a5
#define X11_Greek_IOTAdiaeresis X11_Greek_IOTAdieresis
#define X11_Greek_OMICRONaccent 0x7a7
#define X11_Greek_UPSILONaccent 0x7a8
#define X11_Greek_UPSILONdieresis 0x7a9
#define X11_Greek_OMEGAaccent 0x7ab
#define X11_Greek_accentdieresis 0x7ae
#define X11_Greek_horizbar 0x7af
#define X11_Greek_alphaaccent 0x7b1
#define X11_Greek_epsilonaccent 0x7b2
#define X11_Greek_etaaccent 0x7b3
#define X11_Greek_iotaaccent 0x7b4
#define X11_Greek_iotadieresis 0x7b5
#define X11_Greek_iotaaccentdieresis 0x7b6
#define X11_Greek_omicronaccent 0x7b7
#define X11_Greek_upsilonaccent 0x7b8
#define X11_Greek_upsilondieresis 0x7b9
#define X11_Greek_upsilonaccentdieresis 0x7ba
#define X11_Greek_omegaaccent 0x7bb
#define X11_Greek_ALPHA 0x7c1
#define X11_Greek_BETA 0x7c2
#define X11_Greek_GAMMA 0x7c3
#define X11_Greek_DELTA 0x7c4
#define X11_Greek_EPSILON 0x7c5
#define X11_Greek_ZETA 0x7c6
#define X11_Greek_ETA 0x7c7
#define X11_Greek_THETA 0x7c8
#define X11_Greek_IOTA 0x7c9
#define X11_Greek_KAPPA 0x7ca
#define X11_Greek_LAMDA 0x7cb
#define X11_Greek_LAMBDA 0x7cb
#define X11_Greek_MU 0x7cc
#define X11_Greek_NU 0x7cd
#define X11_Greek_XI 0x7ce
#define X11_Greek_OMICRON 0x7cf
#define X11_Greek_PI 0x7d0
#define X11_Greek_RHO 0x7d1
#define X11_Greek_SIGMA 0x7d2
#define X11_Greek_TAU 0x7d4
#define X11_Greek_UPSILON 0x7d5
#define X11_Greek_PHI 0x7d6
#define X11_Greek_CHI 0x7d7
#define X11_Greek_PSI 0x7d8
#define X11_Greek_OMEGA 0x7d9
#define X11_Greek_alpha 0x7e1
#define X11_Greek_beta 0x7e2
#define X11_Greek_gamma 0x7e3
#define X11_Greek_delta 0x7e4
#define X11_Greek_epsilon 0x7e5
#define X11_Greek_zeta 0x7e6
#define X11_Greek_eta 0x7e7
#define X11_Greek_theta 0x7e8
#define X11_Greek_iota 0x7e9
#define X11_Greek_kappa 0x7ea
#define X11_Greek_lamda 0x7eb
#define X11_Greek_lambda 0x7eb
#define X11_Greek_mu 0x7ec
#define X11_Greek_nu 0x7ed
#define X11_Greek_xi 0x7ee
#define X11_Greek_omicron 0x7ef
#define X11_Greek_pi 0x7f0
#define X11_Greek_rho 0x7f1
#define X11_Greek_sigma 0x7f2
#define X11_Greek_finalsmallsigma 0x7f3
#define X11_Greek_tau 0x7f4
#define X11_Greek_upsilon 0x7f5
#define X11_Greek_phi 0x7f6
#define X11_Greek_chi 0x7f7
#define X11_Greek_psi 0x7f8
#define X11_Greek_omega 0x7f9
#define X11_Greek_switch 0xFF7E
#define X11_leftradical 0x8a1
#define X11_topleftradical 0x8a2
#define X11_horizconnector 0x8a3
#define X11_topintegral 0x8a4
#define X11_botintegral 0x8a5
#define X11_vertconnector 0x8a6
#define X11_topleftsqbracket 0x8a7
#define X11_botleftsqbracket 0x8a8
#define X11_toprightsqbracket 0x8a9
#define X11_botrightsqbracket 0x8aa
#define X11_topleftparens 0x8ab
#define X11_botleftparens 0x8ac
#define X11_toprightparens 0x8ad
#define X11_botrightparens 0x8ae
#define X11_leftmiddlecurlybrace 0x8af
#define X11_rightmiddlecurlybrace 0x8b0
#define X11_topleftsummation 0x8b1
#define X11_botleftsummation 0x8b2
#define X11_topvertsummationconnector 0x8b3
#define X11_botvertsummationconnector 0x8b4
#define X11_toprightsummation 0x8b5
#define X11_botrightsummation 0x8b6
#define X11_rightmiddlesummation 0x8b7
#define X11_lessthanequal 0x8bc
#define X11_notequal 0x8bd
#define X11_greaterthanequal 0x8be
#define X11_integral 0x8bf
#define X11_therefore 0x8c0
#define X11_variation 0x8c1
#define X11_infinity 0x8c2
#define X11_nabla 0x8c5
#define X11_approximate 0x8c8
#define X11_similarequal 0x8c9
#define X11_ifonlyif 0x8cd
#define X11_implies 0x8ce
#define X11_identical 0x8cf
#define X11_radical 0x8d6
#define X11_includedin 0x8da
#define X11_includes 0x8db
#define X11_intersection 0x8dc
#define X11_union 0x8dd
#define X11_logicaland 0x8de
#define X11_logicalor 0x8df
#define X11_partialderivative 0x8ef
#define X11_function 0x8f6
#define X11_leftarrow 0x8fb
#define X11_uparrow 0x8fc
#define X11_rightarrow 0x8fd
#define X11_downarrow 0x8fe
#define X11_blank 0x9df
#define X11_soliddiamond 0x9e0
#define X11_checkerboard 0x9e1
#define X11_ht 0x9e2
#define X11_ff 0x9e3
#define X11_cr 0x9e4
#define X11_lf 0x9e5
#define X11_nl 0x9e8
#define X11_vt 0x9e9
#define X11_lowrightcorner 0x9ea
#define X11_uprightcorner 0x9eb
#define X11_upleftcorner 0x9ec
#define X11_lowleftcorner 0x9ed
#define X11_crossinglines 0x9ee
#define X11_horizlinescan1 0x9ef
#define X11_horizlinescan3 0x9f0
#define X11_horizlinescan5 0x9f1
#define X11_horizlinescan7 0x9f2
#define X11_horizlinescan9 0x9f3
#define X11_leftt 0x9f4
#define X11_rightt 0x9f5
#define X11_bott 0x9f6
#define X11_topt 0x9f7
#define X11_vertbar 0x9f8
#define X11_emspace 0xaa1
#define X11_enspace 0xaa2
#define X11_em3space 0xaa3
#define X11_em4space 0xaa4
#define X11_digitspace 0xaa5
#define X11_punctspace 0xaa6
#define X11_thinspace 0xaa7
#define X11_hairspace 0xaa8
#define X11_emdash 0xaa9
#define X11_endash 0xaaa
#define X11_signifblank 0xaac
#define X11_ellipsis 0xaae
#define X11_doubbaselinedot 0xaaf
#define X11_onethird 0xab0
#define X11_twothirds 0xab1
#define X11_onefifth 0xab2
#define X11_twofifths 0xab3
#define X11_threefifths 0xab4
#define X11_fourfifths 0xab5
#define X11_onesixth 0xab6
#define X11_fivesixths 0xab7
#define X11_careof 0xab8
#define X11_figdash 0xabb
#define X11_leftanglebracket 0xabc
#define X11_decimalpoint 0xabd
#define X11_rightanglebracket 0xabe
#define X11_marker 0xabf
#define X11_oneeighth 0xac3
#define X11_threeeighths 0xac4
#define X11_fiveeighths 0xac5
#define X11_seveneighths 0xac6
#define X11_trademark 0xac9
#define X11_signaturemark 0xaca
#define X11_trademarkincircle 0xacb
#define X11_leftopentriangle 0xacc
#define X11_rightopentriangle 0xacd
#define X11_emopencircle 0xace
#define X11_emopenrectangle 0xacf
#define X11_leftsinglequotemark 0xad0
#define X11_rightsinglequotemark 0xad1
#define X11_leftdoublequotemark 0xad2
#define X11_rightdoublequotemark 0xad3
#define X11_prescription 0xad4
#define X11_minutes 0xad6
#define X11_seconds 0xad7
#define X11_latincross 0xad9
#define X11_hexagram 0xada
#define X11_filledrectbullet 0xadb
#define X11_filledlefttribullet 0xadc
#define X11_filledrighttribullet 0xadd
#define X11_emfilledcircle 0xade
#define X11_emfilledrect 0xadf
#define X11_enopencircbullet 0xae0
#define X11_enopensquarebullet 0xae1
#define X11_openrectbullet 0xae2
#define X11_opentribulletup 0xae3
#define X11_opentribulletdown 0xae4
#define X11_openstar 0xae5
#define X11_enfilledcircbullet 0xae6
#define X11_enfilledsqbullet 0xae7
#define X11_filledtribulletup 0xae8
#define X11_filledtribulletdown 0xae9
#define X11_leftpointer 0xaea
#define X11_rightpointer 0xaeb
#define X11_club 0xaec
#define X11_diamond 0xaed
#define X11_heart 0xaee
#define X11_maltesecross 0xaf0
#define X11_dagger 0xaf1
#define X11_doubledagger 0xaf2
#define X11_checkmark 0xaf3
#define X11_ballotcross 0xaf4
#define X11_musicalsharp 0xaf5
#define X11_musicalflat 0xaf6
#define X11_malesymbol 0xaf7
#define X11_femalesymbol 0xaf8
#define X11_telephone 0xaf9
#define X11_telephonerecorder 0xafa
#define X11_phonographcopyright 0xafb
#define X11_caret 0xafc
#define X11_singlelowquotemark 0xafd
#define X11_doublelowquotemark 0xafe
#define X11_cursor 0xaff
#define X11_leftcaret 0xba3
#define X11_rightcaret 0xba6
#define X11_downcaret 0xba8
#define X11_upcaret 0xba9
#define X11_overbar 0xbc0
#define X11_downtack 0xbc2
#define X11_upshoe 0xbc3
#define X11_downstile 0xbc4
#define X11_underbar 0xbc6
#define X11_jot 0xbca
#define X11_quad 0xbcc
#define X11_uptack 0xbce
#define X11_circle 0xbcf
#define X11_upstile 0xbd3
#define X11_downshoe 0xbd6
#define X11_rightshoe 0xbd8
#define X11_leftshoe 0xbda
#define X11_lefttack 0xbdc
#define X11_righttack 0xbfc
#define X11_hebrew_doublelowline 0xcdf
#define X11_hebrew_aleph 0xce0
#define X11_hebrew_bet 0xce1
#define X11_hebrew_beth 0xce1
#define X11_hebrew_gimel 0xce2
#define X11_hebrew_gimmel 0xce2
#define X11_hebrew_dalet 0xce3
#define X11_hebrew_daleth 0xce3
#define X11_hebrew_he 0xce4
#define X11_hebrew_waw 0xce5
#define X11_hebrew_zain 0xce6
#define X11_hebrew_zayin 0xce6
#define X11_hebrew_chet 0xce7
#define X11_hebrew_het 0xce7
#define X11_hebrew_tet 0xce8
#define X11_hebrew_teth 0xce8
#define X11_hebrew_yod 0xce9
#define X11_hebrew_finalkaph 0xcea
#define X11_hebrew_kaph 0xceb
#define X11_hebrew_lamed 0xcec
#define X11_hebrew_finalmem 0xced
#define X11_hebrew_mem 0xcee
#define X11_hebrew_finalnun 0xcef
#define X11_hebrew_nun 0xcf0
#define X11_hebrew_samech 0xcf1
#define X11_hebrew_samekh 0xcf1
#define X11_hebrew_ayin 0xcf2
#define X11_hebrew_finalpe 0xcf3
#define X11_hebrew_pe 0xcf4
#define X11_hebrew_finalzade 0xcf5
#define X11_hebrew_finalzadi 0xcf5
#define X11_hebrew_zade 0xcf6
#define X11_hebrew_zadi 0xcf6
#define X11_hebrew_qoph 0xcf7
#define X11_hebrew_kuf 0xcf7
#define X11_hebrew_resh 0xcf8
#define X11_hebrew_shin 0xcf9
#define X11_hebrew_taw 0xcfa
#define X11_hebrew_taf 0xcfa
#define X11_Hebrew_switch 0xFF7E
#define X11_Thai_kokai 0xda1
#define X11_Thai_khokhai 0xda2
#define X11_Thai_khokhuat 0xda3
#define X11_Thai_khokhwai 0xda4
#define X11_Thai_khokhon 0xda5
#define X11_Thai_khorakhang 0xda6
#define X11_Thai_ngongu 0xda7
#define X11_Thai_chochan 0xda8
#define X11_Thai_choching 0xda9
#define X11_Thai_chochang 0xdaa
#define X11_Thai_soso 0xdab
#define X11_Thai_chochoe 0xdac
#define X11_Thai_yoying 0xdad
#define X11_Thai_dochada 0xdae
#define X11_Thai_topatak 0xdaf
#define X11_Thai_thothan 0xdb0
#define X11_Thai_thonangmontho 0xdb1
#define X11_Thai_thophuthao 0xdb2
#define X11_Thai_nonen 0xdb3
#define X11_Thai_dodek 0xdb4
#define X11_Thai_totao 0xdb5
#define X11_Thai_thothung 0xdb6
#define X11_Thai_thothahan 0xdb7
#define X11_Thai_thothong 0xdb8
#define X11_Thai_nonu 0xdb9
#define X11_Thai_bobaimai 0xdba
#define X11_Thai_popla 0xdbb
#define X11_Thai_phophung 0xdbc
#define X11_Thai_fofa 0xdbd
#define X11_Thai_phophan 0xdbe
#define X11_Thai_fofan 0xdbf
#define X11_Thai_phosamphao 0xdc0
#define X11_Thai_moma 0xdc1
#define X11_Thai_yoyak 0xdc2
#define X11_Thai_rorua 0xdc3
#define X11_Thai_ru 0xdc4
#define X11_Thai_loling 0xdc5
#define X11_Thai_lu 0xdc6
#define X11_Thai_wowaen 0xdc7
#define X11_Thai_sosala 0xdc8
#define X11_Thai_sorusi 0xdc9
#define X11_Thai_sosua 0xdca
#define X11_Thai_hohip 0xdcb
#define X11_Thai_lochula 0xdcc
#define X11_Thai_oang 0xdcd
#define X11_Thai_honokhuk 0xdce
#define X11_Thai_paiyannoi 0xdcf
#define X11_Thai_saraa 0xdd0
#define X11_Thai_maihanakat 0xdd1
#define X11_Thai_saraaa 0xdd2
#define X11_Thai_saraam 0xdd3
#define X11_Thai_sarai 0xdd4
#define X11_Thai_saraii 0xdd5
#define X11_Thai_saraue 0xdd6
#define X11_Thai_sarauee 0xdd7
#define X11_Thai_sarau 0xdd8
#define X11_Thai_sarauu 0xdd9
#define X11_Thai_phinthu 0xdda
#define X11_Thai_maihanakat_maitho 0xdde
#define X11_Thai_baht 0xddf
#define X11_Thai_sarae 0xde0
#define X11_Thai_saraae 0xde1
#define X11_Thai_sarao 0xde2
#define X11_Thai_saraaimaimuan 0xde3
#define X11_Thai_saraaimaimalai 0xde4
#define X11_Thai_lakkhangyao 0xde5
#define X11_Thai_maiyamok 0xde6
#define X11_Thai_maitaikhu 0xde7
#define X11_Thai_maiek 0xde8
#define X11_Thai_maitho 0xde9
#define X11_Thai_maitri 0xdea
#define X11_Thai_maichattawa 0xdeb
#define X11_Thai_thanthakhat 0xdec
#define X11_Thai_nikhahit 0xded
#define X11_Thai_leksun 0xdf0
#define X11_Thai_leknung 0xdf1
#define X11_Thai_leksong 0xdf2
#define X11_Thai_leksam 0xdf3
#define X11_Thai_leksi 0xdf4
#define X11_Thai_lekha 0xdf5
#define X11_Thai_lekhok 0xdf6
#define X11_Thai_lekchet 0xdf7
#define X11_Thai_lekpaet 0xdf8
#define X11_Thai_lekkao 0xdf9
#define X11_Hangul 0xff31
#define X11_Hangul_Start 0xff32
#define X11_Hangul_End 0xff33
#define X11_Hangul_Hanja 0xff34
#define X11_Hangul_Jamo 0xff35
#define X11_Hangul_Romaja 0xff36
#define X11_Hangul_Codeinput 0xff37
#define X11_Hangul_Jeonja 0xff38
#define X11_Hangul_Banja 0xff39
#define X11_Hangul_PreHanja 0xff3a
#define X11_Hangul_PostHanja 0xff3b
#define X11_Hangul_SingleCandidate 0xff3c
#define X11_Hangul_MultipleCandidate 0xff3d
#define X11_Hangul_PreviousCandidate 0xff3e
#define X11_Hangul_Special 0xff3f
#define X11_Hangul_switch 0xFF7E
#define X11_Hangul_Kiyeog 0xea1
#define X11_Hangul_SsangKiyeog 0xea2
#define X11_Hangul_KiyeogSios 0xea3
#define X11_Hangul_Nieun 0xea4
#define X11_Hangul_NieunJieuj 0xea5
#define X11_Hangul_NieunHieuh 0xea6
#define X11_Hangul_Dikeud 0xea7
#define X11_Hangul_SsangDikeud 0xea8
#define X11_Hangul_Rieul 0xea9
#define X11_Hangul_RieulKiyeog 0xeaa
#define X11_Hangul_RieulMieum 0xeab
#define X11_Hangul_RieulPieub 0xeac
#define X11_Hangul_RieulSios 0xead
#define X11_Hangul_RieulTieut 0xeae
#define X11_Hangul_RieulPhieuf 0xeaf
#define X11_Hangul_RieulHieuh 0xeb0
#define X11_Hangul_Mieum 0xeb1
#define X11_Hangul_Pieub 0xeb2
#define X11_Hangul_SsangPieub 0xeb3
#define X11_Hangul_PieubSios 0xeb4
#define X11_Hangul_Sios 0xeb5
#define X11_Hangul_SsangSios 0xeb6
#define X11_Hangul_Ieung 0xeb7
#define X11_Hangul_Jieuj 0xeb8
#define X11_Hangul_SsangJieuj 0xeb9
#define X11_Hangul_Cieuc 0xeba
#define X11_Hangul_Khieuq 0xebb
#define X11_Hangul_Tieut 0xebc
#define X11_Hangul_Phieuf 0xebd
#define X11_Hangul_Hieuh 0xebe
#define X11_Hangul_A 0xebf
#define X11_Hangul_AE 0xec0
#define X11_Hangul_YA 0xec1
#define X11_Hangul_YAE 0xec2
#define X11_Hangul_EO 0xec3
#define X11_Hangul_E 0xec4
#define X11_Hangul_YEO 0xec5
#define X11_Hangul_YE 0xec6
#define X11_Hangul_O 0xec7
#define X11_Hangul_WA 0xec8
#define X11_Hangul_WAE 0xec9
#define X11_Hangul_OE 0xeca
#define X11_Hangul_YO 0xecb
#define X11_Hangul_U 0xecc
#define X11_Hangul_WEO 0xecd
#define X11_Hangul_WE 0xece
#define X11_Hangul_WI 0xecf
#define X11_Hangul_YU 0xed0
#define X11_Hangul_EU 0xed1
#define X11_Hangul_YI 0xed2
#define X11_Hangul_I 0xed3
#define X11_Hangul_J_Kiyeog 0xed4
#define X11_Hangul_J_SsangKiyeog 0xed5
#define X11_Hangul_J_KiyeogSios 0xed6
#define X11_Hangul_J_Nieun 0xed7
#define X11_Hangul_J_NieunJieuj 0xed8
#define X11_Hangul_J_NieunHieuh 0xed9
#define X11_Hangul_J_Dikeud 0xeda
#define X11_Hangul_J_Rieul 0xedb
#define X11_Hangul_J_RieulKiyeog 0xedc
#define X11_Hangul_J_RieulMieum 0xedd
#define X11_Hangul_J_RieulPieub 0xede
#define X11_Hangul_J_RieulSios 0xedf
#define X11_Hangul_J_RieulTieut 0xee0
#define X11_Hangul_J_RieulPhieuf 0xee1
#define X11_Hangul_J_RieulHieuh 0xee2
#define X11_Hangul_J_Mieum 0xee3
#define X11_Hangul_J_Pieub 0xee4
#define X11_Hangul_J_PieubSios 0xee5
#define X11_Hangul_J_Sios 0xee6
#define X11_Hangul_J_SsangSios 0xee7
#define X11_Hangul_J_Ieung 0xee8
#define X11_Hangul_J_Jieuj 0xee9
#define X11_Hangul_J_Cieuc 0xeea
#define X11_Hangul_J_Khieuq 0xeeb
#define X11_Hangul_J_Tieut 0xeec
#define X11_Hangul_J_Phieuf 0xeed
#define X11_Hangul_J_Hieuh 0xeee
#define X11_Hangul_RieulYeorinHieuh 0xeef
#define X11_Hangul_SunkyeongeumMieum 0xef0
#define X11_Hangul_SunkyeongeumPieub 0xef1
#define X11_Hangul_PanSios 0xef2
#define X11_Hangul_KkogjiDalrinIeung 0xef3
#define X11_Hangul_SunkyeongeumPhieuf 0xef4
#define X11_Hangul_YeorinHieuh 0xef5
#define X11_Hangul_AraeA 0xef6
#define X11_Hangul_AraeAE 0xef7
#define X11_Hangul_J_PanSios 0xef8
#define X11_Hangul_J_KkogjiDalrinIeung 0xef9
#define X11_Hangul_J_YeorinHieuh 0xefa
#define X11_Korean_Won 0xeff
#define X11_EcuSign 0x20a0
#define X11_ColonSign 0x20a1
#define X11_CruzeiroSign 0x20a2
#define X11_FFrancSign 0x20a3
#define X11_LiraSign 0x20a4
#define X11_MillSign 0x20a5
#define X11_NairaSign 0x20a6
#define X11_PesetaSign 0x20a7
#define X11_RupeeSign 0x20a8
#define X11_WonSign 0x20a9
#define X11_NewSheqelSign 0x20aa
#define X11_DongSign 0x20ab
#define X11_EuroSign 0x20ac

char *x11_keyval_name (unsigned int);
unsigned int x11_keyval_from_name (const char *);
int g2icode (unsigned int);
unsigned int i2gcode (int);

#endif /* __X11_KEYSYMS_H__ */
