/*
 * iml_fop.h: IIIMF iml file operation - public header file
 */

#if !defined(IIIMF_IML_FOP_H)
#define IIIMF_IML_FOP_H

#include <dirent.h>
#include <utime.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/uio.h>

#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */

typedef void *	(* iml_fop_get_function_t)(const char *);

typedef void *	(* iml__fopc_create_t)(const char *, int , void *);
typedef void	(* iml__fopc_free_t)(void *);

typedef int	(* iml_fop_close_t)(void *, int);
typedef int	(* iml_fop_creat_t)(void *, const char *, mode_t);
typedef int	(* iml_fop_ftruncate_t)(void *, int, off_t);
typedef off_t	(* iml_fop_lseek_t)(void *, int, off_t, int);
typedef int	(* iml_fop_open_t)(void *, const char *, int, ...);
typedef ssize_t	(* iml_fop_read_t)(void *, int, void *, size_t);
typedef int	(* iml_fop_truncate_t)(void *, const char *, off_t);
typedef ssize_t	(* iml_fop_write_t)(void *, int, const void *, size_t);

typedef int	(* iml_fop_link_t)(void *, const char *, const char *);
typedef int	(* iml_fop_readlink_t)(void *,
				       const char *, char *, size_t);
typedef int	(* iml_fop_rename_t)(void *, const char *, const char *);
typedef int	(* iml_fop_symlink_t)(void *, const char *, const char *);
typedef int	(* iml_fop_unlink_t)(void *, const char *);

typedef int	(* iml_fop_chmod_t)(void *, const char *, mode_t);
typedef int	(* iml_fop_chown_t)(void *, const char *, uid_t, gid_t);
typedef int	(* iml_fop_fchmod_t)(void *, int, mode_t);
typedef int	(* iml_fop_fchown_t)(void *, int, uid_t, gid_t);
typedef int	(* iml_fop_lchown_t)(void *, int, uid_t, gid_t);

typedef int	(* iml_fop_utime_t)(void *,
				    const char *, const struct utimbuf *);
typedef int	(* iml_fop_utimes_t)(void *,
				     const char *, const struct timeval *);

typedef int	(* iml_fop_fstat_t)(void *, int, struct stat *);
typedef int	(* iml_fop_lstat_t)(void *, const char *, struct stat *);
typedef int	(* iml_fop_stat_t)(void *, const char *, struct stat *);

typedef int	(* iml_fop_access_t)(void *, const char *, int);

typedef int	(* iml_fop_closedir_t)(void *, DIR *);
typedef DIR *	(* iml_fop_opendir_t)(void *, const char *);
typedef struct dirent *
		(* iml_fop_readdir_t)(void *, DIR *);
typedef void	(* iml_fop_rewinddir_t)(void *, DIR *);
typedef void	(* iml_fop_seekdir_t)(void *, DIR *, long int);
typedef long int(* iml_fop_telldir_t)(void *, DIR *);

typedef int	(* iml_fop_mkdir_t)(void *, const char *, mode_t);
typedef int	(* iml_fop_rmdir_t)(void *, const char *);

typedef int	(* iml_fop_fcntl_t)(void *, int, int, ...);

#if defined(fop_not_defined)
typedef ssize_t	(* iml_fop_readv_t)(void *,
				    int, const struct iovec *, int);
typedef ssize_t	(* iml_fop_writev_t)(void *, int,
				     const struct iovec *, int);
typedef long	(* iml_fop_fpathconf_t)(void *, int, int);
typedef long	(* iml_fop_pathconf_t)(void *, const char *, int);
#endif /* fop_not_defined */

typedef struct _iml_fop_basic_fopset {
    iml_fop_close_t	fop_close;
    iml_fop_creat_t	fop_creat;
    iml_fop_ftruncate_t	fop_ftruncate;
    iml_fop_lseek_t	fop_lseek;
    iml_fop_open_t	fop_open;
    iml_fop_read_t	fop_read;
    iml_fop_truncate_t	fop_truncate;
    iml_fop_write_t	fop_write;

    iml_fop_link_t	fop_link;
    iml_fop_readlink_t	fop_readlink;
    iml_fop_rename_t	fop_rename;
    iml_fop_symlink_t	fop_symlink;
    iml_fop_unlink_t	fop_unlink;

    iml_fop_chmod_t	fop_chmod;
    iml_fop_chown_t	fop_chown;
    iml_fop_fchmod_t	fop_fchmod;
    iml_fop_fchown_t	fop_fchown;
    iml_fop_lchown_t	fop_lchown;

    iml_fop_utime_t	fop_utime;
    iml_fop_utimes_t	fop_utimes;

    iml_fop_fstat_t	fop_fstat;
    iml_fop_lstat_t	fop_lstat;
    iml_fop_stat_t	fop_stat;
    iml_fop_access_t	fop_access;

    iml_fop_closedir_t	fop_closedir;
    iml_fop_opendir_t	fop_opendir;
    iml_fop_readdir_t	fop_readdir;
    iml_fop_rewinddir_t	fop_rewinddir;
    iml_fop_seekdir_t	fop_seekdir;
    iml_fop_telldir_t	fop_telldir;

    iml_fop_mkdir_t	fop_mkdir;
    iml_fop_rmdir_t	fop_rmdir;

    iml_fop_fcntl_t	fop_fcntl;
} iml_fop_basic_fopset_t;


#define IML_FOPC_TYPE_LE	(0)
#define IML_FOPC_TYPE_DESKTOP	(1)

/* compatibility */
#define IML_NSC_TYPE_LE		(0)
#define IML_NSC_TYPE_DESKTOP	(1)

#if defined(__cplusplus)
}
#endif /* __cplusplus */

#endif /* !IIIMF_IML_FOP_H */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
