/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef IMXK_CONVERTER_H
#define IMXK_CONVERTER_H
#endif

#include "IMKeyMap.h"

#define ShiftMask               (1L<<0)
#define LockMask                (1L<<1)
#define ControlMask             (1L<<2)
#define Button1Mask             (1L<<8)
#define Button2Mask             (1L<<9)
#define Button3Mask             (1L<<10)

typedef unsigned short KeySym;
typedef int Bool;

typedef struct KEYMAP_ENTRY {
    long awtKey;
    KeySym x11Key;
    Bool printable;
} KeymapEntry;

int awt_MetaMask = 0;
int awt_AltMask = 8L;
int awt_NumLockMask = 0;

/* extract the definitions below from java header files */
#undef java_awt_event_KeyEvent_COMPONENT_EVENT_MASK
#define java_awt_event_KeyEvent_COMPONENT_EVENT_MASK 1LL
#undef java_awt_event_KeyEvent_CONTAINER_EVENT_MASK
#define java_awt_event_KeyEvent_CONTAINER_EVENT_MASK 2LL
#undef java_awt_event_KeyEvent_FOCUS_EVENT_MASK
#define java_awt_event_KeyEvent_FOCUS_EVENT_MASK 4LL
#undef java_awt_event_KeyEvent_KEY_EVENT_MASK
#define java_awt_event_KeyEvent_KEY_EVENT_MASK 8LL
#undef java_awt_event_KeyEvent_MOUSE_EVENT_MASK
#define java_awt_event_KeyEvent_MOUSE_EVENT_MASK 16LL
#undef java_awt_event_KeyEvent_MOUSE_MOTION_EVENT_MASK
#define java_awt_event_KeyEvent_MOUSE_MOTION_EVENT_MASK 32LL
#undef java_awt_event_KeyEvent_WINDOW_EVENT_MASK
#define java_awt_event_KeyEvent_WINDOW_EVENT_MASK 64LL
#undef java_awt_event_KeyEvent_ACTION_EVENT_MASK
#define java_awt_event_KeyEvent_ACTION_EVENT_MASK 128LL
#undef java_awt_event_KeyEvent_ADJUSTMENT_EVENT_MASK
#define java_awt_event_KeyEvent_ADJUSTMENT_EVENT_MASK 256LL
#undef java_awt_event_KeyEvent_ITEM_EVENT_MASK
#define java_awt_event_KeyEvent_ITEM_EVENT_MASK 512LL
#undef java_awt_event_KeyEvent_TEXT_EVENT_MASK
#define java_awt_event_KeyEvent_TEXT_EVENT_MASK 1024LL
#undef java_awt_event_KeyEvent_RESERVED_ID_MAX
#define java_awt_event_KeyEvent_RESERVED_ID_MAX 1999L
#undef java_awt_event_KeyEvent_serialVersionUID
#define java_awt_event_KeyEvent_serialVersionUID -1825314779160409405LL
#undef java_awt_event_KeyEvent_COMPONENT_FIRST
#define java_awt_event_KeyEvent_COMPONENT_FIRST 100L
#undef java_awt_event_KeyEvent_COMPONENT_LAST
#define java_awt_event_KeyEvent_COMPONENT_LAST 103L
#undef java_awt_event_KeyEvent_COMPONENT_MOVED
#define java_awt_event_KeyEvent_COMPONENT_MOVED 100L
#undef java_awt_event_KeyEvent_COMPONENT_RESIZED
#define java_awt_event_KeyEvent_COMPONENT_RESIZED 101L
#undef java_awt_event_KeyEvent_COMPONENT_SHOWN
#define java_awt_event_KeyEvent_COMPONENT_SHOWN 102L
#undef java_awt_event_KeyEvent_COMPONENT_HIDDEN
#define java_awt_event_KeyEvent_COMPONENT_HIDDEN 103L
#undef java_awt_event_KeyEvent_serialVersionUID
#define java_awt_event_KeyEvent_serialVersionUID 8101406823902992965LL
#undef java_awt_event_KeyEvent_SHIFT_MASK
#define java_awt_event_KeyEvent_SHIFT_MASK 1L
#undef java_awt_event_KeyEvent_CTRL_MASK
#define java_awt_event_KeyEvent_CTRL_MASK 2L
#undef java_awt_event_KeyEvent_META_MASK
#define java_awt_event_KeyEvent_META_MASK 4L
#undef java_awt_event_KeyEvent_ALT_MASK
#define java_awt_event_KeyEvent_ALT_MASK 8L
#undef java_awt_event_KeyEvent_BUTTON1_MASK
#define java_awt_event_KeyEvent_BUTTON1_MASK 16L
#undef java_awt_event_KeyEvent_BUTTON2_MASK
#define java_awt_event_KeyEvent_BUTTON2_MASK 8L
#undef java_awt_event_KeyEvent_BUTTON3_MASK
#define java_awt_event_KeyEvent_BUTTON3_MASK 4L
#undef java_awt_event_KeyEvent_KEY_FIRST
#define java_awt_event_KeyEvent_KEY_FIRST 400L
#undef java_awt_event_KeyEvent_KEY_LAST
#define java_awt_event_KeyEvent_KEY_LAST 402L
#undef java_awt_event_KeyEvent_KEY_TYPED
#define java_awt_event_KeyEvent_KEY_TYPED 400L
#undef java_awt_event_KeyEvent_KEY_PRESSED
#define java_awt_event_KeyEvent_KEY_PRESSED 401L
#undef java_awt_event_KeyEvent_KEY_RELEASED
#define java_awt_event_KeyEvent_KEY_RELEASED 402L
#undef java_awt_event_KeyEvent_VK_ENTER
#define java_awt_event_KeyEvent_VK_ENTER 10L
#undef java_awt_event_KeyEvent_VK_BACK_SPACE
#define java_awt_event_KeyEvent_VK_BACK_SPACE 8L
#undef java_awt_event_KeyEvent_VK_TAB
#define java_awt_event_KeyEvent_VK_TAB 9L
#undef java_awt_event_KeyEvent_VK_CANCEL
#define java_awt_event_KeyEvent_VK_CANCEL 3L
#undef java_awt_event_KeyEvent_VK_CLEAR
#define java_awt_event_KeyEvent_VK_CLEAR 12L
#undef java_awt_event_KeyEvent_VK_SHIFT
#define java_awt_event_KeyEvent_VK_SHIFT 16L
#undef java_awt_event_KeyEvent_VK_CONTROL
#define java_awt_event_KeyEvent_VK_CONTROL 17L
#undef java_awt_event_KeyEvent_VK_ALT
#define java_awt_event_KeyEvent_VK_ALT 18L
#undef java_awt_event_KeyEvent_VK_PAUSE
#define java_awt_event_KeyEvent_VK_PAUSE 19L
#undef java_awt_event_KeyEvent_VK_CAPS_LOCK
#define java_awt_event_KeyEvent_VK_CAPS_LOCK 20L
#undef java_awt_event_KeyEvent_VK_ESCAPE
#define java_awt_event_KeyEvent_VK_ESCAPE 27L
#undef java_awt_event_KeyEvent_VK_SPACE
#define java_awt_event_KeyEvent_VK_SPACE 32L
#undef java_awt_event_KeyEvent_VK_PAGE_UP
#define java_awt_event_KeyEvent_VK_PAGE_UP 33L
#undef java_awt_event_KeyEvent_VK_PAGE_DOWN
#define java_awt_event_KeyEvent_VK_PAGE_DOWN 34L
#undef java_awt_event_KeyEvent_VK_END
#define java_awt_event_KeyEvent_VK_END 35L
#undef java_awt_event_KeyEvent_VK_HOME
#define java_awt_event_KeyEvent_VK_HOME 36L
#undef java_awt_event_KeyEvent_VK_LEFT
#define java_awt_event_KeyEvent_VK_LEFT 37L
#undef java_awt_event_KeyEvent_VK_UP
#define java_awt_event_KeyEvent_VK_UP 38L
#undef java_awt_event_KeyEvent_VK_RIGHT
#define java_awt_event_KeyEvent_VK_RIGHT 39L
#undef java_awt_event_KeyEvent_VK_DOWN
#define java_awt_event_KeyEvent_VK_DOWN 40L
#undef java_awt_event_KeyEvent_VK_COMMA
#define java_awt_event_KeyEvent_VK_COMMA 44L
#undef java_awt_event_KeyEvent_VK_PERIOD
#define java_awt_event_KeyEvent_VK_PERIOD 46L
#undef java_awt_event_KeyEvent_VK_SLASH
#define java_awt_event_KeyEvent_VK_SLASH 47L
#undef java_awt_event_KeyEvent_VK_0
#define java_awt_event_KeyEvent_VK_0 48L
#undef java_awt_event_KeyEvent_VK_1
#define java_awt_event_KeyEvent_VK_1 49L
#undef java_awt_event_KeyEvent_VK_2
#define java_awt_event_KeyEvent_VK_2 50L
#undef java_awt_event_KeyEvent_VK_3
#define java_awt_event_KeyEvent_VK_3 51L
#undef java_awt_event_KeyEvent_VK_4
#define java_awt_event_KeyEvent_VK_4 52L
#undef java_awt_event_KeyEvent_VK_5
#define java_awt_event_KeyEvent_VK_5 53L
#undef java_awt_event_KeyEvent_VK_6
#define java_awt_event_KeyEvent_VK_6 54L
#undef java_awt_event_KeyEvent_VK_7
#define java_awt_event_KeyEvent_VK_7 55L
#undef java_awt_event_KeyEvent_VK_8
#define java_awt_event_KeyEvent_VK_8 56L
#undef java_awt_event_KeyEvent_VK_9
#define java_awt_event_KeyEvent_VK_9 57L
#undef java_awt_event_KeyEvent_VK_SEMICOLON
#define java_awt_event_KeyEvent_VK_SEMICOLON 59L
#undef java_awt_event_KeyEvent_VK_EQUALS
#define java_awt_event_KeyEvent_VK_EQUALS 61L
#undef java_awt_event_KeyEvent_VK_A
#define java_awt_event_KeyEvent_VK_A 65L
#undef java_awt_event_KeyEvent_VK_B
#define java_awt_event_KeyEvent_VK_B 66L
#undef java_awt_event_KeyEvent_VK_C
#define java_awt_event_KeyEvent_VK_C 67L
#undef java_awt_event_KeyEvent_VK_D
#define java_awt_event_KeyEvent_VK_D 68L
#undef java_awt_event_KeyEvent_VK_E
#define java_awt_event_KeyEvent_VK_E 69L
#undef java_awt_event_KeyEvent_VK_F
#define java_awt_event_KeyEvent_VK_F 70L
#undef java_awt_event_KeyEvent_VK_G
#define java_awt_event_KeyEvent_VK_G 71L
#undef java_awt_event_KeyEvent_VK_H
#define java_awt_event_KeyEvent_VK_H 72L
#undef java_awt_event_KeyEvent_VK_I
#define java_awt_event_KeyEvent_VK_I 73L
#undef java_awt_event_KeyEvent_VK_J
#define java_awt_event_KeyEvent_VK_J 74L
#undef java_awt_event_KeyEvent_VK_K
#define java_awt_event_KeyEvent_VK_K 75L
#undef java_awt_event_KeyEvent_VK_L
#define java_awt_event_KeyEvent_VK_L 76L
#undef java_awt_event_KeyEvent_VK_M
#define java_awt_event_KeyEvent_VK_M 77L
#undef java_awt_event_KeyEvent_VK_N
#define java_awt_event_KeyEvent_VK_N 78L
#undef java_awt_event_KeyEvent_VK_O
#define java_awt_event_KeyEvent_VK_O 79L
#undef java_awt_event_KeyEvent_VK_P
#define java_awt_event_KeyEvent_VK_P 80L
#undef java_awt_event_KeyEvent_VK_Q
#define java_awt_event_KeyEvent_VK_Q 81L
#undef java_awt_event_KeyEvent_VK_R
#define java_awt_event_KeyEvent_VK_R 82L
#undef java_awt_event_KeyEvent_VK_S
#define java_awt_event_KeyEvent_VK_S 83L
#undef java_awt_event_KeyEvent_VK_T
#define java_awt_event_KeyEvent_VK_T 84L
#undef java_awt_event_KeyEvent_VK_U
#define java_awt_event_KeyEvent_VK_U 85L
#undef java_awt_event_KeyEvent_VK_V
#define java_awt_event_KeyEvent_VK_V 86L
#undef java_awt_event_KeyEvent_VK_W
#define java_awt_event_KeyEvent_VK_W 87L
#undef java_awt_event_KeyEvent_VK_X
#define java_awt_event_KeyEvent_VK_X 88L
#undef java_awt_event_KeyEvent_VK_Y
#define java_awt_event_KeyEvent_VK_Y 89L
#undef java_awt_event_KeyEvent_VK_Z
#define java_awt_event_KeyEvent_VK_Z 90L
#undef java_awt_event_KeyEvent_VK_OPEN_BRACKET
#define java_awt_event_KeyEvent_VK_OPEN_BRACKET 91L
#undef java_awt_event_KeyEvent_VK_BACK_SLASH
#define java_awt_event_KeyEvent_VK_BACK_SLASH 92L
#undef java_awt_event_KeyEvent_VK_CLOSE_BRACKET
#define java_awt_event_KeyEvent_VK_CLOSE_BRACKET 93L
#undef java_awt_event_KeyEvent_VK_NUMPAD0
#define java_awt_event_KeyEvent_VK_NUMPAD0 96L
#undef java_awt_event_KeyEvent_VK_NUMPAD1
#define java_awt_event_KeyEvent_VK_NUMPAD1 97L
#undef java_awt_event_KeyEvent_VK_NUMPAD2
#define java_awt_event_KeyEvent_VK_NUMPAD2 98L
#undef java_awt_event_KeyEvent_VK_NUMPAD3
#define java_awt_event_KeyEvent_VK_NUMPAD3 99L
#undef java_awt_event_KeyEvent_VK_NUMPAD4
#define java_awt_event_KeyEvent_VK_NUMPAD4 100L
#undef java_awt_event_KeyEvent_VK_NUMPAD5
#define java_awt_event_KeyEvent_VK_NUMPAD5 101L
#undef java_awt_event_KeyEvent_VK_NUMPAD6
#define java_awt_event_KeyEvent_VK_NUMPAD6 102L
#undef java_awt_event_KeyEvent_VK_NUMPAD7
#define java_awt_event_KeyEvent_VK_NUMPAD7 103L
#undef java_awt_event_KeyEvent_VK_NUMPAD8
#define java_awt_event_KeyEvent_VK_NUMPAD8 104L
#undef java_awt_event_KeyEvent_VK_NUMPAD9
#define java_awt_event_KeyEvent_VK_NUMPAD9 105L
#undef java_awt_event_KeyEvent_VK_MULTIPLY
#define java_awt_event_KeyEvent_VK_MULTIPLY 106L
#undef java_awt_event_KeyEvent_VK_ADD
#define java_awt_event_KeyEvent_VK_ADD 107L
#undef java_awt_event_KeyEvent_VK_SEPARATER
#define java_awt_event_KeyEvent_VK_SEPARATER 108L
#undef java_awt_event_KeyEvent_VK_SUBTRACT
#define java_awt_event_KeyEvent_VK_SUBTRACT 109L
#undef java_awt_event_KeyEvent_VK_DECIMAL
#define java_awt_event_KeyEvent_VK_DECIMAL 110L
#undef java_awt_event_KeyEvent_VK_DIVIDE
#define java_awt_event_KeyEvent_VK_DIVIDE 111L
#undef java_awt_event_KeyEvent_VK_F1
#define java_awt_event_KeyEvent_VK_F1 112L
#undef java_awt_event_KeyEvent_VK_F2
#define java_awt_event_KeyEvent_VK_F2 113L
#undef java_awt_event_KeyEvent_VK_F3
#define java_awt_event_KeyEvent_VK_F3 114L
#undef java_awt_event_KeyEvent_VK_F4
#define java_awt_event_KeyEvent_VK_F4 115L
#undef java_awt_event_KeyEvent_VK_F5
#define java_awt_event_KeyEvent_VK_F5 116L
#undef java_awt_event_KeyEvent_VK_F6
#define java_awt_event_KeyEvent_VK_F6 117L
#undef java_awt_event_KeyEvent_VK_F7
#define java_awt_event_KeyEvent_VK_F7 118L
#undef java_awt_event_KeyEvent_VK_F8
#define java_awt_event_KeyEvent_VK_F8 119L
#undef java_awt_event_KeyEvent_VK_F9
#define java_awt_event_KeyEvent_VK_F9 120L
#undef java_awt_event_KeyEvent_VK_F10
#define java_awt_event_KeyEvent_VK_F10 121L
#undef java_awt_event_KeyEvent_VK_F11
#define java_awt_event_KeyEvent_VK_F11 122L
#undef java_awt_event_KeyEvent_VK_F12
#define java_awt_event_KeyEvent_VK_F12 123L
#undef java_awt_event_KeyEvent_VK_DELETE
#define java_awt_event_KeyEvent_VK_DELETE 127L
#undef java_awt_event_KeyEvent_VK_NUM_LOCK
#define java_awt_event_KeyEvent_VK_NUM_LOCK 144L
#undef java_awt_event_KeyEvent_VK_SCROLL_LOCK
#define java_awt_event_KeyEvent_VK_SCROLL_LOCK 145L
#undef java_awt_event_KeyEvent_VK_PRINTSCREEN
#define java_awt_event_KeyEvent_VK_PRINTSCREEN 154L
#undef java_awt_event_KeyEvent_VK_INSERT
#define java_awt_event_KeyEvent_VK_INSERT 155L
#undef java_awt_event_KeyEvent_VK_HELP
#define java_awt_event_KeyEvent_VK_HELP 156L
#undef java_awt_event_KeyEvent_VK_META
#define java_awt_event_KeyEvent_VK_META 157L
#undef java_awt_event_KeyEvent_VK_BACK_QUOTE
#define java_awt_event_KeyEvent_VK_BACK_QUOTE 192L
#undef java_awt_event_KeyEvent_VK_QUOTE
#define java_awt_event_KeyEvent_VK_QUOTE 222L
#undef java_awt_event_KeyEvent_VK_FINAL
#define java_awt_event_KeyEvent_VK_FINAL 24L
#undef java_awt_event_KeyEvent_VK_CONVERT
#define java_awt_event_KeyEvent_VK_CONVERT 28L
#undef java_awt_event_KeyEvent_VK_NONCONVERT
#define java_awt_event_KeyEvent_VK_NONCONVERT 29L
#undef java_awt_event_KeyEvent_VK_ACCEPT
#define java_awt_event_KeyEvent_VK_ACCEPT 30L
#undef java_awt_event_KeyEvent_VK_MODECHANGE
#define java_awt_event_KeyEvent_VK_MODECHANGE 31L
#undef java_awt_event_KeyEvent_VK_KANA
#define java_awt_event_KeyEvent_VK_KANA 21L
#undef java_awt_event_KeyEvent_VK_KANJI
#define java_awt_event_KeyEvent_VK_KANJI 25L
#undef java_awt_event_KeyEvent_VK_UNDEFINED
#define java_awt_event_KeyEvent_VK_UNDEFINED 0L
#undef java_awt_event_KeyEvent_CHAR_UNDEFINED
#define java_awt_event_KeyEvent_CHAR_UNDEFINED 0L

#undef java_awt_event_InputEvent_SHIFT_MASK
#define java_awt_event_InputEvent_SHIFT_MASK 1L
#undef java_awt_event_InputEvent_CTRL_MASK
#define java_awt_event_InputEvent_CTRL_MASK 2L
#undef java_awt_event_InputEvent_META_MASK
#define java_awt_event_InputEvent_META_MASK 4L
#undef java_awt_event_InputEvent_ALT_MASK
#define java_awt_event_InputEvent_ALT_MASK 8L
#undef java_awt_event_InputEvent_BUTTON1_MASK
#define java_awt_event_InputEvent_BUTTON1_MASK 16L
#undef java_awt_event_InputEvent_BUTTON2_MASK
#define java_awt_event_InputEvent_BUTTON2_MASK 8L
#undef java_awt_event_InputEvent_BUTTON3_MASK
#define java_awt_event_InputEvent_BUTTON3_MASK 4L

enum {  MyFalse = 0, MyTrue = 1 };

static KeymapEntry keymapTable[] = {
    { java_awt_event_KeyEvent_VK_A, IMXK_a, MyTrue },
    { java_awt_event_KeyEvent_VK_B, IMXK_b, MyTrue },
    { java_awt_event_KeyEvent_VK_C, IMXK_c, MyTrue },
    { java_awt_event_KeyEvent_VK_D, IMXK_d, MyTrue },
    { java_awt_event_KeyEvent_VK_E, IMXK_e, MyTrue },
    { java_awt_event_KeyEvent_VK_F, IMXK_f, MyTrue },
    { java_awt_event_KeyEvent_VK_G, IMXK_g, MyTrue },
    { java_awt_event_KeyEvent_VK_H, IMXK_h, MyTrue },
    { java_awt_event_KeyEvent_VK_I, IMXK_i, MyTrue },
    { java_awt_event_KeyEvent_VK_J, IMXK_j, MyTrue },
    { java_awt_event_KeyEvent_VK_K, IMXK_k, MyTrue },
    { java_awt_event_KeyEvent_VK_L, IMXK_l, MyTrue },
    { java_awt_event_KeyEvent_VK_M, IMXK_m, MyTrue },
    { java_awt_event_KeyEvent_VK_N, IMXK_n, MyTrue },
    { java_awt_event_KeyEvent_VK_O, IMXK_o, MyTrue },
    { java_awt_event_KeyEvent_VK_P, IMXK_p, MyTrue },
    { java_awt_event_KeyEvent_VK_Q, IMXK_q, MyTrue },
    { java_awt_event_KeyEvent_VK_R, IMXK_r, MyTrue },
    { java_awt_event_KeyEvent_VK_S, IMXK_s, MyTrue },
    { java_awt_event_KeyEvent_VK_T, IMXK_t, MyTrue },
    { java_awt_event_KeyEvent_VK_U, IMXK_u, MyTrue },
    { java_awt_event_KeyEvent_VK_V, IMXK_v, MyTrue },
    { java_awt_event_KeyEvent_VK_W, IMXK_w, MyTrue },
    { java_awt_event_KeyEvent_VK_X, IMXK_x, MyTrue },
    { java_awt_event_KeyEvent_VK_Y, IMXK_y, MyTrue },
    { java_awt_event_KeyEvent_VK_Z, IMXK_z, MyTrue },

    { java_awt_event_KeyEvent_VK_ENTER, IMXK_Return, MyTrue },
    { java_awt_event_KeyEvent_VK_ENTER, IMXK_KP_Enter, MyTrue },
    { java_awt_event_KeyEvent_VK_ENTER, IMXK_Linefeed, MyTrue },

    { java_awt_event_KeyEvent_VK_BACK_SPACE, IMXK_BackSpace, MyTrue },
    { java_awt_event_KeyEvent_VK_TAB, IMXK_Tab, MyTrue },
/* { java_awt_event_KeyEvent_VK_CANCEL, IMXK_Cancel, MyFalse }, */
    { java_awt_event_KeyEvent_VK_CLEAR, IMXK_Clear, MyFalse },
    { java_awt_event_KeyEvent_VK_SHIFT, IMXK_Shift_L, MyFalse },
    { java_awt_event_KeyEvent_VK_SHIFT, IMXK_Shift_R, MyFalse },
    { java_awt_event_KeyEvent_VK_CONTROL, IMXK_Control_L, MyFalse },
    { java_awt_event_KeyEvent_VK_CONTROL, IMXK_Control_R, MyFalse },
    { java_awt_event_KeyEvent_VK_ALT, IMXK_Alt_L, MyFalse },
    { java_awt_event_KeyEvent_VK_ALT, IMXK_Alt_R, MyFalse },
    { java_awt_event_KeyEvent_VK_META, IMXK_Meta_L, MyFalse },
    { java_awt_event_KeyEvent_VK_META, IMXK_Meta_R, MyFalse },
    { java_awt_event_KeyEvent_VK_PAUSE, IMXK_Pause, MyFalse },
    { java_awt_event_KeyEvent_VK_CAPS_LOCK, IMXK_Caps_Lock, MyFalse },
    { java_awt_event_KeyEvent_VK_ESCAPE, IMXK_Escape, MyTrue },
    { java_awt_event_KeyEvent_VK_SPACE, IMXK_space, MyTrue },

    { java_awt_event_KeyEvent_VK_PAGE_UP, IMXK_Page_Up, MyFalse },
    { java_awt_event_KeyEvent_VK_PAGE_UP, IMXK_R9, MyFalse },
    { java_awt_event_KeyEvent_VK_PAGE_UP, IMXK_Prior, MyFalse },
    { java_awt_event_KeyEvent_VK_PAGE_DOWN, IMXK_Page_Down, MyFalse },
    { java_awt_event_KeyEvent_VK_PAGE_DOWN, IMXK_R15, MyFalse },
    { java_awt_event_KeyEvent_VK_PAGE_DOWN, IMXK_Next, MyFalse },
    { java_awt_event_KeyEvent_VK_END, IMXK_End, MyFalse },
    { java_awt_event_KeyEvent_VK_END, IMXK_R13, MyFalse },
    { java_awt_event_KeyEvent_VK_HOME, IMXK_Home, MyFalse },
    { java_awt_event_KeyEvent_VK_HOME, IMXK_R7, MyFalse },

    { java_awt_event_KeyEvent_VK_LEFT, IMXK_Left, MyFalse },
    { java_awt_event_KeyEvent_VK_UP, IMXK_Up, MyFalse },
    { java_awt_event_KeyEvent_VK_RIGHT, IMXK_Right, MyFalse },
    { java_awt_event_KeyEvent_VK_DOWN, IMXK_Down, MyFalse },
/*    { java_awt_event_KeyEvent_VK_INSERT, IMXK_Insert, MyFalse },
    { java_awt_event_KeyEvent_VK_HELP, IMXK_Help, MyFalse },*/

    { java_awt_event_KeyEvent_VK_0, IMXK_0, MyTrue },
    { java_awt_event_KeyEvent_VK_1, IMXK_1, MyTrue },
    { java_awt_event_KeyEvent_VK_2, IMXK_2, MyTrue },
    { java_awt_event_KeyEvent_VK_3, IMXK_3, MyTrue },
    { java_awt_event_KeyEvent_VK_4, IMXK_4, MyTrue },
    { java_awt_event_KeyEvent_VK_5, IMXK_5, MyTrue },
    { java_awt_event_KeyEvent_VK_6, IMXK_6, MyTrue },
    { java_awt_event_KeyEvent_VK_7, IMXK_7, MyTrue },
    { java_awt_event_KeyEvent_VK_8, IMXK_8, MyTrue },
    { java_awt_event_KeyEvent_VK_9, IMXK_9, MyTrue },

    { java_awt_event_KeyEvent_VK_EQUALS, IMXK_equal, MyTrue },
    { java_awt_event_KeyEvent_VK_BACK_SLASH, IMXK_backslash, MyTrue },
    { java_awt_event_KeyEvent_VK_BACK_QUOTE, IMXK_grave, MyTrue },
    { java_awt_event_KeyEvent_VK_OPEN_BRACKET, IMXK_bracketleft, MyTrue },
    { java_awt_event_KeyEvent_VK_CLOSE_BRACKET, IMXK_bracketright, MyTrue },
    { java_awt_event_KeyEvent_VK_SEMICOLON, IMXK_semicolon, MyTrue },
    { java_awt_event_KeyEvent_VK_QUOTE, IMXK_apostrophe, MyTrue },
    { java_awt_event_KeyEvent_VK_COMMA, IMXK_comma, MyTrue },
    { java_awt_event_KeyEvent_VK_PERIOD, IMXK_period, MyTrue },
    { java_awt_event_KeyEvent_VK_SLASH, IMXK_slash, MyTrue },

    { java_awt_event_KeyEvent_VK_NUMPAD0, IMXK_KP_0, MyTrue },
    { java_awt_event_KeyEvent_VK_NUMPAD1, IMXK_KP_1, MyTrue },
    { java_awt_event_KeyEvent_VK_NUMPAD2, IMXK_KP_2, MyTrue },
    { java_awt_event_KeyEvent_VK_NUMPAD3, IMXK_KP_3, MyTrue },
    { java_awt_event_KeyEvent_VK_NUMPAD4, IMXK_KP_4, MyTrue },
    { java_awt_event_KeyEvent_VK_NUMPAD5, IMXK_KP_5, MyTrue },
    { java_awt_event_KeyEvent_VK_NUMPAD6, IMXK_KP_6, MyTrue },
    { java_awt_event_KeyEvent_VK_NUMPAD7, IMXK_KP_7, MyTrue },
    { java_awt_event_KeyEvent_VK_NUMPAD8, IMXK_KP_8, MyTrue },
    { java_awt_event_KeyEvent_VK_NUMPAD9, IMXK_KP_9, MyTrue },
    { java_awt_event_KeyEvent_VK_MULTIPLY, IMXK_KP_Multiply, MyTrue },
    { java_awt_event_KeyEvent_VK_ADD, IMXK_KP_Add, MyTrue },
    { java_awt_event_KeyEvent_VK_SUBTRACT, IMXK_KP_Subtract, MyTrue },
    { java_awt_event_KeyEvent_VK_DECIMAL, IMXK_KP_Decimal, MyTrue },
    { java_awt_event_KeyEvent_VK_DIVIDE, IMXK_KP_Divide, MyTrue },
    { java_awt_event_KeyEvent_VK_EQUALS, IMXK_KP_Equal, MyTrue },
    { java_awt_event_KeyEvent_VK_INSERT, IMXK_KP_Insert, MyFalse },
    { java_awt_event_KeyEvent_VK_ENTER, IMXK_KP_Enter, MyFalse },

    { java_awt_event_KeyEvent_VK_F1, IMXK_F1, MyFalse },
    { java_awt_event_KeyEvent_VK_F2, IMXK_F2, MyFalse },
    { java_awt_event_KeyEvent_VK_F3, IMXK_F3, MyFalse },
    { java_awt_event_KeyEvent_VK_F4, IMXK_F4, MyFalse },
    { java_awt_event_KeyEvent_VK_F5, IMXK_F5, MyFalse },
    { java_awt_event_KeyEvent_VK_F6, IMXK_F6, MyFalse },
    { java_awt_event_KeyEvent_VK_F7, IMXK_F7, MyFalse },
    { java_awt_event_KeyEvent_VK_F8, IMXK_F8, MyFalse },
    { java_awt_event_KeyEvent_VK_F9, IMXK_F9, MyFalse },
    { java_awt_event_KeyEvent_VK_F10, IMXK_F10, MyFalse },
    { java_awt_event_KeyEvent_VK_F11, IMXK_F11, MyFalse },
    { java_awt_event_KeyEvent_VK_F12, IMXK_F12, MyFalse },

    { java_awt_event_KeyEvent_VK_DELETE, IMXK_Delete, MyTrue },
    { java_awt_event_KeyEvent_VK_DELETE, IMXK_KP_Delete, MyTrue },

/*    { java_awt_event_KeyEvent_VK_NUM_LOCK, IMXK_Num_Lock, MyFalse },*/
    { java_awt_event_KeyEvent_VK_SCROLL_LOCK, IMXK_Scroll_Lock, MyFalse },
/*    { java_awt_event_KeyEvent_VK_PRINTSCREEN, IMXK_Print, MyFalse },*/

/*    { java_awt_event_KeyEvent_VK_ACCEPT, IMXK_Execute, MyFalse },
    { java_awt_event_KeyEvent_VK_CONVERT, IMXK_Henkan, MyFalse },
    { java_awt_event_KeyEvent_VK_NONCONVERT, IMXK_Muhenkan, MyFalse },
    { java_awt_event_KeyEvent_VK_MODECHANGE, IMXK_Henkan_Mode, MyFalse },
    { java_awt_event_KeyEvent_VK_KANA, IMXK_Katakana, MyFalse },
    { java_awt_event_KeyEvent_VK_KANA, IMXK_kana_switch, MyFalse },
    { java_awt_event_KeyEvent_VK_KANJI, IMXK_Kanji, MyFalse },
*/
    { 0, 0, 0 }
};

