/*
 * Copyright 2003 Sun Microsystems Inc.
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Karl Park <karl.park@sun.com>
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>
#include <stdlib.h>
#include <gtk/gtk.h>

#define _(String) String

typedef struct _option_info option_info;


struct _option_info {
    GtkWidget *option_aux;
    GtkWidget *option_keyboard;
    GtkWidget *option_charset;
    GtkWidget *option_autocommit;
};

static option_info *create_ui (GtkWidget *parent);
static GtkWidget *create_keyboard_option (GtkWidget *frame);
static GtkWidget *create_charset_option (GtkWidget *frame);
static GtkWidget *create_hanja_conversion_option (GtkWidget *frame);
static GtkWidget *create_autocommit_option (GtkWidget *frame);

int
main (int argc, char *argv[])
{
    GtkWidget *main_window;
    option_info *oi;

    gtk_init (&argc, &argv);
    main_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

    oi = create_ui (main_window);
    
    gtk_widget_show (oi->option_aux);
    /*
    gtk_widget_show (main_window);
    */
    
    gtk_main ();
    
    return 0;

}

static option_info *
create_ui (GtkWidget *parent)
{
    option_info *poi;
    GtkWidget *vbox;
    GtkWidget *keyboard_option;
    GtkWidget *charset_option;
    GtkWidget *autocommit_option;
    
    GtkWidget *frame_keyboard;
    GtkWidget *frame_charset_reduction;
    GtkWidget *frame_hanja_conversion;
    GtkWidget *frame_autocommit;

    static gchar *p_str_charsetreduction = _("Character set reduction mode");
    static gchar *p_str_autocommit = _("Character Basis auto-commit");
    
    poi = (option_info *) calloc (1, sizeof (option_info));

    /*
      Vertical box for packing stuffs
     */
    vbox = gtk_vbox_new (FALSE, 20);
    gtk_container_add (GTK_CONTAINER (parent), vbox);
    gtk_widget_show (vbox);

    poi->option_aux = vbox;
    
    /* Keyboard Layout selection frame */
    frame_keyboard = gtk_frame_new (_("Default Keyboard Layout Selction"));
    
    /**/ keyboard_option = create_keyboard_option (frame_keyboard);
    /*gtk_widget_show (keyboard_option);*/
    
    gtk_box_pack_start (GTK_BOX (vbox), frame_keyboard, TRUE, TRUE, 200);
    gtk_widget_show (frame_keyboard);
    
    poi->option_keyboard = keyboard_option;
    /* Chracter set reduction mode */

    frame_charset_reduction = gtk_frame_new (p_str_charsetreduction);
    charset_option = create_charset_option (frame_charset_reduction);
    gtk_box_pack_start (GTK_BOX (vbox), frame_charset_reduction,
			FALSE, TRUE, 10);
    gtk_widget_show (frame_charset_reduction);
    poi->option_charset = charset_option;
    /* Hanja conversion format */
    frame_hanja_conversion =
	gtk_frame_new (_("Hanja conversion format"));
    
    (void) create_hanja_conversion_option (frame_hanja_conversion);
    gtk_box_pack_start (GTK_BOX (vbox), frame_hanja_conversion,
			TRUE, FALSE, 0);
    gtk_widget_show (frame_hanja_conversion);
    /* Automatic commit on a character basis */
    frame_autocommit = gtk_frame_new (p_str_autocommit);
    autocommit_option = create_autocommit_option (frame_autocommit);
    gtk_box_pack_start (GTK_BOX (vbox), frame_autocommit,
			TRUE, FALSE, 10);
    poi->option_autocommit = autocommit_option;
    gtk_widget_show (frame_autocommit);
    
    return poi;
}

static GtkWidget *
create_keyboard_option (GtkWidget *frame)
{
    static gchar *keyboard_list[] = {
	_("2 pair"),
	_("3 pair 390"),
	_("3 pair final"),
    };
    static gchar *p_label =
	_("This enables you to choose default keyboard layout");
    
    GtkWidget *combo_keyboard;
    GList *list_keyboard = NULL;
    GtkWidget *vbox;
    GtkWidget *label_keyboard;
    int i;

    g_return_val_if_fail (GTK_IS_FRAME (frame), NULL);
    
    for (i = 0; i < sizeof (keyboard_list) / sizeof (keyboard_list[0]);i++){
	list_keyboard = g_list_append (list_keyboard, keyboard_list [i]);
    }

    vbox = gtk_vbox_new (FALSE, 10);
    gtk_container_add (GTK_CONTAINER (frame), vbox);
    gtk_widget_show (vbox);
    label_keyboard = gtk_label_new (p_label);
    gtk_box_pack_start (GTK_BOX (vbox), label_keyboard,
			FALSE, FALSE, 5);
    gtk_widget_show (label_keyboard);
    
    /* combo box creationg and population */
    combo_keyboard = gtk_combo_new ();
    gtk_combo_set_popdown_strings (GTK_COMBO (combo_keyboard), list_keyboard);
    g_list_free (list_keyboard); /* I can free GList here */
    gtk_box_pack_start (GTK_BOX (vbox),combo_keyboard,
			FALSE, FALSE, 5);
    gtk_widget_show (combo_keyboard);

    return combo_keyboard;

}

static GtkWidget *
create_charset_option (GtkWidget *frame)
{
    GtkWidget *vbox;
    GtkWidget *check_charset;
    static const gchar *p_label = _("Use Character set reduction mode");
    
    g_return_val_if_fail (GTK_IS_FRAME (frame), NULL);
    
    vbox = gtk_vbox_new (FALSE, 10);
    gtk_container_add (GTK_CONTAINER (frame), vbox);

    check_charset = gtk_check_button_new_with_label (p_label);
    gtk_box_pack_start (GTK_BOX (vbox), check_charset,
			FALSE, FALSE, 5);
    gtk_widget_show (check_charset);
    gtk_widget_show (vbox);
    
    return check_charset;
}


static GtkWidget *
create_hanja_conversion_option (GtkWidget *frame)
{
    GtkWidget *vbox;
    GSList *group = NULL;
    GtkWidget *radio_button;
    int i;
    static const gchar *p_str[] = {
	_("hanja"),
	_("hanja(hangul)"),
	_("hangul(hanja)")
    };

    g_return_val_if_fail (GTK_IS_FRAME (frame), NULL);
    

    vbox = gtk_vbox_new (FALSE, 10);
    gtk_container_add (GTK_CONTAINER (frame), vbox);

    
    for (i = 0, group = NULL ; i < 3; i++){
	
	radio_button =
	    gtk_radio_button_new_with_label (group, p_str[i]);
	group =
	    gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio_button));
	gtk_box_pack_start (GTK_BOX (vbox),radio_button, TRUE, TRUE, 0);
	gtk_widget_show (radio_button);
    }
    gtk_widget_show (vbox);
    return vbox;
}

static GtkWidget *
create_autocommit_option (GtkWidget *frame)
{
    GtkWidget *vbox;
    GtkWidget *check_commitoption;
    static const gchar *p_label =
	_("Automatically commit on a character basis");
    
    g_return_val_if_fail (GTK_IS_FRAME (frame), NULL);
    
    vbox = gtk_vbox_new (FALSE, 10);
    gtk_container_add (GTK_CONTAINER (frame), vbox);

    check_commitoption = gtk_check_button_new_with_label (p_label);
    gtk_box_pack_start (GTK_BOX (vbox), check_commitoption,
			FALSE, FALSE, 5);
    gtk_widget_show (check_commitoption);
    gtk_widget_show (vbox);
    
    return check_commitoption;
}
