#ifndef __METHOD_H__
#define __METHOD_H__

#include <stdio.h>
#include <string.h>

#include "key_event.h"
#include "le.h"
#include "encode.h"
#include "xaux_locale.h"
#include "logf.h"

void auxevent_handler (iml_session_t *s, IMAuxEvent *ev);

void proc_aux_event(iml_session_t *s, IMAuxEvent *auxevent);

void proc_paletteaux_connect_event();
void proc_paletteaux_switch_conversion_event();
void proc_paletteaux_switch_hex_inputmode_event();
void proc_paletteaux_switch_junjabanja_event();
void proc_paletteaux_hangul_hanja_conversion_event();
void proc_paletteaux_change_position_event();
void proc_paletteaux_show_selectaux_event(iml_session_t *s);
void proc_selectaux_update_imeinfo_event(iml_session_t *s);
void proc_paletteaux_show_optionaux_event(iml_session_t *s);
void proc_paletteaux_show_keyboardaux_event(iml_session_t *s, int nKeyboardID);
void proc_paletteaux_hide_keyboardaux_event(iml_session_t *s);
void proc_paletteaux_show_lookupaux_event(iml_session_t *s);
void proc_paletteaux_start_action_event(iml_session_t *s, char *command_str);
void proc_paletteaux_set_options_event(iml_session_t *s, IMAuxDrawCallbackStruct *aux_data);
void proc_paletteaux_switch_input_mode_event(iml_session_t *s, int imode);
/* For different keyboard layout support */
/* void proc_paletteaux_switch_keyboardlayout_event(iml_session_t *s, int nKeyboardLayoutID); */
void proc_keyboardaux_change_position_event(iml_session_t *s, int x, int y);
void proc_keyboardaux_change_key_status_event(iml_session_t *s, int key_status);
void proc_lookupaux_change_position_event(iml_session_t *s, int x, int y);
void proc_lookupaux_change_status_event(iml_session_t *s, int on);
void proc_selectaux_change_status_event(iml_session_t *s, int on);
void proc_optionaux_change_status_event(iml_session_t *s, int on);
void proc_commonaux_commit_string_event(iml_session_t *s, int locale_id, char *commit_str);
void proc_commonaux_commit_key_event(iml_session_t *s, int keycode, int keychar, int keystatus);
void proc_commonaux_lost_focus_event(iml_session_t *s);

void le_show_selectaux_notify(iml_session_t *s);
void le_show_optionaux_notify(iml_session_t *s);
void le_show_keyboardaux_notify(iml_session_t *s, int nKeyboardID, int engine_id);
void le_show_lookupaux_notify(iml_session_t *s);
void le_start_action_notify(iml_session_t *s, char *command_str);
void le_imeinfo_notify(iml_session_t *s, char *classname, int aux_locale_id);
void le_update_paletteaux_input_mode_info(iml_session_t *s, int imode);
void le_update_optionaux_argsinfo(iml_session_t *s);
void le_update_keymapinfo_notify(iml_session_t *s, int engine_id);
void le_change_focus_notify(iml_session_t *s);
void le_switch_junjabanja_notify(iml_session_t *s, int junjabanja);

void auxhandler_send_session_property (iml_session_t *s, char *classname);

#endif /* __METHOD_H__ */
