#include <stdio.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "ctim.h"
#include "ctim_messages.h"

ImePropertyRec ctim_options[] = {
#if 0
    { KEYBYKEY_MODE_ID,   ENCODE_UTF8, "/input_style",    KEYBYKEY_MODE_STR, NULL, ImeProperty_Toggle, {0, 0}, 0},
    { HELPINFO_MODE_ID,   ENCODE_UTF8, "/codehinting",    HELPINFO_MODE_STR,   NULL, ImeProperty_Toggle, {0, 0}, 0},
    { AUTOSELECT_MODE_ID, ENCODE_UTF8, "/singleselect",   AUTOSELECT_MODE_STR, NULL, ImeProperty_Toggle, {0, 0}, 1},
    { KEYPROMPT_MODE_ID,  ENCODE_UTF8, "/keyprompt",      KEYPROMPT_MODE_STR, NULL, ImeProperty_Toggle, {0, 0}, 0},
#endif
    { KEYMAPPING_MODE_ID, ENCODE_UTF8, "/keymapping",     KEYMAPPING_MODE_STR, NULL, ImeProperty_Selection, {0, 0}, 0},
};

ImePropertyListRec ctim_optionlist = {
    sizeof(ctim_options)/sizeof(ImePropertyRec),
    ctim_options
};

extern ImmServices imm_services;

char *ctim_get_keymapping_string(CodeTableStruct *ctHeader)
{
	int i;
        char *keymapping_str = NULL;

        if (ctHeader == NULL || ctHeader->keyprompt == NULL)
		return NULL;

	if (GETBIT(ctHeader->bSectionsFlag, KEYPROMPT_SECTION)) {
		int buf_len = 0;
		int item_num = 0;
		char ch;

		char *prefix = "keymapping:/default";

		for (i = 0; i < MAX_USEDCODES_NUM; i ++) {
			ch = ctHeader->UsedCodes[i];

			if (ch == 0) break;

			if (ctHeader->keyprompt[ch].prompt[0] != 0) {
				item_num ++;
				buf_len += strlen (ctHeader->keyprompt[ch].prompt);
				DEBUG_printf("%c: %s\n", ch, ctHeader->keyprompt[ch].prompt);
			}
		}

		if (buf_len > 0) {
			buf_len += (item_num * 2 + strlen (prefix)) + 3;

			keymapping_str = (char *)calloc (1, buf_len);
			snprintf(keymapping_str, buf_len, "%s", prefix);

			for (i = 0; i < MAX_USEDCODES_NUM; i ++) {
				char key_str[256];

				ch = ctHeader->UsedCodes[i];
				if (ch == 0) break;

				if (ctHeader->keyprompt[ch].prompt[0] != 0) {
					char *format_str = "|%c%s";
					if (ch == '/' || ch == '|') {
						format_str = "|\\%c%s";
					}
					snprintf(key_str, 256, format_str,
						 ch, ctHeader->keyprompt[ch].prompt);
					strncat(keymapping_str, key_str, buf_len);
				}
			}
			DEBUG_printf("keymapping_str: %s\n", keymapping_str);
                }
	}

	return keymapping_str;
}

ImeResult ctim_Init_Ime_Properties(ImeInfoRec *ctim_info, CodeTableStruct *ctHeader)
{
#if 0
	int i;
	ImePropertyListRec *pl;

	if (ctim_info == NULL || ctHeader == NULL)
		return (IME_FAIL);

	DEBUG_printf("ctim_Init_Ime_Properties\n");

	pl = (ImePropertyListRec *)calloc(1, sizeof (ImePropertyListRec));
	if (pl == NULL)
		return (IME_FAIL);

	pl->properties = (ImePropertyRec *)calloc (CTIM_ARGS_NUM, sizeof(ImePropertyRec));
	if (pl->properties == NULL) {
		free ((char *) pl);
		return (IME_FAIL);
	}

	pl->count = CTIM_ARGS_NUM;
	for (i = 0; i < CTIM_ARGS_NUM; i ++) {
		ImePropertyRec *pi = &(pl->properties[i]);

		pi->id = ctim_options[i].id;
		pi->encode = ctim_options[i].encode;
		pi->key = ctim_options[i].key;
		pi->name = ctim_options[i].name;
		pi->tip = ctim_options[i].tip;
		pi->type = ctim_options[i].type;
		pi->range = ctim_options[i].range;
	}

	pl->properties[KEYBYKEY_MODE_ID].value.int_value = ctHeader->nKeyByKeyMode;
	pl->properties[HELPINFO_MODE_ID].value.int_value = ctHeader->nHelpInfoMode;
	pl->properties[AUTOSELECT_MODE_ID].value.int_value = ctHeader->nAutoSelectMode;
	pl->properties[KEYPROMPT_MODE_ID].value.int_value = ctHeader->nKeyPromptMode;
#endif

	ctim_options[0].encode = ctHeader->Encode;
	ctim_options[0].name = (char *)ctim_get_keymapping_string(ctHeader);
	ctim_options[0].value.int_value = 0;

	ctim_info->pl = (ImePropertyListRec *)(&ctim_optionlist);

	return (IME_OK);
}

ImeResult ctim_Destroy_Ime_Properties(ImeInfoRec *ctim_info)
{
#if 0
	if (ctim_info == NULL)
		return (IME_FAIL);

	DEBUG_printf("ctim_Destroy_Ime_Properties\n");

	if (ctim_info->pl) {
		if (ctim_info->pl->properties)
			free ((char *) ctim_info->pl->properties);
		free ((char *) ctim_info->pl);
	}
#endif

	if (ctim_options[0].name)
		free ((char *)ctim_options[0].name);
	ctim_options[0].name = NULL;

	return (IME_OK);
}

ImeResult ctim_Set_Ime_Properties(ImeInputContext ic, CodeTableStruct *ctHeader)
{
#if 0
	int i;
	ImePropertyListRec *pl;
	ImePropertyRec *pi;

	DEBUG_printf("ctim_Set_Ime_Properties\n");

	if (ctHeader == NULL)
		return (IME_FAIL);

        pl = imm_services->ImmGetPropertyList(ic);
	if (pl != NULL && pl->count > 0 && pl->properties != NULL) {
		for (i = 0; i < pl->count; i++) {
			pi = &(pl->properties[i]);
			switch (pi->id) {
			case KEYBYKEY_MODE_ID:
				ctHeader->nKeyByKeyMode =  pi->value.int_value;
				break;
			case HELPINFO_MODE_ID:
				ctHeader->nHelpInfoMode = pi->value.int_value;
				break;
			case AUTOSELECT_MODE_ID:
				ctHeader->nAutoSelectMode = pi->value.int_value;
				break;
			case KEYPROMPT_MODE_ID:
				ctHeader->nKeyPromptMode = pi->value.int_value;
				break;
			}
		}
	}
#endif

        ctHeader->nKeyByKeyMode = 0;
        ctHeader->nHelpInfoMode = 0;
        ctHeader->nAutoSelectMode = 1;
        ctHeader->nKeyPromptMode = 1;

	return (IME_OK);
}
