#include <stdio.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "ctim.h"
#include "zhuyin_data.h"
#include "zhuyin_messages.h"

char **KeymappingOptions = NULL;

ImePropertyRec zhuyin_options[] = {
    { ZHUYIN_KEYMAP_MODE_ID,     ENCODE_UTF8, "/keymapping",     ZHUYIN_KEYMAP_MODE_STR, NULL, ImeProperty_Selection, {0, 0}, 0},
    { ZHUYIN_AUTOSELECT_MODE_ID, ENCODE_UTF8, "/singleselect",   ZHUYIN_AUTOSELECT_MODE_STR, NULL, ImeProperty_Toggle, {0, 0}, 1},
};

ImePropertyListRec zhuyin_optionlist = {
    sizeof(zhuyin_options)/sizeof(ImePropertyRec),
    zhuyin_options
};

extern ImmServices imm_services;

char *zhuyin_get_keymapping_string(TZhuyinKeymap *pZhuyinKeymap)
{
	int idx;
	char ch;
	int buf_len = 0;
        char *keymapping_str = NULL;

        if (pZhuyinKeymap == NULL ||
	    pZhuyinKeymap->pName == NULL ||
	    pZhuyinKeymap->pKeymap == NULL)
		return NULL;

	buf_len = strlen (pZhuyinKeymap->pName);
	for (idx = 1; idx <= NUM_OF_ZHUYIN_SYMBOL; idx++) {
		ch = pZhuyinKeymap->pKeymap[idx];
       		if (ch != 0) {
			buf_len += strlen((char *)ZhuyinIndexToZhuyinSymbol(idx));
       		}
       	}

	buf_len += (NUM_OF_ZHUYIN_SYMBOL * 2 + 3);

	keymapping_str = (char *)calloc (buf_len, sizeof (char));
	if (keymapping_str == NULL)
		return NULL;

	snprintf(keymapping_str, buf_len, "%s", pZhuyinKeymap->pName);

	for (idx = 1; idx <= NUM_OF_ZHUYIN_SYMBOL; idx++) {
		char key_str[256];
		ch = pZhuyinKeymap->pKeymap[idx];
       		if (ch != 0) {
			char *format_str = "|%c%s";
			if (ch == '/' || ch == '|') {
				format_str = "|\\%c%s";
			}
			snprintf(key_str, 256, format_str,
				 ch, ZhuyinIndexToZhuyinSymbol(idx));
			strncat(keymapping_str, key_str, buf_len);
       		}
       	}

	DEBUG_printf("keymapping_str: %s\n", keymapping_str);

	return keymapping_str;
}

ImeResult zhuyin_Init_Ime_Properties(ImeInfoRec *zhuyin_info,  TZhuyinData *pZhuyinData)
{
	int i;
	int num_keymappings;

	if (zhuyin_info == NULL || pZhuyinData == NULL)
		return (IME_FAIL);

	DEBUG_printf("zhuyin_Init_Ime_Properties\n");

	if (KeymappingOptions == NULL &&
	    pZhuyinData->pZhuyinKeymapList &&
	    pZhuyinData->pZhuyinKeymapList->nNum_Keymaps > 0){
		int idx;
		num_keymappings = pZhuyinData->pZhuyinKeymapList->nNum_Keymaps;
		KeymappingOptions = (char **)calloc (num_keymappings + 1, 
						     sizeof (char *));
		idx = 0;
		for (i = 0; i < num_keymappings; i++) {
			char *keymapping_str;
			keymapping_str = (char *)zhuyin_get_keymapping_string(pZhuyinData->pZhuyinKeymapList->pKeymaps[i]);

			if (keymapping_str)
				KeymappingOptions[idx++] = keymapping_str;
		}
	}

	zhuyin_options[ZHUYIN_KEYMAP_MODE_ID].range.multiString_range = KeymappingOptions;
	zhuyin_options[ZHUYIN_KEYMAP_MODE_ID].value.int_value = 0;
	zhuyin_options[ZHUYIN_AUTOSELECT_MODE_ID].value.int_value = 1;

	zhuyin_info->pl = (ImePropertyListRec *)(&zhuyin_optionlist);

	return (IME_OK);
}

ImeResult zhuyin_Destroy_Ime_Properties(ImeInfoRec *zhuyin_info)
{
	int i;

	if (KeymappingOptions != NULL) {
		for (i = 0; KeymappingOptions[i]; i++) {
			free ((char *) KeymappingOptions[i]);
		}
		free ((char *)KeymappingOptions);
	}

	return (IME_OK);
}

ImeResult zhuyin_Set_Ime_Properties(ImeInputContext ic, TZhuyinData *pZhuyinData)
{
	int i;
	CodeTableStruct *ctHeader;
	ImePropertyListRec *pl;
	ImePropertyRec *pi;

	DEBUG_printf("zhuyin_Set_Ime_Properties\n");

	if (pZhuyinData == NULL || pZhuyinData->pCodetableHeader == NULL)
		return (IME_FAIL);

	pZhuyinData->nCurrentKeymapID = 0;

	/* ctHeader's argument setting are always coveried by user defined data */
	ctHeader = pZhuyinData->pCodetableHeader;
	ctHeader->nKeyByKeyMode = 0;
	ctHeader->nHelpInfoMode = 0;
	ctHeader->nAutoSelectMode = 1;
	ctHeader->nKeyPromptMode = 1;

        pl = imm_services->ImmGetPropertyList(ic);
	if (pl != NULL && pl->count > 0 && pl->properties != NULL) {
		for (i = 0; i < pl->count; i++) {
			pi = &(pl->properties[i]);
			switch (pi->id) {
			case ZHUYIN_KEYMAP_MODE_ID:
				pZhuyinData->nCurrentKeymapID  =  pi->value.int_value;
				break;
			case ZHUYIN_AUTOSELECT_MODE_ID:
				ctHeader->nAutoSelectMode = pi->value.int_value;
				break;
			}
		}
	}

	return (IME_OK);
}
