#ifndef _THAI_PROTOCOL_H_
#define _THAI_PROTOCOL_H_

/***************************************************************************/
/*         Protocol used by Auxiliary window and Language Engine           */
/***************************************************************************/
/* Conversion Status */
#define CONVERSION_OFF 			0
#define CONVERSION_ON 			1

/* Types of Input Method Switching */
#define IME_ROUND_SWITCH  		0
#define IME_SELECT_SWITCH		1

/* Protocol Number between Auxiliary Window and Language Engine */
enum _protocol_id_list {

	/* For PaletteAux */
	PALETTEAUX_CONNECT = 0,
	PALETTEAUX_SWITCH_CONVERSION,
	PALETTEAUX_SWITCH_ISC_MODE,
	PALETTEAUX_CHANGE_POSITION,
	PALETTEAUX_SHOW_OPTIONAUX,
	PALETTEAUX_SHOW_KEYBOARDAUX,
	PALETTEAUX_SHOW_LOOKUPAUX,
	PALETTEAUX_START_ACTION,

	PALETTEAUX_UPDATE_IMEINFO_NOTIFY,
	PALETTEAUX_SWITCH_CONVERSION_NOTIFY,
	PALETTEAUX_SWITCH_ISC_MODE_NOTIFY,

	/* For Common used protocol */
	COMMONAUX_COMMIT_KEY = 20,
	COMMONAUX_COMMIT_STRING,
	COMMONAUX_LOST_FOCUS,
	COMMONAUX_SET_DEFAULT_VALUE,
	COMMONAUX_GET_DEFAULT_VALUE,

	COMMONAUX_CHANGE_FOCUS_NOTIFY,
	COMMONAUX_UPDATE_KEYMAPINFO_NOTIFY,
	COMMONAUX_SET_IME_NEW_NOTIFY,
	COMMONAUX_SET_IME_INFO_NOTIFY,
	COMMONAUX_SET_IME_END_NOTIFY,

	COMMONAUX_MODE_NAME_NOTIFY,
	COMMONAUX_KEYBOARD_NAME_NOTIFY,
	COMMONAUX_KEYBOARD_LAYOUT_NOTIFY,

	/* For OptionAux */
	OPTIONAUX_CONNECT = 40,
	OPTIONAUX_CHANGE_STATUS,

	OPTIONAUX_SHOW_NOTIFY,
	OPTIONAUX_HIDE_NOTIFY,

	/* For KeyboardAux */
	KEYBOARDAUX_CONNECT = 60,
	KEYBOARDAUX_CHANGE_POSITION,
	KEYBOARDAUX_CHANGE_KEY_STATUS,

	KEYBOARDAUX_SHOW_NOTIFY,
	KEYBOARDAUX_HIDE_NOTIFY,
	KEYBOARDAUX_PRESS_KEY_NOTIFY,

	/* For ActionAux */
	ACTIONAUX_CONNECT = 80,
	ACTIONAUX_START_ACTION_NOTIFY,

};

#endif   /* _THAI_PROTOCOL_H_  */

