#include <stdio.h>

#include "config.h"
#include "le_object.h"

extern char lename_string[];
extern UTFCHAR lename_utf_string[];
extern IMLocale locales[];

static IMLEName lename = { lename_string, lename_utf_string };

#define  LE_VERSION    "2.0"

LeObjectRec *le_object_new()
{
    LeObjectRec *le_object = NULL;
    IMObjectDescriptorStruct *im_objects, *l;
    char auxiliary_object_path[256];

    le_object = (LeObjectRec *) calloc(1, sizeof(LeObjectRec));
    if (le_object == NULL)
        return (NULL);

    /* initilize the IMObjectDescriptorStruct */
    im_objects = (IMObjectDescriptorStruct *) calloc(2, sizeof(IMObjectDescriptorStruct));
    if (im_objects == NULL) {
	free ((char *)le_object);
	return (NULL);
    }

    sprintf(auxiliary_object_path,
	    "./locale/%s/%s/auxiliary_windows/auxiliary_object.so", LE_LANG, LE_NAME);
    l = im_objects;
    l->leid = lename_string;	/* engine id */
    l->type = IM_DOWNLOADINGOBJECT_BINGUI_TYPE;	/* object type */
    l->name = lename_utf_string;
    l->name_length = UTFCHARLen(lename_utf_string);
    l->domain = "com.sun";
    l->scope = lename_string;

    /* path for .so from /usr/lib/im/ */
    l->path = (char *) strdup(auxiliary_object_path);

    l->signature = "";
    l->basepath = NULL;		/* only for CCDEF */
    l->encoding = NULL;		/* only for CCDEF */

    /* initilize the le_object info */
    le_object->version = LE_VERSION;

    le_object->lename = (IMLEName *) &lename;
    le_object->locales = (IMLocale **) &locales;

    le_object->objects = im_objects;

    return (le_object);
}

void le_object_destroy(LeObjectRec *le_object)
{
    IMObjectDescriptorStruct *im_objects;

    if (le_object == NULL)
	return;

    im_objects = le_object->objects;
    if (im_objects == NULL)
	return;

    if (im_objects->path)
	free((char *) im_objects->path);

    free((char *) im_objects);
    free((char *) le_object);

    return;
}
