/*
  Copyright 2002-2003 Sun Microsystems, Inc. All Rights Reserved.

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the
  "Software"), to deal in the Software without restriction, including
  without limitation the rights to use, copy, modify, merge, publish,
  distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to
  the following conditions: The above copyright notice and this
  permission notice shall be included in all copies or substantial
  portions of the Software.


  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
  IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
  THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
  ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


  Except as contained in this notice, the names of The Open Group and/or
  Sun Microsystems, Inc. shall not be used in advertising or otherwise to
  promote the sale, use or other dealings in this Software without prior
  written authorization from The Open Group and/or Sun Microsystems,
  Inc., as applicable.


  X Window System is a trademark of The Open Group

  OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
  logo, LBX, X Window System, and Xinerama are trademarks of the Open
  Group. All other trademarks and registered trademarks mentioned herein
  are the property of their respective owners. No right, title or
  interest in or to any trademark, service mark, logo or trade name of
  Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef _CODETABLE_H_
#define _CODETABLE_H_

/* Limit Constant Defination */
#define MAX_CHNAME_LEN		256 
#define MAX_USEDCODES_NUM	126 
#define MAX_WILDCHAR_NUM  4

/* Limit of Key Prompt */
#define MAX_KEYPROMPT_LEN	4 

/* Limit of Function Key */
#define MAX_FUNCTIONKEY_LEN	6

/* CodeTable File Distinguishment Flag */
#define CODETABLE_FLAG		"CODETABLE"

/* Version Defination */
#define CODETABLE_VERSION	1

/* Section Constant */
enum _Section_List {
  DEFAULT_SECTION = 0,
  DESCRIPTION_SECTION,
  COMMENT_SECTION	,
  KEYPROMPT_SECTION,
  FUNCTIONKEY_SECTION,
  PHRASE_SECTION	,
  SINGLE_SECTION	,
  OPTIONS_SECTION	,
  MAX_SECTION_NUM
};

/* Function Key Defination */
enum _Function_Key_ID {
  PAGEUP_KEY_ID = 0,
  PAGEDOWN_KEY_ID,
  BACKSPACE_KEY_ID,
  CLEARALL_KEY_ID	,
  MAX_FUNCTIONKEY_NUM
};

/* Options Mode Defination */
enum _Option_Mode {
  OFF_MODE = 0,
  ON_MODE	,
};

/* SelectKey Mode Defination */
enum _Select_Key_Mode {
  NUMBER_MODE = 0,
  LOWER_MODE,
  UPPER_MODE,
};

/* Phrase Seperate Tag */
#define HZ_PHRASE_TAG 		'\001'

/* Bit Operations */
#define BITMASK(i) 		(1 << (i))
#define BITSET(a, i) 		((a) |= BITMASK(i))
#define BITCLEAR(a, i) 		((a) &= ~BITMASK(i))
#define GETBIT(a, i) 		((a) & BITMASK(i))

typedef struct _tableNode {
  int keycode;
  int modifier;
  unsigned char   num_NextKeys; 	/* number of possible next input key */
  unsigned short 	num_HZchoice; 	/* number of HZ choices */
  unsigned int 	pos_NextKey;	/* table node pos of next key */
  unsigned int 	pos_HZidx;	/* index of HZ list */
} tableNode;
	
typedef struct _keyPrompt {
  unsigned char	prompt[MAX_KEYPROMPT_LEN + 1];
} keyPrompt;

typedef struct _functionKey {
  unsigned char	keylist[MAX_FUNCTIONKEY_LEN + 1];
} functionKey;

/* codetable file header structure */
typedef struct {
  char		Encode;				/* UTF-8 or native: encode of dict */	
  unsigned char   Lname[MAX_CHNAME_LEN];
  unsigned char 	Cname[MAX_CHNAME_LEN];  	/* IM Name */
  char          	UsedCodes[MAX_USEDCODES_NUM];   /* Characters for valid input */
  unsigned char   WildChar[MAX_WILDCHAR_NUM]; /* Characters for WildChar */
  char          	MaxCodes;			/* Max number of extern codes */

  char		bSectionsFlag;			/* sections exist flag */

  char		Output_Encode;			/* encode of output */
  unsigned 	nKeyByKeyMode 		:1;
  unsigned 	nHelpInfoMode 		:1;
  unsigned 	nAutoSelectMode 	:1;
  unsigned 	nKeyPromptMode 		:1;
  unsigned 	nDisplayOnSpotMode 	:1;
  unsigned 	nSelectKeyMode 		:2;
  unsigned 	nReserved 		:1;

  unsigned int 	sizeHZList; 			/* size of whole hz list */
  unsigned int 	sizeNodeList;			/* size of whole node list */
  unsigned char 	*hzList;			/* pointer of characters list */
  tableNode	*nodeList; 			/* pointer of Tree Node List */
	
  keyPrompt 	*keyprompt; 			/* prompt list of keys */
  functionKey	*functionkey;			/* Functions key defination list */
		
} CodeTableStruct;

int LoadCodeTableHeader(char *file_name, CodeTableStruct *hztbl);
int LoadCodeTable(char *file_name, CodeTableStruct *hztbl);
void UnloadCodeTable(CodeTableStruct *hztbl);
int codetable_search(CodeTableStruct *hztbl, int *inbuf, int inlen, unsigned char **outbuf, unsigned char **attrbuf, int pos, int num);
int Is_Wildchar_Key(CodeTableStruct *hztbl, int key);

#endif    /*  _CODETABLE_H_  */
		
