#include "IIIMText.hh"

#ifndef MAX
#define MAX(x, y) ((x > y) ? (x) : (y))
#endif

void
IIIMText::set_feedback_to_painter(
    QPainter *p,
    QWidget *pw,
    int val
)
{
    /* reset the QPainter */
    p->restore();
    p->save();

    if (val & IIIMP_FEEDBACK_0_REVERSE_VIDEO) {
	QColor f = p->pen().color();
	QColor b = p->backgroundColor();
	
	p->setPen(b);
	p->setBackgroundMode(Qt::OpaqueMode);
	p->setBackgroundColor(f);
    }
    if (val & IIIMP_FEEDBACK_0_UNDERLINE) {
	QFont f = p->font();
	f.setUnderline(true);
	p->setFont(f);
    }
    if (val & IIIMP_FEEDBACK_0_HIGHLIGHT) {
	QColorGroup::ColorRole cr = QColorGroup::HighlightedText;

	p->setBackgroundMode(Qt::OpaqueMode);
	if (pw)
	    p->setBackgroundColor(pw->palette().active().color(cr));
    }
}

QSize
IIIMText::text_element_size(
    QPainter *p,
    const QSize& size,
    const QString& str
)
{
    QRect r2;
    r2 = p->boundingRect(0, 0, 100000, 100000, Qt::AlignAuto, str);
    return QSize(size.width() + r2.width(), MAX(size.height(), r2.height()));
}

QSize
IIIMText::output_string(
    QPainter *p,
    const QRect& r,
    const QSize& size,
    const QString& str
)
{
    QRect r2;

    r2 = p->boundingRect(r.left() + size.width(), r.top(),
			 r.left() + size.width() + 100000, r.bottom(),
			 Qt::AlignAuto, str);
    p->drawText(r2, Qt::AlignAuto, str);
    
    return QSize(size.width() + r2.width(), MAX(size.height(), r2.height()));
}

QSize
IIIMText::draw(
    QPainter *p,
    QWidget *pw,
    const QRect& r
)
{
    IIIMF_status st;
    IIIMP_card16 ch;
    int i, j, n;
    int nfb;
    int cf0v, f0v;
    const IIIMP_card32 *pids, *pfbs;
    QString flagment;
    QSize totsize(0, 0);

    p->save();

    st = iiimcf_get_text_length(text, &n);
    if (st != IIIMF_STATUS_SUCCESS) return totsize;
    
    cf0v = 0;
    for (i = 0; i < n; i++) {
	if (iiimcf_get_char_with_feedback(text, i, &ch, &nfb, &pids, &pfbs)
	    != IIIMF_STATUS_SUCCESS) return totsize;
	f0v = 0;
	for (j = 0; j < nfb; j++, pids++) {
	    if (*pids == 0) {
		f0v = pfbs[j];
		break;
	    }
	}
	// fprintf(stderr, "(%X, %d)", ch, f0v);
	if (f0v != cf0v) {
	    if (!flagment.isEmpty()) {
		set_feedback_to_painter(p, pw, cf0v);
		totsize = output_string(p, r, totsize, flagment);
		flagment.setLength(0);
	    }
	    cf0v = f0v;
	}
	flagment.append(QChar(ch));
    }
    if (!flagment.isEmpty()) {
	set_feedback_to_painter(p, pw, cf0v);
	totsize = output_string(p, r, totsize, flagment);
    }
    // fprintf(stderr, "\n");

    p->restore();

    return totsize;
}

QSize
IIIMText::get_size(
    QPainter *p,
    QWidget *pw
)
{
    IIIMF_status st;
    IIIMP_card16 ch;
    int i, j, n;
    int nfb;
    int cf0v, f0v;
    const IIIMP_card32 *pids, *pfbs;
    QString flagment;
    QSize totsize(0, 0);

    p->save();

    st = iiimcf_get_text_length(text, &n);
    if (st != IIIMF_STATUS_SUCCESS) return totsize;
    
    cf0v = 0;
    for (i = 0; i < n; i++) {
	if (iiimcf_get_char_with_feedback(text, i, &ch, &nfb, &pids, &pfbs)
	    != IIIMF_STATUS_SUCCESS) return totsize;
	f0v = 0;
	for (j = 0; j < nfb; j++, pids++) {
	    if (*pids == 0) {
		f0v = pfbs[j];
		break;
	    }
	}
	// fprintf(stderr, "(%X, %d)", ch, f0v);
	if (f0v != cf0v) {
	    if (!flagment.isEmpty()) {
		set_feedback_to_painter(p, pw, cf0v);
		totsize = text_element_size(p, totsize, flagment);
		flagment.setLength(0);
	    }
	    cf0v = f0v;
	}
	flagment.append(QChar(ch));
    }
    if (!flagment.isEmpty()) {
	set_feedback_to_painter(p, pw, cf0v);
	totsize = text_element_size(p, totsize, flagment);
    }
    // fprintf(stderr, "\n");

    p->restore();

    return totsize;
}

IIIMText::IIIMText(
    IIIMCF_text x_text
)
{
    iiimcf_duplicate_text(x_text, &text);
}

IIIMText::~IIIMText()
{
    iiimcf_destroy_text(text);
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
