""" IPTC module

    begin                : 03/02/11 21:27:18 rnc
    author               : (C) 2002 by Ricardo Niederberger Cabral
    email                : nieder|at|mail.ru
    $Id: IptcExtract.py,v 1.9 2003/09/07 14:00:06 niederberger Exp $        

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 * Code portions of getiptcinfo function from Fredrik Lundh fredrik@pythonware.com and PIL
    
"""
__version__ = "$Revision: 1.9 $"

try:
    import Image, TiffImagePlugin, JpegImagePlugin, IptcImagePlugin
    import StringIO
except:
    pass

class FakeImage:
    pass

#Iptc ref doc used: http://www.fotoware-psj.com/psj/support/telechargement/pdf/iimv4.pdf (page 25->...), thanks Philippe Arnone <Philippe|at|Arnone.org> for the link
infomap=    {
            5:"Object Name",
            7:"Edit status",
            8:"Editorial update",
			10:"Urgency",
			12:"Subject reference",
			15:"Category",
			20:"Supplemental category",
			22:"Fixture Identifier",            
			25:"Keywords",
			26:"Content Location Code",
			27:"Content Location Name",
			30:"Release date",
			35:"Release time",
			37:"Expiration date",
			38:"Expiration time",
			40:"Special instructions",
			42:"Action Advised",
			45:"Reference Service",
			47:"Reference Date",
			50:"Reference Number",            
			55:"Creation date",
			60:"Creation time",
			62:"Digital Creation Date",
			63:"Digital Creation Time",            
			65:"Originating program",
			70:"Program version",
			75:"Object cycle",            
			80:"By Line",
			85:"By title",
			90:"City",
			92:"Sub-location",            
			95:"State/Province",
			100:"Country",
			101:"Country2",
			103:"Original Transmission Reference",
			105:"Headline",
			110:"Credit",
			115:"Source",
            116:"Copyright Notice",
            118:"Contact",
			120:"Caption",
			122:"Caption writer",
			125:"Rasterized Caption",
			131:"Image orientation",
			135:"Language Identifier",
            }

def getiptcinfo(fname):
    # extract IPTC data from a PhotoShop JPEG or TIFF file
    data = None
    im = Image.open(fname)
    if isinstance(im, JpegImagePlugin.JpegImageFile):
        # extract the IPTC/NAA resource
        try:
            app = im.app["APP13"]
            if app[:14] == "Photoshop 3.0\x00":
                app = app[14:]
                # parse the image resource block
                offset = 0
                while app[offset:offset+4] == "8BIM":
                    offset = offset + 4
                    # resource code
                    code = JpegImagePlugin.i16(app, offset)
                    offset = offset + 2
                    # resource name (usually empty)
                    name_len = ord(app[offset])
                    name = app[offset+1:offset+1+name_len]
                    offset = 1 + offset + name_len
                    if offset & 1:
                        offset = offset + 1
                    # resource data block
                    size = JpegImagePlugin.i32(app, offset)
                    offset = offset + 4
                    if code == 0x0404:
                        # 0x0404 contains IPTC/NAA data
                        data = app[offset:offset+size]
                        break
                    offset = offset + size
                    if offset & 1:
                        offset = offset + 1
        except (AttributeError, KeyError):
            pass

    elif isinstance(im, TiffImagePlugin.TiffImageFile):
        # get raw data from the IPTC/NAA tag (PhotoShop tags the data
        # as 4-byte integers, so we cannot use the get method...)
        try:
            type, data = im.tag.tagdata[TiffImagePlugin.IPTC_NAA_CHUNK]
        except (AttributeError, KeyError):
            pass

    if data is None:
        return None # no properties
    # create an IptcImagePlugin object without initializing it
    im = FakeImage()
    im.__class__ = IptcImagePlugin.IptcImageFile
    # parse the IPTC information chunk
    im.info = {}
    im.fp = StringIO.StringIO(data)
    try:
        im._open()
    except (IndexError, KeyError):
        pass # expected failure

    return im.info
