""" XML export module

    begin                : 2003-01-26 00:37:12 rnc
    author               : (C) 2002 by Ricardo Niederberger Cabral
    email                : nieder|at|mail.ru
    $Id: dbExportXML.py,v 1.18 2004/07/26 23:58:55 niederberger Exp $

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""
from string import *

from imgSeekLib import __version__

class dbExportXML:
    def __init__(self,db,opts,batch):
        self.curdb = db
        self.opts = opts
        if self.opts["outdir"][-1] != '/': self.opts["outdir"] = self.opts["outdir"]+'/'
        self.batch = batch

    def putDir(self,doc,parent,id):
        nnode = doc.createElement("Dir")
        nnode.setAttribute("id",str(id))
        nnode.setAttribute("parent-dir-id",str(self.curdb.dirs[id][1]))
        nnode.setAttribute("description",self.curdb.dirs[id][5])
        nnode.setAttribute("volume-id",str(self.curdb.dirs[id][6]))
        for dir in self.curdb.dirs[id][2]:
            self.putDir(doc,nnode,dir)
        for img in self.curdb.dirs[id][3]:
            nnode2 = doc.createElement("Image")
            nnode2.setAttribute("id",str(img))
            nnode.appendChild(nnode2)
        parent.appendChild(nnode)

    def putGroup(self,doc,parent,id):
        nnode = doc.createElement("Group")
        nnode.setAttribute("id",str(id))
        nnode.setAttribute("parent-group-id",str(self.curdb.groups[id][2]))
        nnode.setAttribute("description",self.curdb.groups[id][1])
        nnode.setAttribute("name",self.curdb.groups[id][0])
        for dir in self.curdb.groups[id][4]:
            self.putGroup(doc,nnode,dir)
        for img in self.curdb.groups[id][3]:
            nnode2 = doc.createElement("Image")
            nnode2.setAttribute("id",str(img))
            nnode.appendChild(nnode2)
        parent.appendChild(nnode)

    def do(self):
        """ export only metadata """
        import time
        from xml.dom.minidom import Document

        try:
            outbatch = open(self.opts["outdir"]+"batch.xml","w")
            outimgs = open(self.opts["outdir"]+"imgs.xml","w")
        except:
            import traceback
            traceback.print_exc()
            msg = "Error opening output file for writing. Do you have write permissions on output dir '%s' ?" % self.opts["outdir"]
            print msg
            return msg


        ### Export Batch content
        batchdoc = Document()
        nbatch = batchdoc.createElement("Batch")
        nbatch.setAttribute("creation-time",time.asctime(time.localtime()))
        nbatch.setAttribute("imgSeek-version",__version__)
        nbatch.setAttribute("db-version",str(self.curdb.dbversion))
        batchdoc.appendChild(nbatch)

        for it in self.batch:
            if it[0] == "SysDir":
                nnode = batchdoc.createElement("SysDir")
                nnode.setAttribute("path",it[1])
                nbatch.appendChild(nnode)
            if it[0] == "Dir":
                self.putDir(batchdoc,nbatch,it[1])
            if it[0] == "Group":
                self.putGroup(batchdoc,nbatch,it[1])
            if it[0] == "SimGroup":
                nnode = batchdoc.createElement("SimGroup")
                id = it[1]
                nnode.setAttribute("id",str(id))
                nnode.setAttribute("main-image-id",str(self.curdb.simgroups[id][1]))
                for img in self.curdb.simgroups[id][2]:
                    nnode2 = batchdoc.createElement("Image")
                    nnode2.setAttribute("id",str(img))
                    nnode.appendChild(nnode2)
                nbatch.appendChild(nnode)
            if it[0] == "Img":
                nnode2 = batchdoc.createElement("Image")
                nnode2.setAttribute("id",str(it[1]))
                nbatch.appendChild(nnode2)
            if it[0] == "Volume":
                id = it[1]
                nnode = batchdoc.createElement("Volume")
                nnode.setAttribute("id",str(id))
                nnode.setAttribute("base-path",self.curdb.volumes[id][1])
                nnode.setAttribute("description",self.curdb.volumes[id][2])
                nnode.setAttribute("name",self.curdb.volumes[id][3])
                for img in self.curdb.volumes[id][0]:
                    self.putDir(batchdoc,nnode,img)
                nbatch.appendChild(nnode)
            if it[0] == "File":
                nnode = batchdoc.createElement("SysFile")
                nnode.setAttribute("path",it[1])
                nbatch.appendChild(nnode)
        outbatch.write(batchdoc.toxml())
        outbatch.close()
        del batchdoc

        ### Export images
        batchdoc = Document()
        nbatch = batchdoc.createElement("ImageDatabase")
        nbatch.setAttribute("creation-time",time.asctime(time.localtime()))
        nbatch.setAttribute("imgSeek-version",__version__)
        nbatch.setAttribute("db-version",str(self.curdb.dbversion))
        batchdoc.appendChild(nbatch)
        lst = []
        self.curdb.crawlBatchContentsForImg(self.batch,lst) # populate lst with all images
        for id in lst:
            try:
                nnode = batchdoc.createElement("Image")
                nnode.setAttribute("id",str(id))
                nnode.setAttribute("parent-dir-id",str(self.curdb.img[id][1]))
                nnode.setAttribute("path",self.curdb.img[id][0])
                nbatch.appendChild(nnode)
                try:
                    for gid in self.curdb.img[id][2]:
                        nnode2 = batchdoc.createElement("Group")
                        nnode2.setAttribute("id",str(gid))
                        nnode.appendChild(nnode2)
                except:
                    pass
                try:
                    for fld in self.curdb.meta[id].keys():
                        newel = batchdoc.createElement("meta")
                        newel.setAttribute("field",str(fld))
                        newel.appendChild(batchdoc.createTextNode(str(self.curdb.meta[id][fld])))
                        nnode.appendChild(newel)
                except:
                    pass
            except:
                pass
        outimgs.write(batchdoc.toxml())
        outimgs.close()

        # report back to UI what got written
        xmlfiles = [self.opts["outdir"]+"batch.xml",self.opts["outdir"]+"imgs.xml"]
        outmsg = "Data succesfully exported:\n"
        for xmf in xmlfiles:
            outmsg = outmsg+xmf+"\n"

        return outmsg
