// -*- C++ -*-
// --------------------------------------------------------------------
// Overlay for scissors
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2005  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef SCISSORS_H_
#define SCISSORS_H_

#include "ipeoverlay.h"
#include "ipepage.h"

// --------------------------------------------------------------------

class IpeSubPath;
class IpeSegmentSubPath;
class IpeEllipse;
class IpeClosedSpline;

class IpeScissors : public IpeOverlay {
 public:
  IpeScissors(IpeCanvas *canvas, IpePath *path,
	      IpePage *page, IpePage::iterator it);

  virtual void Draw(QPaintEvent *ev, QPainter *painter) const;
  virtual void MousePress(QMouseEvent *ev);
  virtual void MouseRelease(QMouseEvent *ev);
  virtual void MouseMove(QMouseEvent *ev);
  virtual void KeyPress(QKeyEvent *ev);

 private:
  void Explain() const;
  bool Cut();
  bool CutEllipse();
  bool CutClosedSpline();
  bool CutClosedSegments();
  bool CutSegments();
  void NewObj(IpeSubPath *sp, bool second);
  int FindPoint(const IpeVector &v);
  void Swap();
  void AppendSegs(IpeSegmentSubPath *sp, int i0, int i1);
  bool SplitSegment(IpeSegmentSubPath *sp1, IpeSegmentSubPath *sp2,
		    const IpeVector &pos, int seg);

 private:
  IpePage *iPage;
  IpePage::iterator iIt;
  IpeVector iPointOn;
  IpeMatrix iM;
  int iMoving;
  int iNoCuts;
  IpeVector iPos[2];
  const IpeSubPath *iSP; // not owned
  const IpeSegmentSubPath *iSSP;
  const IpeEllipse *iEll;
  const IpeClosedSpline *iCSP;
};

// --------------------------------------------------------------------
#endif
