/***************************************************************************
 *   Copyright (C) 2004 by Michael Schulze                                 *
 *   mike.s@genion.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef ITUNESDBITUNESDBPARSER_H
#define ITUNESDBITUNESDBPARSER_H

#define ITUNESDBPARSER_BUFFERSIZE 1024

#include "ItunesDBListener.h"
#include "track.h"
#include "playlistitem.h"
#include "playlist.h"

#include <qfile.h>

namespace itunesdb {
#define ITUNESDB_MHDP 0x7064686D
#define IPOD_FIRMWARE_V2 0x10
#define IPOD_FIRMWARE_V13 0x0C


/**
 * parses an iTunesDB file and calls the appropriate methods of a given ITunesDBListener
 @author Michael Schulze
*/
class ItunesDBParser{
private:
    ItunesDBListener * listener;
    Playlist current_playlist;
    
public:
    /**
     * creates a new parser that calls the appropriate methods on the given listener during the parse process
     */
    ItunesDBParser(ItunesDBListener& listener);

    virtual ~ItunesDBParser();
    
    /**
     * parses the given iTunesDB file
     * @param file the file that should be parsed.
     */
    void parse(QFile& file);

    /**
     * parses the given Playcount File
     * the iPod writes playcounts NOT into the iTunesDB
     * but to a file called "Play Count"
     * @param file the file that should be parsed.
     */
    void parsePlaycount(QFile& file);

    /**
     * parses the given On the Go Playlist
     * @param file the file that should be parsed.
     */
    void parseOTG(QFile& file);

private:
    // static void setTrackInfo( Track& track, QString data, Q_UINT32 field);
    void handleItem( ListItem& item);
    void seekRelative(QDataStream& stream, uint numbytes);
};

}

#endif
