//
//	IRE initialisation systems
//

#include "core.hpp"

#ifdef __cplusplus
extern "C" {
#endif

// variables
#ifndef PATH_FILES_CONF
	#define PATH_FILES_CONF "/etc/ire/"
#endif

#ifndef PATH_FILES_DAT
	#define PATH_FILES_DAT "/usr/share/games/ire/"
#endif
// functions


/* Init group */

extern void Init_Sprites();
extern long Init_Sprite(int pos);       // Load and start up sprites
extern long Init_RoofTile(int pos);     // Load and start up roof tiles
extern long Init_LightMap(int number);	// Load and set up light map tile
extern void Init_Things();              // Load in the Characters
extern void Init_Sequences();           // Load in the animation sequences
extern void Init_Font();                // Set up the console font
extern void Init_VRM(int id);           // Load in a single VRM
extern void Init_PE(int pos);			// Register a PE function
extern void Init_Funcs();               // Init functions for all characters1
extern void InitFuncsFor(OBJECT *o,int rebuild);// Assign VRM to CHlist.funcs entries
extern void Init_Areas(OBJECT *o);      // Set up subwidth and subheight
extern void CalcSize(OBJECT *objsel);   // Calculate object size in tiles

/* Search group */

extern SEQ_POOL *findseq(char *name);   // Find an animation sequence
extern S_POOL *find_spr(char *name);

extern void Init_Lookups();
// Fast versions
extern int getnum4sequence(char *r);	// Get index of animation sequence
extern int getnum4sprite(char *r);		// Get index of an image
extern int getnum4PE(char *name);		// Get index of PE function
extern int getnum4char(char *r);		// Get index of an object
extern int getnum4table(char *r);		// Get index of data table

// Slow versions (before lookups have been built)
extern int getnum4sequence_slow(char *r);	// Get index of animation sequence
extern int getnum4sprite_slow(char *r);		// Get index of an image
extern int getnum4VRM(char *name);			// Get index of VRM function
extern int getnum4PE_slow(char *name);		// Get index of PE function
extern int getnum4char_slow(char *r);		// Get index of an object
extern int getnum4table_slow(char *r);		// Get index of data table
extern int getnum4tile(char *r);
extern int getnum4tilelink(char *r);

// Random number generator

extern void qrand_init();
extern int qrand();

// Data Table queries

DT_ITEM *GetTableName_s(char *tablename,char *name);
DT_ITEM *GetTableNum_s(int table,char *name);
DT_ITEM *GetTableNum_i(int table,int num);
DT_ITEM *GetTableName_i(char *tablename,int num);
DT_ITEM *GetTableCase(char *tablename,char *name);

#ifdef __cplusplus
}
#endif

