//
//      Filesystem wrappers
//

#ifdef __cplusplus
extern "C" {
#endif

#include <time.h>

extern char *loadfile(char *srcname, char *destname);
extern void adddatafile(char *df);
extern void checkdatafiles();
extern int fileexists(char *filename);
extern int filelen(char *filename);
extern char datafile_warning;
extern void mountdatafiles();
extern void clean_path(char *fn);
extern void makepath(char *fname);
extern void cpfile(char *local_path, char *abs_path, char *file_name);
extern int data_choose(char *path,char *path_file,int size);
extern void del_path_name(char *path_file,int size);

#ifdef ALLEGRO_H
extern BITMAP *iload_bitmap(char *filename);
extern MIDI *iload_midi(char *filename);
extern SAMPLE *iload_wav(char *filename);
extern DATAFILE *iload_datafile(char *filename);

extern void save_rle_sprite(RLE_SPRITE* spr, char *fname, int avgcol);
extern RLE_SPRITE* load_rle_sprite(char *fname, int *avgcol);
#endif

extern int iload_tempfile(char *filename, char *dest);

typedef struct WadEntry
	{
	unsigned int start;
	char *name;
	} WadEntry;

extern void StartWad(IFILE *ofp);
extern void FinishWad(IFILE *ofp, WadEntry entries[]);
extern int GetWadEntry(IFILE *ifp, char *name);

// map file and directory-related things

extern char *makemapname(int number, int savegame, char *extension);
extern int makesavegamedir(int savegame);
extern void copysavegamedir(int src, int dest);

#ifdef __cplusplus
}
#endif

