<?php

require_once 'lib/Config.php';

$INSTALL[] = "CREATE TABLE comp_group (
	comp_id int(11) DEFAULT '0' NOT NULL,
	group_id int(11) DEFAULT '0' NOT NULL,
	KEY lab_id (group_id))";

$INSTALL[] = "INSERT INTO comp_group VALUES (1,1)";

$INSTALL[] = "CREATE TABLE computers__ID (
	sequence BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
	PRIMARY KEY (sequence))";
	
$INSTALL[] = "CREATE TABLE computers (
	ID BIGINT UNSIGNED NOT NULL,
	name varchar(200),
	type varchar(100),
	flags_server tinyint(4) DEFAULT '0' NOT NULL,
	flags_surplus tinyint(4) DEFAULT '0' NOT NULL,
	os varchar(100),
	osver varchar(20),
	processor varchar(30),
	processor_speed varchar(30),
	location varchar(200) DEFAULT '' NOT NULL,
	serial varchar(200) DEFAULT '' NOT NULL,
	otherserial varchar(200) DEFAULT '' NOT NULL,
	ramtype varchar(200) DEFAULT '' NOT NULL,
	ram varchar(6) DEFAULT '' NOT NULL,
	network varchar(200) DEFAULT '' NOT NULL,
	ip varchar(20),
	mac varchar(30),
	hdspace varchar(6),
	contact varchar(90),
	contact_num varchar(90),
	comments text NOT NULL,
	date_mod datetime,
	PRIMARY KEY (ID),
	KEY location (location),
	KEY flags (flags_server))";

$INSTALL[] = "INSERT INTO computers 
		(ID, name, type, os, osver, processor, processor_speed,
		location, ramtype, ram,
		network, ip, mac, hdspace)
		VALUES (1,'Ants','iMac DV','Mac OS','9.0.4','PowerPC G3',
		'400','Library Back Room','SDRAM DIMMs (<10ns)','192',
		'Generic 100Mbps Card','DHCP','00 50 E4','13')";
$INSTALL[] = "INSERT INTO computers__ID (sequence) VALUES (1)";
	
$INSTALL[] = "CREATE TABLE dropdown_iface ( name char(30))";
	
$INSTALL[] = "INSERT INTO dropdown_iface VALUES ('10Mbps Ethernet (UTP)')";
$INSTALL[] = "INSERT INTO dropdown_iface VALUES ('100Mbps Ethernet (UTP)')";
$INSTALL[] = "INSERT INTO dropdown_iface VALUES ('100Base FL')";
$INSTALL[] = "INSERT INTO dropdown_iface VALUES ('100Mbps FDDI')";
$INSTALL[] = "INSERT INTO dropdown_iface VALUES ('Frame Relay')";
$INSTALL[] = "INSERT INTO dropdown_iface VALUES ('ISDN')";
$INSTALL[] = "INSERT INTO dropdown_iface VALUES ('T1/E1 +')";
$INSTALL[] = "INSERT INTO dropdown_iface VALUES ('Serial Link')";
	
$INSTALL[] = "CREATE TABLE dropdown_locations (name char(200))";
		
$INSTALL[] = "INSERT INTO dropdown_locations VALUES ('Library Back Room')";
$INSTALL[] = "INSERT INTO dropdown_locations VALUES ('Room 34')";
$INSTALL[] = "INSERT INTO dropdown_locations VALUES ('MAOS Lab')";
$INSTALL[] = "INSERT INTO dropdown_locations VALUES ('Office')";
		
$INSTALL[] = "CREATE TABLE dropdown_network ( name char(200))";
		
$INSTALL[] = "INSERT INTO dropdown_network VALUES ('3Com (100Mbps)')";
$INSTALL[] = "INSERT INTO dropdown_network VALUES ('3Com (10Mbps)')";
$INSTALL[] = "INSERT INTO dropdown_network VALUES ('Intel (100Mbps)')";
$INSTALL[] = "INSERT INTO dropdown_network VALUES ('Intel (10Mbps)')";
$INSTALL[] = "INSERT INTO dropdown_network VALUES ('Generic 100Mbps Card')";
$INSTALL[] = "INSERT INTO dropdown_network VALUES ('Generic 10Mbps Card')";
$INSTALL[] = "INSERT INTO dropdown_network VALUES ('None')";
$INSTALL[] = "INSERT INTO dropdown_network VALUES ('AMD 10Mbps')";
$INSTALL[] = "INSERT INTO dropdown_network VALUES ('Realtek 10Mbps')";
$INSTALL[] = "INSERT INTO dropdown_network VALUES ('Realtek 100Mbps')";
		
$INSTALL[] = "CREATE TABLE dropdown_os (name char(100))";
$INSTALL[] = "INSERT INTO dropdown_os VALUES ('Linux (Debian)')";
$INSTALL[] = "INSERT INTO dropdown_os VALUES ('Linux (RedHat)')";
$INSTALL[] = "INSERT INTO dropdown_os VALUES ('Linux (Caldera)')";
$INSTALL[] = "INSERT INTO dropdown_os VALUES ('DOS')";
$INSTALL[] = "INSERT INTO dropdown_os VALUES ('FreeBSD')";
$INSTALL[] = "INSERT INTO dropdown_os VALUES ('Linux (Other)')";
$INSTALL[] = "INSERT INTO dropdown_os VALUES ('Windows')";
$INSTALL[] = "INSERT INTO dropdown_os VALUES ('Other')";
$INSTALL[] = "INSERT INTO dropdown_os VALUES ('Mac OS')";
$INSTALL[] = "INSERT INTO dropdown_os VALUES ('IRIX')";
$INSTALL[] = "INSERT INTO dropdown_os VALUES ('Solaris')";
$INSTALL[] = "INSERT INTO dropdown_os VALUES ('Max OS X')";
		
$INSTALL[] = "CREATE TABLE dropdown_processor ( name varchar(30))";
$INSTALL[] = "INSERT INTO dropdown_processor VALUES ('Intel Pentium')";
$INSTALL[] = "INSERT INTO dropdown_processor VALUES ('Intel Pentium II')";
$INSTALL[] = "INSERT INTO dropdown_processor VALUES ('AMD K6-1')";
$INSTALL[] = "INSERT INTO dropdown_processor VALUES ('AMD K6-2')";
$INSTALL[] = "INSERT INTO dropdown_processor VALUES ('AMD K6-3')";
$INSTALL[] = "INSERT INTO dropdown_processor VALUES ('PowerPC G3')";
$INSTALL[] = "INSERT INTO dropdown_processor VALUES ('Intel Pentium III')";
$INSTALL[] = "INSERT INTO dropdown_processor VALUES ('AMD Athlon')";
$INSTALL[] = "INSERT INTO dropdown_processor VALUES ('68k (Motorola)')";
$INSTALL[] = "INSERT INTO dropdown_processor VALUES ('486 SX')";
$INSTALL[] = "INSERT INTO dropdown_processor VALUES ('486 DX')";
$INSTALL[] = "INSERT INTO dropdown_processor VALUES ('486 DX2/4')";
$INSTALL[] = "INSERT INTO dropdown_processor VALUES ('Intel Itanium')";
$INSTALL[] = "INSERT INTO dropdown_processor VALUES ('PowerPC G4')";
$INSTALL[] = "INSERT INTO dropdown_processor VALUES ('RS3000')";
$INSTALL[] = "INSERT INTO dropdown_processor VALUES ('RS10k')";
$INSTALL[] = "INSERT INTO dropdown_processor VALUES ('Alpha EV6.7')";
$INSTALL[] = "INSERT INTO dropdown_processor VALUES ('PowerPC 603ev')";
$INSTALL[] = "INSERT INTO dropdown_processor VALUES ('PowerPC 603')";
$INSTALL[] = "INSERT INTO dropdown_processor VALUES ('PowerPC 601')";
$INSTALL[] = "INSERT INTO dropdown_processor VALUES ('68040')";
$INSTALL[] = "INSERT INTO dropdown_processor VALUES ('68040')";
		
$INSTALL[] = "CREATE TABLE dropdown_ram ( name char(200))";
$INSTALL[] = "INSERT INTO dropdown_ram VALUES ('36pin SIMMS')";
$INSTALL[] = "INSERT INTO dropdown_ram VALUES ('72pin SIMMS (Fast Page)')";
$INSTALL[] = "INSERT INTO dropdown_ram VALUES ('72pin SIMMS (EDO)')";
$INSTALL[] = "INSERT INTO dropdown_ram VALUES ('Unbuffered DIMMs')";
$INSTALL[] = "INSERT INTO dropdown_ram VALUES ('DIMMs w/EEPROM')";
$INSTALL[] = "INSERT INTO dropdown_ram VALUES ('SDRAM DIMMs (<10ns)')";
$INSTALL[] = "INSERT INTO dropdown_ram VALUES ('ECC DIMMs')";
$INSTALL[] = "INSERT INTO dropdown_ram VALUES ('Other')";
$INSTALL[] = "INSERT INTO dropdown_ram VALUES ('iMac DIMMS')";
		
$INSTALL[] = "CREATE TABLE dropdown_type ( name char(200))";
$INSTALL[] = "INSERT INTO dropdown_type VALUES ('Generic PC')";
$INSTALL[] = "INSERT INTO dropdown_type VALUES ('Macintosh PPC (other)')";
$INSTALL[] = "INSERT INTO dropdown_type VALUES ('Macintosh 68K (68030)')";
$INSTALL[] = "INSERT INTO dropdown_type VALUES ('Macintosh 68K (68040)')";
$INSTALL[] = "INSERT INTO dropdown_type VALUES ('Other')";
$INSTALL[] = "INSERT INTO dropdown_type VALUES ('IBM RS/6000')";
$INSTALL[] = "INSERT INTO dropdown_type VALUES ('Indy')";
$INSTALL[] = "INSERT INTO dropdown_type VALUES ('Octane')";
$INSTALL[] = "INSERT INTO dropdown_type VALUES ('O2')";
$INSTALL[] = "INSERT INTO dropdown_type VALUES ('Onyx 2')";
$INSTALL[] = "INSERT INTO dropdown_type VALUES ('iMac')";
$INSTALL[] = "INSERT INTO dropdown_type VALUES ('iMac DV')";
$INSTALL[] = "INSERT INTO dropdown_type VALUES ('Blue and White G3')";
$INSTALL[] = "INSERT INTO dropdown_type VALUES ('G4')";
$INSTALL[] = "INSERT INTO dropdown_type VALUES ('Homebrew')";
$INSTALL[] = "INSERT INTO dropdown_type VALUES ('Cisco Catalyst 2900 XL')";
$INSTALL[] = "INSERT INTO dropdown_type VALUES ('Cisco 2600')";
$INSTALL[] = "INSERT INTO dropdown_type VALUES ('3Com AccessBuilder')";
$INSTALL[] = "INSERT INTO dropdown_type VALUES ('3Com LinkBuilder Hub')";
$INSTALL[] = "INSERT INTO dropdown_type VALUES ('Cisco 400-series Fast Hub')";
		
$INSTALL[] = "CREATE TABLE event_log (
	ID int(11) NOT NULL auto_increment,
	item int(11) DEFAULT '0' NOT NULL,
	itemtype varchar(10) DEFAULT '' NOT NULL,
	date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
	service varchar(20),
	level tinyint(4) DEFAULT '0' NOT NULL,
	message text NOT NULL,
	PRIMARY KEY (ID),
	KEY comp (item),
	KEY date (date))";
		
$INSTALL[] = "CREATE TABLE followups (
	ID int(11) NOT NULL auto_increment,
	tracking int(11),
	date datetime,
	author varchar(200),
	contents text,
	public tinyint NOT NULL default 1,
	PRIMARY KEY (ID))";
		
$INSTALL[] = "CREATE TABLE groups (
	ID int(11) NOT NULL auto_increment,
	name varchar(200) DEFAULT '' NOT NULL,
	PRIMARY KEY (ID),
	KEY ID (ID),
	UNIQUE ID_2 (ID))";

$INSTALL[] = "INSERT INTO groups VALUES (1,'test')";
		
$INSTALL[] = "CREATE TABLE inst_software (
	ID int(11) NOT NULL auto_increment,
	cID int(11) DEFAULT '0' NOT NULL,
	sID int(11) DEFAULT '0' NOT NULL,
	lID int(11) NOT NULL default '0',
	gID int(11),
	lCnt int(11) NOT NULL DEFAULT '1',
	PRIMARY KEY (ID),
	KEY cID (cID),
	KEY sID (sID),
	KEY lID (lID))";

$INSTALL[] = "CREATE TABLE networking__ID (
	sequence BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
	PRIMARY KEY (sequence))";

$INSTALL[] = "CREATE TABLE networking (
	ID BIGINT UNSIGNED NOT NULL,
	name varchar(30) DEFAULT '' NOT NULL,
	type varchar(30) DEFAULT '' NOT NULL,
	ram varchar(10),
	ip varchar(20) DEFAULT '' NOT NULL,
	mac varchar(30),
	location varchar(40) DEFAULT '' NOT NULL,
	serial varchar(50),
	otherserial varchar(50),
	contact varchar(30) DEFAULT '' NOT NULL,
	contact_num varchar(30) DEFAULT '' NOT NULL,
	datemod datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
	comments text NOT NULL,
	PRIMARY KEY (ID))";
		
$INSTALL[] = "CREATE TABLE networking_ports (
	ID int(11) NOT NULL auto_increment,
	device_on int(11) DEFAULT '0' NOT NULL,
	device_type tinyint(4) DEFAULT '0' NOT NULL,
	iface char(40) DEFAULT '' NOT NULL,
	ifaddr char(30) DEFAULT '' NOT NULL,
	ifmac char(30) DEFAULT '0' NOT NULL,
	logical_number int(11) DEFAULT '0' NOT NULL,
	name char(30) DEFAULT '' NOT NULL,
	PRIMARY KEY (ID))";
		
$INSTALL[] = "INSERT INTO networking_ports
	(device_on, device_type, iface, ifaddr, ifmac, logical_number, name)
	VALUES (1,1,'100Mbps Ethernet (UTP)','DHCP','00 50 E4',1,'Port 1')";
		
$INSTALL[] = "CREATE TABLE networking_wire (
	ID int(11) NOT NULL auto_increment,
	end1 int(11) DEFAULT '0' NOT NULL,
	end2 int(11) DEFAULT '0' NOT NULL,
	PRIMARY KEY (ID))";
		
$INSTALL[] = "CREATE TABLE prefs (
	user varchar(80) DEFAULT '' NOT NULL,
	type enum('no','yes') DEFAULT 'no' NOT NULL,
	os enum('no','yes') DEFAULT 'no' NOT NULL,
	osver enum('no','yes') DEFAULT 'no' NOT NULL,
	processor enum('no','yes') DEFAULT 'no' NOT NULL,
	processor_speed enum('no','yes') DEFAULT 'no' NOT NULL,
	location enum('no','yes') DEFAULT 'no' NOT NULL,
	serial enum('no','yes') DEFAULT 'no' NOT NULL,
	otherserial enum('no','yes') DEFAULT 'no' NOT NULL,
	ramtype enum('no','yes') DEFAULT 'no' NOT NULL,
	ram enum('no','yes') DEFAULT 'no' NOT NULL,
	network enum('no','yes') DEFAULT 'no' NOT NULL,
	ip enum('no','yes') DEFAULT 'no' NOT NULL,
	mac enum('no','yes') DEFAULT 'no' NOT NULL,
	hdspace enum('no','yes') DEFAULT 'no' NOT NULL,
	contact enum('no','yes') DEFAULT 'no' NOT NULL,
	contact_num enum('no','yes') DEFAULT 'no' NOT NULL,
	comments enum('no','yes') DEFAULT 'no' NOT NULL,
	date_mod enum('no','yes') DEFAULT 'no' NOT NULL,
	advanced_tracking enum('no','yes') DEFAULT 'no' NOT NULL,
	tracking_order enum('no','yes') DEFAULT 'no' NOT NULL,
	PRIMARY KEY (user))";
		
$INSTALL[] = "INSERT INTO prefs
		(user, type, advanced_tracking)
		VALUES ('Admin','yes','yes')";
		
$INSTALL[] = "CREATE TABLE software (
	ID int(11) NOT NULL auto_increment,
	name varchar(200),
	platform varchar(200),
	install_package varchar(255),
	class enum('Operating System',
			'Application',
			'CAL',
			'Application Bundle')
		default 'Application',
	comments text,
	PRIMARY KEY (ID)
)";
		
$INSTALL[] = "INSERT INTO software
	(name, platform, class,
	 comments)
	VALUES
	('Test Software','FreeBSD','Application',
	 'This one is in the Back Room')";
$INSTALL[] = "INSERT INTO software
	(name, platform, class,
	 comments)
	VALUES
	('Windows 95','Mac OS','Operating System',
	 'This one is in the Back Room')";
$INSTALL[] = "INSERT INTO software
	(name, platform, class,
	 comments)
	VALUES
	('BlackWidowExplorer','DOS', 'Application',
	 'Comment Here')";
		
$INSTALL[] = "CREATE TABLE templ_inst_software (
	ID int(11) NOT NULL auto_increment,
	cID int(11) DEFAULT '0' NOT NULL,
	sID int(11) DEFAULT '0' NOT NULL,
	PRIMARY KEY (ID),
	KEY cID (cID),
	KEY sID (sID))";
		
$INSTALL[] = "INSERT INTO templ_inst_software VALUES (1,2,3)";
$INSTALL[] = "INSERT INTO templ_inst_software VALUES (2,2,2)";
		
$INSTALL[] = "CREATE TABLE templates (
	ID int(11) NOT NULL auto_increment,
	templname varchar(200),
	name varchar(200),
	type varchar(200),
	flags_server tinyint(4) DEFAULT '0' NOT NULL,
	os varchar(200),
	osver varchar(20),
	processor varchar(200),
	processor_speed varchar(100),
	location varchar(200),
	serial varchar(200),
	otherserial varchar(200),
	ramtype varchar(200),
	ram varchar(20),
	network varchar(200),
	ip varchar(20),
	mac varchar(40),
	hdspace varchar(10),
	contact varchar(200),
	contact_num varchar(200),
	comments text,
	iface varchar(100),
	flags_surplus TINYINT(4) default NULL,
	PRIMARY KEY (ID))";
	
$INSTALL[] = "INSERT INTO templates
	(templname, type, os, processor,
	 location, ramtype, network)
	VALUES
	('Blank Template','Generic PC','Windows','Intel Pentium',
	 'Library Back Room','72pin SIMMS (EDO)','Generic 10Mbps Card')";
$INSTALL[] = "INSERT INTO templates
	(templname, type, flags_server, os, osver, processor,
	 processor_speed, location, ramtype, ram, network,
	 ip,hdspace,iface)
	VALUES
	('Mac G3 All-in-One','Macintosh PPC (other)',1,'Mac OS','8.1','486 DX',
	'266','MAOS Lab','SDRAM DIMMs (<10ns)','96','Generic 100Mbps Card',
	'205.155.38','3','100Mbps Ethernet (UTP)')";
$INSTALL[] = "INSERT INTO templates
	(templname, type, os, osver, processor, processor_speed, location,
	 ramtype, ram, network, mac, hdspace,
	 iface)
	VALUES
	('iMac','iMac','Mac OS','8.6','PowerPC G3','333','Library Back Room',
	 'iMac DIMMS','32','Generic 100Mbps Card','00 50 E4','6',
	 '100Mbps Ethernet (UTP)')";
$INSTALL[] = "INSERT INTO templates
	(templname, type, os, osver, processor, processor_speed,
	 location, ramtype, ram, network,
	 hdspace, iface)
	VALUES
	('iMac DV','iMac DV','Mac OS','9.0.4','PowerPC G3','400',
	 'Library Back Room','SDRAM DIMMs (<10ns)','64','Generic 100Mbps Card',
	 '13','100Mbps Ethernet (UTP)')";

$INSTALL[] = "CREATE TABLE tracking__ID (
	sequence BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
	PRIMARY KEY (sequence))";
	
$INSTALL[] = "CREATE TABLE tracking_status (
	status		VARCHAR(255) NOT NULL,
	closed		TINYINT UNSIGNED NOT NULL DEFAULT 0,
	PRIMARY KEY (status)) TYPE=InnoDB";

$INSTALL[] = "INSERT INTO tracking_status (status, closed) VALUES
		('new', 0),
		('old', 1),
		('wait', 0),
		('assigned', 0),
		('active', 0),
		('complete', 1)";

$INSTALL[] = "CREATE TABLE tracking (
	ID BIGINT UNSIGNED NOT NULL,
	date datetime,
	closedate datetime,
	status		VARCHAR(255) NOT NULL DEFAULT 'new',
	author varchar(200),
	assign varchar(200),
	computer int(11),
	contents text,
	priority tinyint(4) DEFAULT '1' NOT NULL,
	is_group enum('no','yes') DEFAULT 'no' NOT NULL,
	uemail varchar(100),
	emailupdates varchar(4),
	other_emails TEXT,
	INDEX (status),
	FOREIGN KEY (status) REFERENCES tracking_status (status),
	PRIMARY KEY (ID)) TYPE=InnoDB";

$INSTALL[] = "CREATE TABLE users (
	name char(255) DEFAULT '' NOT NULL,
	password char(255),
	fullname char(200),
	email char(100),
	location char(200),
	phone char(100),
	type enum('post-only',
		  'normal',
		  'tech',
		  'admin') DEFAULT 'post-only' NOT NULL,
	comments text,
	PRIMARY KEY(name),
	KEY (type))";
		
$INSTALL[] = "INSERT INTO users
	(name, password, fullname, email,
	 location, phone, type)
	VALUES
	('Admin',md5('admin'),'Administrator Guy','root@localhost',
	 'Admin Place (in front of the computer)','Use e-mail','admin')";
$INSTALL[] = "INSERT INTO users
	(name, password, fullname, type)
	VALUES
	('Guest',md5('guest'),'Guest User','post-only')";
$INSTALL[] = "INSERT INTO users
	(name, password, fullname, email, type)
	VALUES
	('Normal',md5('normal'),'Normal User','user@localhost','normal')";
$INSTALL[] = "INSERT INTO users
	(name, password, fullname, email, type)
	VALUES
	('Tech',md5('tech'),'Technician User','tech@localhost','tech')";
$INSTALL[] = "INSERT INTO users
	(name, password, fullname, type)
	VALUES
	('IRMConnect',md5('irmconnect'),'Special account','post-only')";

$INSTALL[] = "CREATE TABLE config (
	variable	VARCHAR(255) NOT NULL,
	value		TEXT NOT NULL,
	PRIMARY KEY (variable))";

$DBVER = '1.5.2';
$INSTALL[] = "INSERT INTO config (variable, value) VALUES ('dbver', '$DBVER')";
unset($DBVER);

$INSTALL[] = "CREATE TABLE software_bundles (
	bID int(11) unsigned DEFAULT '0' NOT NULL,
	sID int(11) unsigned DEFAULT '0' NOT NULL,
	KEY sID_ndx (sID),
	KEY bID_ndx (bID),
	PRIMARY KEY (sID,bID))";

$INSTALL[] = "CREATE TABLE software_licenses (
	sID int(11) NOT NULL,
	licensekey varchar(200),
	entitlement int(11) DEFAULT '0' NOT NULL,
	ID int(11) NOT NULL auto_increment,
	oem_sticker enum ('Yes', 'No') DEFAULT 'No' NOT NULL,
	PRIMARY KEY (ID),
	KEY sID_ndx (sID),
	KEY ID_ndx (ID))";

$INSTALL[] = "CREATE TABLE kbarticles (
	ID int(11) NOT NULL auto_increment,
	categoryID int(11) NOT NULL default '0',
	question text NOT NULL,
	answer text NOT NULL,
	faq enum('yes','no') NOT NULL default 'no',
	PRIMARY KEY (ID),
	KEY ID (ID))";

$INSTALL[] = "CREATE TABLE kbcategories (
	ID int(11) NOT NULL auto_increment,
	parentID int(11) NOT NULL default '0',
	name text NOT NULL,
	PRIMARY KEY (ID),
	KEY ID (ID))";
	
$INSTALL[] = "INSERT INTO kbcategories
	(ID, parentID, name)
	VALUES
	(1, 0, 'IRM')";
$INSTALL[] = "INSERT INTO kbcategories
	(ID, parentID, name)
	VALUES
	(2, 1, 'Computers')";
$INSTALL[] = "INSERT INTO kbcategories
	(ID, parentID, name)
	VALUES
	(3, 1, 'Networking')";
$INSTALL[] = "INSERT INTO kbcategories
	(ID, parentID, name)
	VALUES
	(4, 1, 'Software')";
$INSTALL[] = "INSERT INTO kbcategories
	(ID, parentID, name)
	VALUES
	(5, 1, 'Tracking')";
$INSTALL[] = "INSERT INTO kbcategories
	(ID, parentID, name)
	VALUES
	(6, 1, 'Reports')";
$INSTALL[] = "INSERT INTO kbcategories
	(ID, parentID, name)
	VALUES
	(7, 1, 'Request Help')";
$INSTALL[] = "INSERT INTO kbcategories
	(ID, parentID, name)
	VALUES
	(8, 1, 'Setup')";
$INSTALL[] = "INSERT INTO kbcategories
	(ID, parentID, name)
	VALUES
	(9, 1, 'Preferences')";
$INSTALL[] = "INSERT INTO kbcategories
	(ID, parentID, name)
	VALUES
	(10, 1, 'Knowledge Base')";
$INSTALL[] = "INSERT INTO kbcategories
	(ID, parentID, name)
	VALUES
	(11, 1, 'FAQ')";
$INSTALL[] = "INSERT INTO kbcategories
	(ID, parentID, name)
	VALUES
	(12, 1, 'Logout')";
	
$INSTALL[] = "CREATE TABLE fasttracktemplates (
	ID INT NOT NULL auto_increment,
	name char(100),
	priority int(11),
	request text,
	response text,
	PRIMARY KEY (ID))";
	
$INSTALL[] = "INSERT INTO fasttracktemplates
	(name, priority)
	VALUES
	('Default',3)";
$INSTALL[] = "INSERT INTO fasttracktemplates
	(name, priority, request,
	 response)
	VALUES ('Reset Password',3, 'User forgot password',
	 'Reset password on the system')";
$INSTALL[] = "INSERT INTO fasttracktemplates
	(name, priority,
	 request,
	 response)
	VALUES
	('Floppy Disk in Drive',3,
	 'Computer will not boot, it says something about NTLDR not found',
	 'There was a floppy disk in the drive, once user removed it and rebooted system it started up just fine.')";
