<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999,2000 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../include/irm.inc");
require_once 'lib/Config.php';
require_once 'include/i18n.php';

AuthCheck("tech");
commonHeader(_("Networking Connector Wizard") . " - " . _("Step 3 of 3"));

$DB = Config::Database();
$qdID = $DB->getTextValue($dID);
$qtype = $DB->getTextValue($device_type);

$query = "SELECT * FROM networking_ports WHERE (device_on = $dID) AND (device_type = $qtype) ORDER BY logical_number";
$data = $DB->getAll($query);
# 1 is computer, 2 networking device
if (count($data) < 1) 
{
	__("Looks like a lonely device to me. No ports found.");
	PRINT "<br>";
	return;
}
PRINT "<table border=1 width=100%>";
PRINT "<tr><th>";
__("Port #");
PRINT "</th><th>";
__("Name");
PRINT "</th><th>";
__("Interface");
PRINT "</th><th>";
__("IP Address");
PRINT "</th><th>";
__("MAC/Network Address");
PRINT "</th><th>";
__("Connected to...");
PRINT "</th></tr>";
foreach ($data as $result)
{
	$ID = $result["ID"];
	$name = $result["name"];
	$logical_number = $result["logical_number"];
	$iface = $result["iface"];
	$ifaddr = $result["ifaddr"];
	$ifmac = $result["ifmac"];
	$qID = $DB->getTextValue($ID);
	$wquery = "SELECT * FROM networking_wire WHERE (end1 = $qID OR end2 = $qID)";
	$wresult = $DB->getRow($wquery);
	if (count($wresult) > 0) 
	{
		$wID = $wresult["ID"];
		$wend1 = $wresult["end1"];
		$wend2 = $wresult["end2"];
		if ($wend1 == $ID) 
		{
			$qwID = $DB->getTextValue($wend2);
		}
		else
		{
			$qwID = $DB->getTextValue($wend1);
		}
		$pquery = "SELECT * FROM networking_ports WHERE (ID = $qwID)";
		$presult = $DB->getRow($pquery);
		$pID = $presult["ID"];
		$pNum = $presult["logical_number"];
		$pOn = $presult["device_on"];
		$pType = $presult["device_type"];

		$qpOn = $DB->getTextValue($pOn);
		if ($pType == 1) 
		{
			$nquery = "SELECT ID,name FROM computers WHERE (ID = $qpOn)";
		}
		else if ($pType == 2)
		{
			$nquery = "SELECT ID,name FROM networking WHERE (ID = $qpOn)";
		}
		$nresult = $DB->getRow($nquery);
		$nname = $nresult["name"];
		$nID = $nresult["ID"];
		$found = 1;
	}
	else 
	{
		$found = 0;
		$pType = 0;
	}

	$userbase = Config::AbsLoc('users');
		
	PRINT "<tr><td><a href=\"$userbase/networking-port.php?ID=$ID\">$logical_number</a></td><td>$name</td><td>$iface</td><td>$ifaddr</td><td>$ifmac</td>";
	PRINT "<td>";
	if ($pType == 1) 
	{
		printf(_("Port %s on computer %s"),
			"<a href=\"$userbase/networking-port.php?ID=$pID\">$pNum</a>",
			"<a href=\"$userbase/computers-info.php?ID=$nID\">$nname ($nID)</a>");
	}
	else if ($pType == 2) 
	{
		printf(_("Port %s on network device %s"),
			"<a href=\"$userbase/networking-port.php?ID=$pID\">$pNum</a>",
			"<a href=\"$userbase/networking-info.php?ID=$nID\">$nname ($nID)</a>");
	}
	else if ($found != 1) 
	{
		__("Port available.");
		printf("<a href=\"%s\">%s</a>",
			"$userbase/networking-connect.php?pID=$ID&pID1=$pID1&go_back=$go_back",
			_("Connect"));
	}
	$found = 0;
	$pType=0;
	PRINT "</td></tr>";
}
PRINT "</table><br>";

commonFooter();
