<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999,2000 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../include/irm.inc");
require_once 'lib/Config.php';
require_once 'include/i18n.php';

AuthCheck("tech");
commonHeader(_("Networking Connector Wizard") ." - " . _("Step 1 of 3"));
?>

<p>
<?php __("This is where you can connect a port to another port easily.  To begin, choose which device you wish to connect it to."); ?>
</p>

<form method=get action="<?php echo Config::AbsLoc('users/networking-connecter-2.php'); ?>">

  <p>Connect to a computer with
  <select name=type size=1>
    <option value=name>name</option>
    <option value=id>ID</option>
  </select>

  <input type=text size=20 name=comp>
  <input type=hidden name=pID1 value="<?php echo $ID ?>">
  <input type=hidden name=go_back value="<?php echo $_SESSION['_sess_prevpage'] ?>">
  <input type=submit value="Continue ->">
</form>";

<p>
<form method=get action="<?php echo Config::AbsLoc('users/networking-connecter-3.php'); ?>">
<?php __("Or choose a network device:");


$query = "SELECT ID,name,location from networking";
$DB = Config::Database();
$data = $DB->getAll($query);
PRINT "<select size=1 name=dID>";
foreach ($data as $result)
{
	$dID = $result["ID"];
	$name = $result["name"];
	$location = $result["location"];
		
	PRINT "<option value=$dID>$name ($location)</option>";
}
PRINT "</select>";
PRINT "<input type=hidden name=device_type value=2>
<input type=hidden name=go_back value=\"".$_SESSION['_sess_prevpage']."\">
<input type=hidden name=pID1 value=\"$ID\">
<input type=submit value=\""._("Continue")." ->\">
</form>";	

commonFooter();
