<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################
include("../include/irm.inc");
require_once 'lib/Config.php';
require_once 'include/i18n.php';

AuthCheck("normal");

commonHeader(_("Software"));

__("Welcome to the IRM Software section.  This where you keep information about
all of your software.") ?>
<a href="<?php echo Config::AbsLoc('users/software-add-form.php') ?>">
<?php __("Click here to add software") ?></a>

<p><?php __("Or you might want to search through the software:") ?>
<br>

<form method=get action="<?php echo Config::AbsLoc('users/software-search.php') ?>"><select name="field" size=1>

<option value="ID"><?php __("IRM ID") ?></option>
<option value="name"><?php __("Name") ?></option>
<option value="platform"><?php __("Platform") ?></option>
<option value="license"><?php __("Number of Licenses") ?></option>
<option value="comments"><?php __("Comments") ?></option>
<option value="class"><?php __("Class") ?></option>
</select> <?php __("where that field contains") ?> 
<input type=text size=30 name="contains"> <?php __("and then show in") ?> <select name=style>
<option value=list selected><?php __("list view") ?></option>
<option value=full><?php __("full view") ?></option>
</select>. <input type=submit value="<?php __("Search") ?>"></form>
<hr noshade>
<?php
$query = "SELECT * FROM software ORDER BY class,name";
$DB = Config::Database();
$data = $DB->getAll($query);
PRINT "<table border=1 width=100%><tr bgcolor=#CCCCCC><th>";
__("Class");
PRINT "</th><th>";
__("Name");
PRINT "</th><th>";
__("Platform");
PRINT "</th><th>"._("Licenses")."</th></tr>";
foreach ($data as $result)
{
  	$ID = $result["ID"];
  	$name = $result["name"];
  	$class = $result["class"];
  	$platform = $result["platform"];
  	$license = Count_licenses($ID);
  	PRINT "<tr bgcolor=#DDDDDD>
		<TD>$class</TD>
		<td><a href=\"".Config::AbsLoc("users/software-info.php?ID=$ID")."\">
		$name ($ID)</a></td><td>$platform</td><td>";
  	$installed = Count_installations($ID);
  	$remaining = $license - $installed;
  	PRINT "<font face=\"Arial, Helvetica\">";
	__("Installed: ");
	PRINT "<b>$installed</b> ";
	__("Remaining: ");
	PRINT "<b>";
  	if ($remaining < 0) 
	{
		PRINT "<font color=red>";
  	} else if ($remaining == 0) 
	{
		PRINT "<font color=blue>";
	} else 
	{
		PRINT "<font color=black>";
	}

	PRINT "$remaining</font></b> ";
	__("Total: ");
	PRINT "<b>$license</b></font></td></tr>";
}
PRINT "</table>";
commonFooter();
