<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../include/irm.inc");
require_once 'lib/Config.php';
require_once 'include/i18n.php';

AuthCheck("post-only");

commonHeader(_("Tracking"));
$DB = Config::Database();

$uname = $DB->getTextValue($IRMName);

if (@$_REQUEST['sort'] && !preg_match('/^[a-zA-Z0-9_]+$/', $_REQUEST['sort']))
{
	trigger_error(sprintf(_("Invalid field name to sort by: %s"),@$_REQUEST['sort']), E_USER_ERROR);
	die(__FILE__.':'.__LINE__.": Failing on field name");
}

$query = "SELECT advanced_tracking,tracking_order FROM prefs WHERE (user = $uname)";
$result = $DB->getRow($query);

$advanced_tracking = $result["advanced_tracking"];
$tracking_order = $result["tracking_order"];

if($tracking_order == "yes")
{
 	$tracking_order = "ASC";
}
else
{
 	$tracking_order = "DESC";
}

if (@$_REQUEST['sort'])
{
	$tracking_order = $_REQUEST['sort']." $tracking_order";
}
else
{
	$tracking_order = "date $tracking_order";
}

if (!isset($show))
{
	$show = '';
}
if($advanced_tracking == "yes")
{
  PRINT '<form method="get" action="'.Config::AbsLoc('users/tracking-index.php').'">';
  PRINT '<select name="show" size=1>';
  PRINT "<option ";
  if($show == "all") 
  { 
    PRINT "selected"; 
  }
  PRINT " value=\"all\">";
  __("Show All Tracking");
  PRINT "</option>";
  PRINT "<option ";
  if($show == "individual") 
  {
    PRINT "selected"; 
  }
  PRINT " value=\"individual\">";
  __("Show only tracking assigned to you");
  PRINT "</option>";
  PRINT "<option ";
  if($show == "unassigned")
  { 
    PRINT "selected"; 
  }
  PRINT " value=\"unassigned\">";
  __("Show only tracking not assigned to anyone");
  PRINT "</option>";
  PRINT "</select>";
  PRINT "<input type=submit value=\""._("Show")."\">";
  PRINT "</form>";
}
PRINT "<br>\n";

__("This is the IRM tracking system it allows you to view the jobs currently in the queue.  In addition, you can click on \"more info\" next to any piece of tracking in order to view more detail or add followup information."); 
?>

<hr noshade>
<form method=get action="<?php echo Config::AbsLoc('users/tracking-search.php'); ?>">
<?php __("Search") ?>

<select name="searchtype">
<option value=""><?php __("Ticket and Followups") ?></option>
<option value="tracking"><?php __("Ticket only") ?></option>
<option value="followups"><?php __("Followups only") ?></option>
</select>

<?php __("for the following term: ") ?><input type=text name=contains size=20> <input type=submit value=Search>
</form>

<?php
$trackingIDs = Tracking::getNotClosed($advanced_tracking, $show, $tracking_order);
$numTrackingIDs = sizeof($trackingIDs);
if($numTrackingIDs != 1)
{
	PRINT "<H3>";
	printf(_("There are currently %s Outstanding Jobs"), $numTrackingIDs);
	PRINT "</H3>\n";
} else
{
	PRINT "<H3>";
	__("There is currently 1 Outstanding Job");
	PRINT "</H3>\n";
}
Tracking::displayHeader();
for($i = 0; $i < $numTrackingIDs; $i++)
{
	$track = new Tracking($trackingIDs[$i]);
	$track->display();
}
Tracking::displayFooter();

commonFooter();
