/*******************************************************\
* irmp3-ncurses - An ncurses frontend for irmp3 using   *
* the Network Control Module                            *
* (C) 2003 Ross Axe                                     *
*                                                       *
* info.c - player/track information manipulation        *
\*******************************************************/

#if HAVE_CONFIG_H
#  include "config.h"
#endif

#include "irmp3-ncurses.h"

vcid("$Id: info.c,v 1.10 2005/03/11 06:06:16 ross Exp $");

struct songinfo songinfo = {
    .length = -1,
    .pos = -1,
};
struct playerstate playerstate = {
    .version = "",
    .playermodule = "",
    .playerversion = "",
    .playstate = PS_STOP,
    .shuffle = false,
    .repeat = RP_NONE,
};


void stripspaces(char *str)
{
    char *ptr;

    for(ptr = str; isspace(*ptr); ptr++) {
	if(!*ptr) {
	    *str = '\0';
	    return;
	}
    }
    memmove(str, ptr, strlen(ptr) + 1);
    for(ptr = strchr(str, '\0') - 1; isspace(*ptr); ptr--) {
	assert(ptr > str);
	*ptr = '\0';
    }
}

void clearsonginfo(void)
{
    songinfo = (struct songinfo) {
	.length = -1,
	.pos = -1,
    };
    printsonginfo();
}

void setartist(const char *artist)
{
    songinfo.artist[0] = '\0';
    strncat(songinfo.artist, artist, sizeof songinfo.artist - 1);
    stripspaces(songinfo.artist);
    printsonginfo();
}

void setalbum(const char *album)
{
    songinfo.album[0] = '\0';
    strncat(songinfo.album, album, sizeof songinfo.album - 1);
    stripspaces(songinfo.album);
    printsonginfo();
}

void settitle(const char *title)
{
    songinfo.title[0] = '\0';
    strncat(songinfo.title, title, sizeof songinfo.title - 1);
    stripspaces(songinfo.title);
    printsonginfo();
}

void setyear(const char *year)
{
    songinfo.year[0] = '\0';
    strncat(songinfo.year, year, sizeof songinfo.year - 1);
    stripspaces(songinfo.year);
    printsonginfo();
}

void setgenre(const char *genre)
{
    songinfo.genre[0] = '\0';
    strncat(songinfo.genre, genre, sizeof songinfo.genre - 1);
    stripspaces(songinfo.genre);
    printsonginfo();
}

void setcomment(const char *comment)
{
    songinfo.comment[0] = '\0';
    strncat(songinfo.comment, comment, sizeof songinfo.comment - 1);
    stripspaces(songinfo.comment);
    printsonginfo();
}

void setfilename(const char *filename)
{
    songinfo.filename[0] = '\0';
    strncat(songinfo.filename, filename, sizeof songinfo.filename - 1);
    stripspaces(songinfo.filename);
    printplayerstate();
}

void setplaystate(enum play playstate)
{
    playerstate.playstate = playstate;
    printplayerstate();
}

void setshufflemode(bool shuffle)
{
    playerstate.shuffle = shuffle;
    printplayerstate();
}

void setrepeatmode(enum repeat repeat)
{
    playerstate.repeat = repeat;
    printplayerstate();
}

void setvolume(int vol)
{
    playerstate.volume = vol;
    printplayerstate();
}

void setbalance(int balance)
{
    playerstate.balance = balance;
    printplayerstate();
}

void setbass(int bass)
{
    playerstate.bass = bass;
    printplayerstate();
}

void settreble(int treble)
{
    playerstate.treble = treble;
    printplayerstate();
}

void setmute(bool mute)
{
    playerstate.mute = mute;
    printplayerstate();
}

void setirmp3version(char *name)
{
    playerstate.version[0] = '\0';
    strncat(playerstate.version, name, sizeof playerstate.version - 1);
    stripspaces(playerstate.version);
    sbar_printf(_("Welcome to %s"), playerstate.version);
}

void setplayerversion(char *name)
{
    playerstate.playerversion[0] = '\0';
    strncat(playerstate.playerversion, name,
	    sizeof playerstate.playerversion - 1);
    stripspaces(playerstate.playerversion);
}

void setplayermodule(char *name)
{
    playerstate.playermodule[0] = '\0';
    strncat(playerstate.playermodule, name,
	    sizeof playerstate.playermodule - 1);
    stripspaces(playerstate.playermodule);
}
